/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.nodes;

import org.eclipse.m2e.core.repository.IRepository;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.swt.graphics.Image;

public class RepositoryNode
implements IMavenRepositoryNode {
    protected final IRepository repository;

    public RepositoryNode(IRepository repository) {
        this.repository = repository;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.repository.getId());
        sb.append(" (").append(this.repository.getUrl()).append(")");
        if (this.repository.getMirrorOf() != null) {
            sb.append(" [mirrorOf=").append(this.repository.getMirrorOf()).append("]");
        }
        if (this.repository.getMirrorId() != null) {
            sb.append(" [mirrored by ").append(this.repository.getMirrorId()).append("]");
        }
        if (this.isUpdating()) {
            sb.append(Messages.RepositoryNode_updating);
        }
        return sb.toString();
    }

    public String getRepoName() {
        return this.repository.toString();
    }

    @Override
    public Object[] getChildren() {
        return new Object[0];
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    public String getRepositoryUrl() {
        return this.repository.getUrl();
    }
}

