/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types.xerces;

import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.ItemPSVI;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.internal.types.xerces.XercesTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XercesTypeModel
implements TypeModel {
    private XSModel _schema;

    public XercesTypeModel(Document doc) {
        this._schema = ((ElementPSVI)doc.getDocumentElement()).getSchemaInformation();
    }

    public XercesTypeModel(XSModel model) {
        this._schema = model;
    }

    @Override
    public TypeDefinition lookupType(String namespace, String typeName) {
        XSTypeDefinition ad = this._schema.getTypeDefinition(typeName, namespace);
        return XercesTypeDefinition.createTypeDefinition(ad);
    }

    @Override
    public TypeDefinition lookupElementDeclaration(String namespace, String elementName) {
        XSElementDeclaration ad = this._schema.getElementDeclaration(elementName, namespace);
        return XercesTypeDefinition.createTypeDefinition(ad.getTypeDefinition());
    }

    @Override
    public TypeDefinition lookupAttributeDeclaration(String namespace, String attributeName) {
        XSAttributeDeclaration ad = this._schema.getAttributeDeclaration(attributeName, namespace);
        return XercesTypeDefinition.createTypeDefinition(ad.getTypeDefinition());
    }

    @Override
    public TypeDefinition getType(Node node) {
        XSTypeDefinition typeDefinition;
        if (node instanceof ItemPSVI && (typeDefinition = ((ItemPSVI)node).getTypeDefinition()) != null) {
            return XercesTypeDefinition.createTypeDefinition(typeDefinition);
        }
        return null;
    }
}

