/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexEntry2;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpEvaluationContext;

public class EnabledTopicUtils {
    public static boolean isEnabled(ITopic topic) {
        if (!topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext())) {
            return false;
        }
        if (topic.getHref() != null) {
            return true;
        }
        return EnabledTopicUtils.hasEnabledSubtopic(topic);
    }

    public static boolean hasEnabledSubtopic(ITopic topic) {
        ITopic[] subtopics;
        ITopic[] iTopicArray = subtopics = topic.getSubtopics();
        int n = subtopics.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic subtopic = iTopicArray[n2];
            if (EnabledTopicUtils.isEnabled(subtopic)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isEnabled(IToc toc) {
        ITopic[] subtopics;
        if (!HelpBasePlugin.getActivitySupport().isEnabled(toc.getHref()) || UAContentFilter.isFiltered((Object)toc, (IEvaluationContext)HelpEvaluationContext.getContext())) {
            return false;
        }
        ITopic[] iTopicArray = subtopics = toc.getTopics();
        int n = subtopics.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic subtopic = iTopicArray[n2];
            if (EnabledTopicUtils.isEnabled(subtopic)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isEnabled(IIndexEntry entry) {
        IIndexEntry[] subentries;
        ITopic[] topics;
        if (UAContentFilter.isFiltered((Object)entry, (IEvaluationContext)HelpEvaluationContext.getContext())) {
            return false;
        }
        ITopic[] iTopicArray = topics = entry.getTopics();
        int n = topics.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic topic = iTopicArray[n2];
            if (EnabledTopicUtils.isEnabled(topic)) {
                return true;
            }
            ++n2;
        }
        IIndexEntry[] iIndexEntryArray = subentries = entry.getSubentries();
        int n3 = subentries.length;
        n = 0;
        while (n < n3) {
            IIndexEntry subentrie = iIndexEntryArray[n];
            if (EnabledTopicUtils.isEnabled(subentrie)) {
                return true;
            }
            ++n;
        }
        if (entry instanceof IIndexEntry2) {
            IIndexSee[] sees;
            IIndexEntry2 indexEntry = (IIndexEntry2)entry;
            IIndexSee[] iIndexSeeArray = sees = indexEntry.getSees();
            int n4 = sees.length;
            int n5 = 0;
            while (n5 < n4) {
                IIndexSee see = iIndexSeeArray[n5];
                if (EnabledTopicUtils.isEnabled(see)) {
                    return true;
                }
                ++n5;
            }
        }
        return false;
    }

    public static boolean isEnabled(IIndexSee see) {
        return see.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext());
    }

    public static IIndexEntry[] getEnabled(IIndexEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            if (!EnabledTopicUtils.isEnabled(entries[i])) {
                ArrayList<IIndexEntry> list = new ArrayList<IIndexEntry>(entries.length);
                int j = 0;
                while (j < entries.length) {
                    if (j < i || EnabledTopicUtils.isEnabled(entries[j])) {
                        list.add(entries[j]);
                    }
                    ++j;
                }
                return list.toArray(new IIndexEntry[list.size()]);
            }
            ++i;
        }
        return entries;
    }

    public static ITopic[] getEnabled(ITopic[] topics) {
        int i = 0;
        while (i < topics.length) {
            if (!EnabledTopicUtils.isEnabled(topics[i])) {
                ArrayList<ITopic> list = new ArrayList<ITopic>(topics.length);
                int j = 0;
                while (j < topics.length) {
                    if (j < i || EnabledTopicUtils.isEnabled(topics[j])) {
                        list.add(topics[j]);
                    }
                    ++j;
                }
                return list.toArray(new ITopic[list.size()]);
            }
            ++i;
        }
        return topics;
    }
}

