/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.plugin.JptCommonUiPlugin;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.ui.jface.ItemContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.jface.StructuredStateProvider;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.ModelTools;
import org.eclipse.swt.graphics.Image;

abstract class AbstractItemStructuredStateProviderManager<V extends StructuredViewer, CP extends ItemContentProvider, CPF extends ItemStructuredContentProvider.Factory>
implements StructuredStateProvider,
ItemStructuredContentProvider.Manager,
ItemExtendedLabelProvider.Manager {
    V viewer;
    private Object input;
    final CPF itemContentProviderFactory;
    private ItemStructuredContentProvider inputContentProvider;
    private final ItemExtendedLabelProvider.Factory itemLabelProviderFactory;
    private final HashMap<Object, ItemExtendedLabelProvider> itemLabelProviders = new HashMap();
    private final ResourceManager resourceManager;
    private final ListenerList<ILabelProviderListener> listenerList = ModelTools.listenerList();
    private final ExceptionHandler exceptionHandler;
    static final JptCommonUiPlugin PLUG_IN = JptCommonUiPlugin.instance();

    AbstractItemStructuredStateProviderManager(CPF itemContentProviderFactory, ItemExtendedLabelProvider.Factory itemLabelProviderFactory, ResourceManager resourceManager, ExceptionHandler exceptionHandler) {
        if (itemContentProviderFactory == null) {
            throw new NullPointerException();
        }
        this.itemContentProviderFactory = itemContentProviderFactory;
        if (itemLabelProviderFactory == null) {
            throw new NullPointerException();
        }
        this.itemLabelProviderFactory = itemLabelProviderFactory;
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.resourceManager = resourceManager;
        if (exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        StructuredViewer temp = (StructuredViewer)v;
        this.viewer = temp;
        if (oldInput != newInput) {
            if (this.inputContentProvider != null) {
                this.disposeInputProviders();
            }
            this.input = newInput;
            if (newInput != null) {
                this.addLabelProvider(newInput);
                this.inputContentProvider = this.itemContentProviderFactory.buildProvider(newInput, this);
                this.addAll(newInput, this.inputContentProvider.getElements());
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != this.input) {
            String msg = MessageFormat.format((String)"Mismatched input: this.input: '{0}' vs. inputElement: '{1}'", (Object[])new Object[]{this.input, inputElement});
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            if (PLUG_IN != null) {
                PLUG_IN.logError(ex);
            } else {
                ex.printStackTrace();
            }
        }
        return this.inputContentProvider.getElements();
    }

    public Image getImage(Object element) {
        return this.getItemLabelProvider(element).getImage();
    }

    public String getText(Object element) {
        return this.getItemLabelProvider(element).getText();
    }

    public String getDescription(Object element) {
        return this.getItemLabelProvider(element).getDescription();
    }

    private ItemExtendedLabelProvider getItemLabelProvider(Object item) {
        this.checkViewer();
        return this.itemLabelProviders.get(item);
    }

    private void checkViewer() {
        if (this.viewer == null) {
            String msg = "This manager must be both the viewer's content provider *and* the viewer's label provider.";
            IllegalStateException ex = new IllegalStateException(msg);
            if (PLUG_IN != null) {
                PLUG_IN.logError(ex);
            } else {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void elementsChanged(Object parent, Iterable<?> addedElements, Iterable<?> removedElements) {
        this.checkUIThread();
        if (parent == this.input) {
            this.elementsChanged_(parent, addedElements, removedElements);
        }
    }

    private void elementsChanged_(Object parent, Iterable<?> addedElements, Iterable<?> removedElements) {
        this.addAll(parent, addedElements);
        this.removeAll(removedElements);
        this.viewer.refresh(false);
    }

    void addAll(Object parent, Object[] items) {
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            this.add(parent, item);
            ++n2;
        }
    }

    void addAll(Object parent, Iterable<?> items) {
        for (Object item : items) {
            this.add(parent, item);
        }
    }

    void add(Object parent, Object item) {
        this.addLabelProvider(item);
    }

    private void addLabelProvider(Object item) {
        this.itemLabelProviders.put(item, this.itemLabelProviderFactory.buildProvider(item, this));
    }

    void removeAll(Object[] items) {
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            this.remove(item);
            ++n2;
        }
    }

    void removeAll(Iterable<?> items) {
        for (Object item : items) {
            this.remove(item);
        }
    }

    void remove(Object item) {
        this.removeLabelProvider(item);
    }

    private void removeLabelProvider(Object item) {
        this.itemLabelProviders.get(item).dispose();
        this.itemLabelProviders.remove(item);
    }

    @Override
    public void labelChanged(Object item) {
        this.checkUIThread();
        if (this.getItemLabelProvider(item) != null) {
            this.labelChanged_(item);
        }
    }

    private void labelChanged_(Object item) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, item));
    }

    @Override
    public void descriptionChanged(Object item) {
        this.checkUIThread();
        if (this.getItemLabelProvider(item) != null) {
            this.descriptionChanged_(item);
        }
    }

    private void descriptionChanged_(Object item) {
    }

    public void addListener(ILabelProviderListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.itemLabelProviders.get(element).isLabelProperty(property);
    }

    void fireLabelProviderChanged(LabelProviderChangedEvent event) {
        for (ILabelProviderListener listener : this.listenerList) {
            try {
                listener.labelProviderChanged(event);
            }
            catch (Throwable t) {
                this.exceptionHandler.handleException(t);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.inputContentProvider != null) {
            this.disposeInputProviders();
            this.input = null;
        }
        if (!this.itemLabelProviders.isEmpty()) {
            String msg = MessageFormat.format((String)"Not all item label providers were disposed: {0}", (Object[])new Object[]{this.itemLabelProviders});
            IllegalStateException ex = new IllegalStateException(msg);
            if (PLUG_IN != null) {
                PLUG_IN.logError(ex);
            } else {
                ex.printStackTrace();
            }
        }
    }

    private void disposeInputProviders() {
        this.removeAll(this.inputContentProvider.getElements());
        this.inputContentProvider.dispose();
        this.inputContentProvider = null;
        this.removeLabelProvider(this.input);
    }

    @Override
    public StructuredViewer getViewer() {
        return this.viewer;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    void checkUIThread() {
        DisplayTools.checkUIThread(this.viewer);
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }
}

