/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.providers;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public abstract class TableStyledLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
ITableLabelProvider {
    public final void dispose() {
    }

    public void doDispose() {
        super.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        TableColumnProvider columnProvider = this.getColumnProviders()[columnIndex];
        return columnProvider.getImage(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        TableColumnProvider columnProvider = this.getColumnProviders()[columnIndex];
        return columnProvider.getText(element);
    }

    public abstract TableColumnProvider[] getColumnProviders();

    public static abstract class AdaptingTableColumnProvider
    extends TableColumnProvider {
        private final TableColumnProvider targetProvider;

        public AdaptingTableColumnProvider(TableColumnProvider targetProvider, String title, int weight, int minimumSize, boolean fill) {
            super(title, weight, minimumSize, fill);
            this.targetProvider = targetProvider;
        }

        @Override
        public StyledString getStyledText(Object element) {
            Object columnObject = this.adapt(element);
            if (columnObject != null) {
                return this.targetProvider.getStyledText(columnObject);
            }
            return new StyledString();
        }

        public Image getImage(Object element) {
            Object columnObject = this.adapt(element);
            if (columnObject != null) {
                return this.targetProvider.getImage(columnObject);
            }
            return null;
        }

        @Override
        public String getToolTipText(Object element) {
            Object columnObject = this.adapt(element);
            if (columnObject != null) {
                return this.targetProvider.getToolTipText(columnObject);
            }
            return this.targetProvider.getToolTipText(element);
        }

        public String getText(Object element) {
            Object columnObject = this.adapt(element);
            if (columnObject != null) {
                return this.targetProvider.getText(columnObject);
            }
            return "";
        }

        public abstract Object adapt(Object var1);
    }

    public static class TableColumnProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private final String title;
        private final int weight;
        private final int minimumSize;
        private final boolean fill;

        public TableColumnProvider(String title, int weight, int minimumSize, boolean fill) {
            this.title = title;
            this.weight = weight;
            this.minimumSize = minimumSize;
            this.fill = fill;
        }

        public String getTitle() {
            return this.title;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getMinimumSize() {
            return this.minimumSize;
        }

        public boolean isFillAvailable() {
            return this.fill;
        }

        public StyledString getStyledText(Object element) {
            String columnText = this.getText(element);
            if (columnText == null) {
                columnText = "";
            }
            return new StyledString(columnText);
        }

        public boolean isStyled() {
            return false;
        }

        public String getToolTipText(Object element) {
            return null;
        }
    }
}

