/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.datatools.enablement.ibm.db2.luw.DB2LUWPluginActivator;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.ServerKindsConfig;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.WrapperConfigFile;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.WrapperConfigManager;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWDatabaseImpl;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;

public class LUWUtil {
    private static final String SINGLE_QUOTE = "'";

    public static String getIdentifier(String name) {
        String identifier = name;
        identifier = identifier.replaceAll(SINGLE_QUOTE, "''");
        return identifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getSingleQuotedString(String orignal) {
        if (orignal.startsWith(SINGLE_QUOTE) && orignal.endsWith(SINGLE_QUOTE)) {
            return orignal;
        }
        StringTokenizer tokenizer = new StringTokenizer(orignal, SINGLE_QUOTE);
        String result = orignal;
        if (!tokenizer.hasMoreTokens()) {
            return result;
        }
        result = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            result = String.valueOf(result) + SINGLE_QUOTE + SINGLE_QUOTE + tokenizer.nextToken();
        }
        return SINGLE_QUOTE + result + SINGLE_QUOTE;
    }

    public Privilege findPrivileges(Object[] privilegelist, String grantee) {
        int i = 0;
        while (i < privilegelist.length) {
            Privilege priv = (Privilege)privilegelist[i];
            if (priv.getGrantee().getName().equals(grantee)) {
                return (Privilege)privilegelist[i];
            }
            ++i;
        }
        return null;
    }

    public static List<String> getDiscoveredLibraries(LUWDatabase luwdb) {
        ArrayList<String> libraries = new ArrayList<String>();
        Hashtable wrapperConfigs = new Hashtable();
        LUWDatabase database = luwdb;
        LUWDatabaseImpl db = (LUWDatabaseImpl)database;
        try {
            WrapperConfigManager wrapperConfigMgr = new WrapperConfigManager(db);
            ServerKindsConfig serverKinds = wrapperConfigMgr.getServerKindsConfig();
            wrapperConfigs = serverKinds.getAllWCF();
        }
        catch (Exception e) {
            DB2LUWPluginActivator.getInstance().log(null, e);
        }
        Enumeration configs = wrapperConfigs.keys();
        while (configs.hasMoreElements()) {
            String configID = (String)configs.nextElement();
            WrapperConfigFile wrapperConfig = (WrapperConfigFile)wrapperConfigs.get(configID);
            try {
                String wrapperID = wrapperConfig.getWrapperID();
                new String();
                if (wrapperID.equalsIgnoreCase("drda")) {
                    libraries.add("DB2");
                    continue;
                }
                if (wrapperID.equalsIgnoreCase("sqlnet") || wrapperID.equalsIgnoreCase("net8")) {
                    libraries.add("ORACLE");
                    continue;
                }
                if (wrapperID.equalsIgnoreCase("dblib") || wrapperID.equalsIgnoreCase("ctlib")) {
                    libraries.add("SYBASE");
                    continue;
                }
                if (wrapperID.equalsIgnoreCase("mssql3")) {
                    libraries.add("SQL_SERVER");
                    continue;
                }
                if (wrapperID.equalsIgnoreCase("odbc")) {
                    libraries.add("ODBC");
                    continue;
                }
                if (wrapperID.equalsIgnoreCase("informix")) {
                    libraries.add("INFORMIX");
                    continue;
                }
                if (wrapperID.equalsIgnoreCase("teradata")) {
                    libraries.add("TERADATA");
                    continue;
                }
                if (!wrapperID.equalsIgnoreCase("jdbc")) continue;
                libraries.add("JDBC");
            }
            catch (Exception e) {
                DB2LUWPluginActivator.getInstance().log(null, e);
            }
        }
        return libraries;
    }
}

