/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.servertype.definition.Module;
import org.eclipse.jst.server.generic.servertype.definition.Port;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class GenericServer
extends ServerDelegate
implements IURLProvider {
    public static final String PROP_CUSTOM_BUILD_SCRIPT = "org.eclipse.jst.server.generic.core.custom_build_file";
    private static final String ATTR_GENERIC_SERVER_MODULES = "Generic_Server_Modules_List";

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (add != null) {
            int i = 0;
            while (i < add.length) {
                IStatus status;
                if (!this.isSupportedModule(add[i])) {
                    return new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.moduleNotCompatible, null);
                }
                if (add[i].getProject() != null && (status = FacetUtil.verifyFacets((IProject)add[i].getProject(), (IServer)this.getServer())) != null && !status.isOK()) {
                    return status;
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    private boolean isSupportedModule(IModule module) {
        if (module == null) {
            return false;
        }
        EList<Module> moduleTypes = this.getServerDefinition().getModule();
        int j = 0;
        while (j < moduleTypes.size()) {
            Module moduleDefinition = (Module)moduleTypes.get(j);
            if (module.getModuleType() != null && module.getModuleType().getId().equals(moduleDefinition.getType())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        int i;
        ArrayList<String> modules = this.getAttribute(ATTR_GENERIC_SERVER_MODULES, null);
        if (add != null && add.length > 0) {
            if (modules == null) {
                modules = new ArrayList<String>(add.length);
            }
            i = 0;
            while (i < add.length) {
                if (!modules.contains(add[i].getId())) {
                    modules.add(add[i].getId());
                }
                ++i;
            }
        }
        if (remove != null && remove.length > 0 && modules != null) {
            i = 0;
            while (i < remove.length) {
                modules.remove(remove[i].getId());
                ++i;
            }
        }
        if (modules != null) {
            this.setAttribute(ATTR_GENERIC_SERVER_MODULES, modules);
        }
    }

    public IModule[] getChildModules(IModule[] module) {
        if (module[0] != null && module[0].getModuleType() != null && module.length == 1) {
            IWebModule webModule;
            IModuleType moduleType = module[0].getModuleType();
            if (moduleType != null && "jst.ear".equals(moduleType.getId())) {
                IModule[] earModules;
                IEnterpriseApplication enterpriseApplication = (IEnterpriseApplication)module[0].loadAdapter(IEnterpriseApplication.class, null);
                if (enterpriseApplication != null && (earModules = enterpriseApplication.getModules()) != null) {
                    return earModules;
                }
            } else if (moduleType != null && "jst.web".equals(moduleType.getId()) && (webModule = (IWebModule)module[0].loadAdapter(IWebModule.class, null)) != null) {
                IModule[] modules = webModule.getModules();
                return modules;
            }
        }
        return new IModule[0];
    }

    private Map getInstanceProperties() {
        Map runtimeProperties = this.getRuntimeDelegate().getServerInstanceProperties();
        Map serverProperties = this.getServerInstanceProperties();
        HashMap instanceProperties = new HashMap(runtimeProperties.size() + serverProperties.size());
        instanceProperties.putAll(runtimeProperties);
        instanceProperties.putAll(serverProperties);
        return instanceProperties;
    }

    public ServerPort[] getServerPorts() {
        ArrayList<ServerPort> ports = new ArrayList<ServerPort>();
        for (Port element : this.getServerDefinition().getPort()) {
            int port = Integer.parseInt(this.getServerDefinition().getResolver().resolveProperties(element.getNo()));
            ports.add(new ServerPort("server", element.getName(), port, element.getProtocol()));
        }
        return ports.toArray(new ServerPort[ports.size()]);
    }

    public URL getModuleRootURL(IModule module) {
        String ctxRoot;
        block6: {
            try {
                if (module != null && module.loadAdapter(IWebModule.class, null) != null) break block6;
                return null;
            }
            catch (Exception e) {
                Trace.trace("Could not get root URL", e);
                return null;
            }
        }
        IWebModule webModule = (IWebModule)module.loadAdapter(IWebModule.class, null);
        String host = this.getServer().getHost();
        String url = "http://" + host;
        int port = 0;
        port = this.getHttpPort();
        port = ServerUtil.getMonitoredPort((IServer)this.getServer(), (int)port, (String)"web");
        if (port != 80) {
            url = url + ":" + port;
        }
        if (!(ctxRoot = webModule.getContextRoot()).startsWith("/")) {
            url = url + "/";
        }
        if (!(url = url + webModule.getContextRoot()).endsWith("/")) {
            url = url + "/";
        }
        return new URL(url);
    }

    protected int getHttpPort() {
        int port = -1;
        for (Port aPort : this.getServerDefinition().getPort()) {
            if (port == -1) {
                port = Integer.parseInt(this.getServerDefinition().getResolver().resolveProperties(aPort.getNo()));
                continue;
            }
            if (!"http".equals(aPort.getProtocol())) continue;
            port = Integer.parseInt(aPort.getNo());
        }
        if (port == -1) {
            port = 8080;
        }
        return port;
    }

    public ServerRuntime getServerDefinition() {
        IServer server = this.getServer();
        if (server == null) {
            throw new IllegalStateException("No server determeined. Server definition can not be determined without a server");
        }
        String rtTypeId = null;
        if (server.getRuntime() != null && server.getRuntime().getRuntimeType() != null) {
            rtTypeId = server.getRuntime().getRuntimeType().getId();
        }
        String serverTypeId = server.getServerType().getId();
        return CorePlugin.getDefault().getServerTypeDefinitionManager().getServerRuntimeDefinition(serverTypeId, rtTypeId, this.getInstanceProperties());
    }

    private GenericServerRuntime getRuntimeDelegate() {
        return (GenericServerRuntime)((Object)this.getServer().getRuntime().loadAdapter(GenericServerRuntime.class, null));
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        if (!this.isSupportedModule(module)) {
            return null;
        }
        IStatus status = this.canModifyModules(new IModule[]{module}, null);
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        IModule[] parents = this.doGetParentModules(module);
        if (parents.length > 0) {
            return parents;
        }
        return new IModule[]{module};
    }

    private IModule[] doGetParentModules(IModule module) {
        IModule[] ears = ServerUtil.getModules((String)"jst.ear");
        ArrayList<IModule> list = new ArrayList<IModule>();
        int i = 0;
        while (i < ears.length) {
            IEnterpriseApplication ear = (IEnterpriseApplication)ears[i].loadAdapter(IEnterpriseApplication.class, null);
            IModule[] childs = ear.getModules();
            int j = 0;
            while (j < childs.length) {
                if (childs[j].equals(module)) {
                    list.add(ears[i]);
                }
                ++j;
            }
            ++i;
        }
        return list.toArray(new IModule[list.size()]);
    }

    public Map getServerInstanceProperties() {
        return this.getAttribute("generic_server_instance_properties", new HashMap());
    }

    public void setServerInstanceProperties(Map map) {
        this.setAttribute("generic_server_instance_properties", map);
    }

    public IStatus validate() {
        EList<Property> props = this.getServerDefinition().getProperty();
        int i = 0;
        while (i < props.size()) {
            String path;
            Property property = (Property)props.get(i);
            if ((property.getType().equals("directory") || property.getType().equals("file")) && (path = (String)this.getInstanceProperties().get(property.getId())) != null && !this.pathExist(path)) {
                return new Status(4, "org.eclipse.jst.server.generic.core", 0, NLS.bind((String)GenericServerCoreMessages.invalidPath, (Object)path), null);
            }
            ++i;
        }
        return new Status(0, "org.eclipse.jst.server.generic.core", 0, "", null);
    }

    private boolean pathExist(String path) {
        File f = new File(path);
        return f.exists();
    }

    public void setDefaults(IProgressMonitor monitor) {
        ServerRuntime serverRuntime = this.getServerDefinition();
        if (serverRuntime == null) {
            return;
        }
        EList<Property> props = this.getServerDefinition().getProperty();
        HashMap<String, String> instancePropsMap = new HashMap<String, String>();
        for (Property element : props) {
            if (!"server".equalsIgnoreCase(element.getContext())) continue;
            if ("select".equals(element.getType()) || "combo".equals(element.getType())) {
                StringTokenizer tokenizer = new StringTokenizer(element.getDefault(), ",");
                if (!tokenizer.hasMoreTokens()) continue;
                String firstToken = tokenizer.nextToken();
                instancePropsMap.put(element.getId(), firstToken);
                continue;
            }
            instancePropsMap.put(element.getId(), element.getDefault());
        }
        this.setServerInstanceProperties(instancePropsMap);
    }
}

