/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.decorators;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.FilterUtil;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.IFilterNode;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.icons.ImageDescription;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IFilterNodeDecorationService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;

public class FilterNodeDecoration
extends LabelProvider
implements ILightweightLabelDecorator,
IFilterNodeDecorationService {
    private static final String FILTERED = " " + ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.FILTER_DECORATION");

    private boolean hasFiltering(IFilterNode filterNode) {
        return FilterUtil.hasFilter((IFilterNode)filterNode);
    }

    public void decorate(Object element, IDecoration decoration) {
        IFilterNode filterNode = (IFilterNode)element;
        if (this.hasFiltering(filterNode)) {
            decoration.addOverlay(ImageDescription.getFilterDecorationDescriptor(), 3);
            decoration.addSuffix(FILTERED);
        }
    }

    @Override
    public void refreshDecoration(Object[] elements) {
        this.fireLabelChangedEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, elements));
    }

    protected void fireLabelChangedEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FilterNodeDecoration.this.fireLabelProviderChanged(event);
            }
        });
    }
}

