/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tm4e.ui.internal.utils.UI;
import org.eclipse.tm4e.ui.internal.widgets.ColumnSelectionAdapter;
import org.eclipse.tm4e.ui.internal.widgets.ColumnViewerComparator;

public abstract class TableWidget<T>
extends TableViewer {
    private final TableColumnLayout tableColumnLayout = new TableColumnLayout();
    private final Set<TableColumn> autoResizeColumns = new HashSet<TableColumn>();
    private final List<int[]> secondarySortColumns = new ArrayList<int[]>();
    private final ColumnViewerComparator viewerComparator = new ColumnViewerComparator();

    protected TableWidget(Composite parent, boolean allowMultiSelection) {
        this(parent, 0x10B00 | (allowMultiSelection ? 2 : 4));
    }

    protected TableWidget(Composite parent, int style) {
        super(new Composite(parent, 0), style);
        this.setContentProvider((IContentProvider)((IStructuredContentProvider)this::getElements));
        this.setLabelProvider((IBaseLabelProvider)new CellLabelProvider());
        Table table = this.getTable();
        Composite container = table.getParent();
        container.setLayout((Layout)this.tableColumnLayout);
        if (parent.getLayout() instanceof GridLayout) {
            container.setLayoutData((Object)new GridData(1808));
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumns();
        this.setComparator(this.viewerComparator);
        this.setSortColumn(0, 1024);
        BidiUtils.applyTextDirection((Control)this.getControl(), (String)"default");
    }

    protected void createAutoResizeColumn(String label, int ... secondarySortColumns) {
        this.createColumn(label, 0, 0, secondarySortColumns);
        TableColumn col = this.getTable().getColumn(this.getTable().getColumnCount() - 1);
        this.autoResizeColumns.add(col);
    }

    protected void createColumn(@Nullable String label, int columnWeight, int minColWidth, int ... secondarySortColumns) {
        TableColumn col = new TableColumn(this.getTable(), 0);
        col.setText(label == null ? "" : label);
        this.secondarySortColumns.add(secondarySortColumns);
        col.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this, this.viewerComparator, secondarySortColumns));
        this.tableColumnLayout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(columnWeight, Math.max(UI.getTextWidth(col.getText()) + 15, minColWidth), true));
    }

    protected abstract void createColumns();

    protected abstract @Nullable Object getColumnText(T var1, int var2);

    public List<T> getElements() {
        return List.of(this.getElements(this.getInput()));
    }

    protected Object[] getElements(@Nullable Object input) {
        if (input == null) {
            return new Object[0];
        }
        if (input instanceof Collection) {
            Collection coll = (Collection)input;
            return coll.toArray(Object[]::new);
        }
        return (Object[])input;
    }

    public T getElementAt(int index) {
        return (T)super.getElementAt(index);
    }

    public int getElementCount() {
        return this.doGetItemCount();
    }

    public boolean isEmpty() {
        return this.doGetItemCount() == 0;
    }

    protected void inputChanged(@Nullable Object input, @Nullable Object oldInput) {
        super.inputChanged(input, oldInput);
        TableColumn[] tableColumnArray = this.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (this.autoResizeColumns.contains(column)) {
                column.pack();
            }
            ++n2;
        }
        this.refresh();
        if (this.getFirstSelectedElement() == null) {
            this.selectFirstRow();
        }
    }

    public TableWidget<T> onSelectionChanged(Consumer<List<T>> consumer) {
        this.addSelectionChangedListener(e -> {
            ISelection iSelection = e.getSelection();
            if (iSelection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)iSelection;
                if (sel.isEmpty()) {
                    consumer.accept(Collections.emptyList());
                } else {
                    consumer.accept(sel.toList());
                }
            }
        });
        return this;
    }

    public TableWidget<T> selectFirstRow() {
        UI.selectFirstElement(this);
        return this;
    }

    public @Nullable T getFirstSelectedElement() {
        ISelection iSelection = super.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)iSelection;
            return (T)selection.getFirstElement();
        }
        return null;
    }

    @Deprecated
    public ISelection getSelection() {
        return super.getSelection();
    }

    public List<T> getTypedSelection() {
        ISelection iSelection = super.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)iSelection;
            return selection.toList();
        }
        return Collections.emptyList();
    }

    public void setSelection(T ... selection) {
        this.setSelection((ISelection)new StructuredSelection((Object[])selection));
    }

    public void setSelection(List<T> selection) {
        this.setSelection((ISelection)new StructuredSelection(selection));
    }

    public void setSelection(Predicate<T> selector) {
        this.setSelection(this.getElements().stream().filter(selector).toList());
    }

    public void setSelection(boolean reveal, T ... selection) {
        this.setSelection(selection);
        if (reveal) {
            this.reveal(selection[0]);
        }
    }

    public void setSortColumn(int col, int sortDirection) {
        this.viewerComparator.setColumns(col, this.secondarySortColumns.get(col));
        this.viewerComparator.setDirection(sortDirection);
        this.getTable().setSortDirection(this.viewerComparator.getDirection());
        this.getTable().setSortColumn(this.getTable().getColumn(col));
    }

    public void refresh(@Nullable Object object) {
        Table swtTable = this.getTable();
        int selectedIndex = swtTable.getSelectionIndex();
        super.refresh(object);
        if (selectedIndex > -1 && !this.isEmpty()) {
            T newSelection;
            if (selectedIndex >= this.getElementCount()) {
                --selectedIndex;
            }
            if ((newSelection = this.getElementAt(selectedIndex)) != null) {
                this.setSelection(newSelection);
            }
        }
    }

    private final class CellLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private CellLabelProvider() {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            return null;
        }

        public @Nullable String getColumnText(@Nullable Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            Object text = TableWidget.this.getColumnText(element, columnIndex);
            return text == null ? null : text.toString();
        }

        public @Nullable String getText(@Nullable Object element) {
            return this.getColumnText(element, 0);
        }
    }
}

