/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.dataprovider;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.eclipse.tracecompass.common.core.format.DataSpeedWithUnitFormat;
import org.eclipse.tracecompass.common.core.format.DecimalWithUnitPrefixFormat;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public final class DataTypeUtils {
    private static final Format DECIMAL_NO_UNIT_FORMAT = new DecimalWithUnitPrefixFormat("");
    private static final Format OTHER_FORMAT = new Format(){
        private static final long serialVersionUID = -2824035517014261121L;

        @Override
        public StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
            if (toAppendTo == null) {
                return new StringBuffer(String.valueOf(obj));
            }
            return Objects.requireNonNull(toAppendTo.append(String.valueOf(obj)));
        }

        @Override
        public @Nullable Object parseObject(@Nullable String source, @Nullable ParsePosition pos) {
            return null;
        }
    };
    private static final Format BINARY_SPEED_FORMAT = new DataSpeedWithUnitFormat(){
        private static final long serialVersionUID = 6571473479261285111L;

        public Number parseObject(String source, ParsePosition pos) {
            return null;
        }
    };
    private static final Format BINARY_SIZE_FORMAT = new DataSizeWithUnitFormat(){
        private static final long serialVersionUID = 391619032553653610L;

        public Number parseObject(String source, ParsePosition pos) {
            return null;
        }
    };

    private DataTypeUtils() {
    }

    public static Format getFormat(DataType type, String units) {
        switch (type) {
            case NUMBER: {
                return units.isEmpty() ? DECIMAL_NO_UNIT_FORMAT : new DecimalWithUnitPrefixFormat(units);
            }
            case TIMESTAMP: {
                return Objects.requireNonNull(TmfTimestampFormat.getDefaulTimeFormat());
            }
            case BINARY_NUMBER: {
                if (units.endsWith("/s")) {
                    return BINARY_SPEED_FORMAT;
                }
                return BINARY_SIZE_FORMAT;
            }
            case DURATION: {
                return SubSecondTimeWithUnitFormat.getInstance();
            }
            case STRING: {
                return OTHER_FORMAT;
            }
            case TIME_RANGE: {
                return OTHER_FORMAT;
            }
        }
        return OTHER_FORMAT;
    }

    public static String toRangeString(long start, long end) {
        return "[" + start + "," + end + "]";
    }
}

