/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt.cocoa;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.osgi.service.event.Event;

public class CocoaUIHandler {
    private static final String COMMAND_ID_ABOUT = "org.eclipse.ui.help.aboutAction";
    private static final String COMMAND_ID_PREFERENCES = "org.eclipse.ui.window.preferences";
    private static final String COMMAND_ID_QUIT = "org.eclipse.ui.file.exit";
    private static final String COMMAND_PARAMETER_ID_MAY_PROMPT = "mayPrompt";
    protected MCommand closeDialogCommand;
    @Inject
    protected MApplication app;
    @Inject
    protected Provider<StatusReporter> statusReporter;
    @Inject
    protected ECommandService commandService;
    @Inject
    protected EHandlerService handlerService;
    @Inject
    protected EModelService modelService;
    @Inject
    protected EBindingService bindingService;
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    @Optional
    protected IPresentationEngine engine;

    @PostConstruct
    public void init() {
        Display display = Display.getDefault();
        display.syncExec(() -> {
            this.hookApplicationMenu();
            this.processModelMenus();
            for (MWindow window : this.app.getChildren()) {
                this.modifyWindowShell(window);
            }
        });
    }

    protected void processModelMenus() {
        for (MWindow window : this.app.getChildren()) {
            this.redirectHandledMenuItems(window.getMainMenu());
        }
        for (MMenuContribution contribution : this.app.getMenuContributions()) {
            this.processMenuContribution(contribution);
        }
    }

    private void processMenuContribution(MMenuContribution contribution) {
        for (MMenuElement elmt : contribution.getChildren()) {
            if (elmt instanceof MMenu) {
                this.redirectHandledMenuItems((MMenu)elmt);
                continue;
            }
            if (!(elmt instanceof MMenuItem)) continue;
            this.redirectHandledMenuItem((MMenuItem)elmt);
        }
    }

    void log(Exception e) {
        ((StatusReporter)this.statusReporter.get()).report((IStatus)new Status(2, "org.eclipse.e4.ui.workbench.renderers.swt.cocoa", "Exception occurred during CocoaUI processing", (Throwable)e), 32, new Object[0]);
    }

    @Inject
    @Optional
    private void monitorShellTopicChanges(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/widget/*") Event event) {
        if (event.getProperty("ChangedElement") instanceof MWindow && event.getProperty("NewValue") != null) {
            MWindow window = (MWindow)event.getProperty("ChangedElement");
            this.modifyWindowShell(window);
        }
    }

    @Inject
    @Optional
    private void monitorMainMenuTopicChanges(@UIEventTopic(value="org/eclipse/e4/ui/model/basic/Window/mainMenu/*") Event event) {
        Object newValue = event.getProperty("NewValue");
        Object oldValue = event.getProperty("OldValue");
        Object element = event.getProperty("ChangedElement");
        if (element instanceof MWindow && oldValue == null && newValue instanceof MMenu) {
            this.modifyWindowShell((MWindow)element);
        }
    }

    @Inject
    @Optional
    private void monitorMenuContributionsChanges(@UIEventTopic(value="org/eclipse/e4/ui/model/menu/MenuContributions/menuContributions/*") Event event) {
        if (event.getProperty("ChangedElement") instanceof MMenuContribution && event.getProperty("NewValue") != null) {
            MMenuContribution contribution = (MMenuContribution)event.getProperty("ChangedElement");
            this.processMenuContribution(contribution);
        }
    }

    @Inject
    @Optional
    private void monitorCommandChanges(@UIEventTopic(value="org/eclipse/e4/ui/model/application/Application/commands/*") Event event) {
        MCommand cmd;
        String id2;
        if (event.getProperty("ChangedElement") instanceof MCommand && (COMMAND_ID_ABOUT.equals(id2 = (cmd = (MCommand)event.getProperty("ChangedElement")).getElementId()) || COMMAND_ID_PREFERENCES.equals(id2) || COMMAND_ID_QUIT.equals(id2))) {
            this.hookApplicationMenu();
        }
    }

    protected void modifyWindowShell(MWindow window) {
        if (window.getWidget() == null) {
            return;
        }
        if (window.getMainMenu() == null) {
            return;
        }
        this.redirectHandledMenuItems(window.getMainMenu());
    }

    private void redirectHandledMenuItems(MMenu menu) {
        if (menu == null) {
            return;
        }
        for (MMenuElement elmt : menu.getChildren()) {
            if (elmt instanceof MMenu) {
                this.redirectHandledMenuItems((MMenu)elmt);
                continue;
            }
            if (!(elmt instanceof MMenuItem)) continue;
            this.redirectHandledMenuItem((MMenuItem)elmt);
        }
    }

    private void redirectHandledMenuItem(MMenuItem item) {
        String elmtId = item.getElementId();
        if (elmtId != null && (elmtId.equals(COMMAND_ID_ABOUT) || elmtId.equals(COMMAND_ID_PREFERENCES) || elmtId.equals(COMMAND_ID_QUIT))) {
            item.setVisible(false);
            item.setToBeRendered(false);
            if (this.engine != null) {
                this.engine.removeGui((MUIElement)item);
            }
        } else if (item instanceof MHandledMenuItem) {
            MHandledMenuItem mhmi = (MHandledMenuItem)item;
            String string = elmtId = mhmi.getCommand() == null ? null : mhmi.getCommand().getElementId();
            if (elmtId != null && (elmtId.equals(COMMAND_ID_ABOUT) || elmtId.equals(COMMAND_ID_PREFERENCES) || elmtId.equals(COMMAND_ID_QUIT))) {
                item.setVisible(false);
                item.setToBeRendered(false);
                if (this.engine != null) {
                    this.engine.removeGui((MUIElement)item);
                }
            }
        }
    }

    private void hookApplicationMenu() {
        this.hookAppMenuItem(-6, COMMAND_ID_QUIT);
        this.hookAppMenuItem(-2, COMMAND_ID_PREFERENCES);
        this.hookAppMenuItem(-1, COMMAND_ID_ABOUT);
    }

    private void hookAppMenuItem(int menuItemId, final String commandId) {
        Menu[] menusToCheck;
        Display display = Display.getDefault();
        Menu[] menuArray = menusToCheck = new Menu[]{display.getMenuBar(), display.getSystemMenu()};
        int n = menusToCheck.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item;
            Menu topLevelMenu = menuArray[n2];
            if (topLevelMenu != null && (item = this.findMenuItemById(topLevelMenu, menuItemId)) != null) {
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (CocoaUIHandler.this.runCommand(commandId) || CocoaUIHandler.this.runAction(commandId)) {
                            e.doit = false;
                        }
                    }
                });
            }
            ++n2;
        }
    }

    private MenuItem findMenuItemById(Menu menu, int menuItemId) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem mi = menuItemArray[n2];
            if (mi.getID() == menuItemId) {
                return mi;
            }
            ++n2;
        }
        return null;
    }

    private boolean runAction(String actionId) {
        MWindow window = (MWindow)this.app.getSelectedElement();
        if (window == null) {
            return false;
        }
        MMenu topMenu = window.getMainMenu();
        MMenuItem item = this.findAction(actionId, topMenu);
        if (item == null || !item.isEnabled()) {
            return false;
        }
        try {
            Display display = Display.getDefault();
            MenuItem aboutItem = null;
            boolean aboutEnabled = true;
            MenuItem prefsItem = null;
            boolean prefsEnabled = true;
            Menu appMenuBar = display.getMenuBar();
            if (appMenuBar != null) {
                aboutItem = this.findMenuItemById(appMenuBar, -1);
                if (aboutItem != null) {
                    aboutEnabled = aboutItem.getEnabled();
                    aboutItem.setEnabled(false);
                }
                if ((prefsItem = this.findMenuItemById(appMenuBar, -2)) != null) {
                    prefsEnabled = prefsItem.getEnabled();
                    prefsItem.setEnabled(false);
                }
            }
            try {
                this.simulateMenuSelection(item);
            }
            finally {
                if (prefsItem != null) {
                    prefsItem.setEnabled(prefsEnabled);
                }
                if (aboutItem != null) {
                    aboutItem.setEnabled(aboutEnabled);
                }
            }
        }
        catch (Exception e) {
            this.log(e);
        }
        return true;
    }

    private void simulateMenuSelection(MMenuItem item) {
        IEclipseContext lclContext = this.getContext((MUIElement)item);
        if (item instanceof MDirectMenuItem) {
            MDirectMenuItem dmi = (MDirectMenuItem)item;
            if (dmi.getObject() == null) {
                IContributionFactory cf = (IContributionFactory)lclContext.get(IContributionFactory.class.getName());
                dmi.setObject(cf.create(dmi.getContributionURI(), lclContext));
            }
            lclContext.set(MItem.class.getName(), (Object)item);
            ContextInjectionFactory.invoke((Object)dmi.getObject(), Execute.class, (IEclipseContext)lclContext);
            lclContext.remove(MItem.class.getName());
        } else if (item instanceof MHandledMenuItem) {
            MHandledMenuItem hmi = (MHandledMenuItem)item;
            EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
            ParameterizedCommand cmd = hmi.getWbCommand();
            if (cmd == null) {
                cmd = this.generateParameterizedCommand((MHandledItem)hmi);
            }
            lclContext.set(MItem.class.getName(), (Object)item);
            service.executeHandler(cmd);
            lclContext.remove(MItem.class.getName());
        } else {
            ((StatusReporter)this.statusReporter.get()).report((IStatus)new Status(2, "org.eclipse.e4.ui.workbench.renderers.swt.cocoa", "Unhandled menu type: " + String.valueOf(item.getClass()) + ": " + String.valueOf(item)), 32, new Object[0]);
        }
    }

    private IEclipseContext getContext(MUIElement element) {
        if (element instanceof MContext) {
            return ((MContext)element).getContext();
        }
        return this.modelService.getContainingContext(element);
    }

    private boolean runCommand(String commandId) {
        if (this.commandService == null || this.handlerService == null) {
            return false;
        }
        Map<String, String> params = COMMAND_ID_QUIT.equals(commandId) ? Collections.singletonMap(COMMAND_PARAMETER_ID_MAY_PROMPT, "true") : null;
        ParameterizedCommand cmd = this.commandService.createCommand(commandId, params);
        if (cmd == null) {
            return false;
        }
        this.handlerService.executeHandler(cmd);
        return true;
    }

    private MMenuItem findAction(String actionId, MMenu menu) {
        if (menu == null) {
            return null;
        }
        for (MMenuElement item : menu.getChildren()) {
            MMenuItem found;
            if (item instanceof MMenuItem) {
                MHandledMenuItem mhmi;
                MMenuItem mmi = (MMenuItem)item;
                if (mmi.getElementId() != null && mmi.getElementId().equals(actionId)) {
                    return mmi;
                }
                if (!(mmi instanceof MHandledMenuItem) || (mhmi = (MHandledMenuItem)mmi).getCommand() == null || !actionId.equals(mhmi.getCommand().getElementId())) continue;
                return mmi;
            }
            if (!(item instanceof MMenu) || (found = this.findAction(actionId, (MMenu)item)) == null) continue;
            return found;
        }
        return null;
    }

    private ParameterizedCommand generateParameterizedCommand(MHandledItem item) {
        HashMap<String, String> parameters = null;
        List modelParms = item.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = this.commandService.createCommand(item.getCommand().getElementId(), parameters);
        item.setWbCommand(cmd);
        return cmd;
    }
}

