/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.widgets.Item;
import org.eclipse.zest.core.widgets.DefaultSubgraph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer2;
import org.eclipse.zest.core.widgets.InternalLayoutContext;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.NodeLayout;
import org.eclipse.zest.layouts.interfaces.SubgraphLayout;

class InternalNodeLayout
implements NodeLayout {
    private static final FigureListener figureListener = source -> {
        GraphNode node = figureToNode.get(source);
        if (node.getLayout().isMinimized() && source.getSize().equals(0, 0)) {
            source.setVisible(false);
        } else {
            source.setVisible(node.isVisible());
        }
    };
    private static final Map<IFigure, GraphNode> figureToNode = new HashMap<IFigure, GraphNode>();
    private DisplayIndependentPoint location;
    private DisplayIndependentDimension size;
    private boolean minimized = false;
    private final GraphNode node;
    private final InternalLayoutContext ownerLayoutContext;
    private DefaultSubgraph subgraph;
    private boolean isDisposed = false;

    public InternalNodeLayout(GraphNode graphNode) {
        this.node = graphNode;
        this.ownerLayoutContext = (InternalLayoutContext)((IContainer2)this.node.parent).getLayoutContext();
        graphNode.nodeFigure.addFigureListener(figureListener);
        figureToNode.put(graphNode.nodeFigure, graphNode);
    }

    public DisplayIndependentPoint getLocation() {
        if (this.location == null) {
            this.refreshLocation();
        }
        return new DisplayIndependentPoint(this.location);
    }

    public DisplayIndependentDimension getSize() {
        if (this.size == null) {
            this.refreshSize();
        }
        return new DisplayIndependentDimension(this.size);
    }

    public SubgraphLayout getSubgraph() {
        return this.subgraph;
    }

    public boolean isMovable() {
        return true;
    }

    public boolean isPrunable() {
        return this.ownerLayoutContext.isPruningEnabled();
    }

    public boolean isPruned() {
        return this.subgraph != null;
    }

    public boolean isResizable() {
        return (((IContainer2)this.node.parent).getItem().getStyle() & 0x10) == 0;
    }

    public void prune(SubgraphLayout subgraph) {
        if (subgraph != null && !(subgraph instanceof DefaultSubgraph)) {
            throw new RuntimeException("InternalNodeLayout can be pruned only to instance of DefaultSubgraph.");
        }
        this.ownerLayoutContext.checkChangesAllowed();
        if (subgraph == this.subgraph) {
            return;
        }
        if (this.subgraph != null) {
            DefaultSubgraph subgraph2 = this.subgraph;
            this.subgraph = null;
            subgraph2.removeNodes(new NodeLayout[]{this});
        }
        if (subgraph != null) {
            this.subgraph = (DefaultSubgraph)subgraph;
            subgraph.addNodes(new NodeLayout[]{this});
        }
    }

    public void setLocation(double x, double y) {
        if (!this.ownerLayoutContext.isLayoutItemFiltered(this.getNode())) {
            this.ownerLayoutContext.checkChangesAllowed();
            this.internalSetLocation(x, y);
        }
    }

    private void internalSetLocation(double x, double y) {
        if (this.location != null) {
            this.location.x = x;
            this.location.y = y;
        } else {
            this.location = new DisplayIndependentPoint(x, y);
        }
    }

    public void setSize(double width, double height) {
        this.ownerLayoutContext.checkChangesAllowed();
        this.internalSetSize(width, height);
    }

    private void internalSetSize(double width, double height) {
        if (this.size != null) {
            this.size.width = width;
            this.size.height = height;
        } else {
            this.size = new DisplayIndependentDimension(width, height);
        }
    }

    public void setMinimized(boolean minimized) {
        this.ownerLayoutContext.checkChangesAllowed();
        this.getSize();
        this.minimized = minimized;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public NodeLayout[] getPredecessingNodes() {
        ConnectionLayout[] connections = this.getIncomingConnections();
        NodeLayout[] result = new NodeLayout[connections.length];
        int i = 0;
        while (i < connections.length) {
            result[i] = connections[i].getSource();
            if (result[i] == this) {
                result[i] = connections[i].getTarget();
            }
            ++i;
        }
        return result;
    }

    public NodeLayout[] getSuccessingNodes() {
        ConnectionLayout[] connections = this.getOutgoingConnections();
        NodeLayout[] result = new NodeLayout[connections.length];
        int i = 0;
        while (i < connections.length) {
            result[i] = connections[i].getTarget();
            if (result[i] == this) {
                result[i] = connections[i].getSource();
            }
            ++i;
        }
        return result;
    }

    public EntityLayout[] getSuccessingEntities() {
        NodeLayout[] successingNodes;
        if (this.isPruned()) {
            return new NodeLayout[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HashSet<SubgraphLayout> addedSubgraphs = new HashSet<SubgraphLayout>();
        NodeLayout[] nodeLayoutArray = successingNodes = this.getSuccessingNodes();
        int n = successingNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout successingNode = nodeLayoutArray[n2];
            if (!successingNode.isPruned()) {
                result.add(successingNode);
            } else {
                SubgraphLayout successingSubgraph = successingNode.getSubgraph();
                if (successingSubgraph.isGraphEntity() && !addedSubgraphs.contains(successingSubgraph)) {
                    result.add(successingSubgraph);
                    addedSubgraphs.add(successingSubgraph);
                }
            }
            ++n2;
        }
        return result.toArray(new EntityLayout[result.size()]);
    }

    public EntityLayout[] getPredecessingEntities() {
        NodeLayout[] predecessingNodes;
        if (this.isPruned()) {
            return new NodeLayout[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HashSet<SubgraphLayout> addedSubgraphs = new HashSet<SubgraphLayout>();
        NodeLayout[] nodeLayoutArray = predecessingNodes = this.getPredecessingNodes();
        int n = predecessingNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout predecessingNode = nodeLayoutArray[n2];
            if (!predecessingNode.isPruned()) {
                result.add(predecessingNode);
            } else {
                SubgraphLayout predecessingSubgraph = predecessingNode.getSubgraph();
                if (predecessingSubgraph.isGraphEntity() && !addedSubgraphs.contains(predecessingSubgraph)) {
                    result.add(predecessingSubgraph);
                    addedSubgraphs.add(predecessingSubgraph);
                }
            }
            ++n2;
        }
        return result.toArray(new EntityLayout[result.size()]);
    }

    public ConnectionLayout[] getIncomingConnections() {
        ArrayList<GraphConnection.InternalConnectionLayout> result = new ArrayList<GraphConnection.InternalConnectionLayout>();
        for (GraphConnection graphConnection : this.node.getTargetConnections()) {
            if (this.ownerLayoutContext.isLayoutItemFiltered(graphConnection)) continue;
            result.add(graphConnection.getLayout());
        }
        for (GraphConnection graphConnection : this.node.getSourceConnections()) {
            if (graphConnection.isDirected() || this.ownerLayoutContext.isLayoutItemFiltered(graphConnection)) continue;
            result.add(graphConnection.getLayout());
        }
        return result.toArray(new ConnectionLayout[result.size()]);
    }

    public ConnectionLayout[] getOutgoingConnections() {
        ArrayList<GraphConnection.InternalConnectionLayout> result = new ArrayList<GraphConnection.InternalConnectionLayout>();
        for (GraphConnection graphConnection : this.node.getSourceConnections()) {
            if (this.ownerLayoutContext.isLayoutItemFiltered(graphConnection)) continue;
            result.add(graphConnection.getLayout());
        }
        for (GraphConnection graphConnection : this.node.getTargetConnections()) {
            if (graphConnection.isDirected() || this.ownerLayoutContext.isLayoutItemFiltered(graphConnection)) continue;
            result.add(graphConnection.getLayout());
        }
        return result.toArray(new ConnectionLayout[result.size()]);
    }

    public double getPreferredAspectRatio() {
        return 0.0;
    }

    GraphNode getNode() {
        return this.node;
    }

    public Item[] getItems() {
        return new GraphNode[]{this.node};
    }

    void applyLayout() {
        if (this.minimized) {
            this.node.setSize(0.0, 0.0);
            if (this.location != null) {
                this.node.setLocation(this.location.x, this.location.y);
            }
        } else {
            this.node.setSize(-1.0, -1.0);
            if (this.location != null) {
                this.node.setLocation(this.location.x, this.location.y);
            }
            if (this.size != null) {
                Dimension currentSize = this.node.getSize();
                if (this.size.width != (double)currentSize.width || this.size.height != (double)currentSize.height) {
                    this.node.setSize(this.size.width, this.size.height);
                }
            }
        }
    }

    InternalLayoutContext getOwnerLayoutContext() {
        return this.ownerLayoutContext;
    }

    void refreshSize() {
        Dimension size2 = this.node.getSize();
        this.internalSetSize(size2.width, size2.height);
    }

    void refreshLocation() {
        Point location2 = this.node.getLocation();
        this.internalSetLocation((double)location2.x + this.getSize().width / 2.0, (double)location2.y + this.size.height / 2.0);
    }

    public String toString() {
        return this.node.toString() + "(layout)";
    }

    void dispose() {
        this.isDisposed = true;
        if (this.subgraph != null) {
            this.subgraph.removeDisposedNodes();
        }
        this.ownerLayoutContext.fireNodeRemovedEvent(this.node.getLayout());
        figureToNode.remove(this.node.nodeFigure);
    }

    boolean isDisposed() {
        return this.isDisposed;
    }
}

