/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.build.gcc.core.internal.Activator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class GCCToolChain
extends PlatformObject
implements IToolChain {
    public static final String TYPE_ID = "org.eclipse.cdt.build.gcc";
    private static Pattern definePattern = Pattern.compile("#define ([^\\s]*)\\s(.*)");
    private final IToolChainProvider provider;
    private final String id;
    private final Path path;
    private final IEnvironmentVariable pathVar;
    private final IEnvironmentVariable[] envVars;
    private final Map<String, String> properties = new HashMap<String, String>();
    private String cCommand;
    private String cppCommand;
    private String[] commands;
    private Set<String> resourcesFileExtensions = this.getResourcesFileExtensions();
    private static Pattern MINGW_PATH = Pattern.compile("\\/([a-zA-z])(\\/.*)");

    @Deprecated
    public GCCToolChain(IToolChainProvider provider, String id, String version) {
        this(provider, id, version, null, null);
    }

    @Deprecated
    public GCCToolChain(IToolChainProvider provider, String id, String version, Path[] path) {
        this(provider, id, version, path, null);
    }

    @Deprecated
    public GCCToolChain(IToolChainProvider provider, String id, String version, Path[] path, String prefix) {
        this.provider = provider;
        this.id = id;
        if (path != null && path.length > 0) {
            StringBuilder pathString = new StringBuilder();
            int i = 0;
            while (i < path.length) {
                pathString.append(path[i].toString());
                if (i < path.length - 1) {
                    pathString.append(File.pathSeparator);
                }
                ++i;
            }
            this.path = path[0];
            this.pathVar = new EnvironmentVariable("PATH", pathString.toString(), 3, File.pathSeparator);
            this.envVars = new IEnvironmentVariable[]{this.pathVar};
        } else {
            this.path = null;
            this.pathVar = null;
            this.envVars = new IEnvironmentVariable[0];
        }
    }

    public GCCToolChain(IToolChainProvider provider, Path pathToToolChain, String arch, IEnvironmentVariable[] envVars) {
        this.provider = provider;
        this.path = pathToToolChain;
        StringBuilder idBuilder = new StringBuilder("gcc-");
        if (arch != null) {
            idBuilder.append(arch);
        }
        idBuilder.append('-');
        if (pathToToolChain != null) {
            idBuilder.append(pathToToolChain.toString().replaceAll("\\\\", "/"));
        }
        this.id = idBuilder.toString();
        this.properties.put("arch", arch);
        EnvironmentVariable pathVar = null;
        if (envVars != null) {
            IEnvironmentVariable[] iEnvironmentVariableArray = envVars;
            int n = envVars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable envVar = iEnvironmentVariableArray[n2];
                if (envVar.getName().equals("PATH")) {
                    pathVar = envVar;
                }
                ++n2;
            }
        }
        if (pathVar == null && this.path != null) {
            pathVar = new EnvironmentVariable("PATH", this.path.getParent().toString(), 3, File.pathSeparator);
            if (envVars == null) {
                envVars = new IEnvironmentVariable[]{pathVar};
            } else {
                IEnvironmentVariable[] newVars = new IEnvironmentVariable[envVars.length + 1];
                System.arraycopy(envVars, 0, newVars, 0, envVars.length);
                newVars[envVars.length] = pathVar;
                envVars = newVars;
            }
        }
        this.pathVar = pathVar;
        this.envVars = envVars;
    }

    public String getTypeId() {
        return TYPE_ID;
    }

    public Path getPath() {
        return this.path;
    }

    public IToolChainProvider getProvider() {
        return this.provider;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return "";
    }

    public String getName() {
        String arch;
        StringBuilder name = new StringBuilder();
        String os = this.getProperty("os");
        if (os != null) {
            name.append(os);
            name.append(' ');
        }
        if ((arch = this.getProperty("arch")) != null) {
            name.append(arch);
            name.append(' ');
        }
        if (this.path != null) {
            name.append(this.path.toString());
        }
        return name.toString();
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if (value != null) {
            return value;
        }
        switch (key) {
            case "os": {
                return Platform.getOS();
            }
            case "arch": {
                if (!Platform.getOS().equals(this.getProperty("os"))) break;
                return Platform.getOSArch();
            }
        }
        return null;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    private String getBinaryParserId() {
        switch (Platform.getOS()) {
            case "win32": {
                return "org.eclipse.cdt.core.PE64";
            }
            case "macosx": {
                return "org.eclipse.cdt.core.MachO64";
            }
        }
        return "org.eclipse.cdt.core.ELF";
    }

    public List<String> getBinaryParserIds() {
        return List.of(this.getBinaryParserId());
    }

    protected void addDiscoveryOptions(List<String> command) {
        command.add("-E");
        command.add("-P");
        command.add("-v");
        command.add("-dD");
    }

    protected String fixMingwPath(String arg) {
        Matcher matcher;
        if (arg.startsWith("/") && Platform.getOS().equals("win32") && (matcher = MINGW_PATH.matcher(arg)).matches()) {
            return matcher.group(1) + ":" + matcher.group(2);
        }
        return arg;
    }

    public IExtendedScannerInfo getScannerInfo(IBuildConfiguration buildConfig, List<String> commandStrings, IExtendedScannerInfo baseScannerInfo, IResource resource, URI buildDirectoryURI) {
        try {
            Path buildDirectory = Paths.get(buildDirectoryURI);
            int offset = 0;
            Path command = Paths.get(commandStrings.get(offset), new String[0]);
            if (command.toString().contains("ccache")) {
                command = Paths.get(commandStrings.get(++offset), new String[0]);
            }
            ArrayList<String> commandLine = new ArrayList<String>();
            Path commandPath = this.getCommandPath(command);
            if (commandPath == null) {
                throw new NullPointerException("Cannot obtain full command path for command " + String.valueOf(command));
            }
            commandLine.add(commandPath.toString());
            if (baseScannerInfo != null) {
                if (baseScannerInfo.getIncludePaths() != null) {
                    String[] stringArray = baseScannerInfo.getIncludePaths();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String includePath = stringArray[n2];
                        commandLine.add("-I" + includePath);
                        ++n2;
                    }
                }
                if (baseScannerInfo.getDefinedSymbols() != null) {
                    for (Map.Entry macro : baseScannerInfo.getDefinedSymbols().entrySet()) {
                        if (macro.getValue() != null && !((String)macro.getValue()).isEmpty()) {
                            commandLine.add("-D" + (String)macro.getKey() + "=" + (String)macro.getValue());
                            continue;
                        }
                        commandLine.add("-D" + (String)macro.getKey());
                    }
                }
            }
            this.addDiscoveryOptions(commandLine);
            commandLine.addAll(commandStrings.subList(offset + 1, commandStrings.size()));
            if ("win32".equals(Platform.getOS())) {
                int i = 0;
                while (i < commandLine.size()) {
                    String arg = (String)commandLine.get(i);
                    if (arg.startsWith("\"") && arg.endsWith("\"")) {
                        commandLine.set(i, arg.substring(1, arg.length() - 1));
                    }
                    ++i;
                }
            }
            boolean haveOut = false;
            int i = 0;
            while (i < commandLine.size() - 1) {
                if (((String)commandLine.get(i)).equals("-o")) {
                    commandLine.set(i + 1, "-");
                    haveOut = true;
                    break;
                }
                ++i;
            }
            if (!haveOut) {
                commandLine.add("-o");
                commandLine.add("-");
            }
            Path tmpFile = null;
            int i2 = 1;
            while (i2 < commandLine.size()) {
                block35: {
                    String mingwPath;
                    String arg;
                    block36: {
                        Path filePath;
                        arg = (String)commandLine.get(i2);
                        if (arg.startsWith("-")) break block36;
                        try {
                            filePath = buildDirectory.resolve((String)commandLine.get(i2)).normalize();
                        }
                        catch (InvalidPathException e) {
                            break block35;
                        }
                        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(filePath.toUri());
                        if (files.length == 0 && (mingwPath = this.fixMingwPath(arg)) != arg) {
                            filePath = Paths.get(mingwPath, new String[0]);
                            files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(filePath.toUri());
                        }
                        if (files.length > 0 && files[0].exists()) {
                            Path parentPath = filePath.getParent();
                            Object extension = files[0].getFileExtension();
                            extension = extension == null ? ".cpp" : "." + (String)extension;
                            tmpFile = Files.createTempFile(parentPath, ".sc", (String)extension, new FileAttribute[0]);
                            commandLine.set(i2, tmpFile.toString());
                        }
                        break block35;
                    }
                    switch (arg) {
                        case "-D": 
                        case "-o": {
                            ++i2;
                            break;
                        }
                        case "-I": {
                            String path = (String)commandLine.get(++i2);
                            mingwPath = this.fixMingwPath(path);
                            if (path == mingwPath) break;
                            commandLine.set(i2, mingwPath);
                        }
                    }
                }
                ++i2;
            }
            if (tmpFile == null) {
                IPath parentPath;
                IPath iPath = parentPath = resource instanceof IFile ? resource.getParent().getLocation() : resource.getLocation();
                if (parentPath.toFile().exists()) {
                    tmpFile = Files.createTempFile(parentPath.toFile().toPath(), ".sc", ".cpp", new FileAttribute[0]);
                    commandLine.add(tmpFile.toString());
                }
            }
            return this.getScannerInfo(buildConfig, commandLine, buildDirectory, tmpFile);
        }
        catch (IOException e) {
            Activator.log(e);
            return null;
        }
    }

    public IExtendedScannerInfo getDefaultScannerInfo(IBuildConfiguration buildConfig, IExtendedScannerInfo baseScannerInfo, ILanguage language, URI buildDirectoryURI) {
        String extension;
        ArrayList<String> commandLine;
        Path buildDirectory;
        block14: {
            String[] commands;
            block13: {
                commands = this.getCompileCommands(language);
                if (commands != null && commands.length != 0) break block13;
                return null;
            }
            try {
                buildDirectory = Paths.get(buildDirectoryURI);
                Path command = Paths.get(commands[0], new String[0]);
                commandLine = new ArrayList<String>();
                Path commandPath = this.getCommandPath(command);
                if (commandPath == null) {
                    throw new NullPointerException("Cannot obtain full command path for command " + String.valueOf(command));
                }
                commandLine.add(commandPath.toString());
                if (baseScannerInfo != null) {
                    if (baseScannerInfo.getIncludePaths() != null) {
                        String[] stringArray = baseScannerInfo.getIncludePaths();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String includePath = stringArray[n2];
                            commandLine.add("-I" + includePath);
                            ++n2;
                        }
                    }
                    if (baseScannerInfo.getDefinedSymbols() != null) {
                        for (Map.Entry macro : baseScannerInfo.getDefinedSymbols().entrySet()) {
                            if (macro.getValue() != null && !((String)macro.getValue()).isEmpty()) {
                                commandLine.add("-D" + (String)macro.getKey() + "=" + (String)macro.getValue());
                                continue;
                            }
                            commandLine.add("-D" + (String)macro.getKey());
                        }
                    }
                }
                this.addDiscoveryOptions(commandLine);
                commandLine.add("-o");
                commandLine.add("-");
                if ("org.eclipse.cdt.core.g++".equals(language.getId())) {
                    extension = ".cpp";
                    break block14;
                }
                if ("org.eclipse.cdt.core.gcc".equals(language.getId())) {
                    extension = ".c";
                    break block14;
                }
                return null;
            }
            catch (IOException e) {
                Activator.log(e);
                return null;
            }
        }
        Path tmpFile = Files.createTempFile(buildDirectory, ".sc", extension, new FileAttribute[0]);
        commandLine.add(tmpFile.toString());
        return this.getScannerInfo(buildConfig, commandLine, buildDirectory, tmpFile);
    }

    private IExtendedScannerInfo getScannerInfo(IBuildConfiguration buildConfig, List<String> commandLine, final Path buildDirectory, Path tmpFile) throws IOException {
        Files.createDirectories(buildDirectory, new FileAttribute[0]);
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine).directory(buildDirectory.toFile());
        CCorePlugin.getDefault().getBuildEnvironmentManager().setEnvironment(processBuilder.environment(), buildConfig, true);
        final Process process = processBuilder.start();
        final HashMap symbols = new HashMap();
        final ArrayList includePath = new ArrayList();
        Thread includePathReaderThread = new Thread("Include Path Reader"){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                        String line = reader.readLine();
                        while (line != null) {
                            String dir = line.trim();
                            if (dir.equals(".")) {
                                includePath.add(buildDirectory.toString());
                            } else {
                                try {
                                    Path dirPath = Paths.get(dir, new String[0]);
                                    if (!dirPath.isAbsolute()) {
                                        dirPath = buildDirectory.resolve(dirPath);
                                    }
                                    if (Files.isDirectory(dirPath, new LinkOption[0])) {
                                        includePath.add(dirPath.toString());
                                    }
                                }
                                catch (InvalidPathException invalidPathException) {
                                    // empty catch block
                                }
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    CCorePlugin.log((Throwable)e);
                }
            }
        };
        includePathReaderThread.start();
        Thread macroReaderThread = new Thread("Macro reader"){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String line = reader.readLine();
                        while (line != null) {
                            Map<String, String> matchDefines = GCCToolChain.this.matchDefines(line);
                            if (matchDefines != null) {
                                symbols.putAll(matchDefines);
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    CCorePlugin.log((Throwable)e);
                }
            }
        };
        macroReaderThread.start();
        try {
            includePathReaderThread.join();
            macroReaderThread.join();
            process.waitFor();
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
        if (tmpFile != null) {
            Files.delete(tmpFile);
        }
        return new ExtendedScannerInfo(symbols, includePath.toArray(new String[includePath.size()]));
    }

    protected Map<String, String> matchDefines(String line) {
        Matcher matcher;
        if (line.startsWith("#define ") && (matcher = definePattern.matcher(line)).matches()) {
            return Map.of(matcher.group(1), matcher.group(2));
        }
        return Map.of();
    }

    public String[] getErrorParserIds() {
        return new String[]{"org.eclipse.cdt.core.GCCErrorParser", "org.eclipse.cdt.core.GASErrorParser", "org.eclipse.cdt.core.GLDErrorParser", "org.eclipse.cdt.core.GmakeErrorParser", "org.eclipse.cdt.core.CWDLocator"};
    }

    public IEnvironmentVariable getVariable(String name) {
        if (this.pathVar != null && (name.equals("PATH") || name.equals("Path"))) {
            return this.pathVar;
        }
        return null;
    }

    public IEnvironmentVariable[] getVariables() {
        return this.envVars;
    }

    public Path getCommandPath(Path command) {
        IEnvironmentVariable myPath;
        if (command.isAbsolute()) {
            return command;
        }
        if (Platform.getOS().equals("win32") && !command.toString().endsWith(".exe") && !command.toString().endsWith(".bat")) {
            command = Paths.get(command.toString() + ".exe", new String[0]);
        }
        String path = (myPath = this.getVariable("PATH")) != null ? myPath.getValue() : System.getenv("PATH");
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            Path entryPath = Paths.get(entry, new String[0]);
            Path cmdPath = entryPath.resolve(command);
            if (Files.isExecutable(cmdPath)) {
                return cmdPath;
            }
            ++n2;
        }
        return null;
    }

    private void initCompileCommands() {
        if (this.commands == null) {
            this.cCommand = this.path.getFileName().toString();
            this.cppCommand = null;
            if (this.cCommand.contains("gcc")) {
                this.cppCommand = this.cCommand.replace("gcc", "g++");
                this.commands = new String[]{this.cCommand, this.cppCommand, this.cCommand.replace("gcc", "cc"), this.cCommand.replace("gcc", "c++")};
            } else if (this.cCommand.contains("clang")) {
                this.cppCommand = this.cCommand.replace("clang", "clang++");
                this.commands = new String[]{this.cCommand, this.cppCommand};
            } else if (this.cCommand.contains("emcc")) {
                this.cppCommand = this.cCommand.replace("emcc", "em++");
                this.commands = new String[]{this.cCommand, this.cppCommand};
            } else {
                this.commands = new String[]{this.cCommand};
            }
        }
    }

    public String[] getCompileCommands() {
        this.initCompileCommands();
        return this.commands;
    }

    public String[] getCompileCommands(ILanguage language) {
        this.initCompileCommands();
        if ("org.eclipse.cdt.core.g++".equals(language.getId())) {
            return new String[]{this.cppCommand != null ? this.cppCommand : this.cCommand};
        }
        if ("org.eclipse.cdt.core.gcc".equals(language.getId())) {
            return new String[]{this.cCommand};
        }
        return new String[0];
    }

    private Set<String> getResourcesFileExtensions() {
        IContentTypeManager manager = Platform.getContentTypeManager();
        TreeSet<String> fileExts = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        IContentType contentTypeCpp = manager.getContentType("org.eclipse.cdt.core.cxxSource");
        fileExts.addAll(Arrays.asList(contentTypeCpp.getFileSpecs(8)));
        IContentType contentTypeC = manager.getContentType("org.eclipse.cdt.core.cSource");
        fileExts.addAll(Arrays.asList(contentTypeC.getFileSpecs(8)));
        return fileExts;
    }

    private static String getFileExtension(String fileName) {
        String ext = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            ext = fileName.substring(i + 1);
        }
        return ext;
    }

    public IResource[] getResourcesFromCommand(List<String> cmd, URI buildDirectoryURI) {
        ArrayList<IFile> resources = new ArrayList<IFile>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = cmd.size() - 1;
        while (i >= 0) {
            String arg = cmd.get(i);
            if (!arg.startsWith("-")) {
                if (i > 1 && cmd.get(i - 1).equals("-o")) {
                    --i;
                } else {
                    String ext = GCCToolChain.getFileExtension(arg);
                    if (this.resourcesFileExtensions.contains(ext)) {
                        try {
                            String mingwPath;
                            Path srcPath = Paths.get(arg, new String[0]);
                            URI uri = srcPath.isAbsolute() ? srcPath.toUri() : ((mingwPath = this.fixMingwPath(arg)) != arg ? Paths.get(mingwPath, new String[0]).toUri() : Paths.get(buildDirectoryURI).resolve(srcPath).toUri().normalize());
                            IFile[] iFileArray = root.findFilesForLocationURI(uri);
                            int n = iFileArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IFile resource = iFileArray[n2];
                                resources.add(resource);
                                ++n2;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            }
            --i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public List<String> stripCommand(List<String> command, IResource[] resources) {
        ArrayList<String> newCommand = new ArrayList<String>();
        int i = 0;
        while (i < command.size()) {
            String arg = command.get(i);
            if (arg.equals("-o")) {
                ++i;
            } else if (arg.startsWith("-")) {
                newCommand.add(arg);
            } else {
                String ext = GCCToolChain.getFileExtension(arg);
                if (!this.resourcesFileExtensions.contains(ext)) {
                    newCommand.add(arg);
                }
            }
            ++i;
        }
        return newCommand;
    }

    public static class GCCInfo {
        private static final Pattern versionPattern = Pattern.compile(".*(gcc|LLVM) version .*");
        private static final Pattern targetPattern = Pattern.compile("Target: (.*)");
        public String target;
        public String version;

        public GCCInfo(String command) throws IOException {
            this(command, null);
        }

        public GCCInfo(String command, Map<String, String> env) throws IOException {
            ProcessBuilder builder = new ProcessBuilder(command, "-v").redirectErrorStream(true);
            if (env != null) {
                Map<String, String> procEnv = builder.environment();
                for (Map.Entry<String, String> entry : env.entrySet()) {
                    if ("PATH".equals(entry.getKey())) {
                        String path = entry.getValue() + File.pathSeparator + procEnv.get("PATH");
                        procEnv.put("PATH", path);
                        continue;
                    }
                    procEnv.put(entry.getKey(), entry.getValue());
                }
            }
            Process proc = builder.start();
            Throwable throwable = null;
            Iterator<Map.Entry<String, String>> iterator = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    Matcher versionMatcher = versionPattern.matcher(line);
                    if (versionMatcher.matches()) {
                        this.version = line.trim();
                    } else {
                        Matcher targetMatcher = targetPattern.matcher(line);
                        if (targetMatcher.matches()) {
                            this.target = targetMatcher.group(1);
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GCCInfo other = (GCCInfo)obj;
            if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }
    }
}

