/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.bcoview.asm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.bcoview.asm.DecompiledClassInfo;
import org.eclipse.jdt.bcoview.asm.DecompiledMethod;
import org.eclipse.jdt.bcoview.asm.DecompilerOptions;
import org.eclipse.jdt.bcoview.asm.ICommentedClassVisitor;
import org.eclipse.jdt.bcoview.asm.Index;
import org.eclipse.jdt.bcoview.asm.JavaVersion;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class CommentedClassVisitor
extends Textifier
implements ICommentedClassVisitor {
    protected final boolean raw;
    protected final boolean showLines;
    protected final boolean showLocals;
    protected final boolean showStackMap;
    protected final boolean showHex;
    private final DecompilerOptions options;
    private DecompiledMethod currMethod;
    private String className;
    private JavaVersion javaVersion;
    private int accessFlags;
    private Textifier dummyAnnVisitor;
    private final ClassNode classNode;
    private LabelNode currentLabel;
    private int currentInsn;
    private static final String[] CHAR_NAMES = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "HT", "LF", "VT", "FF", "CR", "SO", "SI", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US"};

    public CommentedClassVisitor(ClassNode classNode, DecompilerOptions options) {
        super(589824);
        this.classNode = classNode;
        this.options = options;
        this.raw = !options.modes.get(3);
        this.showLines = options.modes.get(4);
        this.showLocals = options.modes.get(5);
        this.showStackMap = options.modes.get(9);
        this.showHex = options.modes.get(10);
        this.javaVersion = new JavaVersion(0);
    }

    private boolean decompilingEntireClass() {
        return this.options.methodFilter == null && this.options.fieldFilter == null;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.decompilingEntireClass()) {
            super.visit(version, access, name, signature, superName, interfaces);
        }
        this.className = name;
        this.javaVersion = new JavaVersion(version);
        this.accessFlags = access;
    }

    public Textifier visitClassAnnotation(String desc, boolean visible) {
        if (this.decompilingEntireClass()) {
            return super.visitClassAnnotation(desc, visible);
        }
        return this.getDummyVisitor();
    }

    public void visitClassAttribute(Attribute attr) {
        if (this.decompilingEntireClass()) {
            super.visitClassAttribute(attr);
        }
    }

    public void visitClassEnd() {
        if (this.decompilingEntireClass()) {
            super.visitClassEnd();
        }
    }

    public Textifier visitField(int access, String name, String desc, String signature, Object value) {
        if (this.options.methodFilter != null) {
            return this.getDummyVisitor();
        }
        if (this.options.fieldFilter != null && !name.equals(this.options.fieldFilter)) {
            return this.getDummyVisitor();
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.decompilingEntireClass()) {
            super.visitInnerClass(name, outerName, innerName, access);
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (this.decompilingEntireClass()) {
            super.visitOuterClass(owner, name, desc);
        }
    }

    public void visitSource(String file, String debug) {
        if (this.decompilingEntireClass()) {
            super.visitSource(file, debug);
        }
    }

    public Textifier visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.options.fieldFilter != null || this.options.methodFilter != null && !(name + desc).equals(this.options.methodFilter)) {
            return this.getDummyVisitor();
        }
        MethodNode meth = null;
        List<String> exList = Arrays.asList(exceptions);
        for (MethodNode mn : this.classNode.methods) {
            if (!mn.name.equals(name) || !mn.desc.equals(desc) || !mn.exceptions.equals(exList)) continue;
            meth = mn;
            break;
        }
        Objects.requireNonNull(meth);
        this.currMethod = new DecompiledMethod(this.className, new HashMap<Label, Integer>(), meth, this.options, access);
        Textifier textifier = super.visitMethod(access, name, desc, signature, exceptions);
        TraceMethodVisitor tm = new TraceMethodVisitor((Printer)textifier);
        meth.accept((MethodVisitor)tm);
        Object methodtext = this.text.remove(this.text.size() - 1);
        this.currMethod.setText((List)methodtext);
        this.text.add(this.currMethod);
        return textifier;
    }

    protected void appendDescriptor(int type, String desc) {
        this.appendDescriptor(this.stringBuilder, type, desc, this.raw);
    }

    protected void appendDescriptor(StringBuilder buf1, int type, String desc, boolean raw1) {
        block27: {
            block26: {
                if (desc == null) {
                    return;
                }
                if (!raw1) break block26;
                if (type == 5 || type == 2 || type == 4) {
                    buf1.append("// signature ").append(desc).append('\n');
                } else {
                    buf1.append(desc);
                }
                break block27;
            }
            block0 : switch (type) {
                case 0: {
                    buf1.append(CommentedClassVisitor.eatPackageNames(desc, '/'));
                    break;
                }
                case 3: 
                case 9: {
                    if (!desc.startsWith("(")) {
                        buf1.append(CommentedClassVisitor.getSimpleName(Type.getType((String)desc)));
                        break;
                    }
                    buf1.append("(");
                    Type[] types = Type.getArgumentTypes((String)desc);
                    int i = 0;
                    while (i < types.length) {
                        if (i > 0) {
                            buf1.append(", ");
                        }
                        buf1.append(CommentedClassVisitor.getSimpleName(types[i]));
                        ++i;
                    }
                    buf1.append(") : ");
                    Type returnType = Type.getReturnType((String)desc);
                    buf1.append(CommentedClassVisitor.getSimpleName(returnType));
                    break;
                }
                case 1: {
                    switch (desc) {
                        case "T": {
                            buf1.append("top");
                            break block0;
                        }
                        case "N": {
                            buf1.append("null");
                            break block0;
                        }
                        case "U": {
                            buf1.append("uninitialized_this");
                            break block0;
                        }
                    }
                    buf1.append(CommentedClassVisitor.getSimpleName(Type.getType((String)desc)));
                    break;
                }
                case 2: 
                case 4: {
                    if (this.stringBuilder.lastIndexOf(this.tab) != this.stringBuilder.length() - this.tab.length()) break;
                    this.stringBuilder.delete(this.stringBuilder.lastIndexOf(this.tab), this.stringBuilder.length());
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    buf1.append(desc);
                }
            }
        }
    }

    public static String getSimpleName(Type t) {
        String name = t.getClassName();
        return CommentedClassVisitor.eatPackageNames(name, '.');
    }

    private static String eatPackageNames(String name, char separator) {
        int start;
        int lastPoint = name.lastIndexOf(separator);
        if (lastPoint < 0) {
            return name;
        }
        StringBuffer sb = new StringBuffer(name);
        do {
            start = CommentedClassVisitor.getPackageStartIndex(sb, separator, lastPoint);
            sb.delete(start, lastPoint + 1);
        } while ((lastPoint = CommentedClassVisitor.lastIndexOf(sb, separator, start)) > 0);
        return sb.toString();
    }

    private static int lastIndexOf(StringBuffer chars, char c, int lastPoint) {
        int i = lastPoint - 1;
        while (i > 0) {
            if (chars.charAt(i) == c) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static int getPackageStartIndex(StringBuffer chars, char c, int firstPoint) {
        int i = firstPoint - 1;
        while (i >= 0) {
            char curr = chars.charAt(i);
            if (curr != c && !Character.isJavaIdentifierPart(curr)) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    private Index getIndex(Label label) {
        for (Object o : this.text) {
            if (!(o instanceof Index)) continue;
            Index index = (Index)o;
            if (index.labelNode == null || index.labelNode.getLabel() != label) continue;
            return index;
        }
        return null;
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (this.showStackMap) {
            this.addIndex(-1);
            super.visitFrame(type, nLocal, local, nStack, stack);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.addIndex(opcode);
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[opcode]).append(' ');
        this.appendDescriptor(0, owner);
        this.stringBuilder.append('.').append(name);
        this.appendDescriptor(3, desc);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitVarInsn(int opcode, int var) {
        this.addIndex(opcode);
        this.text.add(this.tab2 + OPCODES[opcode] + " " + var);
        if (!this.raw) {
            this.text.add(var);
        }
        this.text.add("\n");
    }

    public void visitLabel(Label label) {
        this.addIndex(-1);
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.ltab);
        this.appendLabel(label);
        Index index = this.getIndex(label);
        if (index != null) {
            this.stringBuilder.append(" (").append(index.insn).append(")");
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        InsnList instructions = this.currMethod.meth.instructions;
        LabelNode currLabel = null;
        int i = 0;
        while (i < instructions.size()) {
            LabelNode labelNode;
            AbstractInsnNode insnNode = instructions.get(i);
            if (insnNode instanceof LabelNode && (labelNode = (LabelNode)insnNode).getLabel() == label) {
                currLabel = labelNode;
            }
            ++i;
        }
        this.setCurrentLabel(currLabel);
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.addIndex(186);
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    public void visitIincInsn(int var, int increment) {
        this.addIndex(132);
        this.text.add(this.tab2 + "IINC " + var);
        if (!this.raw) {
            this.text.add(var);
        }
        this.text.add(" " + increment + "\n");
    }

    public void visitIntInsn(int opcode, int operand) {
        this.addIndex(opcode);
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[opcode]).append(' ').append(opcode == 188 ? TYPES[operand] : this.formatValue(operand)).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    private String formatValue(int operand) {
        if (this.showHex) {
            String intStr = Integer.toHexString(operand).toUpperCase();
            return intStr + CommentedClassVisitor.getAsCharComment(operand);
        }
        return Integer.toString(operand);
    }

    private static String getAsCharComment(int value) {
        if (65535 < value || value < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer("    // '");
        switch (value) {
            case 9: {
                sb.append("\\t");
                break;
            }
            case 13: {
                sb.append("\\r");
                break;
            }
            case 10: {
                sb.append("\\n");
                break;
            }
            case 12: {
                sb.append("\\f");
                break;
            }
            default: {
                sb.append((char)value);
            }
        }
        if (value >= CHAR_NAMES.length) {
            if (value == 127) {
                return sb.append("' (DEL)").toString();
            }
            return sb.append("'").toString();
        }
        return sb.append("' (").append(CHAR_NAMES[value]).append(")").toString();
    }

    private String formatValue(Object operand) {
        if (operand == null) {
            return "null";
        }
        if (this.showHex) {
            if (operand instanceof Integer) {
                String intStr = Integer.toHexString((Integer)operand).toUpperCase();
                return intStr + CommentedClassVisitor.getAsCharComment((Integer)operand);
            }
            if (operand instanceof Long) {
                return Long.toHexString((Long)operand).toUpperCase();
            }
            if (operand instanceof Double) {
                return Double.toHexString((Double)operand);
            }
            if (operand instanceof Float) {
                return Float.toHexString(((Float)operand).floatValue());
            }
        }
        return operand.toString();
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (this.showLocals) {
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    public void visitLdcInsn(Object cst) {
        this.addIndex(18);
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LDC ");
        if (cst instanceof String) {
            Printer.appendString((StringBuilder)this.stringBuilder, (String)((String)cst));
        } else if (cst instanceof Type) {
            Type type = (Type)cst;
            String descriptor = type.getDescriptor();
            if (type.getSort() == 11) {
                this.appendDescriptor(3, descriptor);
            } else {
                String descr = this.raw ? descriptor : descriptor.substring(0, descriptor.length() - 1);
                this.appendDescriptor(0, descr + ".class");
            }
        } else {
            this.stringBuilder.append(this.formatValue(cst));
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.showLocals) {
            super.visitMaxs(maxStack, maxLocals);
        }
    }

    public void visitInsn(int opcode) {
        this.addIndex(opcode);
        super.visitInsn(opcode);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.addIndex(opcode);
        super.visitTypeInsn(opcode, desc);
    }

    public void visitFieldInsn(int opcode, String owner1, String name, String desc) {
        this.addIndex(opcode);
        super.visitFieldInsn(opcode, owner1, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.addIndex(opcode);
        super.visitJumpInsn(opcode, label);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.addIndex(170);
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.addIndex(171);
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.addIndex(197);
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitLineNumber(int line, Label start) {
        if (this.showLines) {
            this.addIndex(-1);
            this.currMethod.addLineNumber(start, line);
            super.visitLineNumber(line, start);
        }
    }

    private void addIndex(int opcode) {
        this.text.add(new Index(this.currentLabel, this.currentInsn++, opcode));
    }

    void setCurrentLabel(LabelNode currentLabel) {
        this.currentLabel = currentLabel;
    }

    protected Textifier createTextifier() {
        CommentedClassVisitor classVisitor = new CommentedClassVisitor(this.classNode, this.options);
        classVisitor.currMethod = this.currMethod;
        return classVisitor;
    }

    @Override
    public DecompiledClassInfo getClassInfo() {
        return new DecompiledClassInfo(this.javaVersion, this.accessFlags);
    }

    private Textifier getDummyVisitor() {
        if (this.dummyAnnVisitor == null) {
            this.dummyAnnVisitor = new Textifier(589824){

                public void visitAnnotationEnd() {
                    this.text.clear();
                }

                public void visitClassEnd() {
                    this.text.clear();
                }

                public void visitFieldEnd() {
                    this.text.clear();
                }

                public void visitMethodEnd() {
                    this.text.clear();
                }
            };
        }
        return this.dummyAnnVisitor;
    }
}

