/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualContainer;
import org.eclipse.wst.common.componentcore.resources.ITaggedVirtualResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class VirtualFolder
extends VirtualContainer
implements IVirtualFolder,
ITaggedVirtualResource {
    public VirtualFolder(IProject aComponentProject, IPath aRuntimePath) {
        super(aComponentProject, aRuntimePath);
    }

    @Override
    public void create(int updateFlags, IProgressMonitor monitor) throws CoreException {
        IVirtualComponent container = ComponentCore.createComponent(this.getProject());
        if (!container.getRootFolder().getProjectRelativePath().isRoot()) {
            IFolder realFolder = this.getProject().getFolder(container.getRootFolder().getProjectRelativePath());
            IFolder newFolder = realFolder.getFolder(this.getRuntimePath());
            this.createResource((IContainer)newFolder, updateFlags, monitor);
        } else {
            IFolder newFolder = this.getProject().getFolder(this.getRuntimePath());
            this.createResource((IContainer)newFolder, updateFlags, monitor);
        }
    }

    @Override
    public boolean exists(IPath path) {
        throw new UnsupportedOperationException("Method not supported");
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.getUnderlyingFolder();
    }

    @Override
    public IResource[] getUnderlyingResources() {
        return this.getUnderlyingFolders();
    }

    @Override
    public IContainer getUnderlyingFolder() {
        IPath path = this.getProjectRelativePath();
        if (!path.isRoot()) {
            return this.getProject().getFolder(this.getProjectRelativePath());
        }
        return this.getProject();
    }

    @Override
    public IContainer[] getUnderlyingFolders() {
        IPath[] paths = this.getProjectRelativePaths();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < paths.length) {
            if (!paths[i].isRoot()) {
                IFolder folder = this.getProject().getFolder(paths[i]);
                if (folder != null && folder.exists() && !result.contains(folder)) {
                    result.add(folder);
                }
            } else {
                result.add(this.getProject());
            }
            ++i;
        }
        return result.toArray(new IContainer[result.size()]);
    }

    @Override
    protected void doDeleteMetaModel(int updateFlags, IProgressMonitor monitor) {
        StructureEdit moduleCore = null;
        try {
            IPath runtimePath = this.getRuntimePath();
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            ComponentResource[] resources = component.findResourcesByRuntimePath(runtimePath);
            int i = 0;
            while (i < resources.length) {
                if (runtimePath.equals((Object)resources[i].getRuntimePath())) {
                    component.getResources().remove((Object)resources[i]);
                }
                ++i;
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(null);
                moduleCore.dispose();
            }
        }
    }

    @Override
    protected void doDeleteRealResources(int updateFlags, IProgressMonitor monitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            IPath runtimePath = this.getRuntimePath();
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            ComponentResource[] resources = component.findResourcesByRuntimePath(runtimePath);
            int i = 0;
            while (i < resources.length) {
                IResource realResource;
                if (runtimePath.equals((Object)resources[i].getRuntimePath()) && (realResource = StructureEdit.getEclipseResource(resources[i])) != null && realResource.getType() == this.getType()) {
                    realResource.delete(updateFlags, monitor);
                }
                ++i;
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(null);
                moduleCore.dispose();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean tagResource(IPath aProjectRelativeLocation, String tag, IProgressMonitor monitor) {
        block8: {
            moduleCore = null;
            if (aProjectRelativeLocation == null) break block8;
            if (aProjectRelativeLocation.isUNC()) {
                aProjectRelativeLocation = aProjectRelativeLocation.makeUNC(false);
            }
            absolutePath = aProjectRelativeLocation.makeAbsolute();
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            aComponent = moduleCore.getComponent();
            var11_8 = resources = aComponent.findResourcesByRuntimePath(this.getRuntimePath());
            var10_9 = resources.length;
            var9_10 = 0;
            while (true) {
                resource = var11_8[var9_10];
                if (resource.getSourcePath().equals((Object)absolutePath)) {
                    resource.setTag(tag);
                    return true;
                }
                ++var9_10;
                return (boolean)var9_10;
            }
        }
lbl21:
        // 2 sources

        return false;
        finally {
            if (var9_10 < var10_9) ** continue;
            ** continue;
        }
    }

    @Override
    public IPath getFirstTaggedResource(String tag) {
        List<IPath> paths = this.internalGetTaggedResources(tag, true);
        return !paths.isEmpty() ? paths.get(0) : null;
    }

    @Override
    public IPath[] getTaggedResources(String tag) {
        return this.internalGetTaggedResources(tag, false).toArray(new IPath[0]);
    }

    private List<IPath> internalGetTaggedResources(String tag, boolean firstOnly) {
        WorkbenchComponent aComponent = null;
        ArrayList<IPath> paths = new ArrayList<IPath>();
        aComponent = this.getReadOnlyComponent();
        if (aComponent != null) {
            ComponentResource[] resources;
            ComponentResource[] componentResourceArray = resources = aComponent.findResourcesByRuntimePath(this.getRuntimePath());
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentResource resource = componentResourceArray[n2];
                if (tag.equals(resource.getTag())) {
                    paths.add(resource.getSourcePath());
                    if (firstOnly) break;
                }
                ++n2;
            }
        }
        return paths;
    }
}

