/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigEditPage;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigTypePage2;

public class NewLaunchConfigWizard
extends Wizard
implements ILaunchConfigurationListener {
    private NewLaunchConfigTypePage2 typePage;
    private NewLaunchConfigEditPage editPage;
    private List<ILaunchConfiguration> configsToDelete = new ArrayList<ILaunchConfiguration>();

    public NewLaunchConfigWizard() {
        this.editPage = new NewLaunchConfigEditPage();
        this.typePage = new NewLaunchConfigTypePage2(this.editPage);
        this.setWindowTitle(Messages.NewLaunchConfigWizard_0);
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer != null) {
            ((WizardDialog)wizardContainer).addPageChangingListener((IPageChangingListener)this.editPage);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.typePage);
        this.addPage((IWizardPage)this.editPage);
    }

    public boolean canFinish() {
        if (this.getPage(this.editPage.getName()) == null) {
            return false;
        }
        return super.canFinish();
    }

    public ILaunchConfigurationWorkingCopy getWorkingCopy() {
        return this.editPage.getWorkingCopy();
    }

    public ILaunchMode getLaunchMode() {
        return null;
    }

    public boolean performFinish() {
        this.cleanUpConfigs();
        return this.editPage.performFinish();
    }

    public boolean performCancel() {
        this.cleanUpConfigs();
        return super.performCancel();
    }

    void cleanUpConfigs() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        for (ILaunchConfiguration config : this.configsToDelete) {
            try {
                config.delete();
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy()) {
            this.configsToDelete.add(configuration);
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy()) {
            this.configsToDelete.remove(configuration);
        }
    }
}

