/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeContribution;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class LaunchConfigurationTreeContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private String fMode;
    private Shell fShell;

    public LaunchConfigurationTreeContentProvider(String mode, Shell shell) {
        this.setMode(mode);
        this.setShell(shell);
    }

    public Object[] getChildren(Object parentElement) {
        block7: {
            try {
                if (parentElement instanceof ILaunchConfiguration) {
                    if (((ILaunchConfiguration)parentElement).isPrototype()) {
                        return ((ILaunchConfiguration)parentElement).getPrototypeChildren().toArray();
                    }
                    break block7;
                }
                if (parentElement instanceof ILaunchConfigurationType) {
                    ILaunchConfiguration[] launchConfigurations;
                    ILaunchConfigurationType type = (ILaunchConfigurationType)parentElement;
                    ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
                    ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = this.getLaunchManager().getLaunchConfigurations(type, 1);
                    int n = launchConfigurations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
                        if (launchConfig.getPrototype() == null) {
                            configs.add(launchConfig);
                        }
                        ++n2;
                    }
                    ILaunchConfiguration[] prototypes = this.getLaunchManager().getLaunchConfigurations(type, 2);
                    Collections.addAll(configs, prototypes);
                    return configs.toArray(new ILaunchConfiguration[0]);
                }
                return this.getLaunchManager().getLaunchConfigurationTypes();
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Error_19, LaunchConfigurationsMessages.LaunchConfigurationDialog_An_exception_occurred_while_retrieving_launch_configurations_20, e);
            }
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof ILaunchConfiguration) {
            if (!((ILaunchConfiguration)element).exists()) {
                return null;
            }
            try {
                ILaunchConfiguration prototype = ((ILaunchConfiguration)element).getPrototype();
                if (prototype != null) {
                    return prototype;
                }
                return ((ILaunchConfiguration)element).getType();
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Error_19, LaunchConfigurationsMessages.LaunchConfigurationDialog_An_exception_occurred_while_retrieving_launch_configurations_20, e);
            }
        } else if (element instanceof ILaunchConfigurationType) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ILaunchConfiguration) {
            if (((ILaunchConfiguration)element).isPrototype()) {
                try {
                    return ((ILaunchConfiguration)element).getPrototypeChildren().size() > 0;
                }
                catch (CoreException e) {
                    DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Error_19, LaunchConfigurationsMessages.LaunchConfigurationDialog_An_exception_occurred_while_retrieving_launch_configurations_20, e);
                }
            }
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        ILaunchConfigurationType[] allTypes = this.getLaunchManager().getLaunchConfigurationTypes();
        return this.filterTypes(allTypes).toArray();
    }

    private List<ILaunchConfigurationType> filterTypes(ILaunchConfigurationType[] allTypes) {
        ArrayList<ILaunchConfigurationType> filteredTypes = new ArrayList<ILaunchConfigurationType>();
        String mode = this.getMode();
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = allTypes;
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType type = iLaunchConfigurationTypeArray[n2];
            LaunchConfigurationTypeContribution contribution = new LaunchConfigurationTypeContribution(type);
            if (this.isVisible(type, mode) && !WorkbenchActivityHelper.filterItem((Object)contribution)) {
                filteredTypes.add(type);
            }
            ++n2;
        }
        return filteredTypes;
    }

    private boolean isVisible(ILaunchConfigurationType configType, String mode) {
        if (!configType.isPublic()) {
            return false;
        }
        if (mode == null) {
            return true;
        }
        return configType.supportsMode(mode);
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private void setMode(String mode) {
        this.fMode = mode;
    }

    private String getMode() {
        return this.fMode;
    }

    private void setShell(Shell shell) {
        this.fShell = shell;
    }

    private Shell getShell() {
        return this.fShell;
    }
}

