/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.resolver.catalog;

import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.resolver.catalog.CatalogEntityResolver;
import com.thaiopensource.resolver.catalog.ResolverIOException;
import com.thaiopensource.resolver.xml.XMLDocumentIdentifier;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.sax.SAXSource;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.readers.OASISXMLCatalogReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class OasisCatalog
extends Catalog {
    private final SAXResolver saxResolver;

    OasisCatalog(CatalogManager catalogManager, SAXResolver sAXResolver) {
        super(catalogManager);
        this.saxResolver = sAXResolver;
    }

    @Override
    protected void parseCatalogFile(String string) throws IOException {
        OASISXMLCatalogReader oASISXMLCatalogReader = new OASISXMLCatalogReader();
        try {
            SAXSource sAXSource = this.saxResolver.resolve(new XMLDocumentIdentifier(string, null, "urn:oasis:names:tc:entity:xmlns:xml:catalog"));
            String string2 = sAXSource.getInputSource().getSystemId();
            if (string2 == null) {
                string2 = string;
            }
            this.base = new URL(string2);
            oASISXMLCatalogReader.setCatalog(this);
            XMLReader xMLReader = sAXSource.getXMLReader();
            xMLReader.setEntityResolver(new CatalogEntityResolver(xMLReader.getEntityResolver()));
            xMLReader.setContentHandler(oASISXMLCatalogReader);
            xMLReader.setErrorHandler(new DraconianErrorHandler());
            xMLReader.parse(sAXSource.getInputSource());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            throw new ResolverIOException(exception instanceof ResolverException ? (ResolverException)exception : new ResolverException(sAXException));
        }
    }

    @Override
    protected Catalog newCatalog() {
        return new OasisCatalog(this.catalogManager, this.saxResolver);
    }
}

