/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.SwtCallable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DefaultExceptionHandler;
import org.eclipse.swt.internal.ExceptionStash;
import org.eclipse.swt.internal.GDBus;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.SessionManagerDBus;
import org.eclipse.swt.internal.StrictChecks;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GdkKeymapKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XEvent;
import org.eclipse.swt.internal.gtk.XExposeEvent;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventButton;
import org.eclipse.swt.internal.gtk3.GdkEventKey;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device
implements Executor {
    private static final int SLOT_IN_USE = -2;
    private static final int LAST_TABLE_INDEX = -1;
    int gdkEventCount;
    long[] gdkEvents;
    Widget[] gdkEventWidgets;
    int[] dispatchEvents;
    Event[] eventQueue;
    long fds;
    int allocated_nfds;
    boolean wake;
    boolean windowSizeSet;
    int[] max_priority = new int[1];
    int[] timeout = new int[1];
    Callback eventCallback;
    long eventProc;
    long windowProc2;
    long windowProc3;
    long windowProc4;
    long windowProc5;
    long windowProc6;
    long changeValueProc;
    long snapshotDrawProc;
    long keyPressReleaseProc;
    long focusProc;
    long windowActiveProc;
    long enterMotionProc;
    long leaveProc;
    long scrollProc;
    long resizeProc;
    long activateProc;
    long gesturePressReleaseProc;
    long notifyProc;
    long computeSizeProc;
    Callback windowCallback2;
    Callback windowCallback3;
    Callback windowCallback4;
    Callback windowCallback5;
    Callback windowCallback6;
    Callback changeValue;
    Callback snapshotDraw;
    Callback keyPressReleaseCallback;
    Callback focusCallback;
    Callback windowActiveCallback;
    Callback enterMotionCallback;
    Callback computeSizeCallback;
    Callback scrollCallback;
    Callback leaveCallback;
    Callback resizeCallback;
    Callback activateCallback;
    Callback gesturePressReleaseCallback;
    Callback notifyCallback;
    EventTable eventTable;
    EventTable filterTable;
    static String APP_NAME = "SWT";
    static String APP_VERSION = "";
    static final String DISPATCH_EVENT_KEY = "org.eclipse.swt.internal.gtk.dispatchEvent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String EXTERNAL_EVENT_LOOP_KEY = "org.eclipse.swt.internal.gtk.externalEventLoop";
    long[] closures;
    long[] closuresProc;
    int[] closuresCount;
    int[] signalIds;
    long shellMapProcClosure;
    boolean externalEventLoop;
    int[] indexTable;
    int freeSlot;
    long lastHandle;
    Widget lastWidget;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    static final int SWT_OBJECT_INDEX1;
    static final int SWT_OBJECT_INDEX2;
    Shell[] modalShells;
    Dialog modalDialog;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    int focusEvent;
    Control focusControl;
    Shell activeShell;
    boolean activePending;
    boolean ignoreActivate;
    boolean ignoreFocus;
    Tracker tracker;
    Control imControl;
    long preeditWindow;
    long preeditLabel;
    Synchronizer synchronizer = new Synchronizer(this);
    Consumer<RuntimeException> runtimeExceptionHandler = DefaultExceptionHandler.RUNTIME_EXCEPTION_HANDLER;
    Consumer<Error> errorHandler = DefaultExceptionHandler.RUNTIME_ERROR_HANDLER;
    Thread thread;
    SessionManagerDBus sessionManagerDBus;
    SessionManagerListener sessionManagerListener;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    TrayItem currentTrayItem;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    long timerProc;
    Callback windowTimerCallback;
    long windowTimerProc;
    Caret currentCaret;
    Callback caretCallback;
    int caretId;
    long caretProc;
    Control mnemonicControl;
    int mouseHoverId;
    long mouseHoverHandle;
    long mouseHoverProc;
    Callback mouseHoverCallback;
    long sizeAllocateProc;
    Callback sizeAllocateCallback;
    long sizeRequestProc;
    Callback sizeRequestCallback;
    long shellMapProc;
    Callback shellMapCallback;
    long idleProc;
    int idleHandle;
    Callback idleCallback;
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    Object idleLock = new Object();
    boolean idleNeeded;
    long cellDataProc;
    Callback cellDataCallback;
    long setDirectionProc;
    Callback setDirectionCallback;
    static final String GET_DIRECTION_PROC_KEY = "org.eclipse.swt.internal.gtk.getDirectionProc";
    long emissionProc;
    Callback emissionProcCallback;
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";
    long allChildrenProc;
    long allChildren;
    Callback allChildrenCallback;
    long signalProc;
    Callback signalCallback;
    long shellHandle;
    boolean settingsChanged;
    boolean runSettings;
    static final int STYLE_UPDATED = 1;
    boolean entrySelectOnFocus;
    Control currentControl;
    long checkIfEventProc;
    Callback checkIfEventCallback;
    long flushWindow;
    boolean flushAll;
    GdkRectangle flushRect = new GdkRectangle();
    XExposeEvent exposeEvent = new XExposeEvent();
    long[] flushData = new long[1];
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    GdkRGBA COLOR_WIDGET_DARK_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_NORMAL_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_LIGHT_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_BACKGROUND_RGBA;
    GdkRGBA COLOR_WIDGET_FOREGROUND_RGBA;
    GdkRGBA COLOR_WIDGET_BORDER_RGBA;
    GdkRGBA COLOR_LIST_FOREGROUND_RGBA;
    GdkRGBA COLOR_LIST_BACKGROUND_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_TEXT_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_INACTIVE_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_TEXT_INACTIVE_RGBA;
    GdkRGBA COLOR_INFO_BACKGROUND_RGBA;
    GdkRGBA COLOR_INFO_FOREGROUND_RGBA;
    GdkRGBA COLOR_LINK_FOREGROUND_RGBA;
    GdkRGBA COLOR_TITLE_FOREGROUND_RGBA;
    GdkRGBA COLOR_TITLE_BACKGROUND_RGBA;
    GdkRGBA COLOR_TITLE_BACKGROUND_GRADIENT_RGBA;
    GdkRGBA COLOR_TITLE_INACTIVE_FOREGROUND_RGBA;
    GdkRGBA COLOR_TITLE_INACTIVE_BACKGROUND_RGBA;
    GdkRGBA COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA;
    GdkRGBA COLOR_WIDGET_DISABLED_FOREGROUND_RGBA;
    GdkRGBA COLOR_TEXT_DISABLED_BACKGROUND_RGBA;
    GdkRGBA COLOR_TOGGLE_BUTTON_FOREGROUND_RGBA;
    ArrayList<String> colorList;
    final int SWT_COLOR_LIST_SELECTION_TEXT_INACTIVE = 38;
    final int SWT_COLOR_LIST_SELECTION_INACTIVE = 39;
    static String themeName;
    static boolean themeDark;
    private static final Pattern colorPattern;
    Menu[] popups;
    int clickCount = 1;
    static final int INNER_BORDER = 2;
    int lastEventTime;
    int lastUserEventTime;
    long pangoLayoutNewProc;
    long pangoFontFamilyNewProc;
    long pangoFontFaceNewProc;
    long imContextNewProc;
    long printerOptionWidgetNewProc;
    double resizeLocationX;
    double resizeLocationY;
    int resizeBoundsX;
    int resizeBoundsY;
    int resizeBoundsWidth;
    int resizeBoundsHeight;
    int resizeMode;
    static long fixed_type;
    static long text_renderer_type;
    static long pixbuf_renderer_type;
    static long toggle_renderer_type;
    static long text_renderer_info_ptr;
    static long pixbuf_renderer_info_ptr;
    static long toggle_renderer_info_ptr;
    static Callback rendererClassInitCallback;
    static Callback rendererRenderCallback;
    static Callback rendererSnapshotCallback;
    static Callback rendererGetPreferredWidthCallback;
    static long rendererClassInitProc;
    static long rendererRenderProc;
    static long rendererSnapshotProc;
    static long rendererGetPreferredWidthProc;
    static final int[][] KeyTable;
    int cachedModifierState = 0;
    private int latinKeyGroup;
    Map<Integer, Integer> groupKeysCount;
    long keysChangedProc;
    Callback keysChangedCallback;
    long settingsChangedProc;
    Callback settingsChangedCallback;
    static Display Default;
    static Display[] Displays;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static final int GTK3_MAJOR = 3;
    static final int GTK3_MINOR = 22;
    static final int GTK3_MICRO = 0;
    static final int GTK4_MAJOR = 4;
    static final int GTK4_MINOR = 0;
    static final int GTK4_MICRO = 0;
    Object data;
    String[] keys;
    Object[] values;
    static final int TRIM_NONE = 0;
    static final int TRIM_BORDER = 1;
    static final int TRIM_RESIZE = 2;
    static final int TRIM_TITLE_BORDER = 3;
    static final int TRIM_TITLE_RESIZE = 4;
    static final int TRIM_TITLE = 5;
    int[] trimWidths = new int[6];
    int[] trimHeights = new int[6];
    boolean ignoreTrim;
    String windowManager;

    static {
        byte[] buffer = Converter.wcsToMbcs("SWT_OBJECT_INDEX", true);
        SWT_OBJECT_INDEX = OS.g_quark_from_string(buffer);
        buffer = Converter.wcsToMbcs("SWT_OBJECT_INDEX1", true);
        SWT_OBJECT_INDEX1 = OS.g_quark_from_string(buffer);
        buffer = Converter.wcsToMbcs("SWT_OBJECT_INDEX2", true);
        SWT_OBJECT_INDEX2 = OS.g_quark_from_string(buffer);
        colorPattern = Pattern.compile("[^-]color: (rgba?\\((?:\\d+(?:,\\s?)?){3,4}\\))");
        KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65511, 65536}, {65512, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65027, 32768}, {65362, 0x1000001}, {65431, 0x1000001}, {65364, 0x1000002}, {65433, 0x1000002}, {65361, 0x1000003}, {65430, 0x1000003}, {65363, 0x1000004}, {65432, 0x1000004}, {65365, 0x1000005}, {65434, 0x1000005}, {65366, 0x1000006}, {65435, 0x1000006}, {65360, 0x1000007}, {65429, 0x1000007}, {65367, 0x1000008}, {65436, 0x1000008}, {65379, 0x1000009}, {65438, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65439, 127}, {65307, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}, {65482, 0x1000016}, {65483, 0x1000017}, {65484, 0x1000018}, {65485, 0x1000019}, {65486, 0x100001A}, {65487, 0x100001B}, {65488, 0x100001C}, {65489, 0x100001D}, {65450, 16777258}, {65451, 16777259}, {65421, 0x1000050}, {65453, 16777261}, {65454, 16777262}, {65455, 16777263}, {65456, 0x1000030}, {65457, 0x1000031}, {65458, 16777266}, {65459, 0x1000033}, {65460, 16777268}, {65461, 16777269}, {65462, 16777270}, {65463, 16777271}, {65464, 16777272}, {65465, 16777273}, {65469, 16777277}, {65509, 16777298}, {65407, 16777299}, {65300, 16777300}, {65299, 0x1000055}, {65387, 16777302}, {65377, 16777303}, {65386, 0x1000051}};
        Displays = new Display[1];
        DeviceFinder = () -> {
            Display device = Display.getCurrent();
            if (device == null) {
                device = Display.getDefault();
            }
            Display.setDevice(device);
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
        File file;
        this.trimWidths[0] = 0;
        this.trimHeights[0] = 0;
        this.trimWidths[1] = 4;
        this.trimHeights[1] = 4;
        this.trimWidths[2] = 6;
        this.trimHeights[2] = 6;
        this.trimWidths[3] = 5;
        this.trimHeights[3] = 28;
        this.trimWidths[4] = 6;
        this.trimHeights[4] = 29;
        this.trimWidths[5] = 0;
        this.trimHeights[5] = 23;
        String path = System.getProperty("user.home");
        if (path != null && (file = new File(path, ".swt/trims.prefs")).exists() && file.isFile()) {
            Properties props = new Properties();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    props.load(fis);
                    String trimWidthsString = props.getProperty("trimWidths");
                    String trimHeightsString = props.getProperty("trimHeights");
                    if (trimWidthsString != null && trimHeightsString != null) {
                        StringTokenizer tok = new StringTokenizer(trimWidthsString);
                        int i = 0;
                        while (i < this.trimWidths.length && tok.hasMoreTokens()) {
                            this.trimWidths[i] = Integer.parseInt(tok.nextToken());
                            ++i;
                        }
                        tok = new StringTokenizer(trimHeightsString);
                        i = 0;
                        while (i < this.trimHeights.length && tok.hasMoreTokens()) {
                            this.trimHeights[i] = Integer.parseInt(tok.nextToken());
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    void addLayoutDeferred(Composite comp) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] temp = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, temp, 0, this.layoutDeferred.length);
            this.layoutDeferred = temp;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = comp;
    }

    void addGdkEvent(long event) {
        int length;
        if (this.gdkEvents == null) {
            length = 1024;
            this.gdkEvents = new long[length];
            this.gdkEventWidgets = new Widget[length];
            this.gdkEventCount = 0;
        }
        if (this.gdkEventCount == this.gdkEvents.length) {
            length = this.gdkEventCount + 1024;
            long[] newEvents = new long[length];
            System.arraycopy(this.gdkEvents, 0, newEvents, 0, this.gdkEventCount);
            this.gdkEvents = newEvents;
            Widget[] newWidgets = new Widget[length];
            System.arraycopy(this.gdkEventWidgets, 0, newWidgets, 0, this.gdkEventCount);
            this.gdkEventWidgets = newWidgets;
        }
        Widget widget = null;
        long handle = GTK3.gtk_get_event_widget(event);
        if (handle != 0L) {
            while ((widget = this.getWidget(handle)) == null && (handle = GTK.gtk_widget_get_parent(handle)) != 0L) {
            }
        }
        this.gdkEvents[this.gdkEventCount] = event;
        this.gdkEventWidgets[this.gdkEventCount] = widget;
        ++this.gdkEventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            this.idleNeeded = true;
            if (this.idleHandle == 0) {
                this.idleHandle = GTK.GTK4 ? OS.g_idle_add(this.idleProc, 0L) : GDK.gdk_threads_add_idle(this.idleProc, 0L);
            }
        }
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        if (eventType == 46 || eventType == 54) {
            this.gdbus_init_methods();
        }
        this.eventTable.hook(eventType, listener);
    }

    private void gdbus_init_methods() {
        GDBus.GDBusMethod[] methods = new GDBus.GDBusMethod[]{new GDBus.GDBusMethod("FileOpen", new String[][]{{"as", "A String array containing file paths or URLs for OpenDocument/OpenUrl signal"}}, new String[0][0], args -> {
            String[] fileNames = (String[])args[0];
            int i = 0;
            while (i < fileNames.length) {
                block4: {
                    Event event = new Event();
                    event.text = fileNames[i];
                    try {
                        if (new URI(fileNames[i]).getScheme() != null) {
                            this.sendEvent(54, event);
                            break block4;
                        }
                        throw new URISyntaxException(fileNames[i], "Not a valid Url. Probably file.");
                    }
                    catch (URISyntaxException e) {
                        this.sendEvent(46, event);
                    }
                }
                ++i;
            }
            return null;
        })};
        GDBus.init(methods, Display.getAppName());
    }

    long allChildrenProc(long widget, long recurse) {
        this.allChildren = OS.g_list_append(this.allChildren, widget);
        if (recurse != 0L && GTK.GTK_IS_CONTAINER(widget)) {
            GTK3.gtk_container_forall(widget, this.allChildrenProc, recurse);
        }
        return 0L;
    }

    void addMouseHoverTimeout(long handle) {
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = GTK.GTK4 ? OS.g_timeout_add(400, this.mouseHoverProc, handle) : GDK.gdk_threads_add_timeout(400, this.mouseHoverProc, handle);
        this.mouseHoverHandle = handle;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            if (this.popups[i] != null && this.popups[i].getNameText().equals(menu.getNameText())) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] newSkinWidgets = new Widget[(this.skinList.length + 1) * 3 / 2];
            System.arraycopy(this.skinList, 0, newSkinWidgets, 0, this.skinList.length);
            this.skinList = newSkinWidgets;
        }
        this.skinList[this.skinCount++] = widget;
    }

    void addWidget(long handle, Widget widget) {
        if (handle == 0L) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            int length = this.freeSlot + 1024;
            int[] newIndexTable = new int[length];
            Widget[] newWidgetTable = new Widget[length];
            System.arraycopy(this.indexTable, 0, newIndexTable, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, newWidgetTable, 0, this.freeSlot);
            int i = this.freeSlot;
            while (i < length - 1) {
                newIndexTable[i] = i + 1;
                ++i;
            }
            newIndexTable[length - 1] = -1;
            this.indexTable = newIndexTable;
            this.widgetTable = newWidgetTable;
        }
        int index = this.freeSlot + 1;
        StrictChecks.runIfStrictChecksEnabled(() -> {
            long data = OS.g_object_get_qdata(handle, SWT_OBJECT_INDEX);
            if (data > 0L && data != (long)index) {
                SWT.error(5, null, ". Potential leak of " + String.valueOf(widget) + this.debugInfoForIndex(data - 1L));
            }
        });
        OS.g_object_set_qdata(handle, SWT_OBJECT_INDEX, index);
        int oldSlot = this.freeSlot;
        this.freeSlot = this.indexTable[oldSlot];
        this.indexTable[oldSlot] = -2;
        if (this.widgetTable[oldSlot] != null) {
            SWT.error(5, null, ". Trying to override non empty slot with " + String.valueOf(widget) + this.debugInfoForIndex(oldSlot));
        }
        this.widgetTable[oldSlot] = widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = GTK.GTK4 ? OS.g_idle_add(this.idleProc, 0L) : GDK.gdk_threads_add_idle(this.idleProc, 0L);
                }
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void execute(Runnable runnable) {
        Objects.requireNonNull(runnable);
        if (this.isDisposed()) {
            throw new RejectedExecutionException(new SWTException(24, null));
        }
        if (this.thread == Thread.currentThread()) {
            this.syncExec(runnable);
        } else {
            this.asyncExec(runnable);
        }
    }

    public void beep() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        GDK.gdk_display_beep(GDK.gdk_display_get_default());
    }

    long cellDataProc(long tree_column, long cell, long tree_model, long iter, long data) {
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0L;
        }
        return widget.cellDataProc(tree_column, cell, tree_model, iter, data);
    }

    @Override
    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean multiple) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] != null) {
                    if (!multiple) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[i].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    long checkIfEventProc(long display, long xEvent, long userData) {
        if (GTK.GTK4) {
            return 0L;
        }
        int type = OS.X_EVENT_TYPE(xEvent);
        switch (type) {
            case 12: 
            case 13: {
                break;
            }
            default: {
                return 0L;
            }
        }
        long window = GDK.gdk_x11_window_lookup_for_display(GDK.gdk_display_get_default(), OS.X_EVENT_WINDOW(xEvent));
        if (window == 0L) {
            return 0L;
        }
        if (this.flushWindow != 0L) {
            if (this.flushAll) {
                long tempWindow = window;
                while (tempWindow != this.flushWindow && (tempWindow = GDK.gdk_window_get_parent(tempWindow)) != 0L) {
                }
                if (tempWindow != this.flushWindow) {
                    return 0L;
                }
            } else if (window != this.flushWindow) {
                return 0L;
            }
        }
        OS.memmove(this.exposeEvent, xEvent, (long)XExposeEvent.sizeof);
        switch (type) {
            case 12: 
            case 13: {
                this.flushRect.x = this.exposeEvent.x;
                this.flushRect.y = this.exposeEvent.y;
                this.flushRect.width = Math.max(0, this.exposeEvent.width);
                this.flushRect.height = Math.max(0, this.exposeEvent.height);
                GDK.gdk_window_invalidate_rect(window, this.flushRect, true);
                this.exposeEvent.type = -1;
                OS.memmove(xEvent, this.exposeEvent, (long)XExposeEvent.sizeof);
            }
        }
        return 0L;
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) break;
            if (this.modalShells[index] == null) {
                return;
            }
            ++index;
        }
        if (index == length) {
            return;
        }
        System.arraycopy(this.modalShells, index + 1, this.modalShells, index, --length - index);
        this.modalShells[length] = null;
        if (index == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    @Override
    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void checkIMModule() {
        Map<String, String> env = System.getenv();
        String module = env.get("GTK_IM_MODULE");
        if (module != null && module.equals("xim")) {
            System.err.println("***WARNING: Detected: GTK_IM_MODULE=xim. This input method is unsupported and can cause graphical issues.");
            System.err.println("***WARNING: Unset GTK_IM_MODULE or set GTK_IM_MODULE=ibus if flicking is experienced. ");
            if (OS.isGNOME && OS.isX11()) {
                long settings = GTK.gtk_settings_get_default();
                byte[] ibus = Converter.wcsToMbcs("ibus", true);
                if (settings != 0L) {
                    OS.g_object_set(settings, GTK.gtk_im_module, ibus, 0L);
                }
            }
        }
    }

    boolean checkAndSetThemeDetails(String themeName) {
        if (themeName.endsWith("-dark") || themeName.endsWith(":dark")) {
            System.setProperty("org.eclipse.swt.internal.gtk.theme", themeName);
            return true;
        }
        long settings = GTK.gtk_settings_get_default();
        int[] darkThemePreferred = new int[1];
        OS.g_object_get(settings, GTK.gtk_application_prefer_dark_theme, darkThemePreferred, 0L);
        if (darkThemePreferred[0] != 0) {
            System.setProperty("org.eclipse.swt.internal.gtk.theme", themeName.concat(":dark"));
        } else {
            System.setProperty("org.eclipse.swt.internal.gtk.theme", themeName);
        }
        return darkThemePreferred[0] != 0;
    }

    void createDisplay(DeviceData data) {
        byte[] type_name;
        long ptr;
        if (!GTK.GTK4) {
            OS.swt_set_lock_functions();
            GDK.gdk_threads_init();
            GDK.gdk_threads_enter();
        }
        this.windowSizeSet = false;
        boolean init = GTK.GTK4 ? GTK4.gtk_init_check() : GTK3.gtk_init_check(new long[1], null);
        if (!init) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
        this.checkIMModule();
        themeName = OS.GTK_THEME_SET ? OS.GTK_THEME_SET_NAME : OS.getThemeName();
        themeDark = this.checkAndSetThemeDetails(themeName);
        if (OS.isX11()) {
            this.xDisplay = GTK.GTK4 ? 0L : GDK.gdk_x11_get_default_xdisplay();
            System.setProperty("org.eclipse.swt.internal.gdk.backend", "x11");
        }
        if (OS.SWT_DEBUG) {
            Device.DEBUG = true;
        }
        if (!GTK.GTK4 && (ptr = GTK.gtk_check_version(3, 22, 0)) != 0L) {
            int length = C.strlen(ptr);
            byte[] buffer = new byte[length];
            C.memmove(buffer, ptr, (long)length);
            System.out.println("***WARNING: " + new String(Converter.mbcsToWcs(buffer)));
            System.out.println("***WARNING: SWT requires GTK 3.22.0");
            int major = GTK.gtk_get_major_version();
            int minor = GTK.gtk_get_minor_version();
            int micro = GTK.gtk_get_micro_version();
            System.out.println("***WARNING: Detected: " + major + "." + minor + "." + micro);
        }
        fixed_type = OS.swt_fixed_get_type();
        if (rendererClassInitProc == 0L) {
            rendererClassInitCallback = new Callback(this.getClass(), "rendererClassInitProc", 2);
            rendererClassInitProc = rendererClassInitCallback.getAddress();
        }
        if (GTK.GTK4) {
            if (rendererSnapshotProc == 0L) {
                rendererSnapshotCallback = new Callback(this.getClass(), "rendererSnapshotProc", 6);
                rendererSnapshotProc = rendererSnapshotCallback.getAddress();
            }
        } else if (rendererRenderProc == 0L) {
            rendererRenderCallback = new Callback(this.getClass(), "rendererRenderProc", 6);
            rendererRenderProc = rendererRenderCallback.getAddress();
        }
        if (rendererGetPreferredWidthProc == 0L) {
            rendererGetPreferredWidthCallback = new Callback(this.getClass(), "rendererGetPreferredWidthProc", 4);
            rendererGetPreferredWidthProc = rendererGetPreferredWidthCallback.getAddress();
        }
        if (text_renderer_type == 0L) {
            GTypeInfo renderer_info = new GTypeInfo();
            renderer_info.class_size = (short)GTK.GtkCellRendererTextClass_sizeof();
            renderer_info.class_init = rendererClassInitProc;
            renderer_info.instance_size = (short)GTK.GtkCellRendererText_sizeof();
            text_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(text_renderer_info_ptr, renderer_info, GTypeInfo.sizeof);
            type_name = Converter.wcsToMbcs("SwtTextRenderer", true);
            text_renderer_type = OS.g_type_register_static(GTK.GTK_TYPE_CELL_RENDERER_TEXT(), type_name, text_renderer_info_ptr, 0);
        }
        if (!GTK.GTK4) {
            if (pixbuf_renderer_type == 0L) {
                GTypeInfo renderer_info = new GTypeInfo();
                renderer_info.class_size = (short)GTK.GtkCellRendererPixbufClass_sizeof();
                renderer_info.class_init = rendererClassInitProc;
                renderer_info.instance_size = (short)GTK.GtkCellRendererPixbuf_sizeof();
                pixbuf_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
                OS.memmove(pixbuf_renderer_info_ptr, renderer_info, GTypeInfo.sizeof);
                type_name = Converter.wcsToMbcs("SwtPixbufRenderer", true);
                pixbuf_renderer_type = OS.g_type_register_static(GTK.GTK_TYPE_CELL_RENDERER_PIXBUF(), type_name, pixbuf_renderer_info_ptr, 0);
            }
            if (toggle_renderer_type == 0L) {
                GTypeInfo renderer_info = new GTypeInfo();
                renderer_info.class_size = (short)GTK.GtkCellRendererToggleClass_sizeof();
                renderer_info.class_init = rendererClassInitProc;
                renderer_info.instance_size = (short)GTK.GtkCellRendererToggle_sizeof();
                toggle_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
                OS.memmove(toggle_renderer_info_ptr, renderer_info, GTypeInfo.sizeof);
                type_name = Converter.wcsToMbcs("SwtToggleRenderer", true);
                toggle_renderer_type = OS.g_type_register_static(GTK.GTK_TYPE_CELL_RENDERER_TOGGLE(), type_name, toggle_renderer_info_ptr, 0);
            }
        }
        GTK.gtk_widget_set_default_direction(1);
        byte[] buffer = Converter.wcsToMbcs(APP_NAME, true);
        OS.g_set_prgname(buffer);
        if (OS.isX11() && !GTK.GTK4) {
            GDK.gdk_set_program_class(buffer);
        }
        this.shellHandle = GTK.GTK4 ? GTK4.gtk_window_new() : GTK3.gtk_window_new(0);
        if (this.shellHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_widget_realize(this.shellHandle);
        this.eventCallback = new Callback(this, "eventProc", 2);
        this.eventProc = this.eventCallback.getAddress();
        GDK.gdk_event_handler_set(this.eventProc, 0L, 0L);
        this.signalCallback = new Callback(this, "signalProc", 3);
        this.signalProc = this.signalCallback.getAddress();
        if (!GTK.GTK4) {
            byte[] atomName = Converter.wcsToMbcs("SWT_Window_" + APP_NAME, true);
            long atom = GDK.gdk_atom_intern(atomName, false);
            GDK.gdk_selection_owner_set(GTK3.gtk_widget_get_window(this.shellHandle), atom, 0, false);
            GDK.gdk_selection_owner_get(atom);
        }
        this.latinKeyGroup = this.findLatinKeyGroup();
        this.keysChangedCallback = new Callback(this, "keysChangedProc", 2);
        this.keysChangedProc = this.keysChangedCallback.getAddress();
        long display = GDK.gdk_display_get_default();
        if (GTK.GTK4) {
            long keyboardDevice = GDK.gdk_seat_get_keyboard(GDK.gdk_display_get_default_seat(display));
            OS.g_signal_connect(keyboardDevice, OS.changed, this.keysChangedProc, 0L);
        } else {
            long keymap = GDK.gdk_keymap_get_for_display(display);
            OS.g_signal_connect(keymap, OS.keys_changed, this.keysChangedProc, 0L);
        }
        this.settingsChangedCallback = new Callback(this, "settingsChangedProc", 3);
        this.settingsChangedProc = this.settingsChangedCallback.getAddress();
        OS.g_signal_connect(GTK.gtk_settings_get_default(), OS.notify_gtk_theme, this.settingsChangedProc, 0L);
    }

    private int findLatinKeyGroup() {
        int result = 0;
        this.groupKeysCount = new HashMap<Integer, Integer>();
        long display = GDK.gdk_display_get_default();
        int keyval = 97;
        while (keyval <= 122) {
            boolean foundKeys;
            long[] keys = new long[1];
            int[] n_keys = new int[1];
            if (GTK.GTK4) {
                foundKeys = GDK.gdk_display_map_keyval(display, keyval, keys, n_keys);
            } else {
                long keymap = GDK.gdk_keymap_get_for_display(display);
                foundKeys = GDK.gdk_keymap_get_entries_for_keyval(keymap, keyval, keys, n_keys);
            }
            if (foundKeys) {
                GdkKeymapKey key_entry = new GdkKeymapKey();
                int key = 0;
                while (key < n_keys[0]) {
                    OS.memmove(key_entry, keys[0] + (long)(key * GdkKeymapKey.sizeof), (long)GdkKeymapKey.sizeof);
                    Integer keys_count = this.groupKeysCount.get(key_entry.group);
                    keys_count = keys_count != null ? Integer.valueOf(keys_count + 1) : Integer.valueOf(1);
                    this.groupKeysCount.put(key_entry.group, keys_count);
                    ++key;
                }
                OS.g_free(keys[0]);
            }
            ++keyval;
        }
        int max_keys_count = 0;
        for (Map.Entry<Integer, Integer> entry : this.groupKeysCount.entrySet()) {
            Integer group = entry.getKey();
            Integer keys_count = entry.getValue();
            if (keys_count <= max_keys_count) continue;
            result = group;
            max_keys_count = keys_count;
        }
        return result;
    }

    int getLatinKeyGroup() {
        return this.latinKeyGroup;
    }

    Map<Integer, Integer> getGroupKeysCount() {
        return this.groupKeysCount;
    }

    long keysChangedProc(long keymap, long user_data) {
        this.latinKeyGroup = this.findLatinKeyGroup();
        return 0L;
    }

    long settingsChangedProc(long settings, long key, long user_data) {
        this.settingsChanged = true;
        return 0L;
    }

    Image createImage(String name) {
        long pixbuf;
        byte[] buffer = Converter.wcsToMbcs(name, true);
        if (GTK.GTK4) {
            iconTheme = GTK4.gtk_icon_theme_get_for_display(GDK.gdk_display_get_default());
            long paintable = GTK4.gtk_icon_theme_lookup_icon(iconTheme, buffer, 0L, 48, 1, 1, 32);
            long file = GTK4.gtk_icon_paintable_get_file(paintable);
            long texture = GDK.gdk_texture_new_from_file(file, 0L);
            pixbuf = GDK.gdk_pixbuf_get_from_texture(texture);
            OS.g_object_unref(texture);
            OS.g_object_unref(file);
            OS.g_object_unref(paintable);
        } else {
            iconTheme = GTK3.gtk_icon_theme_get_default();
            pixbuf = GTK3.gtk_icon_theme_load_icon(iconTheme, buffer, 48, 36, 0L);
        }
        if (pixbuf == 0L) {
            return null;
        }
        int width = GDK.gdk_pixbuf_get_width(pixbuf);
        int height = GDK.gdk_pixbuf_get_height(pixbuf);
        int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
        boolean hasAlpha = GDK.gdk_pixbuf_get_has_alpha(pixbuf);
        long pixels = GDK.gdk_pixbuf_get_pixels(pixbuf);
        byte[] data = new byte[stride * height];
        C.memmove(data, pixels, (long)data.length);
        OS.g_object_unref(pixbuf);
        ImageData imageData = null;
        if (hasAlpha) {
            PaletteData palette = new PaletteData(-16777216, 0xFF0000, 65280);
            imageData = new ImageData(width, height, 32, palette);
            byte[] alpha = new byte[stride * height];
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    alpha[y * width + x] = data[y * stride + x * 4 + 3];
                    data[y * stride + x * 4 + 3] = 0;
                    ++x;
                }
                ++y;
            }
            imageData.setAlphas(0, 0, width * height, alpha, 0);
        } else {
            PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
            imageData = new ImageData(width, height, 24, palette);
        }
        imageData.data = data;
        imageData.bytesPerLine = stride;
        return new Image((Device)this, imageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int i = 0;
            while (i < Displays.length) {
                if (display == Displays[i]) {
                    Display.Displays[i] = null;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        if (!GTK.GTK4) {
            GDK.gdk_threads_leave();
        }
    }

    long emissionProc(long ihint, long n_param_values, long param_values, long data) {
        long topLevel = GTK.GTK4 ? GTK4.gtk_widget_get_native(OS.g_value_peek_pointer(param_values)) : GTK3.gtk_widget_get_toplevel(OS.g_value_peek_pointer(param_values));
        if (topLevel == data) {
            GTK.gtk_widget_set_direction(OS.g_value_peek_pointer(param_values), 2);
        }
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int i = 0;
            while (i < Displays.length) {
                Display display = Displays[i];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    long eventProc(long event, long data) {
        int time = GDK.gdk_event_get_time(event);
        if (time != 0) {
            this.lastEventTime = time;
        }
        int eventType = GTK.GTK4 ? GDK.gdk_event_get_event_type(event) : GDK.GDK_EVENT_TYPE(event);
        Control.fixGdkEventTypeValues(eventType);
        switch (eventType) {
            case 4: 
            case 8: {
                this.lastUserEventTime = time;
            }
        }
        boolean dispatch = true;
        if (this.dispatchEvents != null) {
            dispatch = false;
            int i = 0;
            while (i < this.dispatchEvents.length) {
                if (eventType == this.dispatchEvents[i]) {
                    dispatch = true;
                    break;
                }
                ++i;
            }
        }
        if (!dispatch) {
            long copiedEvent = GTK.GTK4 ? GDK.gdk_event_ref(event) : GDK.gdk_event_copy(event);
            this.addGdkEvent(copiedEvent);
            return 0L;
        }
        dispatch = true;
        if (this.tracker != null) {
            dispatch = this.tracker.processEvent(event);
        }
        if (dispatch) {
            GTK3.gtk_main_do_event(event);
        }
        if (this.dispatchEvents == null) {
            this.putGdkEvents();
        }
        return 0L;
    }

    public Widget findWidget(long handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(long handle, long id) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, long id) {
        this.checkDevice();
        return null;
    }

    static long rendererClassInitProc(long g_class, long class_data) {
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        if (GTK.GTK4) {
            klass.snapshot = rendererSnapshotProc;
        } else {
            klass.render = rendererRenderProc;
        }
        klass.get_preferred_width = rendererGetPreferredWidthProc;
        OS.memmove(g_class, klass);
        return 0L;
    }

    void snapshotDrawProc(long handle, long snapshot) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            widget.snapshotToDraw(handle, snapshot);
        }
        long child = GTK4.gtk_widget_get_first_child(handle);
        while (child != 0L) {
            GTK4.gtk_widget_snapshot_child(handle, child, snapshot);
            child = GTK4.gtk_widget_get_next_sibling(child);
        }
    }

    static long rendererGetPreferredWidthProc(long cell, long handle, long minimun_size, long natural_size) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.rendererGetPreferredWidthProc(cell, handle, minimun_size, natural_size);
        }
        return 0L;
    }

    static long rendererRenderProc(long cell, long cr, long handle, long background_area, long cell_area, long flags) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.rendererRenderProc(cell, cr, handle, background_area, cell_area, flags);
        }
        return 0L;
    }

    static long rendererSnapshotProc(long cell, long snapshot, long handle, long background_area, long cell_area, long flags) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.rendererSnapshotProc(cell, snapshot, handle, background_area, cell_area, flags);
        }
        return 0L;
    }

    void flushExposes(long window, boolean all) {
        if (OS.isX11()) {
            this.flushWindow = window;
            this.flushAll = all;
            long xDisplay = GDK.gdk_x11_display_get_xdisplay(GDK.gdk_display_get_default());
            long xEvent = OS.g_malloc(XEvent.sizeof);
            OS.XCheckIfEvent(xDisplay, xEvent, this.checkIfEventProc, 0L);
            OS.g_free(xEvent);
            this.flushWindow = 0L;
        }
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        return this.getBoundsInPixels();
    }

    @Override
    public Rectangle getClientArea() {
        Rectangle workArea;
        if (OS.isX11() && (workArea = this.getWorkArea()) != null) {
            return workArea;
        }
        return super.getClientArea();
    }

    Rectangle getBoundsInPixels() {
        this.checkDevice();
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        int maxWidth = 0;
        int maxHeight = 0;
        long display = GDK.gdk_display_get_default();
        int monitorCount = 0;
        long monitorList = 0L;
        if (GTK.GTK4) {
            monitorList = GDK.gdk_display_get_monitors(display);
            monitorCount = OS.g_list_model_get_n_items(monitorList);
        } else {
            monitorCount = GDK.gdk_display_get_n_monitors(display);
        }
        if (monitorCount > 0) {
            int i = 0;
            while (i < monitorCount) {
                long monitor = GTK.GTK4 ? OS.g_list_model_get_item(monitorList, i) : GDK.gdk_display_get_monitor(display, i);
                GdkRectangle geometry = new GdkRectangle();
                GDK.gdk_monitor_get_geometry(monitor, geometry);
                if (geometry.x + geometry.width > maxWidth) {
                    maxWidth = geometry.x + geometry.width;
                }
                if (geometry.y + geometry.height > maxHeight) {
                    maxHeight = geometry.y + geometry.height;
                }
                ++i;
            }
            bounds.width = maxWidth;
            bounds.height = maxHeight;
            return bounds;
        }
        if (GTK.GTK4) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(0, 0, GDK.gdk_screen_width(), GDK.gdk_screen_height());
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        long settings = GTK.gtk_settings_get_default();
        if (settings == 0L) {
            return 500;
        }
        int[] buffer = new int[1];
        OS.g_object_get(settings, GTK.gtk_cursor_blink, buffer, 0L);
        if (buffer[0] == 0) {
            return 0;
        }
        OS.g_object_get(settings, GTK.gtk_cursor_blink_time, buffer, 0L);
        if (buffer[0] == 0) {
            return 500;
        }
        return buffer[0] / 2;
    }

    long getClosure(int id) {
        if (this.closures[id] != 0L) {
            OS.g_closure_unref(this.closures[id]);
        }
        this.closures[id] = OS.g_cclosure_new(this.closuresProc[id], id, 0L);
        OS.g_closure_ref(this.closures[id]);
        OS.g_closure_sink(this.closures[id]);
        this.closuresCount[id] = 0;
        return this.closures[id];
    }

    public Control getCursorControl() {
        this.checkDevice();
        int[] x = new int[1];
        int[] y = new int[1];
        long handle = 0L;
        long[] user_data = new long[1];
        if (GTK.GTK4) {
            long gtkWindow;
            double[] xDouble = new double[1];
            double[] yDouble = new double[1];
            gdkResource = this.gdk_device_get_surface_at_position(xDouble, yDouble);
            x[0] = (int)xDouble[0];
            y[0] = (int)yDouble[0];
            if (gdkResource != 0L && (gtkWindow = GTK4.gtk_native_get_for_surface(gdkResource)) != 0L) {
                handle = GTK4.gtk_widget_pick(gtkWindow, xDouble[0], yDouble[0], 0);
            }
        } else {
            gdkResource = this.gdk_device_get_window_at_position(x, y);
            if (gdkResource != 0L) {
                GDK.gdk_window_get_user_data(gdkResource, user_data);
                handle = user_data[0];
            } else {
                long xWindow;
                if (OS.isWayland() || GTK.GTK4) {
                    return null;
                }
                long gdkDisplay = GDK.gdk_display_get_default();
                if (OS.isX11()) {
                    GDK.gdk_x11_display_error_trap_push(gdkDisplay);
                }
                int[] unusedInt = new int[1];
                long[] unusedPtr = new long[1];
                long[] buffer = new long[1];
                long xParent = OS.XDefaultRootWindow(this.xDisplay);
                do {
                    if (OS.XQueryPointer(this.xDisplay, xParent, unusedPtr, buffer, unusedInt, unusedInt, unusedInt, unusedInt, unusedInt) == 0) {
                        handle = 0L;
                        break;
                    }
                    xWindow = buffer[0];
                    if (xWindow == 0L) continue;
                    xParent = xWindow;
                    long gdkWindow = GDK.gdk_x11_window_lookup_for_display(gdkDisplay, xWindow);
                    if (gdkWindow == 0L) continue;
                    GDK.gdk_window_get_user_data(gdkWindow, user_data);
                    if (user_data[0] == 0L) continue;
                    handle = user_data[0];
                } while (xWindow != 0L);
                if (OS.isX11()) {
                    GDK.gdk_x11_display_error_trap_pop_ignored(gdkDisplay);
                }
            }
        }
        if (handle == 0L) {
            return null;
        }
        do {
            Control control;
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control) || !(control = (Control)widget).isEnabled()) continue;
            return control;
        } while ((handle = GTK.gtk_widget_get_parent(handle)) != 0L);
        return null;
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            int type = event.type;
            this.sendPreEvent(type);
            try {
                this.filterTable.sendEvent(event);
            }
            finally {
                this.sendPostEvent(type);
            }
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    public Point getCursorLocation() {
        this.checkDevice();
        int[] x = new int[1];
        int[] y = new int[1];
        if (GTK.GTK4) {
            double[] xDouble = new double[1];
            double[] yDouble = new double[1];
            this.getPointerPosition(xDouble, yDouble);
            x[0] = (int)xDouble[0];
            y[0] = (int)yDouble[0];
        } else {
            this.getWindowPointerPosition(0L, x, y, null);
            if (OS.isWayland() && this.activeShell != null) {
                Shell tempShell = this.activeShell;
                int[] offsetX = new int[1];
                int[] offsetY = new int[1];
                while (tempShell.getParent() != null) {
                    GTK3.gtk_window_get_position(tempShell.shellHandle, offsetX, offsetY);
                    x[0] = x[0] + offsetX[0];
                    y[0] = y[0] + offsetY[0];
                    tempShell = tempShell.getParent().getShell();
                }
            }
        }
        return new Point(x[0], y[0]);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(DISPATCH_EVENT_KEY)) {
            return this.dispatchEvents;
        }
        if (key.equals(GET_MODAL_DIALOG)) {
            return this.modalDialog;
        }
        if (key.equals(GET_DIRECTION_PROC_KEY)) {
            return new LONG(this.setDirectionProc);
        }
        if (key.equals(GET_EMISSION_PROC_KEY)) {
            return new LONG(this.emissionProc);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    long gtk_fixed_get_type() {
        return fixed_type;
    }

    long gtk_cell_renderer_text_get_type() {
        return text_renderer_type;
    }

    long gtk_cell_renderer_pixbuf_get_type() {
        return pixbuf_renderer_type;
    }

    long gtk_cell_renderer_toggle_get_type() {
        return toggle_renderer_type;
    }

    String gtk_css_create_css_color_string(String background, String foreground, int property) {
        switch (property) {
            case 16: {
                if (foreground != null && background != null) {
                    return foreground + "\n" + background;
                }
                if (foreground != null) {
                    return foreground;
                }
                return "";
            }
            case 8: {
                if (foreground != null && background != null) {
                    return background + "\n" + foreground;
                }
                if (background != null) {
                    return background;
                }
                return "";
            }
        }
        return "";
    }

    GdkRGBA gtk_css_parse_background(String css, String precise) {
        GdkRGBA rgba = new GdkRGBA();
        if (css.isEmpty()) {
            return this.COLOR_WIDGET_BACKGROUND_RGBA;
        }
        String searched = "";
        if (precise != null) {
            if (css.contains(precise)) {
                searched = css.substring(css.indexOf(precise));
            }
        } else {
            searched = css;
        }
        if (searched.isEmpty()) {
            return this.COLOR_WIDGET_BACKGROUND_RGBA;
        }
        if (searched.contains("background-color:")) {
            int startIndex = searched.indexOf("background-color:");
            String shortOutput = searched.substring(startIndex + 18);
            rgba = this.gtk_css_property_to_rgba(shortOutput);
        } else if (searched.contains("background:")) {
            int startIndex = searched.indexOf("background:");
            String shortOutput = searched.substring(startIndex + 13);
            rgba = this.gtk_css_property_to_rgba(shortOutput);
        }
        return rgba;
    }

    String gtk_css_provider_to_string(long provider) {
        if (provider == 0L) {
            return "";
        }
        long str = GTK.gtk_css_provider_to_string(provider);
        if (str == 0L) {
            return "";
        }
        int length = C.strlen(str);
        byte[] buffer = new byte[length];
        C.memmove(buffer, str, (long)length);
        OS.g_free(str);
        return new String(Converter.mbcsToWcs(buffer));
    }

    GdkRGBA gtk_css_parse_foreground(String css, String precise) {
        if (css.isEmpty()) {
            return this.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        GdkRGBA rgba = new GdkRGBA();
        String searched = "";
        if (precise != null) {
            if (css.contains(precise)) {
                searched = css.substring(css.indexOf(precise));
            }
        } else {
            searched = css;
        }
        if (searched.isEmpty()) {
            return this.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        Matcher m = colorPattern.matcher(searched);
        if (!m.find()) {
            return this.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        String shortOutput = m.group(1);
        rgba = this.gtk_css_property_to_rgba(shortOutput);
        return rgba;
    }

    GdkRGBA gtk_css_property_to_rgba(String property) {
        GdkRGBA rgba = new GdkRGBA();
        String[] propertyParsed = new String[1];
        propertyParsed = property.split(";");
        GDK.gdk_rgba_parse(rgba, Converter.wcsToMbcs(propertyParsed[0], true));
        return rgba;
    }

    String gtk_rgba_to_css_string(GdkRGBA rgba) {
        GdkRGBA toConvert = rgba != null ? rgba : this.COLOR_WIDGET_BACKGROUND_RGBA;
        long str = GDK.gdk_rgba_to_string(toConvert);
        int length = C.strlen(str);
        byte[] buffer = new byte[length];
        C.memmove(buffer, str, (long)length);
        OS.g_free(str);
        return new String(Converter.mbcsToWcs(buffer));
    }

    String gtk_widget_get_name(long handle) {
        String name;
        long str = GTK.gtk_widget_get_name(handle);
        if (str == 0L) {
            name = "*";
        } else {
            int length = C.strlen(str);
            byte[] buffer = new byte[length];
            C.memmove(buffer, str, (long)length);
            name = new String(Converter.mbcsToWcs(buffer));
        }
        return name;
    }

    String gtk_widget_class_get_css_name(long handle) {
        String name;
        long str = GTK.gtk_widget_class_get_css_name(GTK.GTK_WIDGET_GET_CLASS(handle));
        if (str == 0L) {
            name = "*";
        } else {
            int length = C.strlen(str);
            byte[] buffer = new byte[length];
            C.memmove(buffer, str, (long)length);
            name = new String(Converter.mbcsToWcs(buffer));
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    static boolean isValidClass(Class<?> clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    public Menu getMenuBar() {
        this.checkDevice();
        return null;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        int[] buffer = new int[1];
        long settings = GTK.gtk_settings_get_default();
        OS.g_object_get(settings, GTK.gtk_alternative_button_order, buffer, 0L);
        return buffer[0] == 1 ? 16384 : 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        long settings = GTK.gtk_settings_get_default();
        int[] buffer = new int[1];
        OS.g_object_get(settings, GTK.gtk_double_click_time, buffer, 0L);
        return buffer[0];
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        if (this.activeShell == null) {
            return null;
        }
        long shellHandle = this.activeShell.shellHandle;
        long handle = GTK.gtk_window_get_focus(shellHandle);
        if (handle == 0L) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control)) continue;
            Control control = (Control)widget;
            return control.isEnabled() ? control : null;
        } while ((handle = GTK.gtk_widget_get_parent(handle)) != 0L);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        String gtkThemeName = OS.getThemeName();
        return gtkThemeName.contains("HighContrast") || gtkThemeName.contains("ContrastHigh");
    }

    @Override
    public int getDepth() {
        this.checkDevice();
        if (GTK.GTK4) {
            return 32;
        }
        long screen = GDK.gdk_screen_get_default();
        long visual = GDK.gdk_screen_get_system_visual(screen);
        return GDK.gdk_visual_get_depth(visual);
    }

    public int getIconDepth() {
        this.checkDevice();
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public static boolean isSystemDarkTheme() {
        return themeDark;
    }

    int getLastEventTime() {
        return this.lastEventTime;
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    Rectangle getWorkArea() {
        byte[] name = Converter.wcsToMbcs("_NET_WORKAREA", true);
        long atom = GDK.gdk_atom_intern(name, true);
        if (atom == 0L) {
            return null;
        }
        long[] actualType = new long[1];
        int[] actualFormat = new int[1];
        int[] actualLength = new int[1];
        long[] data = new long[1];
        if (!GDK.gdk_property_get(GDK.gdk_get_default_root_window(), atom, 0L, 0L, 16L, 0, actualType, actualFormat, actualLength, data)) {
            return null;
        }
        Rectangle result = null;
        if (data[0] != 0L) {
            if (actualLength[0] == 16) {
                int[] values = new int[4];
                C.memmove(values, data[0], 16L);
                result = new Rectangle(values[0], values[1], values[2], values[3]);
            } else if (actualLength[0] == 32) {
                long[] values = new long[4];
                C.memmove(values, data[0], 32L);
                result = new Rectangle((int)values[0], (int)values[1], (int)values[2], (int)values[3]);
            }
            OS.g_free(data[0]);
        }
        return result;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        Monitor[] monitors = null;
        Rectangle workArea = this.getWorkArea();
        long display = GDK.gdk_display_get_default();
        if (display != 0L) {
            int monitorCount;
            long monitorList = 0L;
            if (GTK.GTK4) {
                monitorList = GDK.gdk_display_get_monitors(display);
                monitorCount = OS.g_list_model_get_n_items(monitorList);
            } else {
                monitorCount = GDK.gdk_display_get_n_monitors(display);
            }
            if (monitorCount > 0) {
                monitors = new Monitor[monitorCount];
                GdkRectangle geometry = new GdkRectangle();
                int i = 0;
                while (i < monitorCount) {
                    long gdkMonitor = GTK.GTK4 ? OS.g_list_model_get_item(monitorList, i) : GDK.gdk_display_get_monitor(display, i);
                    GDK.gdk_monitor_get_geometry(gdkMonitor, geometry);
                    Monitor monitor = new Monitor();
                    monitor.handle = gdkMonitor;
                    monitor.x = geometry.x;
                    monitor.y = geometry.y;
                    monitor.width = geometry.width;
                    monitor.height = geometry.height;
                    if (!OS.isX11() || GTK.GTK4) {
                        int scaleFactor = GDK.gdk_monitor_get_scale_factor(gdkMonitor);
                        monitor.zoom = scaleFactor * 100;
                    } else {
                        monitor.zoom = Display._getDeviceZoom(monitor.handle);
                    }
                    if (!GTK.GTK4) {
                        GDK.gdk_monitor_get_workarea(gdkMonitor, geometry);
                    }
                    monitor.clientX = geometry.x;
                    monitor.clientY = geometry.y;
                    monitor.clientWidth = geometry.width;
                    monitor.clientHeight = geometry.height;
                    monitors[i] = monitor;
                    ++i;
                }
            }
        }
        if (monitors == null) {
            Monitor monitor = new Monitor();
            Rectangle bounds = this.getBounds();
            monitor.x = bounds.x;
            monitor.y = bounds.y;
            monitor.width = bounds.width;
            monitor.height = bounds.height;
            if (workArea != null) {
                monitor.clientX = workArea.x;
                monitor.clientY = workArea.y;
                monitor.clientWidth = workArea.width;
                monitor.clientHeight = workArea.height;
            } else {
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
            monitors = new Monitor[]{monitor};
        }
        return monitors;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor[] monitors = this.getMonitors();
        int primaryMonitorIndex = 0;
        if (GTK.GTK4) {
            primaryMonitorIndex = 0;
        } else {
            long display = GDK.gdk_display_get_default();
            long monitor = GDK.gdk_display_get_primary_monitor(display);
            int i = 0;
            while (i < monitors.length) {
                long toCompare = GDK.gdk_display_get_monitor(display, i);
                if (toCompare == monitor) {
                    primaryMonitorIndex = i;
                    break;
                }
                ++i;
            }
        }
        return monitors[primaryMonitorIndex];
    }

    public Shell[] getShells() {
        this.checkDevice();
        int index = 0;
        Shell[] result = new Shell[16];
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget instanceof Shell) {
                if (!widget.isDisposed()) {
                    j = 0;
                    while (j < index) {
                        if (result[j] == widget) break;
                        ++j;
                    }
                    if (j == index) {
                        if (index == result.length) {
                            Shell[] newResult = new Shell[index + 16];
                            System.arraycopy(result, 0, newResult, 0, index);
                            result = newResult;
                        }
                        result[index++] = (Shell)widget;
                    }
                } else {
                    System.err.println("SWT ERROR: disposed shell detected in the table" + this.debugInfoForIndex(i));
                    j = i;
                    while (j < this.widgetTable.length) {
                        if (this.widgetTable[j] == widget) {
                            this.widgetTable[j] = null;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (index == result.length) {
            return result;
        }
        Shell[] newResult = new Shell[index];
        System.arraycopy(result, 0, newResult, 0, index);
        return newResult;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    @Override
    public Color getSystemColor(int id) {
        this.checkDevice();
        GdkRGBA gdkRGBA = null;
        switch (id) {
            case 36: {
                gdkRGBA = this.copyRGBA(this.COLOR_LINK_FOREGROUND_RGBA);
                break;
            }
            case 28: {
                gdkRGBA = this.copyRGBA(this.COLOR_INFO_FOREGROUND_RGBA);
                break;
            }
            case 29: {
                gdkRGBA = this.copyRGBA(this.COLOR_INFO_BACKGROUND_RGBA);
                break;
            }
            case 30: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_FOREGROUND_RGBA);
                break;
            }
            case 31: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_BACKGROUND_RGBA);
                break;
            }
            case 32: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_BACKGROUND_GRADIENT_RGBA);
                break;
            }
            case 33: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_INACTIVE_FOREGROUND_RGBA);
                break;
            }
            case 34: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA);
                break;
            }
            case 35: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA);
                break;
            }
            case 17: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_DARK_SHADOW_RGBA);
                break;
            }
            case 18: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_NORMAL_SHADOW_RGBA);
                break;
            }
            case 19: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_LIGHT_SHADOW_RGBA);
                break;
            }
            case 20: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA);
                break;
            }
            case 22: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_BACKGROUND_RGBA);
                break;
            }
            case 21: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_FOREGROUND_RGBA);
                break;
            }
            case 23: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_BORDER_RGBA);
                break;
            }
            case 24: {
                gdkRGBA = this.copyRGBA(this.COLOR_LIST_FOREGROUND_RGBA);
                break;
            }
            case 25: {
                gdkRGBA = this.copyRGBA(this.COLOR_LIST_BACKGROUND_RGBA);
                break;
            }
            case 26: {
                gdkRGBA = this.copyRGBA(this.COLOR_LIST_SELECTION_RGBA);
                break;
            }
            case 27: {
                gdkRGBA = this.copyRGBA(this.COLOR_LIST_SELECTION_TEXT_RGBA);
                break;
            }
            case 39: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_DISABLED_FOREGROUND_RGBA);
                break;
            }
            case 38: {
                gdkRGBA = this.copyRGBA(this.COLOR_TEXT_DISABLED_BACKGROUND_RGBA);
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        if (gdkRGBA == null) {
            return super.getSystemColor(2);
        }
        return Color.gtk_new(this, gdkRGBA);
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        if (id < 0 || id >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id] == null) {
            this.cursors[id] = new Cursor(this, id);
        }
        return this.cursors[id];
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        switch (id) {
            case 1: {
                if (this.errorImage == null) {
                    this.errorImage = this.createImage("dialog-error-symbolic");
                }
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage == null) {
                    this.infoImage = this.createImage("dialog-information-symbolic");
                }
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage == null) {
                    this.questionImage = this.createImage("dialog-question-symbolic");
                }
                return this.questionImage;
            }
            case 8: {
                if (this.warningImage == null) {
                    this.warningImage = this.createImage("dialog-warning-symbolic");
                }
                return this.warningImage;
            }
        }
        return null;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        return null;
    }

    GdkRGBA toGdkRGBA(GdkRGBA rgba, double brightness) {
        GdkRGBA newRGBA = new GdkRGBA();
        newRGBA.alpha = rgba.alpha;
        double[] hue = new double[1];
        double[] saturationHSV = new double[1];
        double[] value = new double[1];
        if (GTK.GTK4) {
            float[] h = new float[1];
            float[] s = new float[1];
            float[] v = new float[1];
            GTK4.gtk_rgb_to_hsv((float)rgba.red, (float)rgba.green, (float)rgba.blue, h, s, v);
            hue[0] = h[0];
            saturationHSV[0] = s[0];
            value[0] = v[0];
        } else {
            GTK3.gtk_rgb_to_hsv(rgba.red, rgba.green, rgba.blue, hue, saturationHSV, value);
        }
        double luminosity = (2.0 - saturationHSV[0]) * value[0] / 2.0;
        double saturationHSL = saturationHSV[0] * value[0];
        saturationHSL /= luminosity <= 1.0 ? luminosity : 2.0 - luminosity;
        saturationHSL = Math.max(0.0, Math.min(1.0, saturationHSL * brightness));
        luminosity = Math.max(0.0, Math.min(1.0, luminosity * brightness));
        value[0] = (luminosity + (saturationHSL *= luminosity <= 1.0 ? luminosity : 2.0 - (luminosity *= 2.0))) / 2.0;
        saturationHSV[0] = 2.0 * saturationHSL / (luminosity + saturationHSL);
        if (GTK.GTK4) {
            float[] r = new float[1];
            float[] g = new float[1];
            float[] b = new float[1];
            GTK4.gtk_hsv_to_rgb((float)hue[0], (float)saturationHSV[0], (float)value[0], r, g, b);
            newRGBA.red = r[0];
            newRGBA.green = g[0];
            newRGBA.blue = b[0];
        } else {
            GTK3.gtk_hsv_to_rgb(hue[0], saturationHSV[0], value[0], hue, saturationHSV, value);
            newRGBA.red = hue[0];
            newRGBA.green = saturationHSV[0];
            newRGBA.blue = value[0];
        }
        return newRGBA;
    }

    static int inversePremultipliedColor(int color, int alpha) {
        if (alpha == 0) {
            return 0;
        }
        return (255 * color + alpha - 1) / alpha;
    }

    private static void renderAllBackgrounds(long styleContext, long cairo) {
        long parentStyleContext;
        if (!GTK.GTK4 && (parentStyleContext = GTK3.gtk_style_context_get_parent(styleContext)) != 0L) {
            Display.renderAllBackgrounds(parentStyleContext, cairo);
        }
        GTK.gtk_render_background(styleContext, cairo, -50.0, -50.0, 100.0, 100.0);
    }

    GdkRGBA styleContextEstimateBackgroundColor(long context, int state) {
        GTK.gtk_style_context_save(context);
        GTK.gtk_style_context_set_state(context, state);
        long surface = Cairo.cairo_image_surface_create(0, 1, 1);
        long cairo = Cairo.cairo_create(surface);
        Display.renderAllBackgrounds(context, cairo);
        Cairo.cairo_fill(cairo);
        Cairo.cairo_surface_flush(surface);
        byte[] buffer = new byte[4];
        C.memmove(buffer, Cairo.cairo_image_surface_get_data(surface), (long)buffer.length);
        Cairo.cairo_surface_destroy(surface);
        Cairo.cairo_destroy(cairo);
        GTK.gtk_style_context_restore(context);
        int a = Byte.toUnsignedInt(buffer[3]);
        int r = Byte.toUnsignedInt(buffer[2]);
        int g = Byte.toUnsignedInt(buffer[1]);
        int b = Byte.toUnsignedInt(buffer[0]);
        GdkRGBA rgba = new GdkRGBA();
        rgba.alpha = (float)a / 255.0f;
        rgba.red = (float)Display.inversePremultipliedColor(r, a) / 255.0f;
        rgba.green = (float)Display.inversePremultipliedColor(g, a) / 255.0f;
        rgba.blue = (float)Display.inversePremultipliedColor(b, a) / 255.0f;
        return rgba;
    }

    GdkRGBA copyRGBA(GdkRGBA source) {
        GdkRGBA retRGBA = new GdkRGBA();
        if (source != null) {
            retRGBA.alpha = source.alpha;
            retRGBA.red = source.red;
            retRGBA.green = source.green;
            retRGBA.blue = source.blue;
        }
        return retRGBA;
    }

    void initializeSystemColors() {
        this.COLOR_WIDGET_DARK_SHADOW_RGBA = new GdkRGBA();
        this.COLOR_WIDGET_DARK_SHADOW_RGBA.alpha = 1.0;
        this.initializeNamedColorList();
        long shellContext = GTK.gtk_widget_get_style_context(this.shellHandle);
        this.initializeSystemColorsWidget(shellContext);
        this.initializeSystemColorsList(shellContext);
        this.initializeSystemColorsTitle(shellContext);
        this.initializeSystemColorsLink();
        this.initializeSystemColorsTooltip();
        this.initializeSystemColorsToggleButton();
        this.initializeSystemColorsDisabled();
        this.COLOR_TITLE_FOREGROUND_RGBA = this.COLOR_LIST_SELECTION_TEXT_RGBA;
        this.COLOR_TITLE_BACKGROUND_RGBA = this.COLOR_LIST_SELECTION_RGBA;
        this.COLOR_TITLE_BACKGROUND_GRADIENT_RGBA = this.toGdkRGBA(this.COLOR_LIST_SELECTION_RGBA, 1.3);
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA = this.toGdkRGBA(this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA, 1.3);
    }

    void initializeSystemColorsWidget(long shellContext) {
        this.COLOR_WIDGET_FOREGROUND_RGBA = this.styleContextGetColor(shellContext, 0);
        this.COLOR_WIDGET_LIGHT_SHADOW_RGBA = this.COLOR_WIDGET_BACKGROUND_RGBA = this.styleContextEstimateBackgroundColor(shellContext, 0);
        this.COLOR_WIDGET_NORMAL_SHADOW_RGBA = this.toGdkRGBA(this.COLOR_WIDGET_BACKGROUND_RGBA, 0.7);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA = this.toGdkRGBA(this.COLOR_WIDGET_BACKGROUND_RGBA, 1.3);
    }

    void initializeSystemColorsList(long shellContext) {
        GTK.gtk_style_context_save(shellContext);
        GTK.gtk_style_context_add_class(shellContext, GTK.GTK_STYLE_CLASS_VIEW);
        GTK.gtk_style_context_add_class(shellContext, GTK.GTK_STYLE_CLASS_CELL);
        if (!GTK.GTK4) {
            GTK3.gtk_style_context_invalidate(shellContext);
        }
        this.COLOR_LIST_FOREGROUND_RGBA = this.styleContextGetColor(shellContext, 0);
        this.COLOR_LIST_BACKGROUND_RGBA = this.styleContextEstimateBackgroundColor(shellContext, 0);
        this.COLOR_LIST_SELECTION_TEXT_RGBA = this.styleContextGetColor(shellContext, 36);
        this.COLOR_LIST_SELECTION_RGBA = this.styleContextEstimateBackgroundColor(shellContext, 36);
        this.COLOR_LIST_SELECTION_TEXT_INACTIVE_RGBA = this.styleContextGetColor(shellContext, 68);
        this.COLOR_LIST_SELECTION_INACTIVE_RGBA = this.styleContextEstimateBackgroundColor(shellContext, 68);
        GTK.gtk_style_context_restore(shellContext);
    }

    void initializeSystemColorsTitle(long shellContext) {
        long customLabel = OS.g_object_new(GTK.gtk_label_get_type(), 0L);
        OS.g_object_ref_sink(customLabel);
        long styleContextLabel = GTK.gtk_widget_get_style_context(customLabel);
        this.COLOR_TITLE_INACTIVE_FOREGROUND_RGBA = this.styleContextGetColor(styleContextLabel, 8);
        this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA = this.styleContextEstimateBackgroundColor(shellContext, 8);
        OS.g_object_unref(customLabel);
    }

    private void initializeSystemColorsLink() {
        long window = GTK.GTK4 ? GTK4.gtk_window_new() : GTK3.gtk_window_new(0);
        long label = GTK.gtk_label_new(null);
        if (GTK.GTK4) {
            GTK4.gtk_window_set_child(window, label);
        } else {
            GTK3.gtk_container_add(window, label);
        }
        long styleContextLink = GTK.gtk_widget_get_style_context(label);
        this.COLOR_LINK_FOREGROUND_RGBA = this.styleContextGetColor(styleContextLink, 512);
        if (GTK.GTK4) {
            GTK4.gtk_window_destroy(window);
        } else {
            GTK3.gtk_widget_destroy(window);
        }
    }

    void initializeSystemColorsTooltip() {
        long tooltip = OS.g_object_new(GTK.gtk_tooltip_get_type(), 0L);
        long customLabel = OS.g_object_new(GTK.gtk_label_get_type(), 0L);
        GTK.gtk_tooltip_set_custom(tooltip, customLabel);
        long styleContextLabel = GTK.gtk_widget_get_style_context(customLabel);
        this.COLOR_INFO_FOREGROUND_RGBA = this.styleContextGetColor(styleContextLabel, 0);
        this.COLOR_INFO_BACKGROUND_RGBA = this.styleContextEstimateBackgroundColor(styleContextLabel, 0);
        OS.g_object_unref(tooltip);
    }

    void initializeSystemColorsToggleButton() {
        long button = GTK.gtk_check_button_new();
        OS.g_object_ref_sink(button);
        long styleContextButton = GTK.gtk_widget_get_style_context(button);
        this.COLOR_TOGGLE_BUTTON_FOREGROUND_RGBA = this.styleContextGetColor(styleContextButton, 0);
        OS.g_object_unref(button);
    }

    void initializeSystemColorsDisabled() {
        long window = GTK.GTK4 ? GTK4.gtk_window_new() : GTK3.gtk_window_new(0);
        long entry = GTK.gtk_entry_new();
        if (GTK.GTK4) {
            GTK4.gtk_window_set_child(window, entry);
        } else {
            GTK3.gtk_container_add(window, entry);
        }
        long context = GTK.gtk_widget_get_style_context(entry);
        this.COLOR_WIDGET_DISABLED_FOREGROUND_RGBA = this.styleContextGetColor(context, 8);
        this.COLOR_TEXT_DISABLED_BACKGROUND_RGBA = this.styleContextEstimateBackgroundColor(context, 8);
        if (GTK.GTK4) {
            GTK4.gtk_window_destroy(window);
        } else {
            GTK3.gtk_widget_destroy(window);
        }
    }

    GdkRGBA styleContextGetColor(long context, int flag) {
        GdkRGBA rgba = new GdkRGBA();
        if (GTK.GTK4) {
            GTK4.gtk_style_context_get_color(context, rgba);
        } else {
            GTK.gtk_style_context_save(context);
            GTK.gtk_style_context_set_state(context, flag);
            GTK3.gtk_style_context_get_color(context, flag, rgba);
            GTK.gtk_style_context_restore(context);
        }
        return rgba;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        return false;
    }

    Widget getWidget(long handle) {
        if (handle == 0L) {
            return null;
        }
        if (this.lastWidget != null && this.lastHandle == handle) {
            return this.lastWidget;
        }
        long index = OS.g_object_get_qdata(handle, SWT_OBJECT_INDEX) - 1L;
        if (0L <= index && index < (long)this.widgetTable.length) {
            this.lastHandle = handle;
            this.lastWidget = this.widgetTable[(int)index];
            return this.lastWidget;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long idleProc(long data) {
        boolean result = this.runAsyncMessages(false);
        if (!result) {
            Object object = this.idleLock;
            synchronized (object) {
                this.idleHandle = 0;
            }
        }
        return result ? 1 : 0;
    }

    @Override
    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeSubclasses();
        this.initializeSystemColors();
        this.initializeSystemSettings();
        this.initializeWidgetTable();
        this.initializeSessionManager();
    }

    void initializeCallbacks() {
        this.closures = new long[109];
        this.closuresCount = new int[109];
        this.closuresProc = new long[109];
        this.signalIds = new int[109];
        this.signalIds[2] = OS.g_signal_lookup(OS.button_press_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[4] = OS.g_signal_lookup(OS.button_release_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[10] = OS.g_signal_lookup(OS.configure_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[11] = OS.g_signal_lookup(OS.delete_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[14] = OS.g_signal_lookup(OS.enter_notify_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[16] = OS.g_signal_lookup(OS.event_after, GTK.GTK_TYPE_WIDGET());
        this.signalIds[18] = OS.g_signal_lookup(OS.draw, GTK.GTK_TYPE_WIDGET());
        this.signalIds[19] = OS.g_signal_lookup(OS.draw, GTK.GTK_TYPE_WIDGET());
        this.signalIds[20] = OS.g_signal_lookup(OS.focus, GTK.GTK_TYPE_WIDGET());
        this.signalIds[21] = OS.g_signal_lookup(OS.focus_in_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[22] = OS.g_signal_lookup(OS.focus_out_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[23] = OS.g_signal_lookup(OS.grab_focus, GTK.GTK_TYPE_WIDGET());
        this.signalIds[24] = OS.g_signal_lookup(OS.hide, GTK.GTK_TYPE_WIDGET());
        this.signalIds[27] = OS.g_signal_lookup(OS.key_press_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[28] = OS.g_signal_lookup(OS.key_release_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[29] = OS.g_signal_lookup(OS.leave_notify_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[30] = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
        this.signalIds[31] = OS.g_signal_lookup(OS.map_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[32] = OS.g_signal_lookup(OS.mnemonic_activate, GTK.GTK_TYPE_WIDGET());
        this.signalIds[33] = OS.g_signal_lookup(OS.motion_notify_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[108] = OS.g_signal_lookup(OS.compute_size, GTK.GTK_TYPE_WIDGET());
        if (OS.SWT_MENU_LOCATION_DEBUGGING) {
            long menuType = GTK3.GTK_TYPE_MENU();
            OS.g_type_class_ref(menuType);
            this.signalIds[85] = OS.g_signal_lookup(OS.popped_up, menuType);
        } else {
            this.signalIds[85] = 0;
        }
        this.signalIds[38] = OS.g_signal_lookup(OS.popup_menu, GTK.GTK_TYPE_WIDGET());
        this.signalIds[40] = OS.g_signal_lookup(OS.realize, GTK.GTK_TYPE_WIDGET());
        this.signalIds[43] = OS.g_signal_lookup(OS.scroll_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[45] = OS.g_signal_lookup(OS.show, GTK.GTK_TYPE_WIDGET());
        if (!GTK.GTK4) {
            this.signalIds[46] = OS.g_signal_lookup(OS.show_help, GTK.GTK_TYPE_WIDGET());
        }
        if (!GTK.GTK4) {
            this.signalIds[47] = OS.g_signal_lookup(OS.size_allocate, GTK.GTK_TYPE_WIDGET());
        }
        this.signalIds[48] = OS.g_signal_lookup(OS.style_updated, GTK.GTK_TYPE_WIDGET());
        this.signalIds[54] = OS.g_signal_lookup(OS.unmap, GTK.GTK_TYPE_WIDGET());
        this.signalIds[55] = OS.g_signal_lookup(OS.unmap_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[56] = OS.g_signal_lookup(OS.realize, GTK.GTK_TYPE_WIDGET());
        this.signalIds[59] = OS.g_signal_lookup(OS.window_state_event, GTK.GTK_TYPE_WIDGET());
        this.windowCallback2 = new Callback(this, "windowProc", 2);
        this.windowProc2 = this.windowCallback2.getAddress();
        if (GTK.GTK4) {
            this.snapshotDraw = new Callback((Object)this, "snapshotDrawProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            this.snapshotDrawProc = this.snapshotDraw.getAddress();
            this.keyPressReleaseCallback = new Callback((Object)this, "keyPressReleaseProc", Boolean.TYPE, new Type[]{Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE});
            this.keyPressReleaseProc = this.keyPressReleaseCallback.getAddress();
            this.focusCallback = new Callback((Object)this, "focusProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            this.focusProc = this.focusCallback.getAddress();
            this.windowActiveCallback = new Callback((Object)this, "windowActiveProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            this.windowActiveProc = this.windowActiveCallback.getAddress();
            this.enterMotionCallback = new Callback((Object)this, "enterMotionProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE});
            this.enterMotionProc = this.enterMotionCallback.getAddress();
            this.scrollCallback = new Callback((Object)this, "scrollProc", Boolean.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE});
            this.scrollProc = this.scrollCallback.getAddress();
            this.gesturePressReleaseCallback = new Callback((Object)this, "gesturePressReleaseProc", Void.TYPE, new Type[]{Long.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Long.TYPE});
            this.gesturePressReleaseProc = this.gesturePressReleaseCallback.getAddress();
            this.leaveCallback = new Callback((Object)this, "leaveProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            this.leaveProc = this.leaveCallback.getAddress();
            this.resizeCallback = new Callback((Object)this, "resizeProc", Void.TYPE, new Type[]{Long.TYPE, Integer.TYPE, Integer.TYPE});
            this.resizeProc = this.resizeCallback.getAddress();
            this.activateCallback = new Callback((Object)this, "activateProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
            this.activateProc = this.activateCallback.getAddress();
            this.computeSizeCallback = new Callback((Object)this, "computeSizeProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
            this.computeSizeProc = this.computeSizeCallback.getAddress();
        }
        this.notifyCallback = new Callback((Object)this, "notifyProc", Long.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
        this.closuresProc[102] = this.notifyProc = this.notifyCallback.getAddress();
        this.closuresProc[104] = this.notifyProc;
        this.closuresProc[1] = this.windowProc2;
        this.closuresProc[60] = this.windowProc2;
        this.closuresProc[6] = this.windowProc2;
        this.closuresProc[8] = this.windowProc2;
        this.closuresProc[99] = this.windowProc2;
        this.closuresProc[83] = this.windowProc2;
        this.closuresProc[61] = this.windowProc2;
        this.closuresProc[66] = this.windowProc2;
        this.closuresProc[24] = this.windowProc2;
        this.closuresProc[23] = this.windowProc2;
        this.closuresProc[30] = this.windowProc2;
        this.closuresProc[62] = this.windowProc2;
        this.closuresProc[36] = this.windowProc2;
        this.closuresProc[38] = this.windowProc2;
        this.closuresProc[39] = this.windowProc2;
        this.closuresProc[40] = this.windowProc2;
        this.closuresProc[44] = this.windowProc2;
        this.closuresProc[68] = this.windowProc2;
        this.closuresProc[45] = this.windowProc2;
        this.closuresProc[69] = this.windowProc2;
        this.closuresProc[48] = this.windowProc2;
        this.closuresProc[57] = this.windowProc2;
        this.closuresProc[54] = this.windowProc2;
        this.closuresProc[56] = this.windowProc2;
        this.closuresProc[70] = this.windowProc2;
        this.closuresProc[71] = this.windowProc2;
        this.closuresProc[72] = this.windowProc2;
        this.closuresProc[73] = this.windowProc2;
        this.closuresProc[74] = this.windowProc2;
        this.closuresProc[75] = this.windowProc2;
        this.closuresProc[76] = this.windowProc2;
        this.closuresProc[77] = this.windowProc2;
        this.windowCallback3 = new Callback(this, "windowProc", 3);
        this.closuresProc[2] = this.windowProc3 = this.windowCallback3.getAddress();
        this.closuresProc[3] = this.windowProc3;
        this.closuresProc[4] = this.windowProc3;
        this.closuresProc[5] = this.windowProc3;
        this.closuresProc[9] = this.windowProc3;
        this.closuresProc[10] = this.windowProc3;
        this.closuresProc[11] = this.windowProc3;
        this.closuresProc[14] = this.windowProc3;
        this.closuresProc[16] = this.windowProc3;
        this.closuresProc[18] = this.windowProc3;
        this.closuresProc[19] = this.windowProc3;
        this.closuresProc[20] = this.windowProc3;
        this.closuresProc[21] = this.windowProc3;
        this.closuresProc[22] = this.windowProc3;
        this.closuresProc[27] = this.windowProc3;
        this.closuresProc[28] = this.windowProc3;
        this.closuresProc[25] = this.windowProc3;
        this.closuresProc[29] = this.windowProc3;
        this.closuresProc[31] = this.windowProc3;
        this.closuresProc[32] = this.windowProc3;
        this.closuresProc[33] = this.windowProc3;
        this.closuresProc[34] = this.windowProc3;
        this.closuresProc[35] = this.windowProc3;
        this.closuresProc[37] = this.windowProc3;
        this.closuresProc[43] = this.windowProc3;
        this.closuresProc[46] = this.windowProc3;
        this.closuresProc[47] = this.windowProc3;
        this.closuresProc[53] = this.windowProc3;
        this.closuresProc[55] = this.windowProc3;
        this.closuresProc[59] = this.windowProc3;
        this.closuresProc[82] = this.windowProc3;
        this.windowCallback4 = new Callback(this, "windowProc", 4);
        this.closuresProc[12] = this.windowProc4 = this.windowCallback4.getAddress();
        this.closuresProc[13] = this.windowProc4;
        this.closuresProc[67] = this.windowProc4;
        this.closuresProc[41] = this.windowProc4;
        this.closuresProc[42] = this.windowProc4;
        this.closuresProc[63] = this.windowProc4;
        this.closuresProc[49] = this.windowProc4;
        this.closuresProc[50] = this.windowProc4;
        this.closuresProc[51] = this.windowProc4;
        this.closuresProc[84] = this.windowProc4;
        this.closuresProc[78] = this.windowProc4;
        this.closuresProc[79] = this.windowProc4;
        this.closuresProc[103] = this.windowProc4;
        this.windowCallback5 = new Callback(this, "windowProc", 5);
        this.windowProc5 = this.windowCallback5.getAddress();
        this.changeValue = new Callback((Object)this, "changeValue", Boolean.TYPE, new Type[]{Long.TYPE, Integer.TYPE, Double.TYPE, Long.TYPE});
        this.closuresProc[7] = this.changeValueProc = this.changeValue.getAddress();
        this.closuresProc[17] = this.windowProc5;
        this.closuresProc[26] = this.windowProc5;
        this.closuresProc[52] = this.windowProc5;
        this.closuresProc[80] = this.windowProc5;
        this.closuresProc[81] = this.windowProc5;
        if (this.signalIds[85] != 0) {
            this.windowCallback6 = new Callback(this, "windowProc", 6);
            this.closuresProc[85] = this.windowProc6 = this.windowCallback6.getAddress();
        }
        int i = 0;
        while (i < 109) {
            if (this.closuresProc[i] != 0L) {
                this.closures[i] = OS.g_cclosure_new(this.closuresProc[i], i, 0L);
            }
            if (this.closures[i] != 0L) {
                OS.g_closure_ref(this.closures[i]);
                OS.g_closure_sink(this.closures[i]);
            }
            ++i;
        }
        this.timerCallback = new Callback(this, "timerProc", 1);
        this.timerProc = this.timerCallback.getAddress();
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 1);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 1);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        this.caretCallback = new Callback(this, "caretProc", 1);
        this.caretProc = this.caretCallback.getAddress();
        this.sizeAllocateCallback = new Callback(this, "sizeAllocateProc", 3);
        this.sizeAllocateProc = this.sizeAllocateCallback.getAddress();
        this.sizeRequestCallback = new Callback(this, "sizeRequestProc", 3);
        this.sizeRequestProc = this.sizeRequestCallback.getAddress();
        this.shellMapCallback = new Callback(this, "shellMapProc", 3);
        this.shellMapProc = this.shellMapCallback.getAddress();
        this.shellMapProcClosure = OS.g_cclosure_new(this.shellMapProc, 0L, 0L);
        OS.g_closure_ref(this.shellMapProcClosure);
        this.cellDataCallback = new Callback(this, "cellDataProc", 5);
        this.cellDataProc = this.cellDataCallback.getAddress();
        this.setDirectionCallback = new Callback(this, "setDirectionProc", 2);
        this.setDirectionProc = this.setDirectionCallback.getAddress();
        this.emissionProcCallback = new Callback(this, "emissionProc", 4);
        this.emissionProc = this.emissionProcCallback.getAddress();
        this.allChildrenCallback = new Callback(this, "allChildrenProc", 2);
        this.allChildrenProc = this.allChildrenCallback.getAddress();
        this.checkIfEventCallback = new Callback(this, "checkIfEventProc", 3);
        this.checkIfEventProc = this.checkIfEventCallback.getAddress();
        this.idleCallback = new Callback(this, "idleProc", 1);
        this.idleProc = this.idleCallback.getAddress();
    }

    void initializeNamedColorList() {
        this.colorList = new ArrayList();
        this.colorList.add("black");
        this.colorList.add("darkred");
        this.colorList.add("darkgreen");
        this.colorList.add("darkyellow");
        this.colorList.add("darkblue");
        this.colorList.add("darkmagenta");
        this.colorList.add("darkcyan");
        this.colorList.add("darkgray");
        this.colorList.add("gray");
        this.colorList.add("red");
        this.colorList.add("green");
        this.colorList.add("yellow");
        this.colorList.add("blue");
        this.colorList.add("magenta");
        this.colorList.add("cyan");
        this.colorList.add("white");
    }

    void initializeSubclasses() {
        if (!GTK.GTK4) {
            long pangoLayoutType = OS.PANGO_TYPE_LAYOUT();
            long pangoLayoutClass = OS.g_type_class_ref(pangoLayoutType);
            this.pangoLayoutNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(pangoLayoutClass);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoLayoutClass, OS.pangoLayoutNewProc_CALLBACK(this.pangoLayoutNewProc));
            OS.g_type_class_unref(pangoLayoutClass);
            long imContextType = GTK.GTK_TYPE_IM_MULTICONTEXT();
            long imContextClass = OS.g_type_class_ref(imContextType);
            this.imContextNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(imContextClass);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(imContextClass, OS.imContextNewProc_CALLBACK(this.imContextNewProc));
            OS.g_type_class_unref(imContextClass);
            long pangoFontFamilyType = OS.PANGO_TYPE_FONT_FAMILY();
            long pangoFontFamilyClass = OS.g_type_class_ref(pangoFontFamilyType);
            this.pangoFontFamilyNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(pangoFontFamilyClass);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoFontFamilyClass, OS.pangoFontFamilyNewProc_CALLBACK(this.pangoFontFamilyNewProc));
            OS.g_type_class_unref(pangoFontFamilyClass);
            long pangoFontFaceType = OS.PANGO_TYPE_FONT_FACE();
            long pangoFontFaceClass = OS.g_type_class_ref(pangoFontFaceType);
            this.pangoFontFaceNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(pangoFontFaceClass);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoFontFaceClass, OS.pangoFontFaceNewProc_CALLBACK(this.pangoFontFaceNewProc));
            OS.g_type_class_unref(pangoFontFaceClass);
            long printerOptionWidgetType = GTK.gtk_printer_option_widget_get_type();
            long printerOptionWidgetClass = OS.g_type_class_ref(printerOptionWidgetType);
            this.printerOptionWidgetNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(printerOptionWidgetClass);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(printerOptionWidgetClass, OS.printerOptionWidgetNewProc_CALLBACK(this.printerOptionWidgetNewProc));
            OS.g_type_class_unref(printerOptionWidgetClass);
        }
    }

    void initializeSystemSettings() {
        if (!GTK.GTK4) {
            OS.g_signal_connect(this.shellHandle, OS.style_updated, this.signalProc, 1L);
            OS.g_signal_connect(GTK.gtk_settings_get_default(), OS.notify_theme_change, this.signalProc, 1L);
        }
        int[] flag = new int[1];
        long settings = GTK.gtk_settings_get_default();
        OS.g_object_get(settings, GTK.gtk_entry_select_on_focus, flag, 0L);
        this.entrySelectOnFocus = flag[0] != 0;
    }

    void initializeWidgetTable() {
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        int i = 0;
        while (i < 1023) {
            this.indexTable[i] = i + 1;
            ++i;
        }
        this.indexTable[1023] = -1;
    }

    void initializeSessionManager() {
        this.sessionManagerDBus = new SessionManagerDBus();
        this.sessionManagerListener = new SessionManagerListener(this);
        this.sessionManagerDBus.addListener(this.sessionManagerListener);
    }

    public static String extractFreeGError(long errorPtr) {
        long errorMessageC = OS.g_error_get_message(errorPtr);
        String errorMessageStr = Converter.cCharPtrToJavaString(errorMessageC, false);
        OS.g_error_free(errorPtr);
        return errorMessageStr;
    }

    void releaseSessionManager() {
        if (this.sessionManagerDBus != null) {
            this.sessionManagerDBus.dispose();
            this.sessionManagerDBus = null;
        }
        this.sessionManagerListener = null;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        Cairo.cairo_destroy(hDC);
    }

    @Override
    public long internal_new_GC(GCData data) {
        if (this.isDisposed()) {
            this.error(45);
        }
        long gc = 0L;
        long root = 0L;
        if (GTK.GTK4) {
            long surface = Cairo.cairo_image_surface_create(2, data.width, data.height);
            gc = Cairo.cairo_create(surface);
        } else {
            root = GDK.gdk_get_default_root_window();
            gc = GDK.gdk_cairo_create(root);
        }
        if (gc == 0L) {
            this.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.drawable = root;
            data.backgroundRGBA = this.getSystemColor((int)1).handle;
            data.foregroundRGBA = this.getSystemColor((int)2).handle;
            data.font = this.getSystemFont();
        }
        return gc;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        Point origin;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from == to) {
            return point;
        }
        if (from != null) {
            Point point2 = origin = GTK.GTK4 ? from.getSurfaceOrigin() : from.getWindowOrigin();
            if ((from.style & 0x8000000) != 0) {
                point.x = from.getClientWidth() - point.x;
            }
            point.x += origin.x;
            point.y += origin.y;
        }
        if (to != null) {
            origin = GTK.GTK4 ? to.getSurfaceOrigin() : to.getWindowOrigin();
            point.x -= origin.x;
            point.y -= origin.y;
            if ((to.style & 0x8000000) != 0) {
                point.x = to.getClientWidth() - point.x;
            }
        }
        return point;
    }

    Point mapInPixels(Control from, Control to, int x, int y) {
        Point origin;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from == to) {
            return point;
        }
        if (from != null) {
            Point point2 = origin = GTK.GTK4 ? from.getSurfaceOrigin() : from.getWindowOrigin();
            if ((from.style & 0x8000000) != 0) {
                point.x = from.getClientWidth() - point.x;
            }
            point.x += origin.x;
            point.y += origin.y;
        }
        if (to != null) {
            origin = GTK.GTK4 ? to.getSurfaceOrigin() : to.getWindowOrigin();
            point.x -= origin.x;
            point.y -= origin.y;
            if ((to.style & 0x8000000) != 0) {
                point.x = to.getClientWidth() - point.x;
            }
        }
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    Rectangle mapInPixels(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.mapInPixels(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        Point origin;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        if (from == to) {
            return rect;
        }
        boolean fromRTL = false;
        boolean toRTL = false;
        if (from != null) {
            origin = GTK.GTK4 ? from.getSurfaceOrigin() : from.getWindowOrigin();
            fromRTL = (from.style & 0x8000000) != 0;
            if (fromRTL) {
                rect.x = from.getClientWidth() - rect.x;
            }
            rect.x += origin.x;
            rect.y += origin.y;
        }
        if (to != null) {
            origin = GTK.GTK4 ? to.getSurfaceOrigin() : to.getWindowOrigin();
            rect.x -= origin.x;
            rect.y -= origin.y;
            toRTL = (to.style & 0x8000000) != 0;
            if (toRTL) {
                rect.x = to.getClientWidth() - rect.x;
            }
        }
        if (fromRTL != toRTL) {
            rect.x -= rect.width;
        }
        return rect;
    }

    Rectangle mapInPixels(Control from, Control to, int x, int y, int width, int height) {
        Point origin;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        if (GTK.GTK4) {
            return new Rectangle(x, y, 0, 0);
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        if (from == to) {
            return rect;
        }
        boolean fromRTL = false;
        boolean toRTL = false;
        if (from != null) {
            origin = from.getWindowOrigin();
            fromRTL = (from.style & 0x8000000) != 0;
            if (fromRTL) {
                rect.x = from.getClientWidth() - rect.x;
            }
            rect.x += origin.x;
            rect.y += origin.y;
        }
        if (to != null) {
            origin = to.getWindowOrigin();
            rect.x -= origin.x;
            rect.y -= origin.y;
            toRTL = (to.style & 0x8000000) != 0;
            if (toRTL) {
                rect.x = to.getClientWidth() - rect.x;
            }
        }
        if (fromRTL != toRTL) {
            rect.x -= rect.width;
        }
        return rect;
    }

    long mouseHoverProc(long handle) {
        Widget widget = this.getWidget(handle);
        this.mouseHoverId = 0;
        if (widget == null) {
            return 0L;
        }
        return widget.hoverProc(handle);
    }

    long findFocusedWindow() {
        long gdkWindow = 0L;
        long window_list = GDK.gdk_window_get_children(GDK.gdk_get_default_root_window());
        if (window_list != 0L) {
            long windows = window_list;
            while (windows != 0L) {
                long curr_window = OS.g_list_data(windows);
                int state = GDK.gdk_window_get_state(curr_window);
                if ((state & 0x80) != 0 && (state & 1) == 0) {
                    gdkWindow = curr_window;
                    OS.g_object_ref(gdkWindow);
                    break;
                }
                windows = OS.g_list_next(windows);
            }
            OS.g_list_free(window_list);
        }
        return gdkWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean post(Event event) {
        if (GTK.GTK4) {
            return false;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int type;
            if (this.isDisposed()) {
                this.error(45);
            }
            if (event == null) {
                this.error(4);
            }
            if ((type = event.type) == 5) {
                Rectangle loc = event.getBounds();
                this.setCursorLocation(new Point(loc.x, loc.y));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            long gdkDisplay = GDK.gdk_display_get_default();
            long gdkSeat = GDK.gdk_display_get_default_seat(gdkDisplay);
            switch (type) {
                case 1: 
                case 2: {
                    boolean foundKeys;
                    int state;
                    long gdkWindow = this.findFocusedWindow();
                    if (gdkWindow == 0L) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    int n = state = type == 1 ? 1024 : 2048;
                    if (this.cachedModifierState != 0) {
                        state |= this.cachedModifierState;
                    }
                    int is_modifier = 1;
                    int modifier = event.stateMask != 0 ? event.stateMask : event.keyCode;
                    switch (modifier) {
                        case 131072: {
                            state |= 1;
                            break;
                        }
                        case 65536: {
                            state |= 8;
                            break;
                        }
                        case 262144: {
                            state |= 4;
                            break;
                        }
                        case 32768: {
                            state |= 0x80;
                            break;
                        }
                        default: {
                            is_modifier = this.cachedModifierState == 0 ? 0 : 1;
                        }
                    }
                    this.cachedModifierState = is_modifier == 1 && type == 1 ? state & 0xFFFFFFFF : 0;
                    int hardware_keycode = 0;
                    int raw_keyval = Display.untranslateKey(event.keyCode);
                    if (raw_keyval == 0) {
                        raw_keyval = event.character;
                    }
                    long[] keys_list = new long[1];
                    int[] n_keys = new int[1];
                    int[] keyval = new int[1];
                    int[] effective_group = new int[1];
                    int[] level = new int[1];
                    int[] consumed_modifiers = new int[1];
                    int final_keyval = raw_keyval;
                    long keymap = 0L;
                    if (GTK.GTK4) {
                        foundKeys = GDK.gdk_display_map_keyval(gdkDisplay, raw_keyval, keys_list, n_keys);
                    } else {
                        keymap = GDK.gdk_keymap_get_for_display(gdkDisplay);
                        foundKeys = GDK.gdk_keymap_get_entries_for_keyval(keymap, raw_keyval, keys_list, n_keys);
                    }
                    if (foundKeys) {
                        GdkKeymapKey key_entry = new GdkKeymapKey();
                        if (n_keys[0] > 0) {
                            OS.memmove(key_entry, keys_list[0], (long)GdkKeymapKey.sizeof);
                            hardware_keycode = key_entry.keycode;
                        }
                        OS.g_free(keys_list[0]);
                        GDK.gdk_keymap_translate_keyboard_state(keymap, hardware_keycode, state, 0, keyval, effective_group, level, consumed_modifiers);
                        if (is_modifier == 1) {
                            final_keyval = keyval[0];
                        }
                    }
                    long eventPtr = GDK.gdk_event_new(type == 1 ? 8 : 9);
                    GdkEventKey newKeyEvent = new GdkEventKey();
                    newKeyEvent.type = type == 1 ? 8 : 9;
                    newKeyEvent.window = gdkWindow;
                    newKeyEvent.send_event = 1;
                    newKeyEvent.time = 0;
                    newKeyEvent.keyval = final_keyval;
                    newKeyEvent.state = state;
                    newKeyEvent.hardware_keycode = (short)hardware_keycode;
                    newKeyEvent.group = (byte)effective_group[0];
                    newKeyEvent.is_modifier = is_modifier;
                    GTK3.memmove(eventPtr, newKeyEvent, (long)GdkEventKey.sizeof);
                    GDK.gdk_event_set_device(eventPtr, GDK.gdk_seat_get_keyboard(gdkSeat));
                    if (GTK.GTK4) {
                        GDK.gdk_display_put_event(gdkDisplay, eventPtr);
                    } else {
                        GDK.gdk_event_put(eventPtr);
                    }
                    if (GTK.GTK4) {
                        GDK.gdk_event_unref(eventPtr);
                    } else {
                        GDK.gdk_event_free(eventPtr);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                case 3: 
                case 4: {
                    int[] x = new int[1];
                    int[] y = new int[1];
                    int[] mask = new int[1];
                    long gdkPointerDevice = GDK.gdk_seat_get_pointer(gdkSeat);
                    long gdkWindow = GDK.gdk_device_get_window_at_position(gdkPointerDevice, x, y);
                    if (gdkWindow == 0L) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    OS.g_object_ref(gdkWindow);
                    long eventPtr = GDK.gdk_event_new(type == 3 ? 4 : 7);
                    GdkEventButton newButtonEvent = new GdkEventButton();
                    newButtonEvent.type = type == 3 ? 4 : 7;
                    newButtonEvent.window = gdkWindow;
                    newButtonEvent.send_event = 1;
                    newButtonEvent.time = 0;
                    newButtonEvent.x = x[0];
                    newButtonEvent.y = y[0];
                    newButtonEvent.state = mask[0];
                    newButtonEvent.button = event.button;
                    newButtonEvent.device = gdkPointerDevice;
                    GTK3.memmove(eventPtr, newButtonEvent, (long)GdkEventButton.sizeof);
                    GDK.gdk_event_set_device(eventPtr, gdkPointerDevice);
                    GDK.gdk_event_put(eventPtr);
                    if (GTK.GTK4) {
                        GDK.gdk_event_unref(eventPtr);
                    } else {
                        GDK.gdk_event_free(eventPtr);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    void putGdkEvents() {
        if (this.gdkEventCount != 0) {
            int i = 0;
            while (i < this.gdkEventCount) {
                long event = this.gdkEvents[i];
                Widget widget = this.gdkEventWidgets[i];
                if (widget == null || !widget.isDisposed()) {
                    if (GTK.GTK4) {
                        long display = GDK.gdk_display_get_default();
                        GDK.gdk_display_put_event(display, event);
                    } else {
                        GDK.gdk_event_put(event);
                    }
                }
                if (GTK.GTK4) {
                    GDK.gdk_event_unref(event);
                } else {
                    GDK.gdk_event_free(event);
                }
                this.gdkEvents[i] = 0L;
                this.gdkEventWidgets[i] = null;
                ++i;
            }
            this.gdkEventCount = 0;
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        boolean events = false;
        events |= this.runSettings();
        events |= this.runPopups();
        if (GTK.GTK4) {
            events |= OS.g_main_context_iteration(0L, false);
        } else {
            events |= GTK3.gtk_events_pending();
            GTK3.gtk_main_iteration_do(false);
        }
        if (events) {
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] == null) {
                    Display.Displays[i] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            Display[] newDisplays = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
            newDisplays[Display.Displays.length] = display;
            Displays = newDisplays;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void release() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ExceptionStash exceptions = new ExceptionStash();){
            try {
                this.sendEvent(12, new Event());
            }
            catch (Error | RuntimeException ex) {
                exceptions.stash(ex);
            }
            Object[] objectArray = this.getShells();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = objectArray[n2];
                try {
                    if (!shell.isDisposed()) {
                        shell.dispose();
                    }
                }
                catch (Error | RuntimeException ex) {
                    exceptions.stash(ex);
                }
                ++n2;
            }
            try {
                if (this.tray != null) {
                    this.tray.dispose();
                }
            }
            catch (Error | RuntimeException ex) {
                exceptions.stash(ex);
            }
            this.tray = null;
            while (true) {
                try {
                    while (this.readAndDispatch()) {
                    }
                }
                catch (Error | RuntimeException ex) {
                    exceptions.stash(ex);
                    continue;
                }
                break;
            }
            if (this.disposeList != null) {
                objectArray = this.disposeList;
                n = this.disposeList.length;
                n2 = 0;
                while (n2 < n) {
                    Object next = objectArray[n2];
                    if (next != null) {
                        try {
                            next.run();
                        }
                        catch (Error | RuntimeException ex) {
                            exceptions.stash(ex);
                        }
                    }
                    ++n2;
                }
            }
            this.disposeList = null;
            this.synchronizer.releaseSynchronizer();
            this.synchronizer = null;
            this.releaseSessionManager();
            this.releaseDisplay();
            super.release();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void releaseDisplay() {
        File dir;
        this.windowCallback2.dispose();
        this.windowCallback2 = null;
        this.windowCallback3.dispose();
        this.windowCallback3 = null;
        this.windowCallback4.dispose();
        this.windowCallback4 = null;
        this.windowCallback5.dispose();
        this.windowCallback5 = null;
        if (this.windowCallback6 != null) {
            this.windowCallback6.dispose();
            this.windowCallback6 = null;
        }
        this.windowProc6 = 0L;
        this.windowProc5 = 0L;
        this.windowProc4 = 0L;
        this.windowProc3 = 0L;
        this.windowProc2 = 0L;
        if (this.changeValue != null) {
            this.changeValue.dispose();
            this.changeValue = null;
        }
        this.changeValueProc = 0L;
        if (GTK.GTK4) {
            this.keyPressReleaseCallback.dispose();
            this.keyPressReleaseCallback = null;
            this.keyPressReleaseProc = 0L;
            this.focusCallback.dispose();
            this.focusCallback = null;
            this.focusProc = 0L;
            this.windowActiveCallback.dispose();
            this.windowActiveCallback = null;
            this.windowActiveProc = 0L;
            this.enterMotionCallback.dispose();
            this.enterMotionCallback = null;
            this.enterMotionProc = 0L;
            this.scrollCallback.dispose();
            this.scrollCallback = null;
            this.scrollProc = 0L;
            this.leaveCallback.dispose();
            this.leaveCallback = null;
            this.leaveProc = 0L;
            this.resizeCallback.dispose();
            this.resizeCallback = null;
            this.resizeProc = 0L;
            this.activateCallback.dispose();
            this.activateCallback = null;
            this.activateProc = 0L;
            this.gesturePressReleaseCallback.dispose();
            this.gesturePressReleaseCallback = null;
            this.gesturePressReleaseProc = 0L;
            this.snapshotDraw.dispose();
            this.snapshotDraw = null;
            this.snapshotDrawProc = 0L;
        }
        this.notifyCallback.dispose();
        this.notifyCallback = null;
        this.notifyProc = 0L;
        this.checkIfEventCallback.dispose();
        this.checkIfEventCallback = null;
        this.checkIfEventProc = 0L;
        if (this.preeditWindow != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_window_destroy(this.preeditWindow);
            } else {
                GTK3.gtk_widget_destroy(this.preeditWindow);
            }
        }
        this.preeditWindow = 0L;
        this.imControl = null;
        this.sizeAllocateCallback.dispose();
        this.sizeAllocateCallback = null;
        this.sizeAllocateProc = 0L;
        this.sizeRequestCallback.dispose();
        this.sizeRequestCallback = null;
        this.sizeRequestProc = 0L;
        this.shellMapCallback.dispose();
        this.shellMapCallback = null;
        this.shellMapProc = 0L;
        this.idleCallback.dispose();
        this.idleCallback = null;
        this.idleProc = 0L;
        if (this.idleHandle != 0) {
            OS.g_source_remove(this.idleHandle);
        }
        this.idleHandle = 0;
        this.cellDataCallback.dispose();
        this.cellDataCallback = null;
        this.cellDataProc = 0L;
        this.setDirectionCallback.dispose();
        this.setDirectionCallback = null;
        this.setDirectionProc = 0L;
        this.emissionProcCallback.dispose();
        this.emissionProcCallback = null;
        this.emissionProc = 0L;
        this.allChildrenCallback.dispose();
        this.allChildrenCallback = null;
        this.allChildrenProc = 0L;
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.caretProc = 0L;
        this.caretCallback.dispose();
        this.caretCallback = null;
        int i = 0;
        while (i < 109) {
            if (this.closures[i] != 0L) {
                OS.g_closure_unref(this.closures[i]);
            }
            ++i;
        }
        if (this.shellMapProcClosure != 0L) {
            OS.g_closure_unref(this.shellMapProcClosure);
        }
        if (this.timerIds != null) {
            i = 0;
            while (i < this.timerIds.length) {
                if (this.timerIds[i] != 0) {
                    OS.g_source_remove(this.timerIds[i]);
                }
                ++i;
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0L;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0L;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverProc = 0L;
        this.mouseHoverHandle = 0L;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.cursors[i].dispose();
            }
            ++i;
        }
        this.cursors = null;
        if (this.resources != null) {
            i = 0;
            while (i < this.resources.length) {
                if (this.resources[i] != null) {
                    this.resources[i].dispose();
                }
                ++i;
            }
            this.resources = null;
        }
        this.COLOR_TEXT_DISABLED_BACKGROUND_RGBA = null;
        this.COLOR_WIDGET_DISABLED_FOREGROUND_RGBA = null;
        this.COLOR_LINK_FOREGROUND_RGBA = null;
        this.COLOR_INFO_FOREGROUND_RGBA = null;
        this.COLOR_INFO_BACKGROUND_RGBA = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA = null;
        this.COLOR_TITLE_INACTIVE_FOREGROUND_RGBA = null;
        this.COLOR_TITLE_BACKGROUND_GRADIENT_RGBA = null;
        this.COLOR_TITLE_BACKGROUND_RGBA = null;
        this.COLOR_TITLE_FOREGROUND_RGBA = null;
        this.COLOR_WIDGET_FOREGROUND_RGBA = null;
        this.COLOR_LIST_SELECTION_TEXT_INACTIVE_RGBA = null;
        this.COLOR_LIST_SELECTION_INACTIVE_RGBA = null;
        this.COLOR_LIST_SELECTION_TEXT_RGBA = null;
        this.COLOR_LIST_SELECTION_RGBA = null;
        this.COLOR_LIST_BACKGROUND_RGBA = null;
        this.COLOR_LIST_FOREGROUND_RGBA = null;
        this.COLOR_WIDGET_BORDER_RGBA = null;
        this.COLOR_WIDGET_BACKGROUND_RGBA = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA = null;
        this.COLOR_WIDGET_LIGHT_SHADOW_RGBA = null;
        this.COLOR_WIDGET_NORMAL_SHADOW_RGBA = null;
        this.COLOR_WIDGET_DARK_SHADOW_RGBA = null;
        this.COLOR_TOGGLE_BUTTON_FOREGROUND_RGBA = null;
        GDK.gdk_event_handler_set(0L, 0L, 0L);
        this.eventCallback.dispose();
        this.eventCallback = null;
        if (this.shellHandle != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_window_destroy(this.shellHandle);
            } else {
                GTK3.gtk_widget_destroy(this.shellHandle);
            }
        }
        this.shellHandle = 0L;
        this.signalCallback.dispose();
        this.signalCallback = null;
        this.signalProc = 0L;
        this.keysChangedCallback.dispose();
        this.keysChangedCallback = null;
        this.keysChangedProc = 0L;
        this.settingsChangedCallback.dispose();
        this.settingsChangedCallback = null;
        this.settingsChangedProc = 0L;
        if (!GTK.GTK4) {
            long pangoLayoutType = OS.PANGO_TYPE_LAYOUT();
            long pangoLayoutClass = OS.g_type_class_ref(pangoLayoutType);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoLayoutClass, this.pangoLayoutNewProc);
            OS.g_type_class_unref(pangoLayoutClass);
            this.pangoLayoutNewProc = 0L;
            long imContextType = GTK.GTK_TYPE_IM_MULTICONTEXT();
            long imContextClass = OS.g_type_class_ref(imContextType);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(imContextClass, this.imContextNewProc);
            OS.g_type_class_unref(imContextClass);
            this.imContextNewProc = 0L;
            long pangoFontFamilyType = OS.PANGO_TYPE_FONT_FAMILY();
            long pangoFontFamilyClass = OS.g_type_class_ref(pangoFontFamilyType);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoFontFamilyClass, this.pangoFontFamilyNewProc);
            OS.g_type_class_unref(pangoFontFamilyClass);
            this.pangoFontFamilyNewProc = 0L;
            long pangoFontFaceType = OS.PANGO_TYPE_FONT_FACE();
            long pangoFontFaceClass = OS.g_type_class_ref(pangoFontFaceType);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoFontFaceClass, this.pangoFontFaceNewProc);
            OS.g_type_class_unref(pangoFontFaceClass);
            this.pangoFontFaceNewProc = 0L;
            long printerOptionWidgetType = GTK.gtk_printer_option_widget_get_type();
            long printerOptionWidgetClass = OS.g_type_class_ref(printerOptionWidgetType);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(printerOptionWidgetClass, this.printerOptionWidgetNewProc);
            OS.g_type_class_unref(printerOptionWidgetClass);
            this.printerOptionWidgetNewProc = 0L;
        }
        this.timeout = null;
        this.max_priority = null;
        if (this.fds != 0L) {
            OS.g_free(this.fds);
        }
        this.fds = 0L;
        this.popups = null;
        this.thread = null;
        this.activeShell = null;
        this.lastWidget = null;
        this.closures = null;
        this.flushData = null;
        this.signalIds = null;
        this.indexTable = null;
        this.modalShells = null;
        this.widgetTable = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.filterTable = null;
        this.eventTable = null;
        this.modalDialog = null;
        this.flushRect = null;
        this.exposeEvent = null;
        this.idleLock = null;
        String userHome = System.getProperty("user.home");
        if (userHome != null && ((dir = new File(userHome, ".swt")).exists() && dir.isDirectory() || dir.mkdirs())) {
            File file = new File(dir, "trims.prefs");
            Properties props = new Properties();
            StringBuilder buf = new StringBuilder();
            int[] nArray = this.trimWidths;
            int n = this.trimWidths.length;
            int n2 = 0;
            while (n2 < n) {
                int w = nArray[n2];
                buf.append(w).append(' ');
                ++n2;
            }
            props.put("trimWidths", buf.toString());
            buf = new StringBuilder();
            nArray = this.trimHeights;
            n = this.trimHeights.length;
            n2 = 0;
            while (n2 < n) {
                int h = nArray[n2];
                buf.append(h).append(' ');
                ++n2;
            }
            props.put("trimHeights", buf.toString());
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (FileOutputStream fos = new FileOutputStream(file);){
                    props.store(fos, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    long removeGdkEvent() {
        if (this.gdkEventCount == 0) {
            return 0L;
        }
        long event = this.gdkEvents[0];
        --this.gdkEventCount;
        System.arraycopy(this.gdkEvents, 1, this.gdkEvents, 0, this.gdkEventCount);
        System.arraycopy(this.gdkEventWidgets, 1, this.gdkEventWidgets, 0, this.gdkEventCount);
        this.gdkEvents[this.gdkEventCount] = 0L;
        this.gdkEventWidgets[this.gdkEventCount] = null;
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            if (this.idleHandle != 0) {
                OS.g_source_remove(this.idleHandle);
            }
            this.idleNeeded = false;
            this.idleHandle = 0;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    void removeMouseHoverTimeout(long handle) {
        if (handle != this.mouseHoverHandle) {
            return;
        }
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverHandle = 0L;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    Widget removeWidget(long handle) {
        int index;
        if (handle == 0L) {
            return null;
        }
        this.lastWidget = null;
        Widget widget = null;
        long data = OS.g_object_get_qdata(handle, SWT_OBJECT_INDEX) - 1L;
        if (data < 0L || data > Integer.MAX_VALUE) {
            SWT.error(51, null, ". g_object_get_qdata returned unexpected index value" + this.debugInfoForIndex(data));
        }
        if ((index = (int)data) >= 0 && index < this.widgetTable.length) {
            widget = this.widgetTable[index];
            this.widgetTable[index] = null;
            this.indexTable[index] = this.freeSlot;
            this.freeSlot = index;
            OS.g_object_set_qdata(handle, SWT_OBJECT_INDEX, 0L);
            if (widget == null) {
                SWT.error(5, null, ". Widget already released" + this.debugInfoForIndex(index));
            }
        } else {
            SWT.error(5, null, ". Invalid index for handle " + handle + this.debugInfoForIndex(index));
        }
        return widget;
    }

    String debugInfoForIndex(long index) {
        String s = ", index: " + index;
        int idx = (int)index;
        if (idx >= 0 && idx < this.widgetTable.length) {
            s = s + ", current value at: " + String.valueOf(this.widgetTable[idx]);
        }
        s = s + this.dumpWidgetTableInfo();
        return s;
    }

    void dpiChanged(int newScaleFactor) {
        DPIUtil.setDeviceZoom(DPIUtil.mapDPIToZoom(this.getDPI().x * newScaleFactor));
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].layout(true, true);
            ++i;
        }
    }

    String dumpWidgetTableInfo() {
        StringBuilder sb = new StringBuilder(", table size: ");
        sb.append(this.widgetTable.length);
        IdentityHashMap<Widget, Collection> disposed = new IdentityHashMap<Widget, Collection>();
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget w = this.widgetTable[i];
            if (w != null && w.isDisposed()) {
                disposed.computeIfAbsent(w, k -> new ArrayList()).add(i);
            }
            ++i;
        }
        if (!disposed.isEmpty()) {
            sb.append(", leaked elements:");
            Set set = disposed.entrySet();
            for (Map.Entry entry : set) {
                sb.append(" ").append(entry.getKey()).append(" at ").append(entry.getValue()).append(",");
            }
        }
        return sb.toString();
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runDeferredEvents() {
        boolean run = false;
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            run = true;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return run;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] temp = this.layoutDeferred;
            int count = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int i = 0;
            while (i < count) {
                Composite comp = temp[i];
                if (!comp.isDisposed()) {
                    comp.setLayoutDeferred(false);
                }
                ++i;
            }
            this.update();
            return true;
        }
        return false;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            result = true;
        }
        this.popups = null;
        return result;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.saveResources();
        this.initializeSystemColors();
        this.sendEvent(39, null);
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.fixStyle();
                shell.redraw(true);
                shell.layout(true, true);
            }
            ++i;
        }
        return true;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] oldSkinWidgets = this.skinList;
            int count = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                int i = 0;
                while (i < count) {
                    Widget widget = oldSkinWidgets[i];
                    if (widget != null && !widget.isDisposed()) {
                        widget.state &= 0xFEFFFFFF;
                        oldSkinWidgets[i] = null;
                        Event event = new Event();
                        event.widget = widget;
                        this.sendEvent(45, event);
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    public static void setAppVersion(String version) {
        APP_VERSION = version;
    }

    public void setCursorLocation(int x, int y) {
        if (!OS.isX11()) {
            System.err.println("SWT Display.java Error: setCursorLocation only supported on X11. \n");
        }
        this.setCursorLocation(new Point(x, y));
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        long gdkDisplay = GDK.gdk_display_get_default();
        long gdkPointer = GDK.gdk_get_pointer(gdkDisplay);
        if (!GTK.GTK4) {
            long gdkScreen = GDK.gdk_screen_get_default();
            GDK.gdk_device_warp(gdkPointer, gdkScreen, point.x, point.y);
        }
    }

    public void setData(String key, Object value) {
        Object data;
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(DISPATCH_EVENT_KEY) && (value == null || value instanceof int[])) {
            this.dispatchEvents = (int[])value;
            if (value == null) {
                this.putGdkEvents();
            }
            return;
        }
        if (key.equals(SET_MODAL_DIALOG)) {
            this.setModalDialog((Dialog)value);
            return;
        }
        if (key.equals(ADD_WIDGET_KEY)) {
            data = (Object[])value;
            long handle = ((LONG)data[0]).value;
            Widget widget = (Widget)data[1];
            if (widget != null) {
                this.addWidget(handle, widget);
            } else {
                this.removeWidget(handle);
            }
        }
        if (key.equals(ADD_IDLE_PROC_KEY)) {
            this.addIdleProc();
            return;
        }
        if (key.equals(REMOVE_IDLE_PROC_KEY)) {
            this.removeIdleProc();
            return;
        }
        if (key.equals(EXTERNAL_EVENT_LOOP_KEY)) {
            data = (Boolean)value;
            this.externalEventLoop = data != null && ((Boolean)data).booleanValue();
            return;
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    long setDirectionProc(long widget, long direction) {
        long submenu;
        GTK.gtk_widget_set_direction(widget, (int)direction);
        if (!GTK.GTK4 && GTK3.GTK_IS_MENU_ITEM(widget) && (submenu = GTK3.gtk_menu_item_get_submenu(widget)) != 0L) {
            GTK.gtk_widget_set_direction(submenu, (int)direction);
            GTK3.gtk_container_forall(submenu, this.setDirectionProc, direction);
        }
        if (GTK.GTK_IS_CONTAINER(widget)) {
            GTK3.gtk_container_forall(widget, this.setDirectionProc, direction);
        }
        return 0L;
    }

    void setModalDialog(Dialog modalDailog) {
        this.modalDialog = modalDailog;
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    void setModalShell(Shell shell) {
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) {
                return;
            }
            if (this.modalShells[index] == null) break;
            ++index;
        }
        if (index == length) {
            Shell[] newModalShells = new Shell[length + 4];
            System.arraycopy(this.modalShells, 0, newModalShells, 0, length);
            this.modalShells = newModalShells;
        }
        this.modalShells[index] = shell;
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Synchronizer oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (oldSynchronizer != null) {
                oldSynchronizer.moveAllEventsTo(synchronizer);
            }
            return;
        }
    }

    public final void setRuntimeExceptionHandler(Consumer<RuntimeException> runtimeExceptionHandler) {
        this.checkDevice();
        this.runtimeExceptionHandler = Objects.requireNonNull(runtimeExceptionHandler);
    }

    public final Consumer<RuntimeException> getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    public final void setErrorHandler(Consumer<Error> errorHandler) {
        this.checkDevice();
        this.errorHandler = Objects.requireNonNull(errorHandler);
    }

    public final Consumer<Error> getErrorHandler() {
        return this.errorHandler;
    }

    void showIMWindow(Control control) {
        this.imControl = control;
        if (this.preeditWindow == 0L) {
            this.preeditWindow = GTK3.gtk_window_new(1);
            if (this.preeditWindow == 0L) {
                this.error(2);
            }
            this.preeditLabel = GTK.gtk_label_new(null);
            if (this.preeditLabel == 0L) {
                this.error(2);
            }
            if (GTK.GTK4) {
                GTK4.gtk_window_set_child(this.preeditWindow, this.preeditLabel);
            } else {
                GTK3.gtk_container_add(this.preeditWindow, this.preeditLabel);
                GTK3.gtk_widget_show(this.preeditLabel);
            }
        }
        long[] preeditString = new long[1];
        long[] pangoAttrs = new long[1];
        long imHandle = control.imHandle();
        GTK.gtk_im_context_get_preedit_string(imHandle, preeditString, pangoAttrs, null);
        if (preeditString[0] != 0L && C.strlen(preeditString[0]) > 0) {
            Control widget = control.findBackgroundControl();
            if (widget == null) {
                widget = control;
            }
            widget.setBackgroundGdkRGBA(this.preeditWindow, control.getBackgroundGdkRGBA());
            widget.setForegroundGdkRGBA(this.preeditLabel, control.getForegroundGdkRGBA());
            long fontDesc = control.getFontDescription();
            widget.setFontDescription(this.preeditLabel, fontDesc);
            OS.pango_font_description_free(fontDesc);
            if (pangoAttrs[0] != 0L) {
                GTK.gtk_label_set_attributes(this.preeditLabel, pangoAttrs[0]);
            }
            GTK.gtk_label_set_text(this.preeditLabel, preeditString[0]);
            Point point = control.toDisplay(control.getIMCaretPos());
            GTK3.gtk_window_move(this.preeditWindow, point.x, point.y);
            GtkRequisition requisition = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(this.preeditLabel, requisition, null);
            GTK3.gtk_window_resize(this.preeditWindow, requisition.width, requisition.height);
            GTK3.gtk_widget_show(this.preeditWindow);
        } else {
            GTK3.gtk_widget_hide(this.preeditWindow);
        }
        if (preeditString[0] != 0L) {
            OS.g_free(preeditString[0]);
        }
        if (pangoAttrs[0] != 0L) {
            OS.pango_attr_list_unref(pangoAttrs[0]);
        }
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        if (this.settingsChanged) {
            this.settingsChanged = false;
            this.runSettings = true;
            return false;
        }
        if (!this.synchronizer.isMessagesEmpty()) {
            return true;
        }
        this.sendPreExternalEventDispatchEvent();
        if (!GTK.GTK4) {
            GDK.gdk_threads_leave();
        }
        if (this.fds == 0L) {
            this.allocated_nfds = 2;
            this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
        }
        this.timeout[0] = 0;
        this.max_priority[0] = 0;
        long context = OS.g_main_context_default();
        boolean result = false;
        do {
            int nfds;
            if (!OS.g_main_context_acquire(context)) continue;
            result = OS.g_main_context_prepare(context, this.max_priority);
            while ((nfds = OS.g_main_context_query(context, this.max_priority[0], this.timeout, this.fds, this.allocated_nfds)) > this.allocated_nfds) {
                OS.g_free(this.fds);
                this.allocated_nfds = nfds;
                this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
            }
            long poll = OS.g_main_context_get_poll_func(context);
            if (poll != 0L && (nfds > 0 || this.timeout[0] != 0)) {
                if (this.timeout[0] < 0) {
                    this.timeout[0] = 50;
                }
                this.wake = false;
                OS.Call(poll, this.fds, nfds, this.timeout[0]);
            }
            OS.g_main_context_check(context, this.max_priority[0], this.fds, nfds);
            OS.g_main_context_release(context);
        } while (!result && this.synchronizer.isMessagesEmpty() && !this.wake);
        this.wake = false;
        if (!GTK.GTK4) {
            GDK.gdk_threads_enter();
        }
        this.sendPostExternalEventDispatchEvent();
        return true;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        int timerId;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            OS.g_source_remove(this.timerIds[index]);
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (milliseconds < 0) {
                return;
            }
        } else {
            if (milliseconds < 0) {
                return;
            }
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                int[] newTimerIds = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
                this.timerIds = newTimerIds;
            }
        }
        if ((timerId = GTK.GTK4 ? OS.g_timeout_add(milliseconds, this.timerProc, index) : GDK.gdk_threads_add_timeout(milliseconds, this.timerProc, index)) != 0) {
            this.timerIds[index] = timerId;
            this.timerList[index] = runnable;
        }
    }

    long timerProc(long i) {
        if (this.timerList == null) {
            return 0L;
        }
        int index = (int)i;
        if (index >= 0 && index < this.timerList.length) {
            Runnable runnable = this.timerList[index];
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (runnable != null) {
                try {
                    runnable.run();
                }
                catch (RuntimeException exception) {
                    this.runtimeExceptionHandler.accept(exception);
                }
                catch (Error exception) {
                    this.errorHandler.accept(exception);
                }
            }
        }
        return 0L;
    }

    long caretProc(long clientData) {
        this.caretId = 0;
        if (this.currentCaret == null) {
            return 0L;
        }
        if (this.currentCaret.blinkCaret()) {
            int blinkRate = this.currentCaret.blinkRate;
            if (blinkRate == 0) {
                return 0L;
            }
            this.currentCaret.getParent().blink = true;
            this.caretId = GTK.GTK4 ? OS.g_timeout_add(blinkRate, this.caretProc, 0L) : GDK.gdk_threads_add_timeout(blinkRate, this.caretProc, 0L);
        } else {
            this.currentCaret = null;
        }
        return 0L;
    }

    void resetCaretTiming() {
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
            this.caretId = GTK.GTK4 ? OS.g_timeout_add(this.currentCaret.blinkRate, this.caretProc, 0L) : GDK.gdk_threads_add_timeout(this.currentCaret.blinkRate, this.caretProc, 0L);
        }
    }

    long sizeAllocateProc(long handle, long arg0, long user_data) {
        Widget widget = this.getWidget(user_data);
        if (widget == null) {
            return 0L;
        }
        return widget.sizeAllocateProc(handle, arg0, user_data);
    }

    long sizeRequestProc(long handle, long arg0, long user_data) {
        Widget widget = this.getWidget(user_data);
        if (widget == null) {
            return 0L;
        }
        return widget.sizeRequestProc(handle, arg0, user_data);
    }

    void saveResources() {
        int resourceCount = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            resourceCount = this.resources.length;
            Resource[] newResources = new Resource[resourceCount + 27];
            System.arraycopy(this.resources, 0, newResources, 0, resourceCount);
            this.resources = newResources;
        }
        if (this.errorImage != null) {
            this.resources[resourceCount++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[resourceCount++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[resourceCount++] = this.questionImage;
        }
        if (this.warningImage != null) {
            this.resources[resourceCount++] = this.warningImage;
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        int i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.resources[resourceCount++] = this.cursors[i];
            }
            this.cursors[i] = null;
            ++i;
        }
        if (resourceCount < 27) {
            Resource[] newResources = new Resource[resourceCount];
            System.arraycopy(this.resources, 0, newResources, 0, resourceCount);
            this.resources = newResources;
        }
    }

    private void sendJDKInternalEvent(int eventType) {
        this.sendJDKInternalEvent(eventType, 0);
    }

    private void sendJDKInternalEvent(int eventType, int detail) {
        if (this.eventTable == null || !this.eventTable.hooks(eventType)) {
            return;
        }
        Event event = new Event();
        event.detail = detail;
        event.display = this;
        event.type = eventType;
        event.time = (int)(System.nanoTime() / 1000000L);
        if (!this.filterEvent(event)) {
            this.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(EventTable eventTable, Event event) {
        int type = event.type;
        this.sendPreEvent(type);
        try {
            eventTable.sendEvent(event);
        }
        finally {
            this.sendPostEvent(type);
        }
    }

    void sendPreEvent(int eventType) {
        if (eventType != 50 && eventType != 51 && eventType != 52 && eventType != 53) {
            this.sendJDKInternalEvent(50, eventType);
        }
    }

    void sendPostEvent(int eventType) {
        if (eventType != 50 && eventType != 51 && eventType != 52 && eventType != 53) {
            this.sendJDKInternalEvent(51, eventType);
        }
    }

    public void sendPreExternalEventDispatchEvent() {
        this.sendJDKInternalEvent(52);
    }

    public void sendPostExternalEventDispatchEvent() {
        this.sendJDKInternalEvent(53);
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.currentCaret = caret;
        if (caret == null) {
            return;
        }
        int blinkRate = this.currentCaret.blinkRate;
        this.caretId = GTK.GTK4 ? OS.g_timeout_add(blinkRate, this.caretProc, 0L) : GDK.gdk_threads_add_timeout(blinkRate, this.caretProc, 0L);
    }

    long shellMapProc(long handle, long arg0, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.shellMapProc(handle, arg0, user_data);
    }

    long signalProc(long gobject, long arg1, long user_data) {
        switch ((int)user_data) {
            case 1: {
                this.settingsChanged = true;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = GTK.GTK4 ? OS.g_idle_add(this.idleProc, 0L) : GDK.gdk_threads_add_idle(this.idleProc, 0L);
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    public <T, E extends Exception> T syncCall(SwtCallable<T, E> callable) throws E {
        Objects.nonNull(callable);
        AtomicReference result = new AtomicReference();
        AtomicReference ex = new AtomicReference();
        this.syncExec(() -> {
            try {
                result.setPlain(callable.call());
            }
            catch (Exception e) {
                ex.setPlain(e);
            }
        });
        if (ex.getPlain() != null) {
            Exception e = (Exception)ex.getPlain();
            throw e;
        }
        return (T)result.getPlain();
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        this.flushExposes(0L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        OS.g_main_context_wakeup(0L);
        this.wake = true;
    }

    void enterMotionProc(long controller, double x, double y, long user_data) {
        long handle = GTK.gtk_event_controller_get_widget(controller);
        Widget widget = this.getWidget(handle);
        if (widget != null) {
            widget.enterMotionProc(controller, x, y, user_data);
        }
    }

    boolean scrollProc(long controller, double dx, double dy, long user_data) {
        long handle = GTK.gtk_event_controller_get_widget(controller);
        Widget widget = this.getWidget(handle);
        if (widget != null) {
            return widget.scrollProc(controller, dx, dy, user_data);
        }
        return false;
    }

    void focusProc(long controller, long user_data) {
        long handle = GTK.gtk_event_controller_get_widget(controller);
        Widget widget = this.getWidget(handle);
        if (widget != null) {
            widget.focusProc(controller, user_data);
        }
    }

    void windowActiveProc(long handle, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget != null) {
            widget.windowActiveProc(handle, user_data);
        }
    }

    boolean keyPressReleaseProc(long controller, int keyval, int keycode, int state, long user_data) {
        long handle = GTK.gtk_event_controller_get_widget(controller);
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return false;
        }
        return widget.keyPressReleaseProc(controller, keyval, keycode, state, user_data);
    }

    void gesturePressReleaseProc(long gesture, int n_press, double x, double y, long user_data) {
        long handle = GTK.gtk_event_controller_get_widget(gesture);
        Widget widget = this.getWidget(handle);
        if (widget != null) {
            widget.gesturePressReleaseProc(gesture, n_press, x, y, user_data);
        }
    }

    void leaveProc(long controller, long user_data) {
        long handle = GTK.gtk_event_controller_get_widget(controller);
        Widget widget = this.getWidget(handle);
        if (widget != null) {
            widget.leaveProc(controller, handle, user_data);
        }
    }

    void computeSizeProc(long toplevel, long size, long user_data) {
    }

    void activateProc(long action, long parameter, long user_data) {
        Widget widget = this.getWidget(user_data);
        if (widget == null) {
            return;
        }
        widget.gtk_activate(user_data);
    }

    void resizeProc(long handle, int width, int height) {
        Widget widget = this.getWidget(handle);
        if (widget != null) {
            widget.gtk_size_allocate(handle, 0L);
        }
    }

    long notifyProc(long object, long param_spec, long user_data) {
        Widget widget = this.getWidget(object);
        if (widget == null) {
            widget = this.getWidget(user_data);
            if (widget == null) {
                return 0L;
            }
            return widget.notifyProc(object, param_spec, 102L);
        }
        return widget.notifyProc(object, param_spec, user_data);
    }

    boolean changeValue(long handle, int scroll, double value, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return false;
        }
        return widget.gtk_change_value(handle, scroll, value, user_data);
    }

    long windowProc(long handle, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(handle, user_data);
    }

    long windowProc(long handle, long arg0, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(handle, arg0, user_data);
    }

    long windowProc(long handle, long arg0, long arg1, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(handle, arg0, arg1, user_data);
    }

    long windowProc(long handle, long arg0, long arg1, long arg2, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(handle, arg0, arg1, arg2, user_data);
    }

    long windowProc(long handle, long arg0, long arg1, long arg2, long arg3, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(handle, arg0, arg1, arg2, arg3, user_data);
    }

    long windowTimerProc(long handle) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.timerProc(handle);
    }

    long getWindowPointerPosition(long window, int[] x, int[] y, int[] mask) {
        long display = 0L;
        if (window != 0L) {
            display = GDK.gdk_window_get_display(window);
        } else {
            window = GDK.gdk_get_default_root_window();
            display = GDK.gdk_window_get_display(window);
        }
        long pointer = GDK.gdk_get_pointer(display);
        if (OS.isWayland()) {
            GDK.gdk_window_get_device_position(window, pointer, null, null, mask);
            long windowAtPosition = GDK.gdk_device_get_window_at_position(pointer, x, y);
            if (windowAtPosition != 0L && windowAtPosition != window) {
                int[] origin_x = new int[1];
                int[] origin_y = new int[1];
                GDK.gdk_window_get_origin(windowAtPosition, origin_x, origin_y);
                x[0] = x[0] + origin_x[0];
                y[0] = y[0] + origin_y[0];
                GDK.gdk_window_get_origin(window, origin_x, origin_y);
                x[0] = x[0] - origin_x[0];
                y[0] = y[0] - origin_y[0];
            }
            return windowAtPosition;
        }
        return GDK.gdk_window_get_device_position(window, pointer, x, y, mask);
    }

    void getPointerPosition(double[] x, double[] y) {
        long display = GDK.gdk_display_get_default();
        long seat = GDK.gdk_display_get_default_seat(display);
        long pointer = GDK.gdk_seat_get_pointer(seat);
        GDK.gdk_device_get_surface_at_position(pointer, x, y);
    }

    long gdk_device_get_window_at_position(int[] win_x, int[] win_y) {
        long display = GDK.gdk_display_get_default();
        long device = GDK.gdk_get_pointer(display);
        return GDK.gdk_device_get_window_at_position(device, win_x, win_y);
    }

    long gdk_device_get_surface_at_position(double[] win_x, double[] win_y) {
        long display = GDK.gdk_display_get_default();
        long device = GDK.gdk_get_pointer(display);
        return GDK.gdk_device_get_surface_at_position(device, win_x, win_y);
    }

    static int _getDeviceZoom(long monitor_num) {
        int dpi = 96;
        long display = GDK.gdk_display_get_default();
        long monitor = GDK.gdk_display_get_monitor_at_point(display, 0, 0);
        int scale = GDK.gdk_monitor_get_scale_factor(monitor);
        return DPIUtil.mapDPIToZoom(dpi *= scale);
    }

    static boolean isActivateShellOnForceFocus() {
        return "true".equals(System.getProperty("org.eclipse.swt.internal.activateShellOnForceFocus", "true"));
    }

    public boolean isRescalingAtRuntime() {
        return false;
    }

    @Deprecated(since="2025-03", forRemoval=true)
    public boolean setRescalingAtRuntime(boolean activate) {
        return false;
    }

    private class SessionManagerListener
    implements SessionManagerDBus.IListener {
        Display parent;

        public SessionManagerListener(Display parent) {
            this.parent = parent;
        }

        @Override
        public boolean isReadyToExit() {
            Event event = new Event();
            this.parent.sendEvent(21, event);
            return event.doit;
        }

        @Override
        public void stop() {
            this.parent.dispose();
        }
    }
}

