/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionControlService;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteConnectionPropertyService;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.core.RemotePath;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.remote.core.Messages;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnectionManager;
import org.eclipse.tcf.te.tcf.remote.core.TCFFileStore;
import org.eclipse.tcf.te.tcf.remote.core.TCFProcessBuilder;
import org.eclipse.tcf.te.tcf.remote.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationGetEnvironment;
import org.osgi.framework.Bundle;

public class TCFConnection
implements IRemoteConnectionHostService,
IRemoteConnectionPropertyService,
IRemoteProcessService,
IRemoteConnectionControlService,
IRemoteFileService {
    public static final String CONNECTION_TYPE_ID = "org.eclipse.tcf.te.tcf.remote";
    private IRemoteConnection fRemoteConnection;
    private volatile IPeerNode fPeerNode;
    private volatile boolean fOpen;
    private Map<String, String> fEnvironment;
    private String fWorkingDirectory = "/";
    private String fBaseDirectory = "";

    public TCFConnection(IPeerNode peerNode) {
        this.fPeerNode = peerNode;
        this.fOpen = peerNode.getConnectState() == 11;
    }

    public TCFConnection(IRemoteConnection rc) {
        this.fRemoteConnection = rc;
        this.fOpen = false;
    }

    public String getName() {
        if (this.fPeerNode != null) {
            return this.fPeerNode.getName();
        }
        return this.fRemoteConnection.getName();
    }

    public IRemoteConnection getRemoteConnection() {
        return this.fRemoteConnection;
    }

    void setRemoteConnection(IRemoteConnection remoteConnection) {
        this.fRemoteConnection = remoteConnection;
    }

    void setPeerNode(IPeerNode peerNode) {
        if (this.fPeerNode == peerNode) {
            return;
        }
        this.fPeerNode = peerNode;
        this.setConnectedTCF(peerNode.getConnectState() == 11);
    }

    public IPeerNode getPeerNode() {
        return this.fPeerNode;
    }

    public String getHostname() {
        if (this.fPeerNode == null) {
            return "0.0.0.0";
        }
        return this.getPeerProperty("Host");
    }

    private String getPeerProperty(String key) {
        return (String)this.fPeerNode.getPeer().getAttributes().get(key);
    }

    public int getPort() {
        if (this.fPeerNode != null) {
            try {
                return Integer.parseInt(this.getPeerProperty("Port"));
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    public int getTimeout() {
        return 60;
    }

    public boolean useLoginShell() {
        return false;
    }

    public String getUsername() {
        if (this.fPeerNode == null) {
            return "";
        }
        return this.getPeerProperty("UserName");
    }

    public void setHostname(String hostname) {
    }

    public void setPassphrase(String passphrase) {
    }

    public void setPassword(String password) {
    }

    public void setPort(int port) {
    }

    public void setTimeout(int timeout) {
    }

    public void setUseLoginShell(boolean useLogingShell) {
    }

    public void setUsePassword(boolean usePassword) {
    }

    public void setUsername(String username) {
    }

    public String getProperty(String key) {
        if (this.fPeerNode == null) {
            return null;
        }
        if ("os.name".equals(key)) {
            return this.getPeerProperty("OSName");
        }
        return null;
    }

    public Map<String, String> getEnv() {
        if (this.fEnvironment == null && this.fPeerNode != null) {
            try {
                this.fEnvironment = (Map)new TCFOperationGetEnvironment(this.fPeerNode.getPeer()).execute(SubMonitor.convert(null));
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (CoreException e) {
                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.TCFConnection_errorNoEnvironment, (Throwable)e));
            }
        }
        return this.fEnvironment;
    }

    public String getEnv(String name) {
        Map<String, String> map = this.getEnv();
        if (map != null) {
            return map.get(name);
        }
        return null;
    }

    public IRemoteProcessBuilder getProcessBuilder(List<String> command) {
        if (!this.isOpen()) {
            return null;
        }
        return new TCFProcessBuilder(this, command);
    }

    public IRemoteProcessBuilder getProcessBuilder(String ... command) {
        if (!this.isOpen()) {
            return null;
        }
        return new TCFProcessBuilder(this, command);
    }

    public String getWorkingDirectory() {
        return this.fWorkingDirectory;
    }

    public void setWorkingDirectory(String path) {
        this.fWorkingDirectory = path;
    }

    public boolean isOpen() {
        return this.fOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        if (this.fPeerNode == null) {
            TCFConnectionManager.INSTANCE.waitForInitialization(monitor);
        }
        boolean open = false;
        TCFConnection tCFConnection = this;
        synchronized (tCFConnection) {
            if (this.fOpen) {
                return;
            }
            if (this.fPeerNode.getConnectState() == 11) {
                open = true;
                this.fOpen = true;
            }
        }
        if (open) {
            this.fireConnectionChangeEvent(2);
        } else {
            TCFConnectionManager.INSTANCE.open(this.fPeerNode, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        TCFConnection tCFConnection = this;
        synchronized (tCFConnection) {
            if (!this.fOpen) {
                return;
            }
            this.fOpen = false;
        }
        this.fireConnectionChangeEvent(1);
        TCFConnectionManager.INSTANCE.close(this.fPeerNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnectedTCF(boolean connected) {
        int notify = -1;
        TCFConnection tCFConnection = this;
        synchronized (tCFConnection) {
            if (connected) {
                if (!this.fOpen) {
                    this.fOpen = true;
                    notify = 2;
                }
            } else if (this.fOpen) {
                this.fOpen = false;
                notify = 1;
            }
        }
        if (notify != -1) {
            this.fireConnectionChangeEvent(notify);
        }
    }

    private void fireConnectionChangeEvent(final int type) {
        final IRemoteConnection rc = this.fRemoteConnection;
        if (rc == null) {
            return;
        }
        new Job(Messages.TCFConnection_notifyListeners){

            protected IStatus run(IProgressMonitor monitor) {
                rc.fireConnectionChangeEvent(type);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public String getBaseDirectory() {
        return this.fBaseDirectory;
    }

    public String getDirectorySeparator() {
        return "/";
    }

    public IFileStore getResource(String path) {
        return new TCFFileStore(this, RemotePath.forPosix((String)path).toString(), null);
    }

    public void setBaseDirectory(String path) {
        this.fBaseDirectory = path;
    }

    public String toPath(URI uri) {
        return TCFFileStore.toPath(uri);
    }

    public URI toURI(String path) {
        return this.toURI((IPath)RemotePath.forPosix((String)path));
    }

    public URI toURI(IPath path) {
        if (!path.isAbsolute() && this.fBaseDirectory != null && this.fBaseDirectory.length() > 0) {
            path = RemotePath.forPosix((String)this.fBaseDirectory).append(path);
        }
        return TCFFileStore.toURI(this, path.toString());
    }

    public String getPassphrase() {
        return null;
    }

    public String getPassword() {
        return null;
    }

    public boolean usePassword() {
        return false;
    }
}

