/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.vectorgraphics2d.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.eclipse.swtchart.vectorgraphics2d.util.DataUtils;

public class FormattingWriter
implements Closeable,
Flushable,
AutoCloseable {
    private final OutputStream out;
    private final Charset encoding;
    private final byte[] eolBytes;
    private long position;

    public FormattingWriter(OutputStream out, Charset encoding, String eol) {
        if (out == null) {
            throw new IllegalArgumentException("Output stream cannot be null.");
        }
        if (eol == null || eol.isEmpty()) {
            throw new IllegalArgumentException("End-of-line string cannot be empty.");
        }
        this.out = out;
        this.encoding = encoding;
        this.eolBytes = eol.getBytes(encoding);
    }

    public FormattingWriter write(byte[] bytes) throws IOException {
        this.out.write(bytes, 0, bytes.length);
        this.position += (long)bytes.length;
        return this;
    }

    public FormattingWriter write(String str) throws IOException {
        byte[] bytes = str.getBytes(this.encoding);
        return this.write(bytes);
    }

    public FormattingWriter write(String format, Object ... args) throws IOException {
        return this.write(String.format(null, format, args));
    }

    public FormattingWriter write(Number number) throws IOException {
        return this.write(DataUtils.format(number));
    }

    public FormattingWriter writeln() throws IOException {
        return this.write(this.eolBytes);
    }

    public FormattingWriter writeln(byte[] bytes) throws IOException {
        this.write(bytes);
        return this.writeln();
    }

    public FormattingWriter writeln(String string) throws IOException {
        this.write(string);
        return this.writeln();
    }

    public FormattingWriter writeln(String format, Object ... args) throws IOException {
        this.write(String.format(null, format, args));
        return this.writeln();
    }

    public FormattingWriter writeln(Number number) throws IOException {
        this.write(number);
        return this.writeln();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public long tell() {
        return this.position;
    }
}

