/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sphinx.emf.resource.ScopingResourceSetImpl;
import org.eclipse.sphinx.testutils.EcoreEqualityAssert;
import org.eclipse.sphinx.testutils.TestFileAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestCase
extends TestCase {
    private TestFileAccessor testFileAccessor = null;
    private boolean ignoreLoadProblems;
    private boolean ignoreSaveProblems;

    protected void setUp() throws Exception {
        IEclipsePreferences workbenchPrefs = InstanceScope.INSTANCE.getNode("org.eclipse.ui.workbench");
        workbenchPrefs.put("RUN_IN_BACKGROUND", Boolean.TRUE.toString());
        this.ignoreLoadProblems = false;
        this.ignoreSaveProblems = false;
    }

    protected final TestFileAccessor getTestFileAccessor() {
        if (this.testFileAccessor == null) {
            this.testFileAccessor = new TestFileAccessor(this.getTestPlugin(), new File("working-dir"));
        }
        return this.testFileAccessor;
    }

    protected abstract Plugin getTestPlugin();

    protected boolean isIgnoreLoadProblems() {
        return this.ignoreLoadProblems;
    }

    public void setIgnoreLoadProblems(boolean ignoreLoadProblems) {
        this.ignoreLoadProblems = ignoreLoadProblems;
    }

    protected boolean isIgnoreSaveProblems() {
        return this.ignoreSaveProblems;
    }

    public void setIgnoreSaveProblems(boolean ignoreSaveProblems) {
        this.ignoreSaveProblems = ignoreSaveProblems;
    }

    protected EObject loadInputFile(String inputFileName, ResourceFactoryImpl resourceFactory, Map<?, ?> options) throws Exception {
        return this.loadFile(this.getTestFileAccessor().getInputFileURI(inputFileName), resourceFactory, options);
    }

    protected EObject loadWorkingFile(String workingFileName, ResourceFactoryImpl resourceFactory, Map<?, ?> options) throws Exception {
        return this.loadFile(this.getTestFileAccessor().getWorkingFileURI(workingFileName), resourceFactory, options);
    }

    private EObject loadFile(java.net.URI fileURI, ResourceFactoryImpl resourceFactory, Map<?, ?> options) throws Exception {
        URI emfURI = this.getTestFileAccessor().convertToEMFURI(fileURI);
        XMLResource resource = (XMLResource)resourceFactory.createResource(emfURI);
        resource.load(options);
        ScopingResourceSetImpl resourceSet = this.createDefaultResourceSet();
        resourceSet.getResources().add((Object)resource);
        this.assertHasNoLoadProblems((Resource)resource);
        return (EObject)resource.getContents().get(0);
    }

    protected void saveWorkingFile(String fileName, EObject modelRoot, ResourceFactoryImpl resourceFactory, Map<?, ?> options) throws Exception {
        this.saveFile(this.getTestFileAccessor().getWorkingFileURI(fileName), modelRoot, resourceFactory, options);
    }

    private void saveFile(java.net.URI fileURI, EObject modelRoot, ResourceFactoryImpl resourceFactory, Map<?, ?> options) throws Exception {
        URI emfURI = this.getTestFileAccessor().convertToEMFURI(fileURI);
        XMLResource resource = (XMLResource)resourceFactory.createResource(emfURI);
        resource.getContents().add((Object)modelRoot);
        resource.save(options);
        this.assertHasNoSaveProblems((Resource)resource);
    }

    protected String loadInputFileAsString(String fileName) throws Exception {
        return this.loadFileAsString(this.getTestFileAccessor().openInputFileInputStream(fileName));
    }

    protected String loadWorkingFileAsString(String fileName) throws Exception {
        return this.loadFileAsString(this.getTestFileAccessor().openWorkingFileInputStream(fileName));
    }

    protected String loadFileAsString(InputStream inputStream) throws Exception {
        inputStream = new BufferedInputStream(inputStream);
        try {
            int bufferLength;
            byte[] buffer = new byte[1024];
            StringBuilder content = new StringBuilder();
            while ((bufferLength = inputStream.read(buffer)) > -1) {
                content.append(new String(buffer, 0, bufferLength));
            }
            String string = content.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    protected ScopingResourceSetImpl createDefaultResourceSet() {
        return new ScopingResourceSetImpl();
    }

    public void assertEquals(EObject eObject1, EObject eObject2) {
        EcoreEqualityAssert.assertEquals(eObject1, eObject2);
    }

    protected void assertHasNoLoadProblems(Resource resource) {
        AbstractTestCase.assertNotNull((Object)resource);
        if (!this.isIgnoreLoadProblems()) {
            AbstractTestCase.assertTrue((String)("Errors encountered during resource loading: " + this.formatDiagnosticMessages((EList<Resource.Diagnostic>)resource.getErrors())), (resource.getErrors().size() == 0 ? 1 : 0) != 0);
            AbstractTestCase.assertTrue((String)("Warnings encountered during resource loading: " + this.formatDiagnosticMessages((EList<Resource.Diagnostic>)resource.getWarnings())), (resource.getWarnings().size() == 0 ? 1 : 0) != 0);
        }
    }

    protected void assertHasNoSaveProblems(Resource resource) {
        AbstractTestCase.assertNotNull((Object)resource);
        if (!this.isIgnoreSaveProblems()) {
            AbstractTestCase.assertTrue((String)("Errors encountered during resource saving: " + this.formatDiagnosticMessages((EList<Resource.Diagnostic>)resource.getErrors())), (resource.getErrors().size() == 0 ? 1 : 0) != 0);
            AbstractTestCase.assertTrue((String)("Warnings encountered during resource saving: " + this.formatDiagnosticMessages((EList<Resource.Diagnostic>)resource.getWarnings())), (resource.getWarnings().size() == 0 ? 1 : 0) != 0);
        }
    }

    protected String formatDiagnosticMessages(EList<Resource.Diagnostic> diagnostics) {
        StringBuilder msg = new StringBuilder();
        for (Resource.Diagnostic diagnostic : diagnostics) {
            if (msg.length() > 0) {
                msg.append("; ");
            }
            msg.append(diagnostic.getMessage());
        }
        return msg.toString();
    }
}

