/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.wizards.pages;

import java.util.Collection;
import java.util.Collections;
import java.util.MissingResourceException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.SelectionButtonField;
import org.eclipse.sphinx.platform.ui.util.SWTUtil;
import org.eclipse.sphinx.platform.ui.wizards.pages.AbstractWizardPage;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;
import org.eclipse.sphinx.xtendxpand.preferences.OutletsPreference;
import org.eclipse.sphinx.xtendxpand.ui.groups.OutletsGroup;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.sphinx.xtendxpand.ui.outlet.providers.OutletProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutletsConfigurationPage
extends AbstractWizardPage {
    private SelectionButtonField enableButton;
    private String enableText;
    private OutletsPreference outletsPreference;
    private OutletProvider outletProvider;
    private OutletsGroup outletsGroup;
    private Button restoreDefaultButton;

    public OutletsConfigurationPage(String pageName, String enableText, OutletsPreference outletsPreference) {
        super(pageName);
        this.enableText = enableText;
        this.outletsPreference = outletsPreference;
    }

    protected Control doCreateControl(Composite parent) {
        Composite parentComposite = new Composite(parent, 0);
        parentComposite.setFont(parent.getFont());
        parentComposite.setLayout((Layout)new GridLayout(2, false));
        parentComposite.setLayoutData((Object)new GridData(256));
        this.createOutletsGroupContent(parentComposite);
        return parentComposite;
    }

    protected void createOutletsGroupContent(Composite parent) {
        this.createAdditionalGroups(parent);
        if (this.outletsPreference != null) {
            if (this.enableText != null && this.enableText.length() > 0) {
                this.enableButton = new SelectionButtonField(32);
            }
            if (this.enableText != null && this.enableText.length() > 0) {
                this.enableButton.setLabelText(this.enableText);
                this.enableButton.setSelection(true);
                this.enableButton.fillIntoGrid(parent, 2);
                this.enableButton.addFieldListener(new IFieldListener(){

                    public void dialogFieldChanged(IField field) {
                        OutletsConfigurationPage.this.updateOutletsGroupEnableState(OutletsConfigurationPage.this.enableButton.isSelected());
                    }
                });
            }
            this.outletsGroup = new OutletsGroup(Messages.label_outletsGroupName, this.getOutletProvider());
            this.outletsGroup.createContent(parent, 2);
            this.restoreDefaultButton = SWTUtil.createButton((Composite)this.outletsGroup.getButtonsComposite(), (String)Messages.label_restoreDefaultButtons, (int)8);
            this.restoreDefaultButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.widget == OutletsConfigurationPage.this.restoreDefaultButton) {
                        OutletsConfigurationPage.this.restoreDefaults();
                    }
                }
            });
            if (this.enableButton == null) {
                this.updateOutletsGroupEnableState(true);
            }
        }
    }

    protected void createAdditionalGroups(Composite parent) {
    }

    protected void updateOutletsGroupEnableState(boolean enabled) {
        if (this.outletsGroup != null) {
            this.outletsGroup.setEnabled(enabled);
        }
    }

    protected void restoreDefaults() {
        if (this.outletProvider != null) {
            this.outletProvider.setToDefault();
            this.outletsGroup.getTableViewer().refresh();
        }
    }

    public Collection<ExtendedOutlet> getOutlets() {
        return this.outletProvider != null ? this.outletProvider.getOutlets() : Collections.emptyList();
    }

    protected OutletsPreference getOutletsPreference() {
        return this.outletsPreference;
    }

    protected OutletProvider getOutletProvider() {
        if (this.outletProvider == null) {
            this.outletProvider = this.createOutletProvider();
        }
        return this.outletProvider;
    }

    protected OutletProvider createOutletProvider() {
        return new OutletProvider(this.getOutletsPreference());
    }

    protected String doGetDescription() throws MissingResourceException {
        return Messages.desc_configOutlets;
    }

    protected String doGetTitle() throws MissingResourceException {
        return Messages.title_outletConfigurationDialog;
    }

    protected boolean doIsPageComplete() {
        return true;
    }

    protected IStatus doValidateRules() {
        return null;
    }
}

