/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.wizards;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sphinx.emf.mwe.resources.IWorkspaceResourceLoader;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.ui.wizards.AbstractWizard;
import org.eclipse.sphinx.xtendxpand.jobs.CheckJob;
import org.eclipse.sphinx.xtendxpand.jobs.M2MJob;
import org.eclipse.sphinx.xtendxpand.jobs.XtendJob;
import org.eclipse.sphinx.xtendxpand.ui.internal.Activator;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.sphinx.xtendxpand.ui.wizards.pages.CheckConfigurationPage;
import org.eclipse.sphinx.xtendxpand.ui.wizards.pages.XtendConfigurationPage;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.typesystem.MetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2MConfigurationWizard
extends AbstractWizard {
    protected EObject modelObject;
    protected TypeSystem typeSystem;
    private String m2mJobName;
    private IWorkspaceResourceLoader workspaceResourceLoader;
    private IJobChangeListener resultObjectHandler;
    private IJobChangeListener resultMessageHandler;
    protected XtendConfigurationPage xtendConfigurationPage;
    protected CheckConfigurationPage checkConfigurationPage;

    public M2MConfigurationWizard(EObject modelObject, List<MetaModel> metaModels) {
        Assert.isNotNull(metaModels);
        this.setDialogSettings(Activator.getDefault().getDialogSettings());
        this.setWindowTitle(Messages.title_modelTransformation);
        this.modelObject = modelObject;
        this.typeSystem = new TypeSystemImpl();
        for (MetaModel metaModel : metaModels) {
            ((TypeSystemImpl)this.typeSystem).registerMetaModel(metaModel);
        }
    }

    public String getM2MJobName() {
        return this.m2mJobName != null ? this.m2mJobName : this.getDefaultM2MJobName();
    }

    protected String getDefaultM2MJobName() {
        return Messages.job_transformingModel;
    }

    public void setM2MJobName(String m2mJobName) {
        this.m2mJobName = m2mJobName;
    }

    public IWorkspaceResourceLoader getWorkspaceResourceLoader() {
        return this.workspaceResourceLoader;
    }

    public void setWorkspaceResourceLoader(IWorkspaceResourceLoader resourceLoader) {
        this.workspaceResourceLoader = resourceLoader;
    }

    public IJobChangeListener getResultObjectHandler() {
        return this.resultObjectHandler;
    }

    public void setResultObjectHandler(IJobChangeListener resultObjectHandler) {
        this.resultObjectHandler = resultObjectHandler;
    }

    public IJobChangeListener getResultMessageHandler() {
        return this.resultMessageHandler;
    }

    public void setResultMessageHandler(IJobChangeListener resultMessageHandler) {
        this.resultMessageHandler = resultMessageHandler;
    }

    public void addPages() {
        this.xtendConfigurationPage = this.createXtendConfigurationPage();
        this.addPage((IWizardPage)this.xtendConfigurationPage);
        this.checkConfigurationPage = this.createCheckConfigurationPage();
        this.addPage((IWizardPage)this.checkConfigurationPage);
    }

    protected XtendConfigurationPage createXtendConfigurationPage() {
        XtendConfigurationPage xtendPage = new XtendConfigurationPage(Messages.label_xtendPageName);
        xtendPage.init(this.modelObject, this.typeSystem);
        return xtendPage;
    }

    protected CheckConfigurationPage createCheckConfigurationPage() {
        CheckConfigurationPage checkPage = new CheckConfigurationPage(Messages.label_xtendPageName);
        checkPage.init(this.modelObject);
        return checkPage;
    }

    protected void doPerformFinish(IProgressMonitor monitor) throws CoreException {
        IJobChangeListener resultMessageHandler;
        ExtendedPlatformUI.showSystemConsole();
        CheckJob checkJob = this.isCheckRequired() ? this.createCheckJob() : null;
        XtendJob xtendJob = this.createXtendJob();
        M2MJob job = new M2MJob(this.getM2MJobName(), xtendJob, checkJob);
        job.setPriority(40);
        IJobChangeListener resultObjectHandler = this.getResultObjectHandler();
        if (resultObjectHandler != null) {
            job.addJobChangeListener(resultObjectHandler);
        }
        if ((resultMessageHandler = this.getResultMessageHandler()) != null) {
            job.addJobChangeListener(resultMessageHandler);
        }
        job.schedule();
    }

    protected boolean isCheckRequired() {
        return this.checkConfigurationPage.isCheckEnabled() && !this.checkConfigurationPage.getCheckEvaluationRequests().isEmpty();
    }

    protected CheckJob createCheckJob() {
        CheckJob checkJob = new CheckJob(this.getM2MJobName(), this.typeSystem, this.checkConfigurationPage.getCheckEvaluationRequests());
        checkJob.setWorkspaceResourceLoader(this.getWorkspaceResourceLoader());
        checkJob.setPriority(40);
        IFile file = EcorePlatformUtil.getFile((EObject)this.modelObject);
        if (file != null) {
            checkJob.setRule((ISchedulingRule)file.getProject());
        }
        return checkJob;
    }

    protected XtendJob createXtendJob() {
        XtendJob job = new XtendJob(this.getM2MJobName(), this.typeSystem, this.xtendConfigurationPage.getXtendEvaluationRequests());
        job.setWorkspaceResourceLoader(this.getWorkspaceResourceLoader());
        job.setPriority(40);
        IFile file = EcorePlatformUtil.getFile((EObject)this.modelObject);
        if (file != null) {
            job.setRule((ISchedulingRule)file.getProject());
        }
        return job;
    }

    protected void doPerformCancel(IProgressMonitor monitor) throws CoreException {
    }
}

