/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.saving.SaveIndicatorUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.domain.WorkspaceEditingDomainManager;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.testutils.TestFileAccessor;
import org.eclipse.sphinx.testutils.integration.IReferenceWorkspace;
import org.eclipse.sphinx.testutils.integration.ReferenceWorkspaceChangeListener;
import org.eclipse.sphinx.testutils.integration.ResourceProblemListener;
import org.eclipse.sphinx.testutils.integration.internal.Activator;
import org.eclipse.sphinx.testutils.integration.internal.IInternalReferenceWorkspace;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceEditingDomainDescriptor;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceModelDescriptor;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceProjectDescriptor;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceWorkspaceExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntegrationTestCase<T extends IReferenceWorkspace>
extends TestCase {
    private static final String REFERENCE_WORKSPACE_PROPERTIES_FILE_NAME = "referenceWorkspaceSourceRootDirectory.properties";
    private static final String REFERENCE_WORKSPACE_SOURCE_ROOT_DIRECTORY_PROPERTIES_KEY = "referenceWorksaceSourceDirectory";
    private static final String SCHEDULED_JOB_TIMEOUT = System.getProperty(String.valueOf(AbstractIntegrationTestCase.class.getName()) + ".SCHEDULED_JOB_TIMEOUT", new Integer(10000).toString());
    private static final String JOB_FAMILY_TIMEOUT = System.getProperty(String.valueOf(AbstractIntegrationTestCase.class.getName()) + ".JOB_FAMILY_TIMEOUT", new Integer(60000).toString());
    private TestFileAccessor testFileAccessor = null;
    private IInternalReferenceWorkspace internalRefWks;
    protected T refWks;
    private ModelLoadingJobTracer modelLoadJobTracer = new ModelLoadingJobTracer();
    private ResourceProblemListener resourceProblemListener = new ResourceProblemListener();
    private ReferenceWorkspaceChangeListener referenceWorkspaceChangeListener = new ReferenceWorkspaceChangeListener();
    private File referenceWorkspaceTempDir;
    private File referenceWorkspaceSourceDir;
    private boolean reuseRefWks;

    public AbstractIntegrationTestCase(String referenceWorkspaceTempDirBaseName) {
        this(referenceWorkspaceTempDirBaseName, true);
    }

    public AbstractIntegrationTestCase(String referenceWorkspaceTempDirBaseName, boolean reuseSameReferenceWorkspaceForAllTests) {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        File tempDir = new File(tempDirPath);
        String referenceWorkspaceTempDirName = String.valueOf(referenceWorkspaceTempDirBaseName) + "-" + Activator.getPlugin().getBundle().getVersion();
        this.referenceWorkspaceTempDir = new File(tempDir, referenceWorkspaceTempDirName);
        if (!this.referenceWorkspaceTempDir.exists()) {
            this.referenceWorkspaceTempDir.mkdir();
        }
        this.reuseRefWks = reuseSameReferenceWorkspaceForAllTests;
    }

    protected final TestFileAccessor getTestFileAccessor() {
        if (this.testFileAccessor == null) {
            this.testFileAccessor = new TestFileAccessor(this.getTestPlugin(), new File("working-dir"));
        }
        return this.testFileAccessor;
    }

    protected abstract Plugin getTestPlugin();

    protected boolean isProjectsClosedOnStartup() {
        return false;
    }

    protected void setUp() throws Exception {
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.modelLoadJobTracer);
        IEclipsePreferences workbenchPrefs = InstanceScope.INSTANCE.getNode("org.eclipse.ui.workbench");
        workbenchPrefs.put("RUN_IN_BACKGROUND", Boolean.TRUE.toString());
        if (!this.reuseRefWks) {
            WorkspaceEditingDomainManager.INSTANCE.resetEditingDomainMapping();
            AbstractIntegrationTestCase.assertTrue((boolean)WorkspaceEditingDomainManager.INSTANCE.getEditingDomainMapping().getEditingDomains().isEmpty());
            this.assertAllModelResourcesUnloaded();
            this.synchronizedDeleteWorkspace();
            ModelDescriptorRegistry.INSTANCE.removeModels((IContainer)ResourcesPlugin.getWorkspace().getRoot());
            AbstractIntegrationTestCase.assertTrue((ModelDescriptorRegistry.INSTANCE.getAllModels().size() == 0 ? 1 : 0) != 0);
            this.assertAllModelDescriptorsRemoved();
        } else {
            this.synchronizedDeleteProjects(this.getUnusedReferenceProjects());
        }
        this.initReferenceWorkspace();
        if (this.needToExtractReferenceWorkspaceArchive()) {
            this.synchronizedDeleteWorkspace();
            this.deleteExternalResource(this.referenceWorkspaceTempDir);
            this.extractReferenceWorkspaceArchive();
        } else {
            this.loadReferenceWorkspaceSourceDir();
        }
        org.eclipse.sphinx.emf.workspace.Activator.getPlugin().stopWorkspaceSynchronizing();
        this.importMissingReferenceProjectsIntoWorkspace();
        this.synchronizedOpenAllProjects();
        this.importMissingReferenceFilesToWorkspace();
        this.createInterProjectReferences();
        this.internalRefWks.addResourceSetProblemListener(this.resourceProblemListener);
        if (this.isProjectsClosedOnStartup()) {
            ModelLoadManager.INSTANCE.unloadWorkspace(false, null);
            this.synchronizedCloseAllProjects();
            this.waitForModelLoading();
            this.assertReferenceWorkspaceClosed();
        } else {
            ModelLoadManager.INSTANCE.loadWorkspace(false, null);
            this.waitForModelLoading();
            this.assertReferenceWorkspaceInitialized();
        }
        this.internalRefWks.addReferenceWorkspaceChangeListener(this.referenceWorkspaceChangeListener);
        org.eclipse.sphinx.emf.workspace.Activator.getPlugin().startWorkspaceSynchronizing();
    }

    protected void tearDown() throws Exception {
        this.waitForModelLoading();
        this.internalRefWks.removeResourceSetProblemListener(this.resourceProblemListener);
        this.internalRefWks.removeReferenceWorkspaceChangeListener(this.referenceWorkspaceChangeListener);
        this.unloadDirtyResources();
        this.synchronizedDeleteProjects(this.referenceWorkspaceChangeListener.getRenamedProjects());
        this.synchronizedOpenProjects(this.detectProjectsToOpen());
        this.deleteAddedFiles();
        this.deleteChangedFiles();
        this.unloadReourcesOutsideFileDescriptor();
        this.resetProjectDescriptions();
        this.resetProjectSettings();
        this.waitForModelLoading();
        this.resourceProblemListener.clearHistory();
        this.referenceWorkspaceChangeListener.clearHistory();
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.modelLoadJobTracer);
    }

    private Collection<IProject> detectProjectsToOpen() {
        IProject project;
        HashSet<IProject> projectsToOpen = new HashSet<IProject>();
        if (this.referenceWorkspaceChangeListener.getAddedFiles().size() <= 0 && this.referenceWorkspaceChangeListener.getChangedFiles().size() <= 0 && this.referenceWorkspaceChangeListener.getProjectsWithChangedDescription().size() <= 0 && this.referenceWorkspaceChangeListener.getProjectsWithChangedSettings().size() <= 0) {
            return Collections.emptySet();
        }
        for (IFile changedFile : this.referenceWorkspaceChangeListener.getChangedFiles()) {
            AbstractIntegrationTestCase.assertNotNull((Object)changedFile);
            project = changedFile.getProject();
            AbstractIntegrationTestCase.assertNotNull((Object)project);
            if (!project.exists() || project.isOpen()) continue;
            projectsToOpen.add(project);
        }
        for (IFile addedFile : this.referenceWorkspaceChangeListener.getAddedFiles()) {
            AbstractIntegrationTestCase.assertNotNull((Object)addedFile);
            project = addedFile.getProject();
            if (!project.exists() || project.isOpen()) continue;
            projectsToOpen.add(project);
        }
        for (IProject project2 : this.referenceWorkspaceChangeListener.getProjectsWithChangedDescription()) {
            if (project2 == null || project2.exists() || project2.isOpen()) continue;
            projectsToOpen.add(project2);
        }
        for (IProject project2 : this.referenceWorkspaceChangeListener.getProjectsWithChangedSettings().keySet()) {
            if (project2 == null || project2.exists() || project2.isOpen()) continue;
            projectsToOpen.add(project2);
        }
        return projectsToOpen;
    }

    private void unloadReourcesOutsideFileDescriptor() {
        ArrayList<Resource> resourcesToUnload = new ArrayList<Resource>();
        for (IMetaModelDescriptor metaModelDescriptor : this.internalRefWks.getReferenceEditingDomainDescritpors().keySet()) {
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
            if (editingDomain != null) {
                Set<String> referenceFileNames = this.internalRefWks.getReferenceFileNames(metaModelDescriptor);
                for (Resource resource : editingDomain.getResourceSet().getResources()) {
                    if (referenceFileNames.contains(resource.getURI().lastSegment())) continue;
                    resourcesToUnload.add(resource);
                }
            }
            EcorePlatformUtil.unloadResources((TransactionalEditingDomain)editingDomain, resourcesToUnload, (boolean)true, null);
            this.waitForModelLoading();
        }
    }

    private void deleteChangedFiles() throws Exception {
        for (IFile changedFile : this.referenceWorkspaceChangeListener.getChangedFiles()) {
            if (changedFile == null || !changedFile.isAccessible()) continue;
            this.synchronizedDeleteFile(changedFile);
        }
    }

    private void deleteAddedFiles() throws Exception {
        for (IFile addedFile : this.referenceWorkspaceChangeListener.getAddedFiles()) {
            if (this.refWks.getAllReferenceFiles().contains(addedFile) || addedFile == null || !addedFile.isAccessible()) continue;
            this.synchronizedDeleteFile(addedFile);
        }
    }

    private void unloadDirtyResources() {
        for (IMetaModelDescriptor metaModelDescriptor : this.internalRefWks.getReferenceEditingDomainDescritpors().keySet()) {
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
            if (editingDomain == null) continue;
            Collection dirtyResources = SaveIndicatorUtil.getDirtyResources((EditingDomain)editingDomain);
            EcorePlatformUtil.unloadResources((TransactionalEditingDomain)editingDomain, (Collection)dirtyResources, (boolean)true, null);
            this.waitForModelLoading();
        }
    }

    private void resetProjectDescriptions() throws Exception {
        for (IProject project : this.referenceWorkspaceChangeListener.getProjectsWithChangedDescription()) {
            if (!project.exists()) continue;
            AbstractIntegrationTestCase.assertTrue((boolean)project.isOpen());
            File projectSourceDir = new File(this.referenceWorkspaceSourceDir, project.getName());
            this.importExternalResourceToWorkspace(new File(projectSourceDir, ".project"), (IContainer)project);
        }
    }

    private void resetProjectSettings() throws Exception {
        for (IProject project : this.referenceWorkspaceChangeListener.getProjectsWithChangedSettings().keySet()) {
            if (!project.exists()) continue;
            AbstractIntegrationTestCase.assertTrue((boolean)project.isOpen());
            File projectSourceDir = new File(this.referenceWorkspaceSourceDir, project.getName());
            this.importExternalResourceToWorkspace(new File(projectSourceDir, ".settings"), (IContainer)project);
        }
    }

    private boolean needToExtractReferenceWorkspaceArchive() throws Exception {
        File propertiesFile;
        java.net.URI referenceWorkspaceInputFileURI = this.getReferenceWorkspaceFileAccessor().getInputFileURI(this.internalRefWks.getReferenceWorkspaceArchiveFileName(), true);
        File referenceWorkspaceArchive = null;
        if (referenceWorkspaceInputFileURI != null) {
            referenceWorkspaceArchive = new File(referenceWorkspaceInputFileURI);
        }
        return !(propertiesFile = new File(this.referenceWorkspaceTempDir, REFERENCE_WORKSPACE_PROPERTIES_FILE_NAME)).exists() || referenceWorkspaceArchive != null && referenceWorkspaceArchive.lastModified() > this.referenceWorkspaceTempDir.lastModified();
    }

    private TestFileAccessor getReferenceWorkspaceFileAccessor() {
        return new TestFileAccessor(this.internalRefWks.getReferenceWorkspacePlugin());
    }

    private void saveReferenceWorkspaceSourceDir() throws IOException {
        Properties properties = new Properties();
        properties.put(REFERENCE_WORKSPACE_SOURCE_ROOT_DIRECTORY_PROPERTIES_KEY, this.referenceWorkspaceSourceDir.getAbsolutePath());
        File propertiesFile = new File(this.referenceWorkspaceTempDir, REFERENCE_WORKSPACE_PROPERTIES_FILE_NAME);
        if (!propertiesFile.exists()) {
            propertiesFile.createNewFile();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(propertiesFile);
            properties.store(out, "Reference workspace source directory");
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    private void loadReferenceWorkspaceSourceDir() throws IOException {
        Properties properties = new Properties();
        File propertiesFile = new File(this.referenceWorkspaceTempDir, REFERENCE_WORKSPACE_PROPERTIES_FILE_NAME);
        FileInputStream in = new FileInputStream(propertiesFile);
        properties.load(in);
        String path = properties.getProperty(REFERENCE_WORKSPACE_SOURCE_ROOT_DIRECTORY_PROPERTIES_KEY);
        if (path == null) {
            throw new RuntimeException("No value for key 'referenceWorksaceSourceDirectory' found in properties file '" + propertiesFile.getAbsolutePath() + "'");
        }
        this.referenceWorkspaceSourceDir = new File(path);
    }

    private void initReferenceWorkspace() {
        String[] referenceProjectNames = this.getProjectsToLoad();
        this.refWks = this.createReferenceWorkspace(referenceProjectNames);
        this.internalRefWks = (IInternalReferenceWorkspace)this.refWks;
        this.waitForModelLoading();
    }

    private void importMissingReferenceProjectsIntoWorkspace() throws Exception {
        this.waitForModelLoading();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while importing missing reference projects into workspace.", (Throwable)new RuntimeException());
                Set missingProjects = AbstractIntegrationTestCase.this.getMissingReferenceProjects();
                for (IProject project : missingProjects) {
                    try {
                        AbstractIntegrationTestCase.this.importExternalResourceToWorkspace(new File(AbstractIntegrationTestCase.this.referenceWorkspaceSourceDir, project.getName()), project.getParent());
                    }
                    catch (Exception ex) {
                        errorStatus.add(StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex));
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    private Set<IProject> getMissingReferenceProjects() {
        HashSet<IProject> missingReferenceProjects = new HashSet<IProject>();
        for (ReferenceProjectDescriptor descriptor : this.internalRefWks.getReferenceProjectDescriptors()) {
            if (descriptor.getProject().exists()) continue;
            missingReferenceProjects.add(descriptor.getProject());
        }
        return missingReferenceProjects;
    }

    protected Set<IProject> getAllReferenceProjects() {
        HashSet<IProject> referenceProjects = new HashSet<IProject>();
        for (ReferenceProjectDescriptor descriptor : this.internalRefWks.getReferenceProjectDescriptors()) {
            referenceProjects.add(descriptor.getProject());
        }
        return referenceProjects;
    }

    private Set<IProject> getUnusedReferenceProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IProject> unusedReferenceProjects = new HashSet<IProject>();
        if (this.getProjectsToLoad() == null) {
            return Collections.emptySet();
        }
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            boolean used = false;
            String[] stringArray = this.getProjectsToLoad();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String prjName = stringArray[n4];
                if (prjName.equals(project.getName())) {
                    used = true;
                }
                ++n4;
            }
            if (!used) {
                unusedReferenceProjects.add(project);
            }
            ++n2;
        }
        return unusedReferenceProjects;
    }

    private void importMissingReferenceFilesToWorkspace() throws Exception {
        this.waitForModelLoading();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while importing missing reference projects into workspace.", (Throwable)new RuntimeException());
                for (IFile missingFile : AbstractIntegrationTestCase.this.getMissingReferenceFiles()) {
                    File sourceFile = AbstractIntegrationTestCase.this.referenceWorkspaceSourceDir;
                    String[] stringArray = missingFile.getFullPath().segments();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String segment = stringArray[n2];
                        sourceFile = new File(sourceFile, segment);
                        ++n2;
                    }
                    try {
                        AbstractIntegrationTestCase.this.importExternalResourceToWorkspace(sourceFile, missingFile.getParent());
                    }
                    catch (Exception ex) {
                        errorStatus.add(StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex));
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    private Set<IFile> getMissingReferenceFiles() {
        HashSet<IFile> missingReferenceFiles = new HashSet<IFile>();
        for (IFile file : this.refWks.getAllReferenceFiles()) {
            if (file.exists()) continue;
            missingReferenceFiles.add(file);
        }
        return missingReferenceFiles;
    }

    private void extractReferenceWorkspaceArchive() throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ReferenceWorkspaceExtractor extractor = new ReferenceWorkspaceExtractor();
                extractor.extract(AbstractIntegrationTestCase.this.getReferenceWorkspaceFileAccessor(), AbstractIntegrationTestCase.this.internalRefWks.getReferenceWorkspaceArchiveFileName(), AbstractIntegrationTestCase.this.referenceWorkspaceTempDir);
                AbstractIntegrationTestCase.this.referenceWorkspaceSourceDir = extractor.getExtractedWorkspaceRootDirectory();
                try {
                    AbstractIntegrationTestCase.this.saveReferenceWorkspaceSourceDir();
                }
                catch (Exception ex) {
                    IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    throw new CoreException(status);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, null);
    }

    protected String[] getProjectsToLoad() {
        return null;
    }

    private T createReferenceWorkspace(String[] referenceProjectNames) {
        T referenceWorkspace = this.doCreateReferenceWorkspace(referenceProjectNames);
        Assert.isTrue((boolean)(referenceWorkspace instanceof IInternalReferenceWorkspace));
        return referenceWorkspace;
    }

    protected abstract T doCreateReferenceWorkspace(String[] var1);

    private void createInterProjectReferences() throws CoreException {
        String[][] stringArray = this.getProjectReferences();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] projectPair = stringArray[n2];
            if (projectPair != null && projectPair.length >= 2) {
                IProject parent = this.refWks.getReferenceProject(projectPair[0]);
                IProject child = this.refWks.getReferenceProject(projectPair[1]);
                if (parent != null && parent.isAccessible() && child != null && child.isAccessible()) {
                    IProjectDescription parentDescription = parent.getDescription();
                    parentDescription.setReferencedProjects(new IProject[]{child});
                    parent.setDescription(parentDescription, null);
                }
            }
            ++n2;
        }
    }

    protected String[][] getProjectReferences() {
        return new String[0][0];
    }

    private void assertReferenceWorkspaceInitialized() throws Exception {
        this.assertExpectedReferenceProjectsExist();
        this.assertExpectedReferenceFilesExist();
        this.assertExpectedReferenceModelResourcesLoaded();
        this.assertExpectedReferenceModelDescriptorsExist();
    }

    private void assertExpectedReferenceProjectsExist() {
        Set<IProject> missingReferenceProjects = this.getMissingReferenceProjects();
        if (missingReferenceProjects.size() > 0) {
            System.err.println("Missing reference project(s):");
            for (IProject project : missingReferenceProjects) {
                System.err.println("  " + project.getFullPath());
            }
        }
        AbstractIntegrationTestCase.assertEquals((String)"Missing reference project(s).", (int)0, (int)missingReferenceProjects.size());
    }

    private void assertExpectedReferenceFilesExist() {
        Set<IFile> missingReferenceFiles = this.getMissingReferenceFiles();
        if (missingReferenceFiles.size() > 0) {
            System.err.println("Missing reference file(s):");
            for (IFile file : missingReferenceFiles) {
                System.err.println("  " + file.getFullPath());
            }
        }
        AbstractIntegrationTestCase.assertEquals((String)"Missing reference file(s).", (int)0, (int)missingReferenceFiles.size());
    }

    private void assertExpectedReferenceModelResourcesLoaded() {
        HashMap<TransactionalEditingDomain, HashSet<URI>> missingReferenceModelResources = new HashMap<TransactionalEditingDomain, HashSet<URI>>();
        for (IMetaModelDescriptor metaModelDescriptor : this.internalRefWks.getReferenceEditingDomainDescritpors().keySet()) {
            ReferenceEditingDomainDescriptor editingDomainDescriptor = this.internalRefWks.getReferenceEditingDomainDescritpors().get(metaModelDescriptor);
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
            AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
            HashSet<URI> actualResourceURIs = new HashSet<URI>();
            for (Resource resource : editingDomain.getResourceSet().getResources()) {
                actualResourceURIs.add(resource.getURI());
            }
            HashSet<URI> missingResourceURIs = new HashSet<URI>(editingDomainDescriptor.getResourceURIs());
            missingResourceURIs.removeAll(actualResourceURIs);
            if (missingResourceURIs.size() <= 0) continue;
            missingReferenceModelResources.put(editingDomain, missingResourceURIs);
        }
        if (missingReferenceModelResources.size() > 0) {
            for (TransactionalEditingDomain editingDomain : missingReferenceModelResources.keySet()) {
                System.err.println("Missing model resource(s) in editing domain '" + editingDomain.getID() + "':");
                Set missingResourceURIs = (Set)missingReferenceModelResources.get(editingDomain);
                for (URI uri : missingResourceURIs) {
                    System.err.println("  " + uri.toString());
                }
                for (Resource errorResource : this.resourceProblemListener.getErrorResources()) {
                    if (!missingResourceURIs.contains(errorResource.getURI())) continue;
                    if (errorResource.getErrors().get(0) instanceof Exception) {
                        throw new WrappedException((Exception)errorResource.getErrors().get(0));
                    }
                    throw new RuntimeException(((Resource.Diagnostic)errorResource.getErrors().get(0)).getMessage());
                }
                AbstractIntegrationTestCase.assertEquals((String)("Missing model resource(s) in editing domain '" + editingDomain.getID() + "'. " + missingResourceURIs.toString()), (int)0, (int)missingResourceURIs.size());
            }
        }
    }

    private void assertExpectedReferenceModelDescriptorsExist() {
        Set missingModelDescriptorsInProject;
        HashMap missingModelDescriptors = new HashMap();
        for (ReferenceProjectDescriptor referenceProjectDescriptor : this.internalRefWks.getReferenceProjectDescriptors()) {
            missingModelDescriptorsInProject = new HashSet<ReferenceModelDescriptor>();
            missingModelDescriptorsInProject.addAll(referenceProjectDescriptor.getReferenceModelDescriptors());
            block1: for (ReferenceModelDescriptor referenceModelDescriptor : referenceProjectDescriptor.getReferenceModelDescriptors()) {
                for (IModelDescriptor modelDescriptor : ModelDescriptorRegistry.INSTANCE.getModels((IContainer)referenceProjectDescriptor.getProject())) {
                    if (!referenceModelDescriptor.getMetaModelDescriptor().equals(modelDescriptor.getMetaModelDescriptor()) || !referenceModelDescriptor.getEditingDomainName().equals(modelDescriptor.getEditingDomain().getID()) || !referenceModelDescriptor.getRootProject().equals((Object)modelDescriptor.getScope().getRoot())) continue;
                    missingModelDescriptorsInProject.remove(referenceModelDescriptor);
                    continue block1;
                }
            }
            if (missingModelDescriptorsInProject.size() <= 0) continue;
            missingModelDescriptors.put(referenceProjectDescriptor.getProject(), missingModelDescriptorsInProject);
        }
        if (missingModelDescriptors.size() > 0) {
            for (IProject project : missingModelDescriptors.keySet()) {
                System.err.println("Missing model(s) in project '" + project.getName() + "':");
                missingModelDescriptorsInProject = (Set)missingModelDescriptors.get(project);
                for (ReferenceModelDescriptor referenceModelDescriptor : missingModelDescriptorsInProject) {
                    System.err.println("  " + referenceModelDescriptor);
                }
                AbstractIntegrationTestCase.assertEquals((String)("Missing model(s) in project '" + project.getName() + "'."), (int)0, (int)missingModelDescriptorsInProject.size());
            }
        }
    }

    private void assertReferenceWorkspaceClosed() {
        this.assertAllModelDescriptorsRemoved();
        this.assertAllProjectsClosed();
        this.assertAllModelResourcesUnloaded();
    }

    private void assertAllModelDescriptorsRemoved() {
        this.assertWorkspaceModelsSizeEquals(0);
    }

    private void assertAllModelResourcesUnloaded() {
        for (TransactionalEditingDomain editingDomain : WorkspaceEditingDomainUtil.getAllEditingDomains()) {
            this.assertEditingDomainResourcesSizeEquals(editingDomain, 0);
        }
    }

    private void assertAllProjectsClosed() {
        HashSet<IProject> openProjects = new HashSet<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                openProjects.add(project);
            }
            ++n2;
        }
        if (openProjects.size() > 0) {
            System.err.println("Unexpected number of open project(s):");
            for (IProject project : openProjects) {
                System.err.println("  " + project.getFullPath());
            }
        }
        AbstractIntegrationTestCase.assertTrue((String)"Unexpected number of open project(s).", (openProjects.size() == 0 ? 1 : 0) != 0);
    }

    protected void assertStatusIsOK(IStatus status) {
        if (status != null && !status.isOK()) {
            String severity;
            Throwable throwable;
            if (status instanceof MultiStatus) {
                MultiStatus multi = (MultiStatus)status;
                IStatus[] iStatusArray = multi.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    this.assertStatusIsOK(child);
                    ++n2;
                }
            }
            if ((throwable = status.getException()) != null) {
                this.fail(throwable);
            }
            String message = status.getMessage();
            switch (status.getSeverity()) {
                case 4: {
                    severity = "ERROR";
                    break;
                }
                case 2: {
                    severity = "WARNING";
                    break;
                }
                case 1: {
                    severity = "INFO";
                    break;
                }
                case 8: {
                    severity = "CANCEL";
                    break;
                }
                default: {
                    severity = "NON-OK";
                }
            }
            StringBuilder failureMessage = new StringBuilder();
            if (message == null && message.length() == 0) {
                failureMessage.append("Unspecified ");
            }
            failureMessage.append(severity);
            failureMessage.append(" status encountered");
            if (message != null && message.length() > 0) {
                failureMessage.append(": ");
                failureMessage.append(message);
            }
            AbstractIntegrationTestCase.fail((String)failureMessage.toString());
        }
    }

    protected void assertEditingDomainResourcesSizeEquals(TransactionalEditingDomain editingDomain, int expected) {
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        EList resources = editingDomain.getResourceSet().getResources();
        if (expected == 0 && resources.size() > 0) {
            System.err.println("Unexpected number of resources in editingDomain " + editingDomain.getID() + ":");
            for (Resource resource : resources) {
                System.err.println("  " + resource.getURI());
            }
        }
        AbstractIntegrationTestCase.assertEquals((String)("Unexpected number of resources in editingDomain " + editingDomain.getID()), (int)expected, (int)resources.size());
    }

    protected void assertEditingDomainDoesNotContainResource(TransactionalEditingDomain editingDomain, Resource resource) {
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        AbstractIntegrationTestCase.assertFalse((boolean)editingDomain.getResourceSet().getResources().contains((Object)resource));
    }

    protected void assertEditingDomainContainsResource(TransactionalEditingDomain editingDomain, Resource resource) {
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        AbstractIntegrationTestCase.assertTrue((boolean)editingDomain.getResourceSet().getResources().contains((Object)resource));
    }

    protected void assertEditingDomainContainsResources(TransactionalEditingDomain editingDomain, Collection<Resource> resources) {
        AbstractIntegrationTestCase.assertNotNull(resources);
        for (Resource resource : resources) {
            this.assertEditingDomainContainsResource(editingDomain, resource);
        }
    }

    protected void assertEditingDomainDoesNotContainResources(TransactionalEditingDomain editingDomain, Collection<Resource> resources) {
        if (resources != null && resources.size() > 0) {
            for (Resource resource : resources) {
                this.assertEditingDomainDoesNotContainResource(editingDomain, resource);
            }
        }
    }

    protected void assertEditingDomainContainsResource(TransactionalEditingDomain editingDomain, String resourceName) {
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        AbstractIntegrationTestCase.assertNotNull((Object)resourceName);
        for (Resource res : editingDomain.getResourceSet().getResources()) {
            if (!resourceName.equals(res.getURI().lastSegment())) continue;
            AbstractIntegrationTestCase.assertTrue((boolean)true);
            return;
        }
        AbstractIntegrationTestCase.assertTrue((String)("Editing domain " + editingDomain.getID() + " does not contain resource named '" + resourceName + "'."), (boolean)false);
    }

    protected void assertEditingDomainDoesNotContainResource(TransactionalEditingDomain editingDomain, String resourceName) {
        if (resourceName == null || editingDomain == null) {
            AbstractIntegrationTestCase.assertTrue((boolean)true);
            return;
        }
        for (Resource res : editingDomain.getResourceSet().getResources()) {
            if (!resourceName.equals(res.getURI().lastSegment())) continue;
            AbstractIntegrationTestCase.assertTrue((boolean)false);
        }
        AbstractIntegrationTestCase.assertTrue((boolean)true);
    }

    protected void assertEditingDomainContainsNamedResources(TransactionalEditingDomain editingDomain, Collection<String> resourceNames) {
        AbstractIntegrationTestCase.assertNotNull(resourceNames);
        if (resourceNames.size() == 0) {
            AbstractIntegrationTestCase.assertTrue((boolean)false);
            return;
        }
        for (String resourceName : resourceNames) {
            this.assertEditingDomainContainsResource(editingDomain, resourceName);
        }
    }

    protected void assertEditingDomainDoesNotContainNamedResources(TransactionalEditingDomain editingDomain, Collection<String> resourceNames) {
        if (resourceNames == null) {
            AbstractIntegrationTestCase.assertTrue((boolean)true);
            return;
        }
        if (resourceNames.size() == 0) {
            AbstractIntegrationTestCase.assertTrue((boolean)true);
            return;
        }
        for (String resourceName : resourceNames) {
            this.assertEditingDomainDoesNotContainResource(editingDomain, resourceName);
        }
    }

    protected void assertReferenceProjectAllResourcesLoaded(String projectName) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.internalRefWks.getReferenceProjectDescriptor(projectName);
        AbstractIntegrationTestCase.assertNotNull((String)("Project " + projectName + " does not exist in test reference workspace"), (Object)referenceProjectDescriptor);
        Map<IMetaModelDescriptor, Set<IFile>> files = referenceProjectDescriptor.getFiles();
        if (files != null) {
            for (IMetaModelDescriptor metaModelDescriptor : files.keySet()) {
                if (metaModelDescriptor == MetaModelDescriptorRegistry.NO_MM) continue;
                this.assertReferenceProjectResourcesLoaded(metaModelDescriptor, projectName);
            }
        }
    }

    protected void assertReferenceProjectAllResourcesNotLoaded(String projectName) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.internalRefWks.getReferenceProjectDescriptor(projectName);
        AbstractIntegrationTestCase.assertNotNull((String)("Project " + projectName + " does not exist in test reference workspace"), (Object)referenceProjectDescriptor);
        Map<IMetaModelDescriptor, Set<IFile>> files = referenceProjectDescriptor.getFiles();
        if (files != null) {
            for (IMetaModelDescriptor metaModelDescriptor : files.keySet()) {
                if (metaModelDescriptor == MetaModelDescriptorRegistry.NO_MM) continue;
                this.assertReferenceProjectResourcesNotLoaded(metaModelDescriptor, projectName);
            }
        }
    }

    protected void assertReferenceProjectResourcesLoaded(IMetaModelDescriptor metaModelDescriptor, String projectName) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.internalRefWks.getReferenceProjectDescriptor(projectName);
        AbstractIntegrationTestCase.assertNotNull((String)("Project " + projectName + " does not exist in test reference workspace"), (Object)referenceProjectDescriptor);
        AbstractIntegrationTestCase.assertTrue((boolean)referenceProjectDescriptor.getProject().exists());
        List<String> filesNames = referenceProjectDescriptor.getFileNames(metaModelDescriptor);
        if (this.internalRefWks.getReferenceEditingDomainDescriptor(metaModelDescriptor) == null) {
            AbstractIntegrationTestCase.assertTrue((String)"No such resources in editing domain descriptor", (boolean)false);
        }
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        this.assertEditingDomainContainsNamedResources(editingDomain, filesNames);
    }

    protected void assertReferenceProjectResourcesNotLoaded(IMetaModelDescriptor metaModelDescriptor, String projectName) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.internalRefWks.getReferenceProjectDescriptor(projectName);
        AbstractIntegrationTestCase.assertNotNull((Object)referenceProjectDescriptor);
        List<String> filesNames = referenceProjectDescriptor.getFileNames(metaModelDescriptor);
        if (this.internalRefWks.getReferenceEditingDomainDescriptor(metaModelDescriptor) == null) {
            AbstractIntegrationTestCase.assertTrue((boolean)true);
            return;
        }
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        this.assertEditingDomainDoesNotContainNamedResources(editingDomain, filesNames);
    }

    protected void assertWorkspaceModelsSizeEquals(int expected) {
        Collection modelDescriptors = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        if (expected == 0 && modelDescriptors.size() > 0) {
            System.err.println("Unexpected number of model descriptor(s) in workspace:");
            for (IModelDescriptor modelDescriptor : modelDescriptors) {
                System.err.println("  " + modelDescriptor);
            }
        }
        AbstractIntegrationTestCase.assertEquals((String)"Unexpected number of model descriptors in workspace.", (int)expected, (int)modelDescriptors.size());
    }

    protected void assertProjectModelsSizeEquals(IProject project, int expected) {
        Collection modelDescriptors = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project);
        if (expected == 0 && modelDescriptors.size() > 0) {
            System.err.println("Unexpected number of model descriptor(s) in project '" + project.getName() + "':");
            for (IModelDescriptor modelDescriptor : modelDescriptors) {
                System.err.println("  " + modelDescriptor);
            }
        }
        AbstractIntegrationTestCase.assertEquals((String)("Unexpected number of model descriptor(s) in project '" + project.getName() + "'."), (int)expected, (int)modelDescriptors.size());
    }

    protected void assertProjectHasModels(IProject project, IMetaModelDescriptor metaModelDescriptor) {
        Collection models = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project, metaModelDescriptor);
        AbstractIntegrationTestCase.assertTrue((String)("Missing '" + metaModelDescriptor + "' model descriptor in project '" + project.getName() + "'."), (!models.isEmpty() ? 1 : 0) != 0);
    }

    protected void assertProjectHasNoModels(IProject project, IMetaModelDescriptor metaModelDescriptor) {
        Collection models = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project, metaModelDescriptor);
        AbstractIntegrationTestCase.assertTrue((String)("Unexpected '" + metaModelDescriptor + "' model descriptor in project '" + project.getName() + "'."), (boolean)models.isEmpty());
    }

    protected void synchronizedLoadFile(IFile file) {
        this.waitForModelLoading();
        ModelLoadManager.INSTANCE.loadFile(file, false, null);
        this.waitForModelLoading();
    }

    protected void synchronizedUnloadFile(IFile file) {
        this.waitForModelLoading();
        ModelLoadManager.INSTANCE.unloadFile(file, false, null);
        this.waitForModelLoading();
    }

    protected void synchronizedDeleteFile(final IFile file) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)file);
        this.waitForModelLoading();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file.delete(true, true, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void synchronizedMoveFile(final IFile file, final IPath target) throws CoreException {
        AbstractIntegrationTestCase.assertNotNull((Object)file);
        AbstractIntegrationTestCase.assertNotNull((Object)target);
        this.waitForModelLoading();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file.move(target, true, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void synchronizedRenameFile(final IFile file, String newname) throws CoreException {
        AbstractIntegrationTestCase.assertNotNull((Object)file);
        AbstractIntegrationTestCase.assertNotNull((Object)newname);
        AbstractIntegrationTestCase.assertFalse((newname.length() == 0 ? 1 : 0) != 0);
        this.waitForModelLoading();
        final IPath newPath = file.getFullPath().removeLastSegments(1).append(newname);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file.move(newPath, true, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void deleteExternalResource(String path) throws IOException {
        URI uri = URI.createURI((String)path, (boolean)true);
        URI fileURI = EcoreResourceUtil.convertToAbsoluteFileURI((URI)uri);
        File file = new File(fileURI.toFileString());
        this.deleteExternalResource(file);
    }

    protected void deleteExternalResource(File file) throws IOException {
        Assert.isNotNull((Object)file);
        if (file.isDirectory()) {
            String[] children;
            String[] stringArray = children = file.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                this.deleteExternalResource(new File(file, child));
                ++n2;
            }
            if (!file.delete()) {
                throw new IOException("Unable to delete external directory: '" + file.getPath() + "'");
            }
        } else if (file.exists() && !file.delete()) {
            throw new IOException("Unable to delete external file: '" + file.getPath() + "'");
        }
    }

    protected void synchronizedLoadProject(IProject project, boolean includeReferencedProjects) {
        this.waitForModelLoading();
        ModelLoadManager.INSTANCE.loadProject(project, includeReferencedProjects, false, null);
        this.waitForModelLoading();
    }

    protected void synchronizedLoadAllProjects() {
        this.waitForModelLoading();
        ModelLoadManager.INSTANCE.loadProjects(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()), false, false, null);
        this.waitForModelLoading();
    }

    protected void synchronizedUnloadProject(IProject project, boolean includeReferencedProjects) {
        this.waitForModelLoading();
        ModelLoadManager.INSTANCE.unloadProject(project, includeReferencedProjects, false, null);
        this.waitForModelLoading();
    }

    protected void synchronizedUnloadProjects(Collection<IProject> projectsToUnload, boolean includeReferenceProjects) {
        this.waitForModelLoading();
        ModelLoadManager.INSTANCE.unloadProjects(projectsToUnload, includeReferenceProjects, false, null);
        this.waitForModelLoading();
    }

    protected void synchronizedUnloadAllProjects() {
        this.waitForModelLoading();
        ModelLoadManager.INSTANCE.unloadProjects(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()), false, false, null);
        this.waitForModelLoading();
    }

    protected void synchronizedOpenProject(final IProject project) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)project);
        this.waitForModelLoading();
        AbstractIntegrationTestCase.assertTrue((Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING).length == 0 ? 1 : 0) != 0);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.open(monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void synchronizedOpenProjects(final Collection<IProject> projects) throws Exception {
        AbstractIntegrationTestCase.assertNotNull(projects);
        this.waitForModelLoading();
        AbstractIntegrationTestCase.assertTrue((Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING).length == 0 ? 1 : 0) != 0);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                for (IProject project : projects) {
                    project.open(monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void synchronizedOpenAllProjects() throws Exception {
        this.waitForModelLoading();
        AbstractIntegrationTestCase.assertTrue((Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING).length == 0 ? 1 : 0) != 0);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while opening projects.", (Throwable)new RuntimeException());
                ArrayList<IProject> safeProjects = new ArrayList<IProject>(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)safeProjects.size());
                for (IProject project : safeProjects) {
                    try {
                        project.open((IProgressMonitor)progress.newChild(1));
                    }
                    catch (CoreException ex) {
                        errorStatus.add(ex.getStatus());
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void synchronizedRenameProject(final IProject project, final String newName) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)project);
        this.waitForModelLoading();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.move(project.getFullPath().removeLastSegments(1).append(newName), true, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void synchronizedCloseProject(final IProject project) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)project);
        this.waitForModelLoading();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.close(monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void synchronizedCloseAllProjects() throws Exception {
        this.waitForModelLoading();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while closing projects.", (Throwable)new RuntimeException());
                ArrayList<IProject> safeProjects = new ArrayList<IProject>(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)safeProjects.size());
                for (IProject project : safeProjects) {
                    try {
                        project.close((IProgressMonitor)progress.newChild(1));
                    }
                    catch (CoreException ex) {
                        errorStatus.add(ex.getStatus());
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void synchronizedDeleteProject(final IProject project) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)project);
        this.waitForModelLoading();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AbstractIntegrationTestCase.this.safeDeleteProject(project, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void synchronizedDeleteProjects(final Collection<IProject> projects) throws Exception {
        AbstractIntegrationTestCase.assertNotNull(projects);
        this.waitForModelLoading();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while closing projects.", (Throwable)new RuntimeException());
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.size());
                for (IProject project : projects) {
                    try {
                        AbstractIntegrationTestCase.this.safeDeleteProject(project, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (CoreException ex) {
                        errorStatus.add(ex.getStatus());
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    private void safeDeleteProject(IProject project, IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < 5) {
            try {
                project.delete(true, true, monitor);
                return;
            }
            catch (CoreException ex) {
                if (i == 4) {
                    throw ex;
                }
                try {
                    Thread.sleep(500L + Math.round(1500.0 * Math.random()));
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
    }

    protected void synchronizedDeleteWorkspace() throws CoreException {
        this.waitForModelLoading();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                workspace.getRoot().delete(true, true, null);
            }
        };
        workspace.run(runnable, (ISchedulingRule)workspace.getRoot(), 1, null);
        this.waitForModelLoading();
    }

    protected Resource getProjectResource(IProject project, String fileName) {
        AbstractIntegrationTestCase.assertNotNull((Object)project);
        AbstractIntegrationTestCase.assertNotNull((Object)fileName);
        IFile file = project.getFile(fileName);
        return EcorePlatformUtil.getResource((IFile)file);
    }

    protected Collection<IFile> getAllNonDotFiles() {
        HashSet<IFile> allFiles = new HashSet<IFile>();
        for (IProject project : ExtendedPlatform.getRootProjects()) {
            for (IFile file : ExtendedPlatform.getAllFiles((IProject)project, (boolean)true)) {
                if (file.getName().startsWith(".") || this.hasDotParent((IResource)file)) continue;
                allFiles.add(file);
            }
        }
        return allFiles;
    }

    private boolean hasDotParent(IResource resource) {
        AbstractIntegrationTestCase.assertNotNull((Object)resource);
        IContainer parent = resource.getParent();
        if (parent != null) {
            if (parent.getName().startsWith(".")) {
                return true;
            }
            return this.hasDotParent((IResource)parent);
        }
        return false;
    }

    protected void assertProxiesResolved(Resource inputResource) {
        AbstractIntegrationTestCase.assertNotNull((Object)inputResource);
        TreeIterator allContents = inputResource.getAllContents();
        while (allContents.hasNext()) {
            EObject object = (EObject)allContents.next();
            AbstractIntegrationTestCase.assertFalse((boolean)object.eIsProxy());
        }
    }

    protected void waitForModelLoading() {
        this.waitForFamily(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
    }

    protected void waitForAutoBuild() {
        this.waitForFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    private void waitForFamily(final Object family) {
        Thread t = new Thread(){

            public void run() {
                try {
                    Job.getJobManager().join(family, null);
                }
                catch (Exception exception) {}
            }
        };
        t.setDaemon(true);
        t.start();
        try {
            t.join(Integer.parseInt(JOB_FAMILY_TIMEOUT));
        }
        catch (InterruptedException interruptedException) {}
        if (t.isAlive()) {
            throw new RuntimeException("Timeout while waiting for job family '" + family + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus scheduleAndWait(Job job) throws InterruptedException {
        class DoneListener
        extends JobChangeAdapter {
            boolean done = false;
            IStatus result;

            DoneListener() {
            }

            public synchronized void done(IJobChangeEvent event) {
                this.done = true;
                this.result = event.getResult();
                ((Object)((Object)this)).notify();
            }
        }
        DoneListener doneListener = new DoneListener();
        job.addJobChangeListener((IJobChangeListener)doneListener);
        DoneListener doneListener2 = doneListener;
        synchronized (doneListener2) {
            Thread thread;
            job.schedule();
            ((Object)((Object)doneListener)).wait(Integer.parseInt(SCHEDULED_JOB_TIMEOUT));
            if (!doneListener.done && (thread = job.getThread()) != null) {
                job.getThread().interrupt();
            }
        }
        return doneListener.result;
    }

    protected void fail(Throwable throwable) {
        AssertionFailedError error = new AssertionFailedError();
        error.initCause(throwable);
        throw error;
    }

    protected void importExternalResourceToWorkspace(File externalResource, IContainer targetContainer) throws Exception {
        block8: {
            AbstractIntegrationTestCase.assertNotNull((Object)externalResource);
            AbstractIntegrationTestCase.assertNotNull((Object)targetContainer);
            if (!externalResource.exists()) break block8;
            if (externalResource.isDirectory()) {
                Object importedContainer = targetContainer instanceof IWorkspaceRoot ? ((IWorkspaceRoot)targetContainer).getProject(externalResource.getName()) : targetContainer.getFolder((IPath)new Path(externalResource.getName()));
                File[] fileArray = externalResource.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.importExternalResourceToWorkspace(file, (IContainer)importedContainer);
                    ++n2;
                }
            } else {
                this.createContainerTree(targetContainer);
                IFile importedFile = targetContainer.getFile((IPath)new Path(externalResource.getName()));
                FileInputStream externalFileContents = new FileInputStream(externalResource);
                if (importedFile.exists()) {
                    importedFile.setCharset(null, null);
                    importedFile.setContents((InputStream)externalFileContents, true, false, null);
                } else {
                    try {
                        importedFile.create((InputStream)externalFileContents, true, null);
                        importedFile.setCharset(null, null);
                    }
                    catch (Exception ex) {
                        if (ex.getMessage().contains("already exists")) {
                            externalFileContents = new FileInputStream(externalResource);
                            importedFile.setCharset(null, null);
                            importedFile.setContents((InputStream)externalFileContents, true, false, null);
                        }
                        throw ex;
                    }
                }
            }
        }
    }

    private void createContainerTree(IContainer container) throws Exception {
        Assert.isNotNull((Object)container);
        IProject project = container.getProject();
        if (!project.exists()) {
            project.create(null);
            project.open(null);
        } else if (!project.isAccessible()) {
            project.open(null);
        }
        if (container.getFullPath().segmentCount() > 1) {
            IProject parentContainer = project;
            int i = 1;
            while (i < container.getFullPath().segmentCount()) {
                IFolder folder;
                block8: {
                    folder = parentContainer.getFolder((IPath)new Path(container.getFullPath().segment(i)));
                    if (!folder.exists()) {
                        try {
                            folder.create(true, true, null);
                        }
                        catch (Exception ex) {
                            if (ex.getMessage().contains("already exists")) break block8;
                            throw ex;
                        }
                    }
                }
                parentContainer = folder;
                ++i;
            }
        }
    }

    protected void synchronizedImportExternalResourceToWorkspace(final File externalResource, final IContainer targetContainer) throws Exception {
        this.waitForModelLoading();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    AbstractIntegrationTestCase.this.importExternalResourceToWorkspace(externalResource, targetContainer);
                }
                catch (Exception ex) {
                    IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    throw new CoreException(status);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void synchronizedImportInputFileToWorkspace(String inputFileName, IContainer targetContainer) throws Exception {
        java.net.URI inputFileURI = this.getTestFileAccessor().getInputFileURI(inputFileName, true);
        this.synchronizedImportExternalResourceToWorkspace(new File(inputFileURI), targetContainer);
    }

    protected File getReferenceWorkspaceSourceDir() {
        return this.referenceWorkspaceSourceDir;
    }

    protected ReferenceWorkspaceChangeListener getReferenceWorkspaceChangeListener() {
        return this.referenceWorkspaceChangeListener;
    }

    protected ResourceProblemListener getResourceProblemListener() {
        return this.resourceProblemListener;
    }

    private class ModelLoadingJobTracer
    extends JobChangeAdapter {
        private ModelLoadingJobTracer() {
        }

        private boolean isModelLoadingJob(IJobChangeEvent event) {
            Job job;
            if (event != null && (job = event.getJob()) != null) {
                return job.belongsTo(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            }
            return false;
        }

        public void scheduled(IJobChangeEvent event) {
            this.isModelLoadingJob(event);
        }

        public void running(IJobChangeEvent event) {
            this.isModelLoadingJob(event);
        }

        public void done(IJobChangeEvent event) {
            this.isModelLoadingJob(event);
        }
    }
}

