/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.actions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.edit.TransientItemProvider;
import org.eclipse.sphinx.emf.ui.internal.Activator;
import org.eclipse.sphinx.emf.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.ui.util.EcoreUIUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class BasicOpenInEditorAction
extends BaseSelectionListenerAction {
    protected Map<String, Set<Object>> editorIdToEditorInputObjectsMap = new HashMap<String, Set<Object>>();

    public BasicOpenInEditorAction() {
        super(Messages.OpenInEditor_label);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.editorIdToEditorInputObjectsMap.clear();
        for (Object object : selection.toList()) {
            String editorId;
            if (this.isTransient(object)) {
                this.editorIdToEditorInputObjectsMap.clear();
                return false;
            }
            IEditorDescriptor defaultEditor = EcoreUIUtil.getDefaultEditor(object);
            if (defaultEditor == null || (editorId = defaultEditor.getId()) == null) continue;
            Set<Object> editorInputObjects = this.editorIdToEditorInputObjectsMap.get(editorId);
            if (editorInputObjects == null) {
                editorInputObjects = new HashSet<Object>();
                this.editorIdToEditorInputObjectsMap.put(editorId, editorInputObjects);
            }
            editorInputObjects.add(object);
        }
        return this.editorIdToEditorInputObjectsMap.keySet().size() > 0;
    }

    protected boolean isTransient(Object object) {
        return object instanceof TransientItemProvider;
    }

    public void run() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            for (String editorId : this.editorIdToEditorInputObjectsMap.keySet()) {
                for (Object object : this.editorIdToEditorInputObjectsMap.get(editorId)) {
                    try {
                        URIEditorInput editorInput = EcoreUIUtil.createURIEditorInput(object);
                        if (editorInput == null) continue;
                        page.openEditor((IEditorInput)editorInput, editorId);
                    }
                    catch (Exception ex) {
                        PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }
            }
        }
    }
}

