/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.hummingbird20.workflows.naming;

import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.sphinx.emf.mwe.dynamic.components.AbstractModelWorkflowComponent;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.Component;
import org.eclipse.sphinx.examples.hummingbird20.typemodel.ComponentType;
import org.eclipse.sphinx.examples.hummingbird20.typemodel.Interface;
import org.eclipse.sphinx.examples.workflows.lib.ModelWorkflowExtensions;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class ApplyHummingbird20NamingConventionWorkflowComponent extends AbstractModelWorkflowComponent {
  public ApplyHummingbird20NamingConventionWorkflowComponent() {
    super(true);
  }
  
  protected void invokeInternal(final WorkflowContext ctx, final ProgressMonitor monitor, final Issues issues) {
    InputOutput.<String>println("Executing Apply Hummingbird 2.0 Naming Convention workflow component");
    final List<EObject> modelObjects = ModelWorkflowExtensions.getModelSlot(ctx);
    for (final EObject modelObject : modelObjects) {
      {
        final TreeIterator<EObject> eAllContents = modelObject.eAllContents();
        while (eAllContents.hasNext()) {
          {
            final EObject element = eAllContents.next();
            if ((element instanceof Interface)) {
              boolean _or = false;
              String _name = ((Interface)element).getName();
              boolean _startsWith = _name.startsWith("I");
              boolean _not = (!_startsWith);
              if (_not) {
                _or = true;
              } else {
                String _name_1 = ((Interface)element).getName();
                String _substring = _name_1.substring(1, 2);
                boolean _matches = _substring.matches("[a-z]");
                _or = _matches;
              }
              if (_or) {
                String _name_2 = ((Interface)element).getName();
                String _plus = ("I" + _name_2);
                ((Interface)element).setName(_plus);
              }
            }
            if ((element instanceof ComponentType)) {
              String _name_3 = ((ComponentType)element).getName();
              boolean _endsWith = _name_3.endsWith("Impl");
              boolean _not_1 = (!_endsWith);
              if (_not_1) {
                String _name_4 = ((ComponentType)element).getName();
                String _plus_1 = (_name_4 + "Impl");
                ((ComponentType)element).setName(_plus_1);
              }
            }
            if ((element instanceof Component)) {
              String _name_5 = ((Component)element).getName();
              boolean _endsWith_1 = _name_5.endsWith("Inst");
              boolean _not_2 = (!_endsWith_1);
              if (_not_2) {
                String _name_6 = ((Component)element).getName();
                String _plus_2 = (_name_6 + "Inst");
                ((Component)element).setName(_plus_2);
              }
            }
          }
        }
      }
    }
    InputOutput.<String>println("Done!");
  }
}
