/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips.border.internal;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.border.BorderPainter;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class BorderPiece
implements PrintPiece {
    private final PrintPiece target;
    private final BorderPainter border;
    private final boolean topOpen;
    private final boolean bottomOpen;
    private final Point size;

    public BorderPiece(PrintPiece target, BorderPainter border, boolean topOpen, boolean bottomOpen) {
        Util.notNull(target, border);
        this.target = target;
        this.border = border;
        this.topOpen = topOpen;
        this.bottomOpen = bottomOpen;
        Point targetSize = target.getSize();
        this.size = new Point(targetSize.x + border.getWidth(), targetSize.y + border.getHeight(topOpen, bottomOpen));
    }

    @Override
    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    @Override
    public void paint(GC gc, int x, int y) {
        this.border.paint(gc, x, y, this.size.x, this.size.y, this.topOpen, this.bottomOpen);
        this.target.paint(gc, x + this.border.getLeft(), y + this.border.getTop(this.topOpen));
    }

    @Override
    public void dispose() {
        this.border.dispose();
        this.target.dispose();
    }
}

