/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.shellwax.internal.run;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationSelectionDialog;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class ShLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        this.launch(mode, this.getLaunchConfigurations(selection));
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(mode, this.getLaunchConfigurations(editor));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return this.getLaunchConfigurations(this.getLaunchableResource(selection));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editor) {
        return this.getLaunchConfigurations(this.getLaunchableResource(editor));
    }

    /*
     * WARNING - void declaration
     */
    public IResource getLaunchableResource(ISelection selection) {
        ISelection iSelection = selection;
        if (iSelection instanceof IStructuredSelection) {
            void structuredSelection;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            if (structuredSelection.size() != 1) {
                return null;
            }
            Object firstObject = structuredSelection.getFirstElement();
            return (IResource)Adapters.adapt((Object)firstObject, IResource.class);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public IResource getLaunchableResource(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        IEditorInput iEditorInput = input;
        if (iEditorInput instanceof FileEditorInput) {
            void file;
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            FileEditorInput cfr_ignored_0 = (FileEditorInput)iEditorInput;
            return file.getFile();
        }
        return null;
    }

    private ILaunchConfiguration[] getLaunchConfigurations(IResource resource) {
        if (resource == null || !resource.isAccessible()) {
            return new ILaunchConfiguration[0];
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.shellwax.shlaunchonfigtype");
        try {
            ILaunchConfiguration[] existing = (ILaunchConfiguration[])Arrays.stream(launchManager.getLaunchConfigurations(configType)).filter(launchConfig -> {
                try {
                    return launchConfig.getAttribute("org.eclipse.shellwax.launch.program", "").equals(resource.getLocation().toFile().toString());
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"error", (String)e.getMessage(), (IStatus)e.getStatus());
                    return false;
                }
            }).toArray(ILaunchConfiguration[]::new);
            if (existing.length != 0) {
                return existing;
            }
            String configName = launchManager.generateLaunchConfigurationName(resource.toString());
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, configName);
            wc.setAttribute("org.eclipse.shellwax.launch.program", resource.getLocation().toString());
            wc.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", resource.getLocation().removeLastSegments(1).toString());
            wc.doSave();
            return new ILaunchConfiguration[]{wc};
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"error", (String)e.getMessage(), (IStatus)e.getStatus());
            return null;
        }
    }

    private void launch(String mode, ILaunchConfiguration[] configurations) {
        LaunchConfigurationSelectionDialog dialog;
        if (configurations.length == 1) {
            CompletableFuture.runAsync(() -> {
                try {
                    configurations[0].launch(mode, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"error", (String)e.getMessage(), (IStatus)e.getStatus());
                }
            });
        } else if (configurations.length > 1 && (dialog = new LaunchConfigurationSelectionDialog(Display.getDefault().getActiveShell(), (Object)configurations)).open() == 0) {
            this.launch(mode, (ILaunchConfiguration[])Arrays.asList(dialog.getResult()).toArray(ILaunchConfiguration[]::new));
        }
    }
}

