/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Signale;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUM Streuscheibe Betriebsstellung</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * HGx_gw=Ergänzung gewendete Streuscheiben (Information zunehmend von SBI gefordert)
 * <!-- end-model-doc -->
 * @see org.eclipse.set.toolboxmodel.Signale.SignalePackage#getENUMStreuscheibeBetriebsstellung()
 * @model extendedMetaData="name='ENUMStreuscheibe_Betriebsstellung'"
 * @generated
 */
public enum ENUMStreuscheibeBetriebsstellung implements Enumerator {
	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1(0, "ENUMStreuscheibe_Betriebsstellung_HG1", "HG1"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG1 gw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1_GW_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1_GW(1, "ENUMStreuscheibe_Betriebsstellung_HG1_gw", "HG1_gw"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2(2, "ENUMStreuscheibe_Betriebsstellung_HG2", "HG2"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG2 gw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2_GW_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2_GW(3, "ENUMStreuscheibe_Betriebsstellung_HG2_gw", "HG2_gw"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3(4, "ENUMStreuscheibe_Betriebsstellung_HG3", "HG3"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG3 gw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3_GW_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3_GW(5, "ENUMStreuscheibe_Betriebsstellung_HG3_gw", "HG3_gw"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4(6, "ENUMStreuscheibe_Betriebsstellung_HG4", "HG4"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG4 gw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4_GW_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4_GW(7, "ENUMStreuscheibe_Betriebsstellung_HG4_gw", "HG4_gw"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HL(8, "ENUMStreuscheibe_Betriebsstellung_HL", "HL"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HR_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HR(9, "ENUMStreuscheibe_Betriebsstellung_HR", "HR"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung OL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OL(10, "ENUMStreuscheibe_Betriebsstellung_OL", "OL"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung OR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OR_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OR(11, "ENUMStreuscheibe_Betriebsstellung_OR", "OR"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_SONSTIGE(12, "ENUMStreuscheibe_Betriebsstellung_sonstige", "sonstige"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung VL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VL(13, "ENUMStreuscheibe_Betriebsstellung_VL", "VL"),

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung VR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VR_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VR(14, "ENUMStreuscheibe_Betriebsstellung_VR", "VR");

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1
	 * @model name="ENUMStreuscheibe_Betriebsstellung_HG1" literal="HG1"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1_VALUE = 0;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG1 gw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1_GW
	 * @model name="ENUMStreuscheibe_Betriebsstellung_HG1_gw" literal="HG1_gw"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1_GW_VALUE = 1;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2
	 * @model name="ENUMStreuscheibe_Betriebsstellung_HG2" literal="HG2"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2_VALUE = 2;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG2 gw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2_GW
	 * @model name="ENUMStreuscheibe_Betriebsstellung_HG2_gw" literal="HG2_gw"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2_GW_VALUE = 3;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3
	 * @model name="ENUMStreuscheibe_Betriebsstellung_HG3" literal="HG3"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3_VALUE = 4;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG3 gw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3_GW
	 * @model name="ENUMStreuscheibe_Betriebsstellung_HG3_gw" literal="HG3_gw"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3_GW_VALUE = 5;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4
	 * @model name="ENUMStreuscheibe_Betriebsstellung_HG4" literal="HG4"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4_VALUE = 6;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HG4 gw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4_GW
	 * @model name="ENUMStreuscheibe_Betriebsstellung_HG4_gw" literal="HG4_gw"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4_GW_VALUE = 7;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HL
	 * @model name="ENUMStreuscheibe_Betriebsstellung_HL" literal="HL"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HL_VALUE = 8;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung HR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HR
	 * @model name="ENUMStreuscheibe_Betriebsstellung_HR" literal="HR"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HR_VALUE = 9;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung OL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OL
	 * @model name="ENUMStreuscheibe_Betriebsstellung_OL" literal="OL"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OL_VALUE = 10;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung OR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OR
	 * @model name="ENUMStreuscheibe_Betriebsstellung_OR" literal="OR"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OR_VALUE = 11;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_SONSTIGE
	 * @model name="ENUMStreuscheibe_Betriebsstellung_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_SONSTIGE_VALUE = 12;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung VL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VL
	 * @model name="ENUMStreuscheibe_Betriebsstellung_VL" literal="VL"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VL_VALUE = 13;

	/**
	 * The '<em><b>ENUM Streuscheibe Betriebsstellung VR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VR
	 * @model name="ENUMStreuscheibe_Betriebsstellung_VR" literal="VR"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VR_VALUE = 14;

	/**
	 * An array of all the '<em><b>ENUM Streuscheibe Betriebsstellung</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMStreuscheibeBetriebsstellung[] VALUES_ARRAY =
		new ENUMStreuscheibeBetriebsstellung[] {
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1_GW,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2_GW,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3_GW,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4_GW,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HL,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HR,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OL,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OR,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_SONSTIGE,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VL,
			ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VR,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUM Streuscheibe Betriebsstellung</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMStreuscheibeBetriebsstellung> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUM Streuscheibe Betriebsstellung</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMStreuscheibeBetriebsstellung get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMStreuscheibeBetriebsstellung result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Streuscheibe Betriebsstellung</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMStreuscheibeBetriebsstellung getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMStreuscheibeBetriebsstellung result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Streuscheibe Betriebsstellung</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMStreuscheibeBetriebsstellung get(int value) {
		switch (value) {
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1_GW_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG1_GW;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2_GW_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG2_GW;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3_GW_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG3_GW;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4_GW_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HG4_GW;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HL_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HL;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HR_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_HR;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OL_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OL;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OR_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_OR;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_SONSTIGE_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_SONSTIGE;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VL_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VL;
			case ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VR_VALUE: return ENUM_STREUSCHEIBE_BETRIEBSSTELLUNG_VR;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMStreuscheibeBetriebsstellung(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMStreuscheibeBetriebsstellung
