/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.IGraphContentProvider;
import org.eclipse.zest.core.viewers.internal.IStylingGraphModelFactory;
import org.eclipse.zest.core.widgets.CGraphNode;
import org.eclipse.zest.core.widgets.ConstraintAdapter;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.core.widgets.ZestStyles;
import org.eclipse.zest.layouts.LayoutAlgorithm;

public abstract class AbstractStructuredGraphViewer
extends AbstractZoomableViewer {
    private int graphStyle;
    private int nodeStyle;
    private int connectionStyle;
    private HashMap nodesMap = new HashMap();
    private HashMap connectionsMap = new HashMap();
    private List constraintAdapters = new ArrayList();

    protected AbstractStructuredGraphViewer(int graphStyle) {
        this.graphStyle = graphStyle;
        this.connectionStyle = 0;
        this.nodeStyle = 0;
    }

    public void setNodeStyle(int nodeStyle) {
        if (this.getInput() != null) {
            throw new SWTError(1);
        }
        this.nodeStyle = nodeStyle;
    }

    public void setConnectionStyle(int connectionStyle) {
        if (this.getInput() != null) {
            throw new SWTError(1);
        }
        if (!ZestStyles.validateConnectionStyle(connectionStyle)) {
            throw new SWTError(5);
        }
        this.connectionStyle = connectionStyle;
    }

    public int getGraphStyle() {
        return this.graphStyle;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    public Graph getGraphControl() {
        return (Graph)this.getControl();
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public void addConstraintAdapter(ConstraintAdapter constraintAdapter) {
        this.constraintAdapters.add(constraintAdapter);
    }

    public List getConstraintAdapters() {
        return this.constraintAdapters;
    }

    public abstract void setLayoutAlgorithm(LayoutAlgorithm var1, boolean var2);

    protected abstract LayoutAlgorithm getLayoutAlgorithm();

    public void setLayoutAlgorithm(LayoutAlgorithm algorithm) {
        this.setLayoutAlgorithm(algorithm, false);
    }

    public Object[] getNodeElements() {
        return this.nodesMap.keySet().toArray();
    }

    public Object[] getConnectionElements() {
        return this.connectionsMap.keySet().toArray();
    }

    HashMap getNodesMap() {
        return this.nodesMap;
    }

    GraphNode addGraphModelContainer(Object element) {
        GraphNode node = this.getGraphModelNode(element);
        if (node == null) {
            node = new GraphContainer((Graph)this.getControl(), 0);
            this.nodesMap.put(element, node);
            node.setData(element);
        }
        return node;
    }

    GraphNode addGraphModelNode(IContainer container, Object element) {
        GraphNode node = this.getGraphModelNode(element);
        if (node == null) {
            node = new GraphNode(container, 0);
            this.nodesMap.put(element, node);
            node.setData(element);
        }
        return node;
    }

    GraphNode addGraphModelNode(Object element, IFigure figure) {
        GraphNode node = this.getGraphModelNode(element);
        if (node == null) {
            if (figure != null) {
                node = new CGraphNode((IContainer)((Graph)this.getControl()), 0, figure);
                this.nodesMap.put(element, node);
                node.setData(element);
            } else {
                node = new GraphNode((Graph)this.getControl(), 0);
                this.nodesMap.put(element, node);
                node.setData(element);
            }
        }
        return node;
    }

    GraphConnection addGraphModelConnection(Object element, GraphNode source, GraphNode target) {
        GraphConnection connection = this.getGraphModelConnection(element);
        if (connection == null) {
            connection = new GraphConnection((Graph)this.getControl(), 0, source, target);
            this.connectionsMap.put(element, connection);
            connection.setData(element);
        }
        return connection;
    }

    GraphConnection getGraphModelConnection(Object obj) {
        return (GraphConnection)((Object)this.connectionsMap.get(obj));
    }

    GraphNode getGraphModelNode(Object obj) {
        return (GraphNode)((Object)this.nodesMap.get(obj));
    }

    void removeGraphModelConnection(Object obj) {
        GraphConnection connection = (GraphConnection)((Object)this.connectionsMap.get(obj));
        if (connection != null) {
            this.connectionsMap.remove(obj);
            if (!connection.isDisposed()) {
                connection.dispose();
            }
        }
    }

    void removeGraphModelNode(Object obj) {
        GraphNode node = (GraphNode)((Object)this.nodesMap.get(obj));
        if (node != null) {
            this.nodesMap.remove(obj);
            if (!node.isDisposed()) {
                node.dispose();
            }
        }
    }

    protected void internalRefresh(Object element) {
        if (this.getInput() == null) {
            return;
        }
        if (element == this.getInput()) {
            this.getFactory().refreshGraph(this.getGraphControl());
        } else {
            this.getFactory().refresh(this.getGraphControl(), element);
        }
        this.getGraphControl().getLightweightSystem().getUpdateManager().performUpdate();
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        if (item == this.getGraphControl()) {
            this.getFactory().update(this.getNodesArray(this.getGraphControl()));
            this.getFactory().update(this.getConnectionsArray(this.getGraphControl()));
        } else if (item instanceof GraphItem) {
            this.getFactory().update((GraphItem)item);
        }
    }

    protected Widget doFindInputItem(Object element) {
        if (element == this.getInput() && element instanceof Widget) {
            return (Widget)element;
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        Widget node = (Widget)this.nodesMap.get(element);
        Widget connection = (Widget)this.connectionsMap.get(element);
        return node != null ? node : connection;
    }

    protected List getSelectionFromWidget() {
        List internalSelection = this.getWidgetSelection();
        LinkedList<Object> externalSelection = new LinkedList<Object>();
        Iterator i = internalSelection.iterator();
        while (i.hasNext()) {
            Object data = ((GraphItem)((Object)i.next())).getData();
            if (data == null) continue;
            externalSelection.add(data);
        }
        return externalSelection;
    }

    protected GraphItem[] findItems(List l) {
        if (l == null) {
            return new GraphItem[0];
        }
        ArrayList<GraphItem> list = new ArrayList<GraphItem>();
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            GraphItem w = (GraphItem)this.findItem(iterator.next());
            list.add(w);
        }
        return list.toArray(new GraphItem[list.size()]);
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        Graph control = (Graph)this.getControl();
        LinkedList<GraphItem> selection = new LinkedList<GraphItem>();
        for (Object obj : l) {
            GraphNode node = (GraphNode)((Object)this.nodesMap.get(obj));
            GraphConnection conn = (GraphConnection)((Object)this.connectionsMap.get(obj));
            if (node != null) {
                selection.add(node);
            }
            if (conn == null) continue;
            selection.add(conn);
        }
        control.setSelection(selection.toArray(new GraphNode[selection.size()]));
    }

    protected List getWidgetSelection() {
        Graph control = (Graph)this.getControl();
        return control.getSelection();
    }

    protected void inputChanged(Object input, Object oldInput) {
        IStylingGraphModelFactory factory = this.getFactory();
        factory.setConnectionStyle(this.getConnectionStyle());
        factory.setNodeStyle(this.getNodeStyle());
        HashMap oldNodesMap = this.nodesMap;
        Graph graph = (Graph)this.getControl();
        graph.setSelection(new GraphNode[0]);
        for (GraphNode node : this.nodesMap.values()) {
            if (node.isDisposed()) continue;
            node.dispose();
        }
        for (GraphConnection connection : this.connectionsMap.values()) {
            if (connection.isDisposed()) continue;
            connection.dispose();
        }
        this.nodesMap = new HashMap();
        this.connectionsMap = new HashMap();
        graph = factory.createGraphModel(graph);
        ((Graph)this.getControl()).setNodeStyle(this.getNodeStyle());
        ((Graph)this.getControl()).setConnectionStyle(this.getConnectionStyle());
        for (Object data : oldNodesMap.keySet()) {
            GraphNode newNode = (GraphNode)((Object)this.nodesMap.get(data));
            if (newNode == null) continue;
            GraphNode oldNode = (GraphNode)((Object)oldNodesMap.get(data));
            newNode.setLocation(oldNode.getLocation().x, oldNode.getLocation().y);
            if (!oldNode.isSizeFixed()) continue;
            newNode.setSize(oldNode.getSize().width, oldNode.getSize().height);
        }
        this.applyLayout();
    }

    protected abstract IStylingGraphModelFactory getFactory();

    protected void filterVisuals() {
        if (this.getGraphControl() == null) {
            return;
        }
        Object[] filtered = this.getFilteredChildren(this.getInput());
        SimpleGraphComparator comparator = new SimpleGraphComparator();
        TreeSet filteredElements = new TreeSet(comparator);
        TreeSet<GraphItem> unfilteredElements = new TreeSet<GraphItem>(comparator);
        List connections = this.getGraphControl().getConnections();
        List nodes = this.getGraphControl().getNodes();
        if (filtered.length == 0) {
            for (GraphConnection c : connections) {
                c.setVisible(false);
            }
            for (GraphNode n : nodes) {
                n.setVisible(false);
            }
            return;
        }
        for (GraphConnection c : connections) {
            if (c.getExternalConnection() == null) continue;
            unfilteredElements.add(c);
        }
        for (GraphNode n : nodes) {
            if (n.getData() == null) continue;
            unfilteredElements.add(n);
        }
        int i = 0;
        while (i < filtered.length) {
            Object modelElement = this.connectionsMap.get(filtered[i]);
            if (modelElement == null) {
                modelElement = this.nodesMap.get(filtered[i]);
            }
            if (modelElement != null) {
                filteredElements.add(modelElement);
            }
            ++i;
        }
        unfilteredElements.removeAll(filteredElements);
        while (unfilteredElements.size() > 0) {
            GraphItem i2 = (GraphItem)((Object)unfilteredElements.first());
            i2.setVisible(false);
            unfilteredElements.remove((Object)i2);
        }
        while (filteredElements.size() > 0) {
            GraphItem i3 = (GraphItem)((Object)filteredElements.first());
            i3.setVisible(true);
            filteredElements.remove((Object)i3);
        }
    }

    protected Object[] getRawChildren(Object parent) {
        if (parent == this.getInput()) {
            LinkedList<Object> children = new LinkedList<Object>();
            if (this.getGraphControl() != null) {
                List connections = this.getGraphControl().getConnections();
                List nodes = this.getGraphControl().getNodes();
                for (GraphConnection c : connections) {
                    if (c.getExternalConnection() == null) continue;
                    children.add(c.getExternalConnection());
                }
                for (GraphNode n : nodes) {
                    if (n.getData() == null) continue;
                    children.add(n.getData());
                }
                return children.toArray();
            }
        }
        return super.getRawChildren(parent);
    }

    public void reveal(Object element) {
        Widget[] items = this.findItems(element);
        int i = 0;
        while (i < items.length) {
            Widget item = items[i];
            if (item instanceof GraphNode) {
                GraphNode graphModelNode = (GraphNode)item;
                graphModelNode.highlight();
            } else if (item instanceof GraphConnection) {
                GraphConnection graphModelConnection = (GraphConnection)item;
                graphModelConnection.highlight();
            }
            ++i;
        }
    }

    public void unReveal(Object element) {
        Widget[] items = this.findItems(element);
        int i = 0;
        while (i < items.length) {
            Widget item = items[i];
            if (item instanceof GraphNode) {
                GraphNode graphModelNode = (GraphNode)item;
                graphModelNode.unhighlight();
            } else if (item instanceof GraphConnection) {
                GraphConnection graphModelConnection = (GraphConnection)item;
                graphModelConnection.unhighlight();
            }
            ++i;
        }
    }

    public abstract void applyLayout();

    public void removeRelationship(Object connection) {
        GraphConnection relationship = (GraphConnection)((Object)this.connectionsMap.get(connection));
        if (relationship != null) {
            if (this.getLayoutAlgorithm() != null) {
                this.getLayoutAlgorithm().removeRelationship(relationship.getLayoutRelationship());
            }
            relationship.dispose();
        }
    }

    public void addNode(Object element) {
        if (this.nodesMap.get(element) == null) {
            this.getFactory().createNode(this.getGraphControl(), element);
        }
    }

    public void removeNode(Object element) {
        GraphNode node = (GraphNode)((Object)this.nodesMap.get(element));
        if (node != null) {
            if (this.getLayoutAlgorithm() != null) {
                this.getLayoutAlgorithm().removeEntity(node.getLayoutEntity());
                this.getLayoutAlgorithm().removeRelationships(node.getSourceConnections());
                this.getLayoutAlgorithm().removeRelationships(node.getTargetConnections());
            }
            node.dispose();
        }
    }

    public void addRelationship(Object connection, Object srcNode, Object destNode) {
        IStylingGraphModelFactory modelFactory = this.getFactory();
        modelFactory.createConnection(this.getGraphControl(), connection, srcNode, destNode);
    }

    public void addRelationship(Object connection) {
        IStylingGraphModelFactory modelFactory = this.getFactory();
        if (this.connectionsMap.get(connection) == null) {
            if (modelFactory.getContentProvider() instanceof IGraphContentProvider) {
                IGraphContentProvider content = (IGraphContentProvider)modelFactory.getContentProvider();
                Object source = content.getSource(connection);
                Object dest = content.getDestination(connection);
                modelFactory.createConnection(this.getGraphControl(), connection, source, dest);
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected GraphConnection[] getConnectionsArray(Graph graph) {
        GraphConnection[] connsArray = new GraphConnection[graph.getConnections().size()];
        connsArray = graph.getConnections().toArray(connsArray);
        return connsArray;
    }

    protected GraphNode[] getNodesArray(Graph graph) {
        GraphNode[] nodesArray = new GraphNode[graph.getNodes().size()];
        nodesArray = graph.getNodes().toArray(nodesArray);
        return nodesArray;
    }

    private class SimpleGraphComparator
    implements Comparator {
        TreeSet storedStrings = new TreeSet();

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof GraphNode && arg1 instanceof GraphConnection) {
                return 1;
            }
            if (arg0 instanceof GraphConnection && arg1 instanceof GraphNode) {
                return -1;
            }
            if (arg0.equals(arg1)) {
                return 0;
            }
            return this.getObjectString(arg0).compareTo(this.getObjectString(arg1));
        }

        private String getObjectString(Object o) {
            String s = String.valueOf(o.getClass().getName()) + "@" + Integer.toHexString(o.hashCode());
            while (this.storedStrings.contains(s)) {
                s = String.valueOf(s) + 'X';
            }
            return s;
        }
    }
}

