/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.rap.http.servlet.internal.context.ContextController;
import org.eclipse.rap.http.servlet.internal.context.DispatchTargets;
import org.eclipse.rap.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.rap.http.servlet.internal.registration.ServletRegistration;
import org.eclipse.rap.http.servlet.internal.servlet.HttpSessionAdaptor;
import org.eclipse.rap.http.servlet.internal.servlet.RequestDispatcherAdaptor;
import org.eclipse.rap.http.servlet.internal.util.EventListeners;
import org.eclipse.rap.service.servlet.internal.runtime.dto.ServletDTO;

public class HttpServletRequestWrapperImpl
extends HttpServletRequestWrapper {
    private final Deque<DispatchTargets> dispatchTargets = new LinkedList<DispatchTargets>();
    private final HttpServletRequest request;
    private List<Part> parts;
    private final Lock lock = new ReentrantLock();
    private static final Set<String> dispatcherAttributes = new HashSet<String>();
    private static final Object NULL_PLACEHOLDER;

    static {
        dispatcherAttributes.add("jakarta.servlet.error.exception");
        dispatcherAttributes.add("jakarta.servlet.error.exception_type");
        dispatcherAttributes.add("jakarta.servlet.error.message");
        dispatcherAttributes.add("jakarta.servlet.error.request_uri");
        dispatcherAttributes.add("jakarta.servlet.error.servlet_name");
        dispatcherAttributes.add("jakarta.servlet.error.status_code");
        dispatcherAttributes.add("jakarta.servlet.forward.context_path");
        dispatcherAttributes.add("jakarta.servlet.forward.path_info");
        dispatcherAttributes.add("jakarta.servlet.forward.query_string");
        dispatcherAttributes.add("jakarta.servlet.forward.request_uri");
        dispatcherAttributes.add("jakarta.servlet.forward.servlet_path");
        dispatcherAttributes.add("jakarta.servlet.include.context_path");
        dispatcherAttributes.add("jakarta.servlet.include.path_info");
        dispatcherAttributes.add("jakarta.servlet.include.query_string");
        dispatcherAttributes.add("jakarta.servlet.include.request_uri");
        dispatcherAttributes.add("jakarta.servlet.include.servlet_path");
        NULL_PLACEHOLDER = new Object();
    }

    public static HttpServletRequestWrapperImpl findHttpRuntimeRequest(HttpServletRequest request) {
        while (request instanceof HttpServletRequestWrapper) {
            if (request instanceof HttpServletRequestWrapperImpl) {
                return (HttpServletRequestWrapperImpl)request;
            }
            request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
        }
        return null;
    }

    public HttpServletRequestWrapperImpl(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public String changeSessionId() {
        HttpSessionAdaptor httpSessionAdaptor = (HttpSessionAdaptor)this.getSession(false);
        if (httpSessionAdaptor == null) {
            throw new IllegalStateException("No session");
        }
        DispatchTargets currentDispatchTarget = this.dispatchTargets.peek();
        String oldSessionId = httpSessionAdaptor.getId();
        String newSessionId = super.changeSessionId();
        currentDispatchTarget.getContextController().removeActiveSession(oldSessionId);
        currentDispatchTarget.getContextController().addSessionAdaptor(newSessionId, httpSessionAdaptor);
        return newSessionId;
    }

    public String getAuthType() {
        String authType = (String)this.getAttribute("org.osgi.service.servlet.authentication.type");
        if (authType != null) {
            return authType;
        }
        return this.request.getAuthType();
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.getAttribute("org.osgi.service.servlet.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return this.request.getRemoteUser();
    }

    public String getPathInfo() {
        DispatchTargets currentDispatchTargets = this.dispatchTargets.peek();
        if (currentDispatchTargets.getServletName() != null || currentDispatchTargets.getDispatcherType() == DispatcherType.INCLUDE) {
            return this.dispatchTargets.getLast().getPathInfo();
        }
        return currentDispatchTargets.getPathInfo();
    }

    public DispatcherType getDispatcherType() {
        return this.dispatchTargets.peek().getDispatcherType();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.dispatchTargets.peek().getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public String getQueryString() {
        DispatchTargets currentDispatchTargets = this.dispatchTargets.peek();
        if (currentDispatchTargets.getServletName() != null || currentDispatchTargets.getDispatcherType() == DispatcherType.INCLUDE) {
            return this.request.getQueryString();
        }
        return currentDispatchTargets.getQueryString();
    }

    public String getRequestURI() {
        DispatchTargets currentDispatchTargets = this.dispatchTargets.peek();
        if (currentDispatchTargets.getServletName() != null || currentDispatchTargets.getDispatcherType() == DispatcherType.INCLUDE) {
            return this.request.getRequestURI();
        }
        return currentDispatchTargets.getRequestURI();
    }

    public ServletContext getServletContext() {
        return this.dispatchTargets.peek().getServletRegistration().getServletContext();
    }

    public String getServletPath() {
        DispatchTargets currentDispatchTargets = this.dispatchTargets.peek();
        if (currentDispatchTargets.getServletName() != null || currentDispatchTargets.getDispatcherType() == DispatcherType.INCLUDE) {
            return this.dispatchTargets.getLast().getServletPath();
        }
        if (currentDispatchTargets.getServletPath().equals("/")) {
            return "";
        }
        return currentDispatchTargets.getServletPath();
    }

    public String getContextPath() {
        return this.dispatchTargets.peek().getContextController().getFullContextPath();
    }

    public Object getAttribute(String attributeName) {
        DispatchTargets current = this.dispatchTargets.peek();
        DispatcherType dispatcherType = current.getDispatcherType();
        if (dispatcherType == DispatcherType.ASYNC || dispatcherType == DispatcherType.REQUEST || !attributeName.startsWith("jakarta.servlet.")) {
            return this.request.getAttribute(attributeName);
        }
        boolean hasServletName = current.getServletName() != null;
        Map<String, Object> specialOverides = current.getSpecialOverides();
        if (dispatcherType == DispatcherType.ERROR) {
            if (dispatcherAttributes.contains(attributeName) && !attributeName.startsWith("jakarta.servlet.error.")) {
                return null;
            }
        } else if (dispatcherType == DispatcherType.INCLUDE) {
            if (hasServletName && attributeName.startsWith("jakarta.servlet.include")) {
                return null;
            }
            if (dispatcherAttributes.contains(attributeName)) {
                Object specialOveride = specialOverides.get(attributeName);
                if (NULL_PLACEHOLDER.equals(specialOveride)) {
                    return null;
                }
                if (specialOveride != null) {
                    return specialOveride;
                }
                Object attributeValue = super.getAttribute(attributeName);
                if (attributeValue != null) {
                    return attributeValue;
                }
            }
            if (attributeName.equals("jakarta.servlet.include.context_path")) {
                return current.getContextController().getFullContextPath();
            }
            if (attributeName.equals("jakarta.servlet.include.path_info")) {
                return current.getPathInfo();
            }
            if (attributeName.equals("jakarta.servlet.include.query_string")) {
                return current.getQueryString();
            }
            if (attributeName.equals("jakarta.servlet.include.request_uri")) {
                return current.getRequestURI();
            }
            if (attributeName.equals("jakarta.servlet.include.servlet_path")) {
                return current.getServletPath();
            }
            if (dispatcherAttributes.contains(attributeName)) {
                return null;
            }
        } else if (dispatcherType == DispatcherType.FORWARD) {
            if (hasServletName && attributeName.startsWith("jakarta.servlet.forward")) {
                return null;
            }
            if (dispatcherAttributes.contains(attributeName)) {
                Object specialOveride = specialOverides.get(attributeName);
                if (NULL_PLACEHOLDER.equals(specialOveride)) {
                    return null;
                }
                if (specialOveride != null) {
                    return specialOveride;
                }
            }
            DispatchTargets original = this.dispatchTargets.getLast();
            if (attributeName.equals("jakarta.servlet.forward.context_path")) {
                return original.getContextController().getFullContextPath();
            }
            if (attributeName.equals("jakarta.servlet.forward.path_info")) {
                return original.getPathInfo();
            }
            if (attributeName.equals("jakarta.servlet.forward.query_string")) {
                return original.getQueryString();
            }
            if (attributeName.equals("jakarta.servlet.forward.request_uri")) {
                return original.getRequestURI();
            }
            if (attributeName.equals("jakarta.servlet.forward.servlet_path")) {
                return original.getServletPath();
            }
            if (dispatcherAttributes.contains(attributeName)) {
                return null;
            }
        }
        return this.request.getAttribute(attributeName);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        DispatchTargets currentDispatchTarget = this.dispatchTargets.peek();
        ContextController contextController = currentDispatchTarget.getContextController();
        if (!((String)path).startsWith("/")) {
            path = currentDispatchTarget.getServletPath() + "/" + (String)path;
        } else if (((String)path).startsWith(contextController.getFullContextPath())) {
            path = ((String)path).substring(contextController.getFullContextPath().length());
        }
        DispatchTargets requestedDispatchTargets = contextController.getDispatchTargets((String)path, null);
        if (requestedDispatchTargets == null) {
            return null;
        }
        return new RequestDispatcherAdaptor(requestedDispatchTargets, (String)path);
    }

    public static String getDispatchPathInfo(HttpServletRequest req) {
        if (req.getDispatcherType() == DispatcherType.INCLUDE) {
            return (String)req.getAttribute("jakarta.servlet.include.path_info");
        }
        return req.getPathInfo();
    }

    public static String getDispatchRequestURI(HttpServletRequest req) {
        if (req.getDispatcherType() == DispatcherType.INCLUDE) {
            return (String)req.getAttribute("jakarta.servlet.include.request_uri");
        }
        return req.getRequestURI();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = this.request.getSession(create);
        if (session != null) {
            DispatchTargets currentDispatchTarget = this.dispatchTargets.peek();
            return currentDispatchTarget.getContextController().getSessionAdaptor(session, ((Servlet)currentDispatchTarget.getServletRegistration().getT()).getServletConfig().getServletContext());
        }
        return null;
    }

    public synchronized void pop() {
        if (this.dispatchTargets.size() > 1) {
            this.dispatchTargets.pop();
        }
    }

    public synchronized void push(DispatchTargets toPush) {
        toPush.addRequestParameters(this.request);
        this.dispatchTargets.push(toPush);
    }

    public void removeAttribute(String name) {
        if (dispatcherAttributes.contains(name)) {
            DispatchTargets current = this.dispatchTargets.peek();
            current.getSpecialOverides().remove(name);
        }
        this.request.removeAttribute(name);
        DispatchTargets currentDispatchTarget = this.dispatchTargets.peek();
        EventListeners eventListeners = currentDispatchTarget.getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(currentDispatchTarget.getServletRegistration().getServletContext(), (ServletRequest)this, name, null);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
        }
    }

    public void setAttribute(String name, Object value) {
        boolean added;
        boolean bl = added = this.request.getAttribute(name) == null;
        if (dispatcherAttributes.contains(name)) {
            DispatchTargets current = this.dispatchTargets.peek();
            if (value == null) {
                current.getSpecialOverides().put(name, NULL_PLACEHOLDER);
            } else {
                current.getSpecialOverides().put(name, value);
            }
        }
        this.request.setAttribute(name, value);
        DispatchTargets currentDispatchTarget = this.dispatchTargets.peek();
        EventListeners eventListeners = currentDispatchTarget.getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(currentDispatchTarget.getServletRegistration().getServletContext(), (ServletRequest)this, name, value);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            if (added) {
                servletRequestAttributeListener.attributeAdded(servletRequestAttributeEvent);
                continue;
            }
            servletRequestAttributeListener.attributeReplaced(servletRequestAttributeEvent);
        }
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (name != null) {
            Collection<Part> allParts = this.getParts();
            for (Part part : allParts) {
                if (!name.equals(part.getName())) continue;
                return part;
            }
        }
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return new ArrayList<Part>(this.getParts0());
    }

    public AsyncContext startAsync() throws IllegalStateException {
        EndpointRegistration<?> endpointRegistration = this.dispatchTargets.peek().getServletRegistration();
        if (endpointRegistration instanceof ServletRegistration) {
            ServletRegistration servletRegistration = (ServletRegistration)endpointRegistration;
            if (((ServletDTO)((Object)servletRegistration.getD())).asyncSupported) {
                return this.request.startAsync();
            }
        }
        throw new IllegalStateException("Async not supported by " + String.valueOf(endpointRegistration));
    }

    private List<Part> getParts0() throws IOException, ServletException {
        ServletRegistration servletRegistration = this.getServletRegistration();
        if (servletRegistration == null) {
            throw new ServletException("Not a servlet request!");
        }
        this.lock.lock();
        try {
            if (this.parts != null) {
                List<Part> list = this.parts;
                return list;
            }
            this.parts = servletRegistration.parseRequest((HttpServletRequest)this);
            List<Part> list = this.parts;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ServletRegistration getServletRegistration() {
        EndpointRegistration<?> servletRegistration = this.dispatchTargets.peek().getServletRegistration();
        if (servletRegistration instanceof ServletRegistration) {
            return (ServletRegistration)servletRegistration;
        }
        return null;
    }
}

