/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.IPhase;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseListenerManager;
import org.eclipse.rap.rwt.lifecycle.ILifeCycle;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.swt.widgets.Display;

abstract class PhaseExecutor {
    private final PhaseListenerManager phaseListenerManager;
    private final IPhase[] phases;
    private final ILifeCycle lifecycle;

    PhaseExecutor(PhaseListenerManager phaseListenerManager, IPhase[] phases, ILifeCycle lifecycle) {
        this.phaseListenerManager = phaseListenerManager;
        this.phases = phases;
        this.lifecycle = lifecycle;
    }

    final void execute(PhaseId startPhaseId) throws IOException {
        PhaseId currentPhaseId = startPhaseId;
        while (currentPhaseId != null) {
            IPhase currentPhase = this.findPhase(currentPhaseId);
            CurrentPhase.set(currentPhaseId);
            this.phaseListenerManager.notifyBeforePhase(currentPhaseId, this.lifecycle);
            PhaseId nextPhaseId = currentPhase.execute(this.getDisplay());
            this.phaseListenerManager.notifyAfterPhase(currentPhaseId, this.lifecycle);
            currentPhaseId = nextPhaseId;
        }
    }

    abstract Display getDisplay();

    private IPhase findPhase(PhaseId phaseId) {
        IPhase result = null;
        int i = 0;
        while (result == null && i < this.phases.length) {
            if (this.phases[i].getPhaseId().equals(phaseId)) {
                result = this.phases[i];
            }
            ++i;
        }
        return result;
    }
}

