/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.persistence.AttributeConverter;
import javax.persistence.PersistenceException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ClassNameConversionRequired;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sessions.Session;

public class ConverterClass<T extends AttributeConverter<X, Y>, X, Y>
implements Converter,
ClassNameConversionRequired {
    protected boolean isForMapKey;
    protected boolean disableConversion;
    protected Class fieldClassification;
    protected String fieldClassificationName;
    protected String attributeConverterClassName;
    protected AttributeConverter<X, Y> attributeConverter;
    protected AbstractSession session;

    public ConverterClass(String attributeConverterClassName, boolean isForMapKey, String fieldClassificationName, boolean disableConversion) {
        this.isForMapKey = isForMapKey;
        this.disableConversion = disableConversion;
        this.fieldClassificationName = fieldClassificationName;
        this.attributeConverterClassName = attributeConverterClassName;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        this.constructAttributeConverter(classLoader);
        this.constructFieldClassification(classLoader);
    }

    private void constructAttributeConverter(ClassLoader classLoader) {
        Object attributeConverterInstance;
        block7: {
            Class<T> attributeConverterClass = this.getAttributeConverterClass(classLoader);
            attributeConverterInstance = this.getAttributeConverterInstance(attributeConverterClass);
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        if (attributeConverterInstance == null) {
                            attributeConverterInstance = (AttributeConverter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass<T>(attributeConverterClass));
                        }
                        break block7;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.errorInstantiatingClass(attributeConverterClass, exception.getException());
                    }
                }
                if (attributeConverterInstance == null) {
                    attributeConverterInstance = (AttributeConverter)PrivilegedAccessHelper.newInstanceFromClass(attributeConverterClass);
                }
            }
            catch (IllegalAccessException | InstantiationException exception) {
                throw ValidationException.errorInstantiatingClass(attributeConverterClass, exception);
            }
        }
        this.attributeConverter = attributeConverterInstance;
    }

    private T getAttributeConverterInstance(Class<T> attributeConverterClass) {
        try {
            return (T)((AttributeConverter)this.session.getInjectionManager().createManagedBeanAndInjectDependencies(attributeConverterClass));
        }
        catch (Exception e) {
            this.session.logThrowable(1, "jpa", e);
            return null;
        }
    }

    private Class<T> getAttributeConverterClass(ClassLoader classLoader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedClassForName(this.attributeConverterClassName, true, classLoader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(this.attributeConverterClassName, true, classLoader);
        }
        catch (ClassNotFoundException exception) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception);
        }
    }

    private void constructFieldClassification(ClassLoader classLoader) {
        block5: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.fieldClassification = AccessController.doPrivileged(new PrivilegedClassForName(this.fieldClassificationName, true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.fieldClassificationName, exception.getException());
                    }
                }
                this.fieldClassification = PrivilegedAccessHelper.getClassForName(this.fieldClassificationName, true, classLoader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.fieldClassificationName, exception);
            }
        }
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        try {
            return this.attributeConverter.convertToEntityAttribute(dataValue);
        }
        catch (RuntimeException re) {
            throw new PersistenceException(ExceptionLocalization.buildMessage("wrap_convert_exception", new Object[]{"convertToEntityAttribute", this.attributeConverterClassName, dataValue}), (Throwable)re);
        }
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        try {
            return this.attributeConverter.convertToDatabaseColumn(objectValue);
        }
        catch (RuntimeException re) {
            throw new PersistenceException(ExceptionLocalization.buildMessage("wrap_convert_exception", new Object[]{"convertToDatabaseColumn", this.attributeConverterClassName, objectValue}), (Throwable)re);
        }
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        if (mapping.isDirectToFieldMapping()) {
            DirectToFieldMapping m = (DirectToFieldMapping)mapping;
            if (this.disableConversion) {
                m.setConverter(null);
            } else {
                m.setConverter(this);
                m.setFieldClassification(this.fieldClassification);
                m.setFieldClassificationClassName(this.fieldClassificationName);
            }
        } else if (mapping.isDirectMapMapping() && this.isForMapKey) {
            DirectMapMapping m = (DirectMapMapping)mapping;
            if (this.disableConversion) {
                m.setKeyConverter(null);
            } else {
                m.setKeyConverter(this);
                m.setDirectKeyFieldClassification(this.fieldClassification);
                m.setDirectKeyFieldClassificationName(this.fieldClassificationName);
            }
        } else if (mapping.isDirectCollectionMapping()) {
            DirectCollectionMapping m = (DirectCollectionMapping)mapping;
            if (this.disableConversion) {
                m.setValueConverter(null);
            } else {
                m.setValueConverter(this);
                m.setDirectFieldClassification(this.fieldClassification);
                m.setDirectFieldClassificationName(this.fieldClassificationName);
            }
        }
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }
}

