/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.management;

import com.mongodb.ServerAddress;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.event.ConnectionEvent;
import com.mongodb.event.ConnectionPoolListenerAdapter;
import com.mongodb.event.ConnectionPoolOpenedEvent;
import com.mongodb.event.ConnectionPoolWaitQueueEvent;
import com.mongodb.management.ConnectionPoolStatisticsMBean;
import java.util.concurrent.atomic.AtomicInteger;

final class ConnectionPoolStatistics
extends ConnectionPoolListenerAdapter
implements ConnectionPoolStatisticsMBean {
    private final ServerAddress serverAddress;
    private final ConnectionPoolSettings settings;
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger checkedOutCount = new AtomicInteger();
    private final AtomicInteger waitQueueSize = new AtomicInteger();

    public ConnectionPoolStatistics(ConnectionPoolOpenedEvent event) {
        this.serverAddress = event.getServerId().getAddress();
        this.settings = event.getSettings();
    }

    @Override
    public String getHost() {
        return this.serverAddress.getHost();
    }

    @Override
    public int getPort() {
        return this.serverAddress.getPort();
    }

    @Override
    public int getMinSize() {
        return this.settings.getMinSize();
    }

    @Override
    public int getMaxSize() {
        return this.settings.getMaxSize();
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public int getCheckedOutCount() {
        return this.checkedOutCount.get();
    }

    @Override
    public int getWaitQueueSize() {
        return this.waitQueueSize.get();
    }

    @Override
    public void connectionCheckedOut(ConnectionEvent event) {
        this.checkedOutCount.incrementAndGet();
    }

    @Override
    public void connectionCheckedIn(ConnectionEvent event) {
        this.checkedOutCount.decrementAndGet();
    }

    @Override
    public void connectionAdded(ConnectionEvent event) {
        this.size.incrementAndGet();
    }

    @Override
    public void connectionRemoved(ConnectionEvent event) {
        this.size.decrementAndGet();
    }

    @Override
    public void waitQueueEntered(ConnectionPoolWaitQueueEvent event) {
        this.waitQueueSize.incrementAndGet();
    }

    @Override
    public void waitQueueExited(ConnectionPoolWaitQueueEvent event) {
        this.waitQueueSize.decrementAndGet();
    }
}

