/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.collab.ui.view;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.internal.presence.collab.ui.Activator;
import org.eclipse.ecf.internal.presence.collab.ui.Messages;
import org.eclipse.ecf.internal.presence.collab.ui.view.ShowViewDialogLabelProvider;
import org.eclipse.ecf.internal.presence.collab.ui.view.ShowViewDialogTreeContentProvider;
import org.eclipse.ecf.internal.presence.collab.ui.view.ShowViewDialogViewerFilter;
import org.eclipse.ecf.presence.collab.ui.AbstractCollabShare;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ViewShare
extends AbstractCollabShare {
    private static final Map viewSharechannels = new Hashtable();

    public static ViewShare getViewShare(ID containerID) {
        return (ViewShare)((Object)viewSharechannels.get(containerID));
    }

    public static ViewShare addViewShare(ID containerID, IChannelContainerAdapter channelAdapter) throws ECFException {
        return viewSharechannels.put(containerID, new ViewShare(channelAdapter));
    }

    public static ViewShare removeViewShare(ID containerID) {
        return (ViewShare)((Object)viewSharechannels.remove(containerID));
    }

    public ViewShare(IChannelContainerAdapter adapter) throws ECFException {
        super(adapter);
    }

    private void handleOpenViewRequest(final String user, final String viewID, final String secondaryID, final int mode) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (MessageDialog.openQuestion(null, (String)Messages.ViewShare_VIEWSHARE_RECEIVED_REQUEST_TITLE, (String)NLS.bind((String)Messages.ViewShare_VIEWSHARE_RECEIVED_REQUEST_MESSAGE, (Object)user))) {
                    try {
                        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPage wp = ww.getActivePage();
                        if (wp == null) {
                            throw new PartInitException(Messages.ViewShare_EXCEPTION_WORKBENCHPAGE_NULL);
                        }
                        wp.showView(viewID, secondaryID, mode);
                    }
                    catch (Exception e) {
                        ViewShare.this.logError(Messages.ViewShare_VIEWSHARE_ERROR_LOG_MESSAGE, e);
                    }
                }
            }
        });
    }

    public void sendOpenViewRequest(final String senderuser, final ID toID) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = ww.getActivePage();
                if (page == null) {
                    return;
                }
                ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(null, (ILabelProvider)new ShowViewDialogLabelProvider(), (ITreeContentProvider)new ShowViewDialogTreeContentProvider());
                dlg.setTitle(Messages.ViewShare_VIEWSHARE_VIEW_REQUEST_DIALOG_TITLE);
                dlg.setMessage(Messages.ViewShare_VIEWSHARE_VIEW_REQUEST_DIALOG_MESSAGE);
                dlg.addFilter((ViewerFilter)new ShowViewDialogViewerFilter());
                dlg.setComparator(new ViewerComparator());
                dlg.setValidator(new ISelectionStatusValidator(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public IStatus validate(Object[] selection) {
                        int i = 0;
                        while (i < selection.length) {
                            if (!(selection[i] instanceof IViewDescriptor)) {
                                return new Status(4, "org.eclipse.ecf.presence.collab.ui", 0, "", null);
                            }
                            ++i;
                        }
                        return new Status(0, Activator.getDefault().getBundle().getSymbolicName(), 0, "", null);
                    }
                });
                IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
                dlg.setInput((Object)reg);
                dlg.open();
                if (dlg.getReturnCode() == 1) {
                    return;
                }
                Object[] descs = dlg.getResult();
                if (descs == null) {
                    return;
                }
                String[] selectedIDs = new String[descs.length];
                int i = 0;
                while (i < descs.length) {
                    selectedIDs[i] = ((IViewDescriptor)descs[i]).getId();
                    try {
                        ViewShare.this.sendMessage(toID, ViewShare.this.serialize(new Object[]{senderuser, selectedIDs[i]}));
                    }
                    catch (ECFException e) {
                        ViewShare.this.logError(e.getStatus());
                    }
                    catch (Exception e) {
                        ViewShare.this.logError(Messages.Share_EXCEPTION_LOG_SEND, e);
                    }
                    ++i;
                }
            }
        });
    }

    protected void handleMessage(ID fromContainerID, byte[] data) {
        try {
            Object[] msg = (Object[])this.deserialize(data);
            this.handleOpenViewRequest((String)msg[0], (String)msg[1], null, 1);
        }
        catch (Exception e) {
            this.logError(Messages.Share_EXCEPTION_LOG_MESSAGE, e);
        }
    }
}

