/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.csv.importer.mapping;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DataType implements Enumerator
{
    STRING(0, "String", "String"),
    BOOLEAN(1, "Boolean", "Boolean"),
    INTEGER(2, "Integer", "Integer"),
    REAL(3, "Real", "Real"),
    DATE(4, "Date", "Date"),
    ENUMERATION(5, "Enumeration", "Enumeration"),
    XHTML(6, "XHTML", "XHTML");

    public static final int STRING_VALUE = 0;
    public static final int BOOLEAN_VALUE = 1;
    public static final int INTEGER_VALUE = 2;
    public static final int REAL_VALUE = 3;
    public static final int DATE_VALUE = 4;
    public static final int ENUMERATION_VALUE = 5;
    public static final int XHTML_VALUE = 6;
    private static final DataType[] VALUES_ARRAY;
    public static final List<DataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataType[]{STRING, BOOLEAN, INTEGER, REAL, DATE, ENUMERATION, XHTML};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return BOOLEAN;
            }
            case 2: {
                return INTEGER;
            }
            case 3: {
                return REAL;
            }
            case 4: {
                return DATE;
            }
            case 5: {
                return ENUMERATION;
            }
            case 6: {
                return XHTML;
            }
        }
        return null;
    }

    private DataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

