/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.npm.internal.launch.shortcut;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.wst.jsdt.js.npm.NpmPlugin;
import org.eclipse.wst.jsdt.js.npm.internal.NpmScriptTask;
import org.eclipse.wst.jsdt.js.npm.util.NpmUtil;

public abstract class GenericNpmLaunch
implements ILaunchShortcut {
    protected abstract String getCommandName();

    public void launch(ISelection selection, String mode) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IResource) {
                IResource selectedResource = (IResource)element;
                this.launch(selectedResource, mode);
            } else if (element instanceof NpmScriptTask) {
                NpmScriptTask scriptTask = (NpmScriptTask)((Object)element);
                this.launch(scriptTask.getParent(), mode, scriptTask.getName());
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput editorInput = editor.getEditorInput();
        IFile file = ResourceUtil.getFile((IEditorInput)editorInput);
        if (file != null && file.exists() && "package.json".equals(file.getName())) {
            this.launch((IResource)file, mode);
        }
    }

    private void launch(IResource resource, String mode) {
        this.launch(resource, mode, null);
    }

    private void launch(IResource resource, String mode, String subCommand) {
        try {
            IProject project = resource.getProject();
            IPath workingDirectory = this.getWorkingDirectory(resource);
            if (project.exists() && workingDirectory != null) {
                String projectName = project.getName();
                ILaunchConfigurationType npmLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.wst.jsdt.js.npm.npmLaunchConfigurationType");
                ILaunchConfigurationWorkingCopy npmLaunch = npmLaunchType.newInstance(null, this.generateLaunchName(projectName));
                npmLaunch.setAttribute("org.eclipse.wst.jsdt.js.npm.COMMAND", this.getCommandName());
                npmLaunch.setAttribute("org.eclipse.wst.jsdt.js.npm.PROJECT", projectName);
                npmLaunch.setAttribute("org.eclipse.wst.jsdt.js.npm.DIR", workingDirectory.toOSString());
                npmLaunch.setAttribute("org.eclipse.wst.jsdt.js.npm.SUBCOMMAND", subCommand);
                DebugUITools.launch((ILaunchConfiguration)npmLaunch, (String)mode);
            }
        }
        catch (CoreException e) {
            NpmPlugin.logError(e, e.getMessage());
        }
    }

    private String generateLaunchName(String projectName) {
        return String.valueOf(projectName) + " [" + "npm" + " " + this.getCommandName() + "]";
    }

    protected IPath getWorkingDirectory(IResource resource) throws CoreException {
        IPath workingDir = null;
        if (resource != null && resource.exists()) {
            if (resource.getType() == 1 && "package.json".equals(resource.getName())) {
                workingDir = resource.getParent().getLocation();
            } else if (resource.getType() == 2) {
                workingDir = resource.getLocation();
            } else if (resource.getType() == 4) {
                IProject project = (IProject)resource;
                IFile file = project.getFile("package.json");
                workingDir = file.exists() ? resource.getLocation() : NpmUtil.getNpmWorkingDir(project, "node_modules");
            }
        }
        return workingDir;
    }
}

