/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.snapshot.StateSnapshot;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.trim.ITmfTrimmableTrace;
import org.eclipse.tracecompass.tmf.ui.dialog.DirectoryDialogFactory;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

@NonNullByDefault
public class TrimTraceHandler
extends AbstractHandler {
    private static final String TRACE_NAME_SUFFIX = "-trimmed";

    public boolean isEnabled() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return false;
        }
        IHandlerService service = (IHandlerService)workbench.getService(IHandlerService.class);
        ExecutionEvent executionEvent = new ExecutionEvent(null, Collections.emptyMap(), null, (Object)service.getCurrentState());
        ISelection element = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (!(element instanceof TreeSelection)) {
            return false;
        }
        Object firstElement = ((TreeSelection)element).getFirstElement();
        TmfTraceElement traceElem = (TmfTraceElement)firstElement;
        ITmfTrace trace = traceElem.getTrace();
        if (!(trace instanceof ITmfTrimmableTrace)) {
            return false;
        }
        TmfTraceManager tm = TmfTraceManager.getInstance();
        TmfTimeRange selectionRange = tm.getTraceContext(trace).getSelectionRange();
        return !selectionRange.getStartTime().equals(selectionRange.getEndTime());
    }

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object element = ((IStructuredSelection)selection).getFirstElement();
        final TmfTraceElement traceElem = (TmfTraceElement)element;
        final ITmfTrace trace = traceElem.getTrace();
        if (!(trace instanceof ITmfTrimmableTrace)) {
            return null;
        }
        final ITmfTrimmableTrace trimmableTrace = (ITmfTrimmableTrace)trace;
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TmfTraceManager tm = TmfTraceManager.getInstance();
        TmfTimeRange timeRange = tm.getTraceContext(trace).getSelectionRange();
        if (timeRange.getStartTime().equals(timeRange.getEndTime())) {
            MessageDialog.openError((Shell)shell, (String)Messages.TrimTraces_InvalidTimeRange_DialogTitle, (String)Messages.TrimTraces_InvalidTimeRange_DialogText);
            return null;
        }
        final TmfTimeRange tr = timeRange.getStartTime().compareTo(timeRange.getEndTime()) > 0 ? new TmfTimeRange(timeRange.getEndTime(), timeRange.getStartTime()) : timeRange;
        DirectoryDialog dialog = DirectoryDialogFactory.create(shell);
        dialog.setText(Messages.TrimTraces_DirectoryChooser_DialogTitle);
        String result = dialog.open();
        if (result == null) {
            return null;
        }
        Path parentPath = (Path)NonNullUtils.checkNotNull((Object)Paths.get(result, new String[0]));
        if (!parentPath.toFile().isDirectory()) {
            MessageDialog.openError((Shell)shell, (String)Messages.TrimTraces_InvalidDirectory_DialogTitle, (String)Messages.TrimTraces_InvalidDirectory_DialogText);
            return null;
        }
        if (!Files.isWritable(parentPath)) {
            MessageDialog.openError((Shell)shell, (String)Messages.TrimTraces_InvalidDirectory_DialogTitle, (String)Messages.TrimTraces_NoWriteAccess_DialogText);
            return null;
        }
        String newTraceName = String.valueOf(trace.getResource().getName()) + TRACE_NAME_SUFFIX;
        Path potentialPath = parentPath.resolve(newTraceName);
        int i = 2;
        while (potentialPath.toFile().exists()) {
            newTraceName = String.valueOf(trace.getResource().getName()) + TRACE_NAME_SUFFIX + '-' + String.valueOf(i);
            potentialPath = parentPath.resolve(newTraceName);
            ++i;
        }
        final Path tracePath = (Path)NonNullUtils.checkNotNull((Object)potentialPath);
        try {
            Files.createDirectory(tracePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        TmfWorkspaceModifyOperation trimOperation = new TmfWorkspaceModifyOperation(){

            @Override
            public void execute(@Nullable IProgressMonitor monitor) throws CoreException {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                long snapshotTime = tr.getStartTime().toNanos();
                ArrayList<@NonNull ITmfAnalysisModuleWithStateSystems> statesystemModules = new ArrayList<ITmfAnalysisModuleWithStateSystems>();
                for (IAnalysisModule module : trace.getAnalysisModules()) {
                    if (!(module instanceof ITmfAnalysisModuleWithStateSystems)) continue;
                    statesystemModules.add((ITmfAnalysisModuleWithStateSystems)module);
                }
                Path path = trimmableTrace.trim(tr, tracePath, (IProgressMonitor)mon.split(1));
                if (path == null) {
                    Activator.getDefault().logWarning("Could not trim trace " + tracePath);
                    return;
                }
                SubMonitor ssMon = SubMonitor.convert((IProgressMonitor)mon, (int)statesystemModules.size());
                try {
                    for (ITmfAnalysisModuleWithStateSystems module : statesystemModules) {
                        ssMon.split(1);
                        Map versions = module.getProviderVersions();
                        Iterable sss = module.getStateSystems();
                        for (ITmfStateSystem ss : sss) {
                            Integer version = (Integer)versions.get(ss.getSSID());
                            if (snapshotTime > ss.getCurrentEndTime() || version == null) continue;
                            StateSnapshot snapshot = new StateSnapshot(ss, Math.max(snapshotTime, ss.getStartTime()), version.intValue());
                            snapshot.write(tracePath);
                        }
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", "An error occured while attempting to save the initial state"));
                }
                TmfProjectElement currentProjectElement = traceElem.getProject();
                TmfTraceFolder traceFolder = currentProjectElement.getTracesFolder();
                if (traceFolder != null) {
                    Display.getDefault().asyncExec(() -> {
                        try {
                            TmfOpenTraceHelper.openTraceFromPath(traceFolder, path.toString(), shell);
                        }
                        catch (CoreException e) {
                            Activator.getDefault().logWarning("Trace " + traceFolder + " failed to open: " + path);
                        }
                    });
                } else {
                    Activator.getDefault().logWarning("Trace folder does not exist: " + path);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)trimOperation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(Messages.TrimTraceHandler_failMsg, e.getMessage(), e);
            return null;
        }
        return null;
    }
}

