/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.core.internal;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModule;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.ldt.debug.core.internal.Activator;

public class LuaReplacePathSourceContainer
extends AbstractSourceContainer {
    public Object[] findSourceElements(String suri) throws CoreException {
        String path;
        ILaunchConfiguration configuration = this.getDirector().getLaunchConfiguration();
        String projectName = configuration.getAttribute("project", null);
        if (projectName == null) {
            return new Object[0];
        }
        String replacePath = configuration.getAttribute("remoteWorkingDir", null);
        if (replacePath == null) {
            return new Object[0];
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IScriptProject prj = DLTKCore.create((IProject)project);
        if (prj == null) {
            return new Object[0];
        }
        String spath = null;
        try {
            URI uri = new URI(suri);
            if ("file".equalsIgnoreCase(uri.getScheme()) && (path = uri.getPath()) != null && path.startsWith(replacePath)) {
                spath = path.substring(replacePath.length() + 1);
            }
        }
        catch (URISyntaxException e) {
            Activator.logWarning("unable to found source for " + suri, e);
        }
        if (spath == null) {
            return new Object[0];
        }
        IProjectFragment[] allProjectFragments = prj.getAllProjectFragments();
        path = new Path(spath);
        IProjectFragment[] iProjectFragmentArray = allProjectFragments;
        int n = allProjectFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFragment projectFragment = iProjectFragmentArray[n2];
            Object result = this.searchInIParent((IParent)projectFragment, (IPath)path);
            if (result != null) {
                return new Object[]{result};
            }
            ++n2;
        }
        return new Object[0];
    }

    private Object searchInIParent(IParent parent, IPath path) throws CoreException {
        block10: {
            IModelElement[] children;
            block9: {
                IModelElement[] children2;
                if (path.segmentCount() <= 1) break block9;
                String firstSegment = path.segment(0);
                IModelElement[] iModelElementArray = children2 = parent.getChildren();
                int n = children2.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath cleanpath;
                    Object result;
                    IModelElement child = iModelElementArray[n2];
                    if (child instanceof IScriptFolder && firstSegment.equals(child.getElementName()) && (result = this.searchInIParent((IParent)((IScriptFolder)child), cleanpath = path.removeFirstSegments(1))) != null) {
                        return result;
                    }
                    ++n2;
                }
                break block10;
            }
            if (path.segmentCount() != 1) break block10;
            String firstSegment = path.segment(0);
            IModelElement[] iModelElementArray = children = parent.getChildren();
            int n = children.length;
            int n3 = 0;
            while (n3 < n) {
                IModelElement child = iModelElementArray[n3];
                if (child instanceof IScriptFolder) {
                    Object result;
                    IScriptFolder scriptFolder = (IScriptFolder)child;
                    if (scriptFolder.isRootFolder() && (result = this.searchInIParent((IParent)((IScriptFolder)child), path)) != null) {
                        return result;
                    }
                } else if (child instanceof IModule && firstSegment.equals(child.getElementName())) {
                    if (child.getResource() != null) {
                        return child.getResource();
                    }
                    if (child instanceof IStorage) {
                        return child;
                    }
                }
                ++n3;
            }
        }
        return null;
    }

    public String getName() {
        return "Lua Replace Path Buildpath Source Container";
    }

    public ISourceContainerType getType() {
        return null;
    }
}

