/* This file was generated by SableCC (http://www.sablecc.org/). */

package org.eclipse.jubula.client.core.gen.parser.parameter.lexer;

import java.io.*;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.*;

@SuppressWarnings("nls")
public class Lexer
{
    protected Token token;
    protected State state = State.NORMAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    @SuppressWarnings("unused")
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    public Lexer(@SuppressWarnings("hiding") PushbackReader in)
    {
        this.in = in;
    }
 
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        return this.token;
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        @SuppressWarnings("hiding") int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        @SuppressWarnings("hiding") int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            @SuppressWarnings("hiding") Token token = new0(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 7: state = State.LITERAL; break;
                                case 0: state = State.LITERAL; break;
                            }
                            return token;
                        }
                    case 1:
                        {
                            @SuppressWarnings("hiding") Token token = new1(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 7: state = State.FUNCTION_NAME; break;
                                case 0: state = State.FUNCTION_NAME; break;
                            }
                            return token;
                        }
                    case 2:
                        {
                            @SuppressWarnings("hiding") Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.FUNCTION; break;
                            }
                            return token;
                        }
                    case 3:
                        {
                            @SuppressWarnings("hiding") Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 6: state = State.FUNCTION_ARGS; break;
                            }
                            return token;
                        }
                    case 4:
                        {
                            @SuppressWarnings("hiding") Token token = new4(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 7: state = State.FUNCTION_ARGS; break;
                            }
                            return token;
                        }
                    case 5:
                        {
                            @SuppressWarnings("hiding") Token token = new5(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 7: state = State.FUNCTION_ARGS; break;
                            }
                            return token;
                        }
                    case 6:
                        {
                            @SuppressWarnings("hiding") Token token = new6(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 7: state = State.FUNCTION_ARGS; break;
                            }
                            return token;
                        }
                    case 7:
                        {
                            @SuppressWarnings("hiding") Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 7: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 8:
                        {
                            @SuppressWarnings("hiding") Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 7: state = State.REFERENCE; break;
                                case 0: state = State.REFERENCE; break;
                            }
                            return token;
                        }
                    case 9:
                        {
                            @SuppressWarnings("hiding") Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 10:
                        {
                            @SuppressWarnings("hiding") Token token = new10(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.REF_BRACE; break;
                                case 1: state = State.VAR_BRACE; break;
                            }
                            return token;
                        }
                    case 11:
                        {
                            @SuppressWarnings("hiding") Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.NORMAL; break;
                                case 4: state = State.NORMAL; break;
                                case 1: state = State.NORMAL; break;
                                case 2: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 12:
                        {
                            @SuppressWarnings("hiding") Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 7: state = State.VARIABLE; break;
                                case 0: state = State.VARIABLE; break;
                            }
                            return token;
                        }
                    case 13:
                        {
                            @SuppressWarnings("hiding") Token token = new13(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 14:
                        {
                            @SuppressWarnings("hiding") Token token = new14(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                                case 2: state = State.VARIABLE; break;
                            }
                            return token;
                        }
                    case 15:
                        {
                            @SuppressWarnings("hiding") Token token = new15(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.NORMAL; break;
                                case 4: state = State.REFERENCE; break;
                            }
                            return token;
                        }
                    case 16:
                        {
                            @SuppressWarnings("hiding") Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 17:
                        {
                            @SuppressWarnings("hiding") Token token = new17(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 8: state = State.LITERAL; break;
                            }
                            return token;
                        }
                    case 18:
                        {
                            @SuppressWarnings("hiding") Token token = new18(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 8: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                    @SuppressWarnings("hiding") EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOpenLiteral(line, pos); }
    Token new1(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFunctionToken(line, pos); }
    Token new2(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFunctionName(text, line, pos); }
    Token new3(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBeginFunctionArgsToken(line, pos); }
    Token new4(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComma(text, line, pos); }
    Token new5(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEscapedSymbolInFunction(text, line, pos); }
    Token new6(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFunctionAlphanumeric(text, line, pos); }
    Token new7(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEndFunctionArgsToken(line, pos); }
    Token new8(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TReferenceToken(line, pos); }
    Token new9(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEscapedSymbol(text, line, pos); }
    Token new10(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOpenBrace(line, pos); }
    Token new11(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCloseBrace(line, pos); }
    Token new12(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TVariableToken(line, pos); }
    Token new13(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAlphanumeric(text, line, pos); }
    Token new14(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TVariableBody(text, line, pos); }
    Token new15(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TReferenceBody(text, line, pos); }
    Token new16(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TChar(text, line, pos); }
    Token new17(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLiteralBody(text, line, pos); }
    Token new18(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCloseLiteral(line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(@SuppressWarnings("hiding") Token token) throws IOException
    {
        @SuppressWarnings("hiding") String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // NORMAL
            {{0, 35, 1}, {36, 36, 2}, {37, 38, 1}, {39, 39, 3}, {40, 47, 1}, {48, 57, 4}, {58, 60, 1}, {61, 61, 5}, {62, 62, 1}, {63, 63, 6}, {64, 64, 1}, {65, 90, 7}, {91, 91, 1}, {92, 92, 8}, {93, 94, 1}, {95, 95, 9}, {96, 96, 1}, {97, 122, 10}, {123, 65535, 1}, },
            {},
            {},
            {},
            {{48, 57, 11}, {65, 90, 12}, {95, 95, 13}, {97, 122, 14}, },
            {},
            {},
            {{48, 122, -6}, },
            {{36, 36, 15}, {39, 39, 16}, {61, 61, 17}, {63, 63, 18}, {92, 92, 19}, },
            {{48, 122, -6}, },
            {{48, 122, -6}, },
            {{48, 122, -6}, },
            {{48, 122, -6}, },
            {{48, 122, -6}, },
            {{48, 122, -6}, },
            {},
            {},
            {},
            {},
            {},
        }
        { // VARIABLE
            {{48, 57, 1}, {65, 90, 2}, {95, 95, 3}, {97, 122, 4}, {123, 123, 5}, {125, 125, 6}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {},
            {},
        }
        { // VAR_BRACE
            {{48, 57, 1}, {65, 90, 2}, {95, 95, 3}, {97, 122, 4}, {125, 125, 5}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {},
        }
        { // REFERENCE
            {{48, 57, 1}, {65, 90, 2}, {95, 95, 3}, {97, 122, 4}, {123, 123, 5}, {125, 125, 6}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {},
            {},
        }
        { // REF_BRACE
            {{48, 57, 1}, {65, 90, 2}, {95, 95, 3}, {97, 122, 4}, {125, 125, 5}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {},
        }
        { // FUNCTION_NAME
            {{48, 57, 1}, {65, 90, 2}, {95, 95, 3}, {97, 122, 4}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
            {{48, 122, -2}, },
        }
        { // FUNCTION
            {{40, 40, 1}, },
            {},
        }
        { // FUNCTION_ARGS
            {{36, 36, 1}, {39, 39, 2}, {41, 41, 3}, {44, 44, 4}, {45, 45, 5}, {46, 46, 6}, {48, 57, 7}, {61, 61, 8}, {63, 63, 9}, {65, 90, 10}, {92, 92, 11}, {95, 95, 12}, {97, 122, 13}, },
            {},
            {},
            {},
            {{32, 32, 14}, },
            {{45, 57, -2}, {65, 90, 10}, {95, 122, -2}, },
            {{45, 122, -7}, },
            {{45, 122, -7}, },
            {},
            {},
            {{45, 122, -7}, },
            {{36, 36, 15}, {39, 39, 16}, {40, 40, 17}, {41, 41, 18}, {44, 44, 19}, {61, 61, 20}, {63, 63, 21}, {92, 92, 22}, },
            {{45, 122, -7}, },
            {{45, 122, -7}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
        }
        { // LITERAL
            {{0, 38, 1}, {39, 39, 2}, {40, 65535, 1}, },
            {{0, 38, 1}, {40, 65535, 1}, },
            {},
        }
    };*/

    private static int[][] accept;
/*  {
        // NORMAL
        {-1, 16, 12, 0, 13, 8, 1, 13, 16, 13, 13, 13, 13, 13, 13, 9, 9, 9, 9, 9, },
        // VARIABLE
        {-1, 14, 14, 14, 14, 10, 11, },
        // VAR_BRACE
        {-1, 14, 14, 14, 14, 11, },
        // REFERENCE
        {-1, 15, 15, 15, 15, 10, 11, },
        // REF_BRACE
        {-1, 15, 15, 15, 15, 11, },
        // FUNCTION_NAME
        {-1, 2, 2, 2, 2, },
        // FUNCTION
        {-1, 3, },
        // FUNCTION_ARGS
        {-1, 12, 0, 7, 4, 6, 6, 6, 8, 1, 6, -1, 6, 6, 4, 5, 5, 5, 5, 5, 5, 5, 5, },
        // LITERAL
        {-1, 17, 18, },

    };*/

    public static class State
    {
        public final static State NORMAL = new State(0);
        public final static State VARIABLE = new State(1);
        public final static State VAR_BRACE = new State(2);
        public final static State REFERENCE = new State(3);
        public final static State REF_BRACE = new State(4);
        public final static State FUNCTION_NAME = new State(5);
        public final static State FUNCTION = new State(6);
        public final static State FUNCTION_ARGS = new State(7);
        public final static State LITERAL = new State(8);

        private int id;

        private State(@SuppressWarnings("hiding") int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
