/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.dialogs.FilteredBranchesWidget;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FeatureBranchSelectionDialog
extends MessageDialog {
    private List<Ref> selected = new ArrayList<Ref>();
    private FilteredBranchesWidget filteredFeatures;
    private GitFlowRepository gfRepo;

    public FeatureBranchSelectionDialog(Shell parentShell, List<Ref> refs, String title, String message, String featurePrefix, GitFlowRepository gfRepo) {
        super(parentShell, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.gfRepo = gfRepo;
        this.filteredFeatures = new FilteredBranchesWidget(refs, featurePrefix, gfRepo);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createCustomArea(Composite parent) {
        Control result = this.filteredFeatures.create(parent);
        TreeViewer viewer = this.filteredFeatures.getBranchesList();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FeatureBranchSelectionDialog.this.checkPage();
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (FeatureBranchSelectionDialog.this.getButton(0).isEnabled()) {
                    FeatureBranchSelectionDialog.this.buttonPressed(0);
                }
            }
        });
        return result;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.selected = this.filteredFeatures.getSelection();
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    public Ref getSelectedNode() {
        if (this.selected.isEmpty()) {
            return null;
        }
        return this.selected.get(0);
    }

    private void checkPage() {
        List<Ref> selection = this.filteredFeatures.getSelection();
        if (selection.isEmpty() || selection.get(0) == null) {
            this.getButton(0).setEnabled(false);
            return;
        }
        Repository repository = this.gfRepo.getRepository();
        try {
            Ref currentBranch = repository.exactRef(repository.getFullBranch());
            this.getButton(0).setEnabled(!selection.get(0).equals(currentBranch));
        }
        catch (IOException e) {
            Activator.logError("Unable to find current branch", e);
        }
    }
}

