/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlLocationCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlMappingGroupCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionStateChange;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueConstant;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventField;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventName;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValuePool;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueQuery;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueScript;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueSelf;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueStackPeek;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public class TmfXmlStateValueCu
implements IDataDrivenCompilationUnit {
    private final Supplier<DataDrivenValue> fGenerator;

    TmfXmlStateValueCu(Supplier<DataDrivenValue> generator) {
        this.fGenerator = generator;
    }

    @Override
    public DataDrivenValue generate() {
        return Objects.requireNonNull(this.fGenerator.get());
    }

    public static @Nullable List<TmfXmlStateValueCu> compileAttribute(AnalysisCompilationData analysisData, Element valueEl) {
        String type = valueEl.getAttribute("type");
        ITmfStateValue.Type forcedType = ITmfStateValue.Type.NULL;
        switch (type) {
            case "constant": {
                String name = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                if (name == null || name.isEmpty()) {
                    Activator.logError("The value of a constant attribute should not be null");
                    return null;
                }
                TmfXmlStateValueCu tmfXmlStateValueCu = new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(null, forcedType, name));
                return Collections.singletonList(tmfXmlStateValueCu);
            }
            case "eventField": {
                String name = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                if (name == null || name.isEmpty()) {
                    Activator.logError("The value of an event field attribute should not be null");
                    return null;
                }
                return Collections.singletonList(new TmfXmlStateValueCu(() -> new DataDrivenValueEventField(null, forcedType, name)));
            }
            case "location": {
                String name = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                if (name == null || name.isEmpty()) {
                    Activator.logError("The value of a location attribute should not be null");
                    return null;
                }
                TmfXmlLocationCu location = analysisData.getLocation(name);
                if (location == null) {
                    Activator.logError("Location " + name + " does not exist");
                    return null;
                }
                return location.getValues();
            }
            case "query": {
                List<Element> childElements = TmfXmlUtils.getChildElements(valueEl, "stateAttribute");
                ArrayList<TmfXmlStateValueCu> subAttribs = new ArrayList<TmfXmlStateValueCu>();
                for (Element subAttributeNode : childElements) {
                    List<TmfXmlStateValueCu> subAttrib = TmfXmlStateValueCu.compileAttribute(analysisData, subAttributeNode);
                    if (subAttrib == null) {
                        return null;
                    }
                    subAttribs.addAll(subAttrib);
                }
                return Collections.singletonList(new TmfXmlStateValueCu(new StateValueQueryGenerator(subAttribs, null, forcedType)));
            }
            case "eventName": {
                return Collections.singletonList(new TmfXmlStateValueCu(() -> new DataDrivenValueEventName(null)));
            }
            case "": {
                return Collections.singletonList(new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(null, forcedType, null)));
            }
            case "self": {
                return Collections.singletonList(new TmfXmlStateValueCu(() -> new DataDrivenValueSelf(forcedType)));
            }
            case "pool": {
                return Collections.singletonList(new TmfXmlStateValueCu(() -> new DataDrivenValuePool()));
            }
        }
        Activator.logError("Compiling state value: The XML element is not of the right type " + type);
        return null;
    }

    private static @Nullable String getValueString(AnalysisCompilationData analysisContent, Element attribute) {
        return analysisContent.getStringValue(attribute.getAttribute("value"));
    }

    public static @Nullable TmfXmlStateValueCu compileValue(AnalysisCompilationData analysisData, Element valueEl) {
        String type = valueEl.getAttribute("type");
        String stack = valueEl.getAttribute("stack");
        DataDrivenActionStateChange.StackAction stackAction = DataDrivenActionStateChange.StackAction.getTypeFromString(stack);
        if (stackAction == DataDrivenActionStateChange.StackAction.PEEK) {
            type = "peek";
        }
        String mapGroupAttrib = valueEl.getAttribute("mappingGroup");
        TmfXmlMappingGroupCu mappingGroup = analysisData.getMappingGroup(mapGroupAttrib);
        if (!mapGroupAttrib.isEmpty() && mappingGroup == null) {
            Activator.logError("The mapping group " + mapGroupAttrib + " does not exist in this analysis");
            return null;
        }
        String mappingGroupId = mapGroupAttrib.isEmpty() ? null : mapGroupAttrib;
        String forcedTypeName = valueEl.getAttribute("forcedType");
        ITmfStateValue.Type forcedType = forcedTypeName.isEmpty() ? ITmfStateValue.Type.NULL : TmfXmlUtils.getTmfStateValueByName(forcedTypeName);
        switch (type) {
            case "int": {
                if (mappingGroup != null) {
                    Activator.logWarning("state value is type int but a mappingGroup is specified");
                }
                String value = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                try {
                    int intValue = Integer.parseInt(value);
                    return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(mappingGroupId, forcedType, intValue));
                }
                catch (NumberFormatException e) {
                    Activator.logError("Compiling state value: value is not a parseable integer " + value);
                    return null;
                }
            }
            case "long": {
                if (mappingGroup != null) {
                    Activator.logWarning("state value is type long but a mappingGroup is specified");
                }
                String value = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                try {
                    long longValue = Long.parseLong(value);
                    return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(mappingGroupId, forcedType, longValue));
                }
                catch (NumberFormatException e) {
                    Activator.logError("Compiling state value: value is not a parseable long " + value);
                    return null;
                }
            }
            case "string": {
                String value = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(mappingGroupId, forcedType, value));
            }
            case "null": {
                if (mappingGroup != null) {
                    Activator.logWarning("state value is type null but a mappingGroup is specified");
                }
                return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(mappingGroupId, forcedType, null));
            }
            case "eventField": {
                String name = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                if (name == null || name.isEmpty()) {
                    Activator.logError("The value of an event field attribute should not be null");
                    return null;
                }
                return new TmfXmlStateValueCu(() -> new DataDrivenValueEventField(mappingGroupId, forcedType, name));
            }
            case "eventName": {
                return new TmfXmlStateValueCu(() -> new DataDrivenValueEventName(mappingGroupId));
            }
            case "delete": {
                if (mappingGroup != null) {
                    Activator.logWarning("state value is type delete but a mappingGroup is specified");
                }
                return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(mappingGroupId, forcedType, null));
            }
            case "query": {
                List<Element> childElements = TmfXmlUtils.getChildElements(valueEl, "stateAttribute");
                ArrayList<TmfXmlStateValueCu> subAttribs = new ArrayList<TmfXmlStateValueCu>();
                for (Element subAttributeNode : childElements) {
                    List<TmfXmlStateValueCu> subAttrib = TmfXmlStateValueCu.compileAttribute(analysisData, subAttributeNode);
                    if (subAttrib == null) {
                        return null;
                    }
                    subAttribs.addAll(subAttrib);
                }
                return new TmfXmlStateValueCu(new StateValueQueryGenerator(subAttribs, mappingGroupId, forcedType));
            }
            case "script": {
                List<Element> childElements = TmfXmlUtils.getChildElements(valueEl, "stateValue");
                HashMap<String, TmfXmlStateValueCu> values = new HashMap<String, TmfXmlStateValueCu>();
                for (Element subAttributeNode : childElements) {
                    String valueId = subAttributeNode.getAttribute("id");
                    TmfXmlStateValueCu subAttrib = TmfXmlStateValueCu.compileValue(analysisData, subAttributeNode);
                    if (subAttrib == null) {
                        return null;
                    }
                    values.put(valueId, subAttrib);
                }
                String script = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                if (script == null) {
                    Activator.logError("The script resolves to null");
                    return null;
                }
                String scriptEngine = valueEl.getAttribute("scriptEngine");
                if (scriptEngine.isEmpty()) {
                    scriptEngine = "nashorn";
                }
                return new TmfXmlStateValueCu(new StateValueScriptGenerator(values, script, scriptEngine, mappingGroupId, forcedType));
            }
            case "peek": {
                List<Element> childElements = TmfXmlUtils.getChildElements(valueEl, "stateAttribute");
                if (childElements.isEmpty()) {
                    Activator.logWarning("Compiling state value: Stack peek should have children state attributes");
                }
                ArrayList<TmfXmlStateValueCu> subAttribs = new ArrayList<TmfXmlStateValueCu>();
                for (Element subAttributeNode : childElements) {
                    List<TmfXmlStateValueCu> subAttrib = TmfXmlStateValueCu.compileAttribute(analysisData, subAttributeNode);
                    if (subAttrib == null) {
                        return null;
                    }
                    subAttribs.addAll(subAttrib);
                }
                return new TmfXmlStateValueCu(new StateValueStackPeekGenerator(subAttribs, mappingGroupId, forcedType));
            }
        }
        Activator.logError("Compiling state value: The XML element is not of the right type " + type);
        return null;
    }

    public static @Nullable TmfXmlStateValueCu compileField(AnalysisCompilationData analysisData, Element fieldEl) {
        String name = analysisData.getStringValue(fieldEl.getAttribute("name"));
        if (name == null || name.isEmpty()) {
            Activator.logError("The value of an event field attribute should not be null");
            return null;
        }
        return new TmfXmlStateValueCu(() -> new DataDrivenValueEventField(null, ITmfStateValue.Type.NULL, name));
    }

    public static TmfXmlStateValueCu compileAsQuery(List<TmfXmlStateValueCu> attributesCu) {
        return new TmfXmlStateValueCu(new StateValueQueryGenerator(attributesCu, null, ITmfStateValue.Type.NULL));
    }

    private static class StateValueQueryGenerator
    implements Supplier<DataDrivenValue> {
        private final List<TmfXmlStateValueCu> fList;
        private final @Nullable String fMappingGroupId;
        private final ITmfStateValue.Type fForcedType;

        StateValueQueryGenerator(List<TmfXmlStateValueCu> list, @Nullable String mappingGroup, ITmfStateValue.Type forcedType) {
            this.fList = list;
            this.fMappingGroupId = mappingGroup;
            this.fForcedType = forcedType;
        }

        @Override
        public DataDrivenValue get() {
            ArrayList<DataDrivenValue> generated = new ArrayList<DataDrivenValue>();
            for (TmfXmlStateValueCu subValue : this.fList) {
                generated.add(subValue.generate());
            }
            return new DataDrivenValueQuery(this.fMappingGroupId, this.fForcedType, generated);
        }
    }

    private static class StateValueScriptGenerator
    implements Supplier<DataDrivenValue> {
        private final Map<String, TmfXmlStateValueCu> fMap;
        private final String fScript;
        private final String fScriptEngine;
        private final @Nullable String fMappingGroupId;
        private final ITmfStateValue.Type fForcedType;

        StateValueScriptGenerator(Map<String, TmfXmlStateValueCu> list, String script, String scriptEngine, @Nullable String mappingGroup, ITmfStateValue.Type forcedType) {
            this.fMap = list;
            this.fScript = script;
            this.fScriptEngine = scriptEngine;
            this.fMappingGroupId = mappingGroup;
            this.fForcedType = forcedType;
        }

        @Override
        public DataDrivenValue get() {
            HashMap<String, DataDrivenValue> values = new HashMap<String, DataDrivenValue>();
            this.fMap.entrySet().forEach(entry -> {
                DataDrivenValue dataDrivenValue = values.put((String)entry.getKey(), Objects.requireNonNull((TmfXmlStateValueCu)entry.getValue()).generate());
            });
            return new DataDrivenValueScript(this.fMappingGroupId, this.fForcedType, values, this.fScript, this.fScriptEngine);
        }
    }

    private static class StateValueStackPeekGenerator
    implements Supplier<DataDrivenValue> {
        private final List<TmfXmlStateValueCu> fList;
        private final @Nullable String fMappingGroupId;
        private final ITmfStateValue.Type fForcedType;

        StateValueStackPeekGenerator(List<TmfXmlStateValueCu> list, @Nullable String mappingGroup, ITmfStateValue.Type forcedType) {
            this.fList = list;
            this.fMappingGroupId = mappingGroup;
            this.fForcedType = forcedType;
        }

        @Override
        public DataDrivenValue get() {
            ArrayList<DataDrivenValue> generated = new ArrayList<DataDrivenValue>();
            for (TmfXmlStateValueCu subValue : this.fList) {
                generated.add(subValue.generate());
            }
            return new DataDrivenValueStackPeek(this.fMappingGroupId, this.fForcedType, generated);
        }
    }
}

