/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.AbstractTreeElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.TreeElementStateProviderFactory;
import org.eclipse.ui.IMemento;

public class FolderElementStateProvider
extends AbstractTreeElementStateProvider {
    private IFolder folder = null;

    public FolderElementStateProvider(TreeViewer viewer, IMemento memento) {
        super(viewer);
        Assert.isNotNull((Object)memento);
        String pathAsString = memento.getString("path");
        if (pathAsString != null) {
            this.folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(pathAsString));
        }
    }

    public FolderElementStateProvider(TreeViewer viewer, IFolder folder) {
        super(viewer);
        this.folder = folder;
    }

    @Override
    public boolean hasUnderlyingModel() {
        return false;
    }

    @Override
    public boolean canUnderlyingModelBeLoaded() {
        return false;
    }

    @Override
    public boolean isUnderlyingModelLoaded() {
        return false;
    }

    @Override
    public void loadUnderlyingModel() {
    }

    @Override
    public boolean isStale() {
        if (this.folder != null) {
            return !this.folder.exists();
        }
        return true;
    }

    @Override
    public Object getTreeElement() {
        return this.folder;
    }

    @Override
    public void appendToMemento(IMemento parentMemento) {
        if (this.folder != null) {
            IMemento memento = parentMemento.createChild(TreeElementStateProviderFactory.MEMENTO_TYPE_ELEMENT_FOLDER);
            memento.putString("path", this.folder.getFullPath().toString());
        }
    }

    public String toString() {
        return "FolderElementProvider [folder=" + this.folder + "]";
    }
}

