/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.refresh;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTask;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshGraphicalOrderingOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshSemanticOrderingsOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SynchronizeGraphicalOrderingOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.RefreshOrderingHelper;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;

public class RefreshLayoutCommand
extends RecordingCommand {
    private static final ProfilerTask REFRESH_LAYOUT = new ProfilerTask(Messages.RefreshLayoutCommand_profilerTaskCategory, Messages.RefreshLayoutCommand_profilerTaskName, "/images/viewpoint.gif");
    private Diagram diagram;
    private boolean refreshDiagram;

    public RefreshLayoutCommand(TransactionalEditingDomain domain, Diagram diagram, boolean refreshDiagram) {
        super(domain, Messages.RefreshLayoutCommand_commandName);
        this.diagram = diagram;
        this.refreshDiagram = refreshDiagram;
    }

    protected void doExecute() {
        DslCommonPlugin.PROFILER.startWork(REFRESH_LAYOUT);
        SequenceDiagram sequenceDiagram = (SequenceDiagram)ISequenceElementAccessor.getSequenceDiagram(this.diagram).get();
        SequenceDDiagram sequenceDDiagram = sequenceDiagram.getSequenceDDiagram();
        IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)sequenceDDiagram);
        if (permissionAuthority != null && permissionAuthority.canEditInstance((EObject)sequenceDDiagram)) {
            sequenceDiagram.useCache(true);
            try {
                RefreshGraphicalOrderingOperation refreshGraphicalOrderingOperation;
                final Iterable<? extends EventEnd> allEventEnds = RefreshOrderingHelper.getAllEventEnds(sequenceDDiagram);
                RefreshSemanticOrderingsOperation refreshSemanticOrderingOperation = new RefreshSemanticOrderingsOperation(sequenceDDiagram){

                    @Override
                    protected Iterable<? extends EventEnd> getAllEventEnds() {
                        return allEventEnds;
                    }
                };
                if (((Boolean)refreshSemanticOrderingOperation.execute()).booleanValue()) {
                    sequenceDiagram.clearOrderedCaches();
                }
                if (((Boolean)(refreshGraphicalOrderingOperation = new RefreshGraphicalOrderingOperation(sequenceDiagram){

                    @Override
                    protected Iterable<? extends EventEnd> getAllEventEnds() {
                        return allEventEnds;
                    }
                }).execute()).booleanValue()) {
                    sequenceDiagram.clearOrderedCaches();
                }
                if (this.refreshDiagram) {
                    SynchronizeGraphicalOrderingOperation synchronizeGraphicalOrderingOperation = new SynchronizeGraphicalOrderingOperation(this.diagram, false);
                    synchronizeGraphicalOrderingOperation.execute();
                    if (((Boolean)refreshGraphicalOrderingOperation.execute()).booleanValue()) {
                        sequenceDiagram.clearOrderedCaches();
                    }
                }
            }
            finally {
                sequenceDiagram.useCache(false);
                sequenceDiagram.clearAllCaches();
            }
        }
        DslCommonPlugin.PROFILER.stopWork(REFRESH_LAYOUT);
    }
}

