/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.internal.engines.lowvision.Messages;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.InteriorImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.InteriorImageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.DontRelyOnColorRecommendation;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionRecommendation;

public class ImageColorProblem
extends LowVisionProblem {
    InteriorImageComponent imageComponent1 = null;
    InteriorImageComponent imageComponent2 = null;

    public ImageColorProblem(InteriorImage interiorImage, LowVisionType lowVisionType, double d, InteriorImageComponent interiorImageComponent, InteriorImageComponent interiorImageComponent2) throws LowVisionProblemException {
        super(3, lowVisionType, Messages.ImageColorProblem_This_image_has_two_or_more_components_whose_colors_are_too_close__1, interiorImage, d);
        this.left = interiorImage.getLeft();
        this.top = interiorImage.getTop();
        this.width = interiorImage.getWidth();
        this.height = interiorImage.getHeight();
        this.imageComponent1 = interiorImageComponent;
        this.imageComponent2 = interiorImageComponent2;
        if (interiorImageComponent.getContainerImage() != interiorImageComponent2.getContainerImage()) {
            throw new LowVisionProblemException("The two component come from different images.");
        }
        if (interiorImageComponent.getContainerImage() != interiorImage) {
            throw new LowVisionProblemException("The container of the components and the InteriorImage do not match.");
        }
        this.setRecommendations();
    }

    public InteriorImageComponent[] getInteriorImageComponentArray() {
        InteriorImageComponent[] interiorImageComponentArray = new InteriorImageComponent[]{this.imageComponent1, this.imageComponent2};
        return interiorImageComponentArray;
    }

    public InteriorImage getContainerImage() {
        return this.imageComponent1.getContainerImage();
    }

    protected void setRecommendations() throws LowVisionProblemException {
        this.numRecommendations = 1;
        this.recommendations = new LowVisionRecommendation[this.numRecommendations];
        this.recommendations[0] = new DontRelyOnColorRecommendation(this);
    }

    public IInt2D showProblemImage() {
        Int2D int2D = null;
        try {
            int n;
            int n2;
            byte[][] byArray;
            int n3;
            int n4;
            BinaryImage binaryImage;
            int n5;
            int n6;
            ConnectedComponent connectedComponent;
            InteriorImage interiorImage = (InteriorImage)this.pageComponent;
            Int2D int2D2 = interiorImage.simulate(this.lowVisionType);
            int2D = new Int2D(int2D2.getWidth(), int2D2.getHeight());
            int n7 = this.imageComponent1.getNumConnectedComponents();
            ConnectedComponent[] connectedComponentArray = this.imageComponent1.getConnectedComponents();
            int n8 = 0;
            while (n8 < n7) {
                connectedComponent = connectedComponentArray[n8];
                n6 = connectedComponent.getLeft();
                n5 = connectedComponent.getTop();
                binaryImage = connectedComponent.getShape();
                n4 = binaryImage.getWidth();
                n3 = binaryImage.getHeight();
                byArray = binaryImage.getData();
                n2 = 0;
                while (n2 < n3) {
                    n = 0;
                    while (n < n4) {
                        if (byArray[n2][n] != 0) {
                            int2D.getData()[n2 + n5][n + n6] = int2D2.getData()[n2 + n5][n + n6];
                        }
                        ++n;
                    }
                    ++n2;
                }
                ++n8;
            }
            n7 = this.imageComponent2.getNumConnectedComponents();
            connectedComponentArray = null;
            connectedComponentArray = this.imageComponent2.getConnectedComponents();
            n8 = 0;
            while (n8 < n7) {
                connectedComponent = connectedComponentArray[n8];
                n6 = connectedComponent.getLeft();
                n5 = connectedComponent.getTop();
                binaryImage = connectedComponent.getShape();
                n4 = binaryImage.getWidth();
                n3 = binaryImage.getHeight();
                byArray = binaryImage.getData();
                n2 = 0;
                while (n2 < n3) {
                    n = 0;
                    while (n < n4) {
                        if (byArray[n2][n] != 0) {
                            int2D.getData()[n2 + n5][n + n6] = int2D2.getData()[n2 + n5][n + n6];
                        }
                        ++n;
                    }
                    ++n2;
                }
                ++n8;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return int2D;
    }
}

