/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.java.types.JavaTypeId;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.LambdaTypeId;
import org.eclipse.ocl.pivot.ids.NestedPackageId;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.OclInvalidTypeId;
import org.eclipse.ocl.pivot.ids.OclVoidTypeId;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.ids.TemplateBinding;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TemplateableTypeId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.ids.UnspecifiedId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.TupleValue;

public abstract class AbstractId2JavaClassVisitor
implements IdVisitor<Class<?>> {
    protected final @NonNull GenModelHelper genModelHelper;

    protected AbstractId2JavaClassVisitor(@NonNull GenModelHelper genModelHelper) {
        this.genModelHelper = genModelHelper;
    }

    public @NonNull Class<?> doVisit(@NonNull ElementId elementId) {
        return (Class)ClassUtil.nonNullState((Object)((Class)elementId.accept((IdVisitor)this)));
    }

    public @NonNull Class<?> visitClassId(@NonNull ClassId id) {
        EnvironmentFactory environmentFactory = this.genModelHelper.getEnvironmentFactory();
        Type type = environmentFactory.getIdResolver().getType((TypeId)id, null);
        EClass eClass = (EClass)type.getESObject();
        if (eClass != null) {
            try {
                return this.genModelHelper.getEcoreInterfaceClassifier((EClassifier)eClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Object.class;
    }

    public @NonNull Class<?> visitInvalidId(@NonNull OclInvalidTypeId id) {
        return InvalidValueException.class;
    }

    public @NonNull Class<?> visitLambdaTypeId(@NonNull LambdaTypeId id) {
        return LambdaType.class;
    }

    public @NonNull Class<?> visitNestedPackageId(@NonNull NestedPackageId id) {
        return Package.class;
    }

    public @NonNull Class<?> visitNsURIPackageId(@NonNull NsURIPackageId id) {
        return Package.class;
    }

    public @NonNull Class<?> visitNullId(@NonNull OclVoidTypeId id) {
        return Object.class;
    }

    public @NonNull Class<?> visitOperationId(@NonNull OperationId id) {
        return Operation.class;
    }

    public @Nullable Class<?> visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
        if (id instanceof JavaTypeId) {
            return ((JavaTypeId)id).getJavaClass();
        }
        if (id == TypeId.BOOLEAN) {
            return Boolean.class;
        }
        if (id == TypeId.INTEGER_RANGE) {
            return IntegerRange.class;
        }
        if (id == TypeId.OCL_ANY) {
            return Object.class;
        }
        if (id == TypeId.OCL_COMPARABLE) {
            return Object.class;
        }
        if (id == TypeId.OCL_SUMMABLE) {
            return Object.class;
        }
        if (id == TypeId.STRING) {
            return String.class;
        }
        return null;
    }

    public @NonNull Class<?> visitPropertyId(@NonNull PropertyId id) {
        return Property.class;
    }

    public @NonNull Class<?> visitRootPackageId(@NonNull RootPackageId id) {
        return Package.class;
    }

    public @NonNull Class<?> visitTemplateBinding(@NonNull TemplateBinding id) {
        return this.visiting((ElementId)id);
    }

    public @NonNull Class<?> visitTemplateParameterId(@NonNull TemplateParameterId id) {
        return Object.class;
    }

    public @NonNull Class<?> visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
        return Type.class;
    }

    public @NonNull Class<?> visitTuplePartId(@NonNull TuplePartId id) {
        return Property.class;
    }

    public @NonNull Class<?> visitTupleTypeId(@NonNull TupleTypeId id) {
        return TupleValue.class;
    }

    public @NonNull Class<?> visitUnspecifiedId(@NonNull UnspecifiedId id) {
        return this.visiting((ElementId)id);
    }

    public @NonNull Class<?> visiting(@NonNull ElementId id) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + id.getClass().getName());
    }
}

