/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.gef.dot.internal.DotExecutableUtils;
import org.eclipse.gef.dot.internal.ui.DotExportRadioGroupFieldEditor;
import org.eclipse.gef.dot.internal.ui.DotUiMessages;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.Preferences;

public class GraphvizPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DOT_SELECT_SHORT = DotUiMessages.GraphvizPreference_0;
    private static final String DOT_SELECT_LONG = DotUiMessages.GraphvizPreference_1;
    private static final String INVALID_DOT_EXECUTABLE = DotUiMessages.GraphvizPreference_2;
    private static final String INVALID_GRAPHVIZ_CONF = DotUiMessages.GraphvizPreference_3;
    private static final String GRAPHVIZ_CONF_HINT = DotUiMessages.GraphvizPreference_4;
    private static final String DOT_EXPORT_FORMAT = DotUiMessages.GraphvizPreference_5;
    private static final String DOT_EXPORT_FORMAT_HINT = DotUiMessages.GraphvizPreference_6;
    public static final String DOT_PATH_PREF_KEY = "dotpath";
    public static final String DOT_EXPORTFORMAT_PREF_KEY = "dotexportformat";
    private static final String DOT_EXPORTFORMAT_DEFAULT = "pdf";
    private DotExportRadioGroupFieldEditor radioGroupFieldEditor;

    public GraphvizPreferencePage() {
        super(1);
    }

    public static boolean isGraphvizConfigured() {
        return GraphvizPreferencePage.getDotExecutablePath().length() != 0;
    }

    public static void showGraphvizConfigurationDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        new GraphvizConfigurationDialog(shell).open();
    }

    public static String getDotExecutablePath() {
        return GraphvizPreferencePage.dotUiPrefs().get(DOT_PATH_PREF_KEY, "");
    }

    public static String getDotExportFormat() {
        return GraphvizPreferencePage.dotUiPrefs().get(DOT_EXPORTFORMAT_PREF_KEY, "");
    }

    private static boolean isValidDotExecutable(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        File file = new File(path);
        return file.getName().equals("dot") || file.getName().equals("dot.exe");
    }

    protected static Preferences dotUiPrefs() {
        return ConfigurationScope.INSTANCE.getNode(DotActivator.getInstance().getBundle().getSymbolicName());
    }

    protected static IPreferenceStore dotUiPrefStore() {
        return new ScopedPreferenceStore(ConfigurationScope.INSTANCE, DotActivator.getInstance().getBundle().getSymbolicName());
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(GraphvizPreferencePage.dotUiPrefStore());
        this.setDescription(DOT_SELECT_LONG);
    }

    protected void createFieldEditors() {
        FileFieldEditor fileFieldEditor = new FileFieldEditor(DOT_PATH_PREF_KEY, DOT_SELECT_SHORT, true, 0, this.getFieldEditorParent()){
            {
                this.setErrorMessage(INVALID_DOT_EXECUTABLE);
            }

            public boolean isValid() {
                boolean isValid = super.isValid();
                String currentValue = this.getStringValue();
                if (!currentValue.isEmpty()) {
                    isValid = isValid && GraphvizPreferencePage.isValidDotExecutable(currentValue);
                }
                return isValid;
            }

            protected void refreshValidState() {
                super.refreshValidState();
                if (!this.isValid()) {
                    this.showErrorMessage(this.getErrorMessage());
                }
                this.checkState();
            }

            public boolean doCheckState() {
                String currentValue = this.getStringValue();
                if (!currentValue.isEmpty()) {
                    return GraphvizPreferencePage.isValidDotExecutable(currentValue);
                }
                return super.doCheckState();
            }

            public String changePressed() {
                String dotExecutablePath = super.changePressed();
                if (dotExecutablePath == null) {
                    return null;
                }
                GraphvizPreferencePage.this.adaptDotExportUI(dotExecutablePath);
                return dotExecutablePath;
            }
        };
        this.addField((FieldEditor)fileFieldEditor);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(GraphvizPreferencePage.DOT_PATH_PREF_KEY)) {
                    String dotExecutablePath = (String)event.getNewValue();
                    GraphvizPreferencePage.this.adaptDotExportUI(dotExecutablePath);
                }
            }
        });
        String dotExecutablePath = GraphvizPreferencePage.getDotExecutablePath();
        this.addDotExportUI(dotExecutablePath);
    }

    private String[] getSupportedExportFormats(String dotExecutablePath) {
        String[] supportedExportFormats = null;
        supportedExportFormats = DotExecutableUtils.getSupportedExportFormats((String)dotExecutablePath);
        return supportedExportFormats;
    }

    private String getDefaultExportFormat(String[] supportedExportFormats) {
        if (supportedExportFormats == null) {
            return null;
        }
        return Arrays.asList(supportedExportFormats).contains(DOT_EXPORTFORMAT_DEFAULT) ? DOT_EXPORTFORMAT_DEFAULT : supportedExportFormats[0];
    }

    private String[][] getLabelsAndValues(String[] supportedExportFormats) {
        String[][] labelsAndValues = null;
        if (supportedExportFormats != null) {
            labelsAndValues = new String[supportedExportFormats.length][2];
            int i = 0;
            while (i < supportedExportFormats.length) {
                labelsAndValues[i] = new String[]{supportedExportFormats[i], supportedExportFormats[i]};
                ++i;
            }
        }
        return labelsAndValues;
    }

    private void adaptDotExportUI(String dotExecutablePath) {
        if (GraphvizPreferencePage.isValidDotExecutable(dotExecutablePath)) {
            if (this.radioGroupFieldEditor == null) {
                this.addDotExportUI(dotExecutablePath);
            } else {
                this.updateDotExportUI(dotExecutablePath);
            }
        } else {
            this.removeDotExportUI();
        }
    }

    private void addDotExportUI(String dotExecutablePath) {
        String defaultExportFormat;
        String[] supportedExportFormats = null;
        if (!dotExecutablePath.isEmpty()) {
            supportedExportFormats = this.getSupportedExportFormats(dotExecutablePath);
        }
        String[][] labelsAndValues = this.getLabelsAndValues(supportedExportFormats);
        this.radioGroupFieldEditor = new DotExportRadioGroupFieldEditor(DOT_EXPORTFORMAT_PREF_KEY, DOT_EXPORT_FORMAT, DOT_EXPORT_FORMAT_HINT, 5, labelsAndValues, this.getFieldEditorParent());
        if (GraphvizPreferencePage.getDotExportFormat().isEmpty() && (defaultExportFormat = this.getDefaultExportFormat(supportedExportFormats)) != null) {
            GraphvizPreferencePage.dotUiPrefs().put(DOT_EXPORTFORMAT_PREF_KEY, defaultExportFormat);
        }
        this.addField((FieldEditor)this.radioGroupFieldEditor);
    }

    private void updateDotExportUI(String dotExecutablePath) {
        String[] supportedExportFormats = this.getSupportedExportFormats(dotExecutablePath);
        String defaultExportFormat = this.getDefaultExportFormat(supportedExportFormats);
        String[][] labelsAndValues = this.getLabelsAndValues(supportedExportFormats);
        GraphvizPreferencePage.dotUiPrefs().put(DOT_EXPORTFORMAT_PREF_KEY, defaultExportFormat);
        this.radioGroupFieldEditor.update(labelsAndValues);
    }

    private void removeDotExportUI() {
        if (this.radioGroupFieldEditor != null) {
            this.radioGroupFieldEditor.clear();
            GraphvizPreferencePage.dotUiPrefs().remove(DOT_EXPORTFORMAT_PREF_KEY);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.removeDotExportUI();
    }

    public static class GraphvizConfigurationDialog
    extends MessageDialog {
        public GraphvizConfigurationDialog(Shell parentShell) {
            super(parentShell, INVALID_GRAPHVIZ_CONF, null, GRAPHVIZ_CONF_HINT, 4, new String[]{IDialogConstants.CANCEL_LABEL}, 0);
        }

        protected Control createMessageArea(Composite composite) {
            String linkText = this.message;
            this.message = null;
            super.createMessageArea(composite);
            this.message = linkText;
            Link messageLink = new Link(composite, 64);
            messageLink.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)messageLink);
            messageLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.gef.dot.internal.ui.GraphvizPreferencePage", null, null);
                    if (pref != null) {
                        this.close();
                        pref.open();
                    }
                }
            });
            return composite;
        }
    }
}

