/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ICloseablePart;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IPartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PartLists;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabItemPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class PagePart
extends AbstractPart
implements IPage,
IAdaptable {
    protected Object rawModel;
    protected TabFolderPart parent;

    public PagePart(TabFolderPart parent, Object rawModel) {
        super(parent.getSashWindowContainer());
        this.parent = parent;
        this.rawModel = rawModel;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    protected TabFolderPart getParent() {
        return this.parent;
    }

    protected TabItemPart getAssociatedTabItemPart() {
        return this.getParent().lookupAssociatedTabItemPart(this);
    }

    public void orphan() {
        if (this.garbageState == AbstractPart.GarbageState.UNVISITED) {
            this.garbageState = AbstractPart.GarbageState.ORPHANED;
            this.parent = null;
        }
    }

    public void unchanged() {
        if (this.garbageState != AbstractPart.GarbageState.UNVISITED && this.garbageState != AbstractPart.GarbageState.ORPHANED) {
            throw new IllegalStateException("Try to change state from " + this.garbageState.toString() + " to UNCHANGED. This is forbidden.");
        }
        this.garbageState = AbstractPart.GarbageState.UNCHANGED;
    }

    abstract boolean visit(IPartVisitor var1);

    public AbstractPart findPartAt(Point position, Class<?> expectedTileType) {
        if (expectedTileType == this.getClass()) {
            return this;
        }
        return null;
    }

    public abstract void createPartControl(Composite var1);

    @Override
    public abstract Control getControl();

    public abstract void reparent(TabFolderPart var1);

    public Widget getTabWidget() {
        return this.getAssociatedTabItemPart().control;
    }

    public void fillPartMap(PartLists partMap) {
        partMap.addLeaf(this);
        this.garbageState = AbstractPart.GarbageState.UNVISITED;
    }

    @Override
    public Object getRawModel() {
        return this.rawModel;
    }

    @Override
    public String getPageTitle() {
        return null;
    }

    @Override
    public Image getPageIcon() {
        return null;
    }

    public void refreshTab() {
        this.getParent().refreshPageTab(this);
    }

    public boolean canClose() {
        ICloseablePart closeable = this.getAdapter(ICloseablePart.class);
        return closeable == null || closeable == this || closeable.canClose();
    }

    public abstract void setFocus();

    public abstract void dispose();

    public abstract void disposeThisAndChildren();

    public abstract void garbage();

    public boolean isPartFor(Object realModel) {
        return this.rawModel == realModel;
    }
}

