/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.internal;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.objectteams.otdt.core.compiler.ISMAPConstants;

public class StepFromLinenumberGenerator
implements IDebugEventFilter,
ISMAPConstants {
    private static StepFromLinenumberGenerator _stepGenerator;

    public static StepFromLinenumberGenerator getInstance() {
        if (_stepGenerator == null) {
            _stepGenerator = new StepFromLinenumberGenerator();
        }
        return _stepGenerator;
    }

    public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
        int index = 0;
        while (index < events.length) {
            DebugEvent event = events[index];
            JDIThread thread = this.getThreadFromEvent(event);
            if (thread == null) {
                return events;
            }
            try {
                IStackFrame topStackframe = this.getStackFrame(thread);
                if (this.isResumeEvent(event) || topStackframe == null) {
                    return events;
                }
                if (this.isStepOverElement(topStackframe) && this.isSuspendEvent(event)) {
                    this.generateStepOver(thread);
                    return this.filterEvent(events, index);
                }
                if (this.isStepIntoElement(topStackframe) && this.isSuspendEvent(event)) {
                    this.generateStepInto(thread);
                    return this.filterEvent(events, index);
                }
            }
            catch (DebugException e) {
                e.printStackTrace();
                return events;
            }
            ++index;
        }
        return events;
    }

    private boolean isResumeEvent(DebugEvent event) {
        return event.getKind() == 1;
    }

    private boolean isSuspendEvent(DebugEvent event) {
        return event.getKind() == 2;
    }

    private boolean isStepOverElement(IStackFrame topStackframe) throws DebugException {
        return topStackframe.getLineNumber() == 65534;
    }

    private boolean isStepIntoElement(IStackFrame topStackframe) throws DebugException {
        return topStackframe.getLineNumber() == 65533;
    }

    private IStackFrame getStackFrame(JDIThread thread) throws DebugException {
        if (thread.hasStackFrames()) {
            return thread.getTopStackFrame();
        }
        return null;
    }

    private JDIThread getThreadFromEvent(DebugEvent event) {
        if (event.getSource() instanceof JDIThread) {
            return (JDIThread)event.getSource();
        }
        return null;
    }

    private DebugEvent[] filterEvent(DebugEvent[] events, int index) {
        DebugEvent[] filtered = new DebugEvent[events.length - 1];
        if (filtered.length > 0) {
            int j = 0;
            int idx = 0;
            while (idx < events.length) {
                if (idx != index) {
                    filtered[j] = events[idx];
                    ++j;
                }
                ++idx;
            }
        }
        return filtered;
    }

    private void generateStepInto(JDIThread thread) {
        IJavaDebugTarget debugTarget = (IJavaDebugTarget)thread.getDebugTarget();
        try {
            thread.stepInto();
        }
        catch (DebugException e) {
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)debugTarget, 16)});
        }
    }

    private void generateStepOver(JDIThread thread) {
        IJavaDebugTarget debugTarget = (IJavaDebugTarget)thread.getDebugTarget();
        try {
            thread.stepOver();
        }
        catch (DebugException e) {
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)debugTarget, 16)});
        }
    }
}

